/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.newscriptrunner.commands.connector;

import java.text.MessageFormat;
import oracle.dbtools.raptor.newscriptrunner.commands.connect.ConnectorArgs;
import oracle.dbtools.raptor.newscriptrunner.commands.connect.ParseConnectionSpecArgs;
import oracle.dbtools.raptor.newscriptrunner.commands.connector.Messages;
import oracle.dbtools.raptor.newscriptrunner.commands.connector.OracleRestConnector;
import oracle.dbtools.raptor.newscriptrunner.commands.connector.OracleStandardFormConnectorType;
import oracle.dbtools.raptor.newscriptrunner.commands.connector.URLProperty;
import oracle.dbtools.raptor.utils.SQLPLUSUtil;

public class OracleRestConnectorType
extends OracleStandardFormConnectorType {
    private static final String NAME = "OREST";
    private static final String SHORT_NAME = "OR";

    protected OracleRestConnectorType() {
        super(OracleRestConnectorType.createSelectorProperty(NAME, SHORT_NAME));
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public String getShortName() {
        return SHORT_NAME;
    }

    @Override
    public void parseConnectionSpec(ParseConnectionSpecArgs args) {
        super.parseConnectionSpec(args);
        String url = args.getPropertyValue(URLProperty.URL);
        if (url != null && !SQLPLUSUtil.hasOracleRestStub(url)) {
            args.addError(MessageFormat.format(Messages.getString(Messages.Key.INVALID_PREFIX), this.getName(), url));
        }
    }

    @Override
    public OracleRestConnector createConnectorImpl(ConnectorArgs args) {
        return new OracleRestConnector(args);
    }
}

