/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.newscriptrunner.commands.connector;

import java.text.MessageFormat;
import oracle.dbtools.raptor.newscriptrunner.commands.connect.ConnectorArgs;
import oracle.dbtools.raptor.newscriptrunner.commands.connect.FlagProperty;
import oracle.dbtools.raptor.newscriptrunner.commands.connect.ParseConnectionSpecArgs;
import oracle.dbtools.raptor.newscriptrunner.commands.connector.CloudConfigProperty;
import oracle.dbtools.raptor.newscriptrunner.commands.connector.CloudWalletConnector;
import oracle.dbtools.raptor.newscriptrunner.commands.connector.Messages;
import oracle.dbtools.raptor.newscriptrunner.commands.connector.OracleStandardFormConnectorType;
import oracle.dbtools.raptor.newscriptrunner.commands.connector.ProxyProperty;
import oracle.dbtools.raptor.newscriptrunner.commands.connector.URLProperty;
import oracle.dbtools.raptor.newscriptrunner.commands.connector.WalletValue;

public class CloudWalletConnectorType
extends OracleStandardFormConnectorType {
    private static final String NAME = "WALLET";
    private static final String SHORT_NAME = "W";

    protected CloudWalletConnectorType(FlagProperty selector) {
        super(selector);
        this.addProperty(CloudConfigProperty.CLOUDCONFIG);
        this.addProperty(ProxyProperty.PROXY);
    }

    public CloudWalletConnectorType() {
        this(CloudWalletConnectorType.createSelectorProperty(NAME, SHORT_NAME));
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public String getShortName() {
        return SHORT_NAME;
    }

    @Override
    public void parseConnectionSpec(ParseConnectionSpecArgs args) {
        super.parseConnectionSpec(args);
        String url = args.getPropertyValue(URLProperty.URL);
        if (url != null && url.startsWith("jdbc:") && !url.startsWith("jdbc:oracle:thin:")) {
            args.addError(MessageFormat.format(Messages.getString(Messages.Key.INVALID_PREFIX), this.getName(), url));
        } else {
            WalletValue walletValue = args.getPropertyValue(CloudConfigProperty.CLOUDCONFIG);
            if (walletValue == null) {
                args.addError(Messages.getString(Messages.Key.INVALID_WALLET_URL));
            }
        }
    }

    @Override
    public CloudWalletConnector createConnectorImpl(ConnectorArgs args) {
        return new CloudWalletConnector(args);
    }
}

