/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.newscriptrunner.commands.connector;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import oracle.dbtools.raptor.newscriptrunner.ScriptRunnerContext;
import oracle.dbtools.raptor.newscriptrunner.commands.connect.ConnectOptionType;
import oracle.dbtools.raptor.newscriptrunner.commands.connect.ConnectorTypeCache;
import oracle.dbtools.raptor.newscriptrunner.commands.connect.FlagProperty;
import oracle.dbtools.raptor.newscriptrunner.commands.connect.HelpContainerRef;
import oracle.dbtools.raptor.newscriptrunner.commands.connect.Property;
import oracle.dbtools.raptor.newscriptrunner.util.help.HelpContainer;
import oracle.dbtools.raptor.newscriptrunner.util.service.Environment;

public abstract class AbstractConnectOptionType
implements ConnectOptionType {
    protected static final Map<String, Function<Environment, String>> selectorHelpMap = new HashMap<String, Function<Environment, String>>();
    protected static final HelpContainer selectorHelpContainer = new HelpContainer(){

        @Override
        public String getContainerName() {
            return "";
        }

        @Override
        public Optional<String> get(String key, Environment environment) {
            Function<Environment, String> function = selectorHelpMap.get(key);
            if (function != null) {
                return Optional.ofNullable(function.apply(environment));
            }
            return Optional.empty();
        }
    };
    private static HelpContainer helpBundle;
    private final List<Property<?>> properties = new ArrayList();
    protected final FlagProperty selector;

    protected static FlagProperty createSelectorProperty(String name, String shortName) {
        return AbstractConnectOptionType.createSelectorProperty(name, shortName, false);
    }

    protected static FlagProperty createSelectorProperty(final String name, final String shortName, final boolean mandatory) {
        FlagProperty selector = new FlagProperty(){

            @Override
            public String getName() {
                return name;
            }

            @Override
            public String getShortName() {
                return shortName;
            }

            @Override
            public String getHelpId() {
                return this.getName() + "_SELECTOR";
            }

            @Override
            public HelpContainerRef getHelpContainer() {
                return HelpContainerRef.create(selectorHelpContainer);
            }

            @Override
            public boolean matchesNull() {
                return !mandatory;
            }

            @Override
            public boolean isFlag() {
                return true;
            }
        };
        selectorHelpMap.put(selector.getHelpId(), environment -> MessageFormat.format(AbstractConnectOptionType.getHelpBundle().get("SELECTOR_PROPERTY", (Environment)environment).get(), name.toUpperCase()));
        selectorHelpMap.put(selector.getHelpId() + "_SH", environment -> MessageFormat.format(AbstractConnectOptionType.getHelpBundle().get("SELECTOR_PROPERTY_SH", (Environment)environment).get(), name.toUpperCase()));
        selectorHelpMap.put(selector.getHelpId() + "_EX", environment -> MessageFormat.format(AbstractConnectOptionType.getHelpBundle().get("SELECTOR_PROPERTY_EX", (Environment)environment).get(), name.toUpperCase(), name.toLowerCase()));
        return selector;
    }

    protected static HelpContainer getHelpBundle() {
        if (helpBundle == null) {
            String bundleName = ConnectorTypeCache.class.getPackageName() + ".Help";
            for (HelpContainer helpContainer : ScriptRunnerContext.getCurrentContext().getService(ConnectorTypeCache.class).getHelpContainers()) {
                if (!bundleName.equals(helpContainer.getContainerName())) continue;
                helpBundle = helpContainer;
                break;
            }
        }
        return helpBundle;
    }

    protected AbstractConnectOptionType(FlagProperty selector) {
        this.addProperty(selector);
        this.selector = selector;
    }

    protected void addProperty(Property<?> property) {
        this.properties.add(property);
    }

    protected void replaceProperty(Property<?> property) {
        this.properties.removeIf(p -> p.getName().equals(property.getName()));
        this.properties.add(property);
    }

    @Override
    public List<Property<?>> getProperties() {
        return Collections.unmodifiableList(this.properties);
    }
}

