/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.newscriptrunner.commands.connect;

import java.io.BufferedOutputStream;
import java.sql.Connection;
import oracle.dbtools.raptor.newscriptrunner.ISQLCommand;
import oracle.dbtools.raptor.newscriptrunner.ScriptRunnerContext;
import oracle.dbtools.raptor.newscriptrunner.commands.connect.Disconnector;
import oracle.dbtools.raptor.utils.SQLPLUSUtil;

public abstract class AbstractConnectionProcessor {
    protected final ScriptRunnerContext ctx;
    protected final BufferedOutputStream out;
    protected final ISQLCommand cmd;

    protected AbstractConnectionProcessor(ScriptRunnerContext ctx, ISQLCommand cmd) {
        this.ctx = ctx;
        this.cmd = SQLPLUSUtil.cleanCommand(cmd);
        this.out = ctx.getOutputStream();
    }

    protected void disposeConnection(Connection connection, Disconnector disconnector) {
        Object jline = this.ctx.getProperty("script.runner.jline");
        if (jline == null) {
            if (!SQLPLUSUtil.isConnectionClosed(connection)) {
                this.closeConnection(connection, disconnector);
            }
            this.ctx.setCloseConnection(true);
        } else {
            Boolean doNullBase = this.ctx.getBaseConnection() != null && connection != null && this.ctx.getBaseConnection().equals(connection);
            this.ctx.setCloseConnection(true);
            if (!SQLPLUSUtil.isConnectionClosed(connection)) {
                this.closeConnection(connection, disconnector);
            }
            if (doNullBase.booleanValue()) {
                this.ctx.setBaseConnection(null);
            }
            this.ctx.setCloseConnection(false);
        }
    }

    protected void closeConnection(Connection connection, Disconnector disconnector) {
        if (disconnector != null && this.ctx.getCloseConnection()) {
            disconnector.disconnect();
        }
    }
}

