/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.newscriptrunner.commands;

import java.sql.Connection;
import oracle.dbtools.raptor.newscriptrunner.ISQLCommand;
import oracle.dbtools.raptor.newscriptrunner.SQLCommand;
import oracle.dbtools.raptor.newscriptrunner.ScriptRunnerContext;
import oracle.dbtools.raptor.newscriptrunner.commands.AForAllStmtsCommand;
import oracle.dbtools.raptor.newscriptrunner.commands.IStoreCommand;
import oracle.dbtools.raptor.newscriptrunner.commands.StoreRegistry;
import oracle.dbtools.raptor.newscriptrunner.restricted.Restricted;

@Restricted(level=Restricted.Level.NONE)
public class SetVerify
extends AForAllStmtsCommand
implements IStoreCommand {
    private static final SQLCommand.StmtSubType m_cmdStmtSubType = SQLCommand.StmtSubType.G_S_SET_VERIFY;

    public SetVerify() {
        super(m_cmdStmtSubType);
    }

    @Override
    public boolean handleEvent(Connection conn, ScriptRunnerContext ctx, ISQLCommand cmd) {
        String toPrint = (String)cmd.getProperty("prop_printed_string");
        if (ctx.isVerifyOn() && toPrint != null && !toPrint.equals("") && !cmd.getStmtType().equals((Object)SQLCommand.StmtType.G_C_SQLPLUS)) {
            ctx.write(toPrint);
            cmd.setProperty("prop_printed_string", "");
        }
        if (cmd.getStmtSubType() == m_cmdStmtSubType) {
            boolean isHandled = this.doHandleCmd(conn, ctx, cmd);
            if (isHandled && cmd.getProperty("prop_status_boolean") != null) {
                this.setCmdOn((Boolean)cmd.getProperty("prop_status_boolean"));
            }
            return isHandled;
        }
        if (this.isListenerOn(conn, ctx, cmd)) {
            return this.doHandleWatcher(conn, ctx, cmd);
        }
        return false;
    }

    @Override
    public void doBeginWatcher(Connection conn, ScriptRunnerContext ctx, ISQLCommand cmd) {
        String toPrint = (String)cmd.getProperty("prop_printed_string");
        if (ctx.isVerifyOn() && toPrint != null && !toPrint.equals("")) {
            ctx.write(toPrint);
            cmd.setProperty("prop_printed_string", "");
        }
    }

    @Override
    public boolean doHandleCmd(Connection conn, ScriptRunnerContext ctx, ISQLCommand cmd) {
        ctx.setVerify((Boolean)cmd.getProperty("prop_status_boolean"));
        return true;
    }

    @Override
    public String getStoreCommand(ScriptRunnerContext ctx) {
        return StoreRegistry.getCommand("verify", ctx.isVerifyOn() ? "ON" : "OFF");
    }
}

