/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.newscriptrunner.commands;

import java.sql.Connection;
import java.sql.SQLException;
import oracle.dbtools.raptor.newscriptrunner.CommandListener;
import oracle.dbtools.raptor.newscriptrunner.ISQLCommand;
import oracle.dbtools.raptor.newscriptrunner.ScriptRunnerContext;
import oracle.dbtools.raptor.newscriptrunner.restricted.Restricted;
import oracle.jdbc.OracleConnection;

@Restricted(level=Restricted.Level.R4)
public class SetStatementCache
extends CommandListener {
    private static final String CMD = "setstatementcache";

    @Override
    public boolean handleEvent(Connection conn, ScriptRunnerContext ctx, ISQLCommand cmd) {
        if (ctx != null && ctx.getProperty("script.runner.sqlplus.nolog") != null && Boolean.valueOf(ctx.getProperty("script.runner.sqlplus.nolog").equals(Boolean.TRUE)).booleanValue()) {
            return false;
        }
        if (cmd.getLoweredTrimmedNoWhitespaceSQL().startsWith(CMD) && conn instanceof OracleConnection) {
            block8: {
                String[] parts = cmd.getSql().toLowerCase().trim().split(" ");
                try {
                    if (parts[2].equals("on")) {
                        ((OracleConnection)conn).setImplicitCachingEnabled(true);
                        ((OracleConnection)conn).setStatementCacheSize(100);
                        ctx.write("Statement Caching set to 100");
                        break block8;
                    }
                    if (parts[2].equals("off")) {
                        ((OracleConnection)conn).setImplicitCachingEnabled(true);
                        ctx.write("Statement Caching disabled");
                        break block8;
                    }
                    Integer size = 100;
                    try {
                        Integer.parseInt(parts[2]);
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                    ((OracleConnection)conn).setImplicitCachingEnabled(true);
                    ((OracleConnection)conn).setStatementCacheSize(size.intValue());
                    ctx.write("Statement Caching set to " + size);
                }
                catch (SQLException e) {
                    ctx.write("Failed to enable Statement Caching" + e.getLocalizedMessage());
                }
            }
            return true;
        }
        return false;
    }

    @Override
    public void beginEvent(Connection conn, ScriptRunnerContext ctx, ISQLCommand cmd) {
    }

    @Override
    public void endEvent(Connection conn, ScriptRunnerContext ctx, ISQLCommand cmd) {
    }
}

