/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.newscriptrunner.commands;

import java.sql.Connection;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import oracle.dbtools.raptor.newscriptrunner.CommandListener;
import oracle.dbtools.raptor.newscriptrunner.ISQLCommand;
import oracle.dbtools.raptor.newscriptrunner.ScriptRunnerContext;
import oracle.dbtools.raptor.newscriptrunner.commands.Messages;
import oracle.dbtools.raptor.newscriptrunner.commands.show.IShowCommand;

public class SetSecuredCol
extends CommandListener
implements IShowCommand {
    String[] aliases = new String[]{"securedcol"};
    final String auth = "******************************";
    final String unknown = "??????????????????????????????";

    @Override
    public String[] getShowAliases() {
        return this.aliases;
    }

    @Override
    public boolean handleShow(Connection conn, ScriptRunnerContext ctx, ISQLCommand cmd) {
        String unsupported = Messages.getString("SetSecuredCol.0");
        if (!ctx.isSQLPlusClassic()) {
            ctx.write(MessageFormat.format(unsupported, cmd.getSql()));
        }
        if (ctx.getProperty("script.runner.set_securedcol") != null) {
            String on = "OFF";
            boolean x = (Boolean)ctx.getProperty("script.runner.set_securedcol");
            if (x) {
                on = "ON";
                ctx.write(MessageFormat.format(Messages.getString("SetSecuredCol.1"), on, ctx.getProperty("script.runner.set_securedcol_unauth"), ctx.getProperty("script.runner.set_securedcol_unknown")));
            } else {
                on = "OFF";
                ctx.write(MessageFormat.format(Messages.getString("SetSecuredCol.2"), on));
            }
        }
        return true;
    }

    @Override
    public boolean needsDatabase() {
        return false;
    }

    @Override
    public boolean inShowAll() {
        return false;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public boolean handleEvent(Connection conn, ScriptRunnerContext ctx, ISQLCommand cmd) {
        String unsupported = Messages.getString("SetSecuredCol.0");
        if (!ctx.isSQLPlusClassic()) {
            ctx.write(MessageFormat.format(unsupported, cmd.getSql()));
        }
        String lauth = "******************************";
        String lunknown = "??????????????????????????????";
        String msg = Messages.getString("SetSecuredCol.3");
        String sql = cmd.getSql();
        String regex = "\"([^\"]*)\"|(\\S+)";
        Matcher m = Pattern.compile(regex).matcher(sql);
        ArrayList<String> ltokens = new ArrayList<String>();
        while (m.find()) {
            if (m.group(1) != null) {
                ltokens.add(m.group(1));
                continue;
            }
            ltokens.add(m.group(2));
        }
        String[] tokens = ltokens.toArray(new String[ltokens.size()]);
        if (tokens.length < 3) {
            ctx.write("");
            return true;
        }
        boolean onoff = false;
        String token = tokens[2];
        if (token.toLowerCase().equals("on") || token.toLowerCase().equals("off")) {
            onoff = token.toLowerCase().equals("on") ? Boolean.TRUE : Boolean.FALSE;
        } else {
            ctx.write("");
        }
        if (onoff) {
            msg = MessageFormat.format(msg, onoff ? "ON" : "OFF");
            if (tokens.length > 3) {
                if (tokens.length != 5 && tokens.length != 7) {
                    ctx.write(msg);
                    return true;
                }
                if (tokens.length == 5) {
                    if (tokens[3].equalsIgnoreCase("unauth") || tokens[3].equalsIgnoreCase("unauthorized")) {
                        lauth = tokens[4];
                    } else {
                        if (!tokens[3].equalsIgnoreCase("unk") && !tokens[3].equalsIgnoreCase("unknown")) {
                            ctx.write(msg);
                            return true;
                        }
                        lunknown = tokens[4];
                    }
                }
                if (tokens.length == 7) {
                    if (tokens[3].equalsIgnoreCase("unauth") || tokens[3].equalsIgnoreCase("unauthorized")) {
                        lauth = tokens[4];
                    } else {
                        if (!tokens[3].equalsIgnoreCase("unk") && !tokens[3].equalsIgnoreCase("unknown")) {
                            ctx.write(msg);
                            return true;
                        }
                        lunknown = tokens[4];
                    }
                    if (tokens[5].equalsIgnoreCase("unauth") || tokens[5].equalsIgnoreCase("unauthorized")) {
                        lauth = tokens[6];
                    } else {
                        if (!tokens[5].equalsIgnoreCase("unk") && !tokens[5].equalsIgnoreCase("unknown")) {
                            ctx.write(msg);
                            return true;
                        }
                        lunknown = tokens[6];
                    }
                }
            }
            ctx.putProperty("script.runner.set_securedcol", onoff);
            ctx.putProperty("script.runner.set_securedcol_unauth", lauth);
            ctx.putProperty("script.runner.set_securedcol_unknown", lunknown);
            return true;
        }
        if (tokens.length <= 3) {
            ctx.putProperty("script.runner.set_securedcol", onoff);
            ctx.putProperty("script.runner.set_securedcol_unauth", "******************************");
            ctx.putProperty("script.runner.set_securedcol_unknown", "??????????????????????????????");
            return true;
        }
        msg = MessageFormat.format(msg, onoff ? "ON" : "OFF");
        ctx.write(msg);
        return true;
    }

    @Override
    public void beginEvent(Connection conn, ScriptRunnerContext ctx, ISQLCommand cmd) {
    }

    @Override
    public void endEvent(Connection conn, ScriptRunnerContext ctx, ISQLCommand cmd) {
    }
}

