/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.newscriptrunner.commands;

import java.sql.Connection;
import java.text.MessageFormat;
import java.util.List;
import oracle.dbtools.raptor.newscriptrunner.CommandListener;
import oracle.dbtools.raptor.newscriptrunner.ISQLCommand;
import oracle.dbtools.raptor.newscriptrunner.ScriptRunnerContext;
import oracle.dbtools.raptor.newscriptrunner.commands.IStoreCommand;
import oracle.dbtools.raptor.newscriptrunner.commands.Messages;
import oracle.dbtools.raptor.newscriptrunner.commands.StoreRegistry;
import oracle.dbtools.raptor.newscriptrunner.commands.show.IShowCommand;
import oracle.dbtools.raptor.newscriptrunner.restricted.Restricted;
import oracle.dbtools.util.print.PrintTheme;

@Restricted(level=Restricted.Level.R4)
public class SetPrintTheme
extends CommandListener
implements IShowCommand,
IStoreCommand {
    @Override
    public boolean handleEvent(Connection conn, ScriptRunnerContext ctx, ISQLCommand cmd) {
        if (cmd.getLoweredTrimmedNoWhitespaceSQL().startsWith("setprinttheme")) {
            String[] parts = cmd.getSQLOrig().split(" ");
            if (parts.length < 3 || parts.length == 3 && parts[2].toUpperCase().contains("ultra_light".toUpperCase())) {
                if (ctx.getFeedback() != -2) {
                    ctx.write(Messages.getString("CLEAREDTHEME"));
                }
                ctx.putProperty("script.runner.set_printtheme", null);
                return true;
            }
            String theme = parts[2].trim();
            if (!this.isValid(ctx, theme)) {
                ctx.write(Messages.getString("INCORRECTTHEME"));
                return true;
            }
            ctx.putProperty("script.runner.set_printtheme", theme);
            return true;
        }
        return false;
    }

    private boolean isValid(ScriptRunnerContext ctx, String format) {
        if ((System.console() == null || System.getProperty("os.name").toLowerCase().contains("win")) && !format.toLowerCase().contains("ascii")) {
            ctx.write(Messages.getString("THEMENOTAVAILABLE"));
            return false;
        }
        boolean valid = false;
        List<String> list = PrintTheme.getAllThemes();
        for (String s : list) {
            if (!s.equalsIgnoreCase(format)) continue;
            return true;
        }
        return valid;
    }

    @Override
    public void beginEvent(Connection conn, ScriptRunnerContext ctx, ISQLCommand cmd) {
    }

    @Override
    public void endEvent(Connection conn, ScriptRunnerContext ctx, ISQLCommand cmd) {
    }

    @Override
    public boolean handleShow(Connection conn, ScriptRunnerContext ctx, ISQLCommand cmd) {
        String theme = null;
        theme = ctx.getProperties().containsKey("script.runner.set_printtheme") && ctx.getProperties().get("script.runner.set_printtheme") != null ? (String)ctx.getProperties().get("script.runner.set_printtheme") : PrintTheme.getDefault().toString();
        ctx.write("");
        ctx.write(MessageFormat.format(Messages.getString("PRINTTHEME"), theme) + "\n");
        return true;
    }

    @Override
    public String[] getShowAliases() {
        return new String[]{"printtheme"};
    }

    @Override
    public boolean needsDatabase() {
        return false;
    }

    @Override
    public boolean inShowAll() {
        return false;
    }

    @Override
    public String getStoreCommand(ScriptRunnerContext ctx) {
        String theme = ctx.getProperties().containsKey("script.runner.set_printtheme") && ctx.getProperties().get("script.runner.set_printtheme") != null ? (String)ctx.getProperties().get("script.runner.set_printtheme") : PrintTheme.getDefault().toString();
        return StoreRegistry.getCommand("printtheme", MessageFormat.format("{0}", theme));
    }
}

