/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.newscriptrunner.commands;

import java.sql.Connection;
import oracle.dbtools.raptor.newscriptrunner.CommandListener;
import oracle.dbtools.raptor.newscriptrunner.ISQLCommand;
import oracle.dbtools.raptor.newscriptrunner.ScriptRunnerContext;
import oracle.dbtools.raptor.newscriptrunner.commands.Messages;

public class SetEscChar
extends CommandListener {
    private static final String ESCCHAR = "escchar";

    @Override
    public void beginEvent(Connection conn, ScriptRunnerContext ctx, ISQLCommand cmd) {
    }

    @Override
    public void endEvent(Connection conn, ScriptRunnerContext ctx, ISQLCommand cmd) {
    }

    @Override
    public boolean handleEvent(Connection conn, ScriptRunnerContext ctx, ISQLCommand cmd) {
        String checkValue;
        String sql = cmd.getSql().trim().toLowerCase();
        String[] tokens = sql.split("\\s+");
        if (tokens.length != 3) {
            ctx.write(Messages.getString("NO_ESCAPE_VAL"));
        } else if (tokens[1].equalsIgnoreCase(ESCCHAR) && this.validate(checkValue = tokens[2], ctx)) {
            ctx.escChar = checkValue;
        }
        return true;
    }

    boolean validate(String input, ScriptRunnerContext ctx) {
        if ("off".equalsIgnoreCase(input)) {
            return true;
        }
        if ("$".equals(input)) {
            return true;
        }
        if ("%".equals(input)) {
            return true;
        }
        if ("?".equals(input)) {
            return true;
        }
        if ("@".equals(input)) {
            return true;
        }
        ctx.write(Messages.getString("INVALID_ESCAPE"));
        return false;
    }
}

