/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.newscriptrunner.commands;

import java.sql.Connection;
import java.util.Map;
import java.util.Optional;
import oracle.dbtools.common.utils.StringUtils;
import oracle.dbtools.raptor.newscriptrunner.CommandListener;
import oracle.dbtools.raptor.newscriptrunner.IGetPromptedFieldProvider;
import oracle.dbtools.raptor.newscriptrunner.IHelp;
import oracle.dbtools.raptor.newscriptrunner.ISQLCommand;
import oracle.dbtools.raptor.newscriptrunner.ScriptRunnerContext;
import oracle.dbtools.raptor.newscriptrunner.ScriptUtils;
import oracle.dbtools.raptor.newscriptrunner.commands.ArgumentOptions;
import oracle.dbtools.raptor.newscriptrunner.commands.ArgumentOptionsAll;
import oracle.dbtools.raptor.newscriptrunner.commands.Messages;
import oracle.dbtools.raptor.newscriptrunner.parameterparser.CommandParserConstants;
import oracle.dbtools.raptor.newscriptrunner.parameterparser.Help.CommandHelp;
import oracle.dbtools.raptor.newscriptrunner.parameterparser.exception.CommandHelpClassException;
import oracle.dbtools.raptor.newscriptrunner.parameterparser.exception.CommandOptionsClassException;
import oracle.dbtools.raptor.newscriptrunner.parameterparser.exception.ConnectionNotValidException;
import oracle.dbtools.raptor.newscriptrunner.parameterparser.exception.ExtraParameterException;
import oracle.dbtools.raptor.newscriptrunner.parameterparser.exception.InvalidCommandException;
import oracle.dbtools.raptor.newscriptrunner.parameterparser.exception.MissingRequiredParameterException;
import oracle.dbtools.raptor.newscriptrunner.parameterparser.exception.ParameterFailedValidationException;
import oracle.dbtools.raptor.newscriptrunner.parameterparser.interfaces.ICommandSyntax;
import oracle.dbtools.raptor.newscriptrunner.parameterparser.parameter.StandardParameter;
import oracle.dbtools.raptor.newscriptrunner.parameterparser.parser.CommandParser;
import oracle.dbtools.raptor.newscriptrunner.util.help.HelpPages;
import oracle.dbtools.raptor.newscriptrunner.util.help.HelpPagesBuilder;
import oracle.dbtools.raptor.newscriptrunner.util.parser.CommandPageAssemblers;
import oracle.dbtools.raptor.newscriptrunner.util.parser.Type;

public class ArgumentCommand
extends CommandListener
implements IHelp,
ICommandSyntax {
    private static final String HELP_BUNDLE = "argument.Help";
    private static final String NL = "\n";
    private String[] aliases = new String[]{"argument", "arg"};
    public static String DEFAULT = "default";
    private CommandHelp help;

    @Override
    public boolean handleEvent(Connection conn, ScriptRunnerContext ctx, ISQLCommand cmd) {
        if (cmd.getProperty("STRIPPED_CONTINUATION") == null) {
            cmd.setSql(ScriptUtils.checkforContinuationChars(cmd.getSql()));
        }
        if (this.startsWithAlias(cmd.getSql(), this.aliases)) {
            ScriptRunnerContext.Parameters params = ctx.getParameterInstance();
            try {
                this.help = new CommandHelp(ctx, ArgumentOptions.class);
                CommandParser.loadParams("argument.parms", cmd.getSql(), ctx, ArgumentOptions.class, false, true, true);
                boolean _help = params.getParameterAsBoolean("argument.parms", CommandParserConstants.HELP);
                if (_help) {
                    ctx.write(this.help.getCommandHelp());
                    return true;
                }
                String argNumber = params.getParameterAsInt("argument.parms", "arg_num").toString();
                String command = params.getParameterAsString("argument.parms", "action");
                String commandString = StringUtils.unQuote(params.getParameterAsString("argument.parms", "action_value"));
                String comment = StringUtils.unQuote(params.getParameterAsString("argument.parms", "comment_value"));
                switch (command.toLowerCase()) {
                    case "default": {
                        if (!ctx.getMap().containsKey(argNumber)) {
                            ctx.getMap().put(argNumber, commandString);
                        }
                        break;
                    }
                    case "prompt": {
                        if (!ctx.getMap().containsKey(argNumber)) {
                            IGetPromptedFieldProvider provider = ctx.getSubstitutionFieldProvider();
                            String prompterResult = provider.getPromptedField(ctx, commandString, false);
                            ctx.getMap().put(argNumber, prompterResult);
                        }
                        break;
                    }
                    default: {
                        ctx.writeln("some error here\n" + this.getHelp());
                        break;
                    }
                }
            }
            catch (CommandHelpClassException | CommandOptionsClassException | ConnectionNotValidException | ExtraParameterException | InvalidCommandException | MissingRequiredParameterException | ParameterFailedValidationException e) {
                ctx.write(e.getLocalizedMessage() + NL);
                ctx.write(Messages.getString("FAILED_REQUEST"));
                params.printParametersAsTable("argument.parms");
            }
            return true;
        }
        return false;
    }

    @Override
    public void beginEvent(Connection conn, ScriptRunnerContext ctx, ISQLCommand cmd) {
    }

    @Override
    public void endEvent(Connection conn, ScriptRunnerContext ctx, ISQLCommand cmd) {
    }

    @Override
    public String getCommand() {
        return "argument";
    }

    @Override
    public String getCommandLongName() {
        return "argument";
    }

    @Override
    public Map<String, Map<String, StandardParameter>> getCommandModel() {
        return ArgumentOptions.commandModel;
    }

    @Override
    public String getCommandShortName() {
        return "arg";
    }

    @Override
    public Optional<String> getHelp(ScriptRunnerContext ctx, String pagePath) {
        return this.createHelpPages(ctx, ArgumentOptionsAll.getCommandType()).get(pagePath);
    }

    @Override
    public boolean isSqlPlus() {
        return false;
    }

    @Override
    public String getDescription() {
        return Messages.getString("ARGUMENT_COMMAND_DESCRIPTION");
    }

    private HelpPages createHelpPages(ScriptRunnerContext ctx, Type type) {
        HelpPages helpPages = new HelpPagesBuilder(ctx.getEnvironment()).enableColorCode(ctx.isCommandLine()).addHelpContainerFor(this, HELP_BUNDLE).addPages(new CommandPageAssemblers(type, new Type[0])).build();
        return helpPages;
    }
}

