/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.format;

import java.io.IOException;
import java.sql.Clob;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.dbtools.raptor.format.ResultsFormatter;
import oracle.dbtools.raptor.utils.DataTypesUtil;

public class HTMLFormatter
extends ResultsFormatter {
    public static final String TYPE = "HTML";
    public static final String EXT = "htm";
    public static final String KEY_REC_TERM = "EXPORT_HTM_REC_TERM";
    private boolean _result = true;
    private ArrayList<String> m_colnames = null;
    private ArrayList<String> m_currRow = null;
    private static final String MIME = "text/html";
    private static final String HEADER = "<!DOCTYPE html>\n<html>\n\n<head>\n  <meta charset='@@ENCODING@@'>\n  \n  <title>Result Data</title>\n  \n  <meta name=\"viewport\" content=\"width=device-width, initial-scale=1.0\">\n\n  \n  <style>\n  * { \n    margin: 0; \n    padding: 0; \n  }\n  body { \n    font: 14px/1.4 Palatino, Serif; \n  }\n  \n  /* \n  Generic Styling, for Desktops/Laptops \n  */\n  table { \n    width: 100%; \n    border-collapse: collapse; \n  }\n  /* Zebra striping */\n  tr:nth-of-type(odd) { \n    background: #eee; \n  }\n  th { \n    background: #333; \n    color: white; \n    font-weight: bold; \n  }\n  td, th { \n    padding: 6px; \n    border: 1px solid #9B9B9B; \n    text-align: left; \n  }\n  @media \n  only screen and (max-width: 760px),\n  (min-device-width: 768px) and (max-device-width: 1024px)  {\n    table, thead, tbody, th, td, tr { display: block; }\n    thead tr { position: absolute;top: -9999px;left: -9999px;}\n    tr { border: 1px solid #9B9B9B; }\n    td { border: none;border-bottom: 1px solid #9B9B9B; position: relative;padding-left: 50%; }\n    \n    td:before { position: absolute;top: 6px;left: 6px;width: 45%; padding-right: 10px; white-space: nowrap;}\n    \n    /*\n    Label the data\n    */";
    private static final String HEADER_PART2 = "  }\n  \n  /* Smartphones (portrait and landscape) ----------- */\n  @media only screen\n  and (min-device-width : 320px)\n  and (max-device-width : 480px) {\n    body { \n      padding: 0; \n      margin: 0; \n      width: 320px; }\n    }\n  \n  /* iPads (portrait and landscape) ----------- */\n  @media only screen and (min-device-width: 768px) and (max-device-width: 1024px) {\n    body { \n      width: 495px; \n    }\n  }\n  \n  </style>\n  <!--<![endif]-->\n<script type=\"text/javascript\">\n\nfunction search(){\n  \n  var s = document.getElementById('search').value;\n\n  rows = document.getElementById('data').getElementsByTagName('TR');\n  for(var i=0;i<rows.length;i++){\n    if ( rows[i].textContent.indexOf(s)>0  || s.length==0 ) {\n\t  rows[i].style.display ='';\n    } else {\n      rows[i].style.display ='none';\n    }\n  }\n}\n\n\nvar timer;\nfunction delayedSearch() {\n\tclearTimeout(timer);\n\tconsole.log('delay-ing')\n    timer = setTimeout(function () {\n\t\tconsole.log('delay-running')\n\t\tsearch();\n    }, 500);\n  }</script>\n</head>\n\n<body>\n<div><input type=\"text\" size=\"30\" maxlength=\"1000\" value=\"\" id=\"search\" onkeyup=\"delayedSearch();\" /><input type=\"button\" value=\"Go\" onclick=\"lsearch();\"/> </div>";

    public HTMLFormatter() {
        super(TYPE, "HTML File", EXT);
    }

    @Override
    public String getMimeType() {
        return MIME;
    }

    @Override
    public boolean isTextEditorReadable() {
        return false;
    }

    @Override
    public void start() throws IOException {
        String name;
        int i;
        this.write(HEADER.replace("@@ENCODING@@", this.getEncode()) + this.getLineTerminator());
        int size = this.getColumnCount();
        this.m_colnames = new ArrayList();
        for (i = 0; i < size; ++i) {
            name = this.getColumnName(i);
            this.m_colnames.add(name);
            this.write("td:nth-of-type(" + Integer.toString(i + 1) + "):before { content: \"" + name + "\"; }" + this.getLineTerminator());
        }
        this.write(HEADER_PART2 + this.getLineTerminator());
        this.write("<table><thead><tr>");
        for (i = 0; i < size; ++i) {
            name = this.getColumnName(i);
            this.write("\t<th>" + name + "</th>" + this.getLineTerminator());
        }
        this.write("</tr></thead>\n<tbody id=\"data\">\n" + this.getLineTerminator());
    }

    @Override
    public void startRow() throws IOException {
        this.m_currRow = new ArrayList();
        this.write("\t<tr>" + this.getLineTerminator());
    }

    @Override
    public void printColumn(Object col, int viewIndex, int modelIndex) throws IOException {
        if (super.getDataType(viewIndex) == 2) {
            this.write("<td align=\"right\">");
        } else {
            this.write("<td>");
        }
        String lastVal = "";
        if (col instanceof List) {
            Object str = "<table><tr>";
            List l = (List)col;
            List zeroThRow = (List)l.get(0);
            int c = 0;
            for (Object fld : zeroThRow) {
                str = (String)str + "<th>" + String.valueOf(zeroThRow.get(c)) + "</th>";
                ++c;
            }
            str = (String)str + "</tr>";
            int i = 0;
            for (Object row : l) {
                if (i > 0) {
                    str = (String)str + "<tr>";
                    int j = 0;
                    for (Object fld : (List)row) {
                        lastVal = this.getValue(fld).toString();
                        str = (String)str + "<td>" + this.escape(lastVal) + "</td>";
                        ++j;
                    }
                    str = (String)str + "</tr>";
                }
                ++i;
            }
            str = (String)str + "</table>";
            this.write((String)str);
        } else {
            lastVal = this.getValue(col);
            this.write(this.escape(lastVal));
        }
        this.write("</td>" + this.getLineTerminator());
        if (lastVal == null) {
            this.m_currRow.add("");
        } else {
            this.m_currRow.add(lastVal);
        }
    }

    private String escape(String string) {
        if (string != null) {
            return string.replace("<", "&lt;").replace(">", "&gt;");
        }
        return "&nbsp;";
    }

    @Override
    public void endRow() throws IOException {
        this.write("\t</tr>" + this.getLineTerminator());
    }

    @Override
    public void end() throws IOException {
        this.write("</tbody></table><!-- SQL:\n" + this.getWrapper().getSQL() + "--></body></html>\n");
        HTMLFormatter.handleColumnNewVal(this.getScriptContext(), this.m_colnames, this.m_currRow);
    }

    public void setResult(boolean result) {
        this._result = result;
    }

    @Override
    public void setTableName(String tName) {
    }

    @Override
    public boolean allowsLobs() {
        return true;
    }

    @Override
    public boolean isLineTerminatorSupported() {
        return true;
    }

    @Override
    public String getLineTerminatorConfigKey() {
        return KEY_REC_TERM;
    }

    @Override
    protected String getValue(Object col) {
        Object val = null;
        try {
            if (col instanceof Clob) {
                Integer size = null;
                if (this.getScriptContext() != null) {
                    size = (Integer)this.getScriptContext().getProperty("script.runner.setlong");
                }
                val = size != null ? DataTypesUtil.stringValue(col, this.getConnection(), size) : DataTypesUtil.stringValue(col, this.getConnection());
            } else {
                val = super.getValue(col);
            }
        }
        catch (Exception e) {
            Logger.getLogger(DataTypesUtil.class.getName()).log(Level.WARNING, e.getStackTrace()[0].toString(), e);
        }
        return val != null ? val.toString() : null;
    }

    @Override
    public Boolean isCandidateForSpoolMax() {
        return true;
    }
}

