/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.datatypes.strategies.preparedstatement;

import java.sql.SQLException;
import oracle.dbtools.raptor.datatypes.BindContext;
import oracle.dbtools.raptor.datatypes.BindingMode;
import oracle.dbtools.raptor.datatypes.BindingStyle;
import oracle.dbtools.raptor.datatypes.DataBinding;
import oracle.dbtools.raptor.datatypes.DataType;
import oracle.dbtools.raptor.datatypes.DataValue;
import oracle.dbtools.raptor.datatypes.ValueType;
import oracle.dbtools.raptor.datatypes.strategies.preparedstatement.PrepareBindingBase;
import oracle.jdbc.OraclePreparedStatement;

public class PrepareBindingDatumAtName<S extends OraclePreparedStatement, P extends DataBinding>
extends PrepareBindingBase<S, P> {
    public PrepareBindingDatumAtName(BindContext<S> context, P param) {
        this(context, param, param.getDataType());
    }

    public PrepareBindingDatumAtName(BindContext<S> context, P param, DataType dataType) {
        this(context, param, dataType, param.getMode());
    }

    public PrepareBindingDatumAtName(BindContext<S> context, P param, BindingMode modeOverride) {
        this(context, param, param.getDataType(), modeOverride);
    }

    protected PrepareBindingDatumAtName(BindContext<S> context, P param, DataType dataType, BindingMode modeOverride) {
        super(context, param, dataType, modeOverride);
    }

    @Override
    public BindingStyle getBindingStyle(BindingMode mode) {
        if (this.getByNameBindToken() != null) {
            return BindingStyle.NAME;
        }
        return BindingStyle.POSITION;
    }

    @Override
    public String getBindToken(BindingMode mode) {
        if (this.getBindingStyle(mode) == BindingStyle.NAME) {
            return this.getByNameBindToken();
        }
        return this.getByPositionBindToken();
    }

    @Override
    protected void customBindIN(DataValue value) throws SQLException {
        String bindToken = this.getByNameBindToken();
        if (this.getBindingStyle(this.getMode()) == BindingStyle.NAME) {
            this.customBindIN(value, bindToken);
        } else {
            this.customBindIN(value, this.remapPosition(bindToken));
        }
    }

    protected void customBindIN(DataValue value, int pos) throws SQLException {
        Object typedValue;
        Object object = typedValue = value != null ? value.getTypedValue(this.getBindContext().getDataTypeConnectionProvider(), ValueType.DATUM) : null;
        if (typedValue != null) {
            ((OraclePreparedStatement)this.getStatement()).setObject(pos, typedValue, this.getDataType().getSqlDataType(ValueType.DATUM));
        } else {
            ((OraclePreparedStatement)this.getStatement()).setNull(pos, this.getDataType().getSqlDataType(ValueType.DATUM));
        }
    }

    protected void customBindIN(DataValue value, String name) throws SQLException {
        Object typedValue;
        Object object = typedValue = value != null ? value.getTypedValue(this.getBindContext().getDataTypeConnectionProvider(), ValueType.DATUM) : null;
        if (typedValue != null) {
            ((OraclePreparedStatement)this.getStatement()).setObjectAtName(name, typedValue, this.getDataType().getSqlDataType(ValueType.DATUM));
        } else {
            String userTypeName = this.getDataType().getUserDataTypeString();
            if (userTypeName != null) {
                ((OraclePreparedStatement)this.getStatement()).setNullAtName(name, this.getDataType().getSqlDataType(ValueType.DATUM), userTypeName);
            } else {
                ((OraclePreparedStatement)this.getStatement()).setNullAtName(name, this.getDataType().getSqlDataType(ValueType.DATUM));
            }
        }
    }

    @Override
    protected void customBindOUT() throws SQLException {
        String bindToken = this.getByNameBindToken();
        if (this.getBindingStyle(this.getMode()) == BindingStyle.NAME) {
            this.customBindOUT(bindToken);
        } else {
            this.customBindOUT(this.remapPosition(bindToken));
        }
    }

    protected void customBindOUT(String bindToken) throws SQLException {
        this.customBindOUT(this.remapPosition(bindToken));
    }

    protected void customBindOUT(int pos) throws SQLException {
        String userTypeName = this.getDataType().getUserDataTypeString();
        if (userTypeName != null) {
            ((OraclePreparedStatement)this.getStatement()).registerReturnParameter(pos, this.getDataType().getSqlDataType(ValueType.DATUM), userTypeName);
        } else {
            ((OraclePreparedStatement)this.getStatement()).registerReturnParameter(pos, this.getDataType().getSqlDataType(ValueType.DATUM));
        }
    }

    @Override
    protected void customReportBinding(StringBuilder buffer, String nullToken, DataValue value) {
        this.reportBinding(buffer, nullToken, this.getBindToken(this.getMode()), value.getDataType(), this.getMode().getEffectiveMode(), value.getStringValue().toString());
    }
}

