/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.datatypes.strategies.callablestatement;

import java.io.IOException;
import java.io.InputStream;
import java.sql.SQLException;
import oracle.dbtools.raptor.datatypes.BindContext;
import oracle.dbtools.raptor.datatypes.DataBinding;
import oracle.dbtools.raptor.datatypes.DataTypeIOException;
import oracle.dbtools.raptor.datatypes.DataValue;
import oracle.dbtools.raptor.datatypes.ValueType;
import oracle.dbtools.raptor.datatypes.objects.LongBinary;
import oracle.dbtools.raptor.datatypes.strategies.callablestatement.CallableBindingDatumAtName;
import oracle.jdbc.OracleCallableStatement;

public class CallableBindingLONGBINARY<S extends OracleCallableStatement, P extends DataBinding>
extends CallableBindingDatumAtName<S, P> {
    public CallableBindingLONGBINARY(BindContext<S> context, P param) {
        super(context, param);
    }

    @Override
    protected void customBindIN(DataValue value, int pos) throws SQLException {
        LongBinary longBinary = (LongBinary)value.getTypedValue(this.getBindContext().getDataTypeConnectionProvider(), ValueType.DEFAULT);
        if (longBinary != null && !longBinary.isNull()) {
            try {
                ((OracleCallableStatement)this.getStatement()).setBinaryStream(pos, longBinary.getInputStream(), (int)longBinary.getLength());
            }
            catch (IOException e) {
                throw new DataTypeIOException(e);
            }
        } else {
            ((OracleCallableStatement)this.getStatement()).setNull(pos, this.getDataType().getSqlDataType(ValueType.JDBC));
        }
    }

    @Override
    protected void customBindIN(DataValue value, String name) throws SQLException {
        LongBinary longBinary = (LongBinary)value.getTypedValue(this.getBindContext().getDataTypeConnectionProvider(), ValueType.DEFAULT);
        if (longBinary != null && !longBinary.isNull()) {
            try {
                ((OracleCallableStatement)this.getStatement()).setBinaryStreamAtName(name, longBinary.getInputStream(), (int)longBinary.getLength());
            }
            catch (IOException e) {
                throw new DataTypeIOException(e);
            }
        } else {
            ((OracleCallableStatement)this.getStatement()).setNull(name, this.getDataType().getSqlDataType(ValueType.JDBC));
        }
    }

    @Override
    protected DataValue customOutput(int pos) throws SQLException {
        InputStream istream = ((OracleCallableStatement)this.getStatement()).getBinaryStream(pos);
        return this.getDataType().getDataValue(istream);
    }
}

