/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.datatypes.metadata;

import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import oracle.dbtools.raptor.datatypes.BindingMode;
import oracle.dbtools.raptor.datatypes.DataTypeFactory;
import oracle.dbtools.raptor.datatypes.NamedValue;
import oracle.dbtools.raptor.datatypes.TypeMetadata;
import oracle.dbtools.raptor.utils.DataTypesUtil;

public final class ArgMetadata
extends NamedValue<Map<TypeMetadata.Attribute, Object>> {
    final TreeMap<Integer, ArgMetadata> components;
    final BindingMode mode;
    final boolean defaulted;
    final String defaultValue;
    final Integer defaultLength;
    final ArgIdentifier identifier;
    Integer minCompPosition;
    Integer maxCompPosition;

    public ArgMetadata(ArgIdentifier identifier, String argName, String inOut, Map<TypeMetadata.Attribute, Object> typeAttributes, String defaulted, String defaultValue, Integer defaultLength, List<ArgMetadata> components) {
        super(argName, typeAttributes);
        this.identifier = identifier;
        this.components = new TreeMap();
        this.mode = argName == null && identifier.getPosition() != null && identifier.getPosition() == 0 ? BindingMode.RETURN : (inOut != null ? BindingMode.getBindingMode(inOut) : null);
        this.defaulted = "Y".equals(defaulted);
        this.defaultValue = defaultValue;
        this.defaultLength = defaultLength;
        this.minCompPosition = null;
        this.maxCompPosition = null;
        if (components != null) {
            for (ArgMetadata component : components) {
                this.addComponent(component);
            }
        }
    }

    public ArgMetadata(ArgIdentifier identifier, String argName, Map<TypeMetadata.Attribute, Object> typeAttributes, String defaulted, String defaultValue, Integer defaultLength, List<ArgMetadata> components) {
        this(identifier, argName, null, typeAttributes, defaulted, defaultValue, defaultLength, components);
    }

    public ArgMetadata(ArgIdentifier identifier, String argName, String inOut, Map<TypeMetadata.Attribute, Object> typeAttributes, String defaulted, String defaultValue, Integer defaultLength) {
        this(identifier, argName, inOut, typeAttributes, defaulted, defaultValue, defaultLength, null);
    }

    public ArgMetadata(ArgIdentifier identifier, String argName, Map<TypeMetadata.Attribute, Object> typeAttributes, String defaulted, String defaultValue, Integer defaultLength) {
        this(identifier, argName, null, typeAttributes, defaulted, defaultValue, defaultLength);
    }

    public ArgMetadata(ArgIdentifier identifier, String argName, Map<TypeMetadata.Attribute, Object> typeAttributes) {
        this(identifier, argName, null, typeAttributes, null, null, null);
    }

    public ArgMetadata(ArgIdentifier identifier, String argName, String inOut, Map<TypeMetadata.Attribute, Object> typeAttributes, String defaulted) {
        this(identifier, argName, inOut, typeAttributes, defaulted, null, null, null);
    }

    public ArgIdentifier getIdentifier() {
        return this.identifier;
    }

    public boolean isDefaulted() {
        return this.defaulted;
    }

    public String getDefaultValue() {
        return this.defaultValue;
    }

    public Integer getDefaultLength() {
        return this.defaultLength;
    }

    public BindingMode getMode() {
        return this.mode;
    }

    public ArgMetadata getComponent(int position) {
        return this.components.get(position);
    }

    boolean addComponent(ArgMetadata component) {
        if (component != null) {
            Integer position = component.identifier.getPosition();
            if (position == null) {
                position = this.components.size() + 1;
            } else if (position < 0) {
                throw new IllegalArgumentException();
            }
            ArgMetadata oldComponent = this.components.put(position, component);
            if (oldComponent != null && oldComponent != component) {
                this.components.put(oldComponent.identifier.getPosition(), oldComponent);
                throw new IllegalArgumentException();
            }
            if (this.minCompPosition == null || this.minCompPosition > position) {
                this.minCompPosition = position;
            }
            if (this.maxCompPosition == null || this.maxCompPosition < position) {
                this.maxCompPosition = position;
            }
            return true;
        }
        throw new IllegalArgumentException();
    }

    public int countComponents() {
        return this.components.size();
    }

    public boolean hasComponents() {
        return !this.components.isEmpty();
    }

    public Iterator<ArgMetadata> componentIterator() {
        return this.components.values().iterator();
    }

    public NamedValue<TypeMetadata> extractTypeMetadata(DataTypeFactory dataTypeFactory) {
        HashMap<TypeMetadata.Attribute, Object> typeAttributes = new HashMap<TypeMetadata.Attribute, Object>((Map)this.getValue());
        LinkedList<NamedValue<TypeMetadata>> typeComponents = new LinkedList<NamedValue<TypeMetadata>>();
        for (ArgMetadata argMetadata : this.components.values()) {
            typeComponents.add(argMetadata.extractTypeMetadata(dataTypeFactory));
        }
        if (typeComponents.size() != 0) {
            typeAttributes.put(TypeMetadata.Attribute.TYPE_COMPONENTS, typeComponents);
        }
        TypeMetadata typeMetaData = dataTypeFactory.getTypeMetadata(typeAttributes);
        return new NamedValue<TypeMetadata>(this.getName(), typeMetaData);
    }

    boolean identifiedBy(ArgIdentifier identifier) {
        return this.identifier.matches(identifier);
    }

    public Integer getMinCompPosition() {
        return this.minCompPosition;
    }

    public Integer getMaxCompPosition() {
        return this.maxCompPosition;
    }

    public static final class ArgIdentifier
    implements Cloneable {
        private final Integer position;
        private final Integer level;

        ArgIdentifier(int position, Integer level) {
            this.position = position;
            this.level = level;
        }

        public Object clone() {
            return new ArgIdentifier(this.position, this.level);
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj instanceof ArgIdentifier) {
                ArgIdentifier other = (ArgIdentifier)obj;
                return DataTypesUtil.areEqual(this.position, other.position) && DataTypesUtil.areEqual(this.level, other.level);
            }
            return false;
        }

        public int hashCode() {
            int hash = 23;
            hash = 31 * hash + (this.position == null ? 0 : this.position.hashCode());
            hash = 31 * hash + (this.level == null ? 0 : this.level.hashCode());
            return hash;
        }

        public Integer getPosition() {
            return this.position;
        }

        public Integer getLevel() {
            return this.level;
        }

        boolean matches(ArgIdentifier identifier) {
            return DataTypesUtil.areEqual(this, identifier);
        }
    }
}

