/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.backgroundTask.jobs;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.FutureTask;
import java.util.function.Predicate;
import java.util.stream.Stream;
import oracle.dbtools.raptor.backgroundTask.IRaptorTaskStatus;
import oracle.dbtools.raptor.backgroundTask.ITaskTracker;
import oracle.dbtools.raptor.backgroundTask.Messages;
import oracle.dbtools.raptor.backgroundTask.RaptorTask;
import oracle.dbtools.raptor.backgroundTask.RaptorTaskManager;
import oracle.dbtools.raptor.backgroundTask.TaskException;
import oracle.dbtools.raptor.backgroundTask.command.CommandTask;
import oracle.dbtools.raptor.backgroundTask.jobs.JobCancelException;
import oracle.dbtools.raptor.backgroundTask.jobs.JobNotFoundException;
import oracle.dbtools.raptor.newscriptrunner.ISQLCommand;
import oracle.dbtools.raptor.newscriptrunner.ScriptExecutor;
import oracle.dbtools.raptor.newscriptrunner.ScriptRunnerContext;

public class JobsProcessor {
    private static final List<Job> jobs = new ArrayList<Job>();
    private static final JobsTaskTracker<?> jobsTaskTracker = new JobsTaskTracker();
    private static final Object _waitLock = new Object();

    private JobsProcessor() {
    }

    public static void init(ScriptRunnerContext ctx) {
        RaptorTaskManager.getInstance().setIDETaskTracker(jobsTaskTracker);
    }

    public static List<Job> list() {
        return Collections.unmodifiableList(jobs);
    }

    public static void cancel(int id) throws JobCancelException {
        JobsProcessor.list().stream().filter(job -> job.getId() == id).map(Job::getTask).forEach(JobsProcessor::cancelTask);
    }

    public static void cancel(String taskName) throws JobCancelException {
        JobsProcessor.list().stream().map(Job::getTask).filter(task -> task.getDescriptor().getName().equalsIgnoreCase(taskName)).forEach(JobsProcessor::cancelTask);
    }

    public static void cancelTask(RaptorTask<?> task) {
        if (task != null) {
            IRaptorTaskStatus status = task.getStatus();
            if (status == IRaptorTaskStatus.FINISHED) {
                throw new JobCancelException(Messages.getString("CANT_CANCEL_TASK_ALREADY_FINISHED"));
            }
            if (status == IRaptorTaskStatus.FAILED) {
                throw new JobCancelException(Messages.getString("CANT_CANCEL_TASK_ALREADY_FAILED"));
            }
            if (status == IRaptorTaskStatus.PAUSED) {
                throw new JobCancelException(Messages.getString("CANT_CANCEL_TASK_PAUSED"));
            }
            if (!task.isCancellable()) {
                throw new JobCancelException(Messages.getString("TASK_NOT_CANCELLABLE"));
            }
            task.requestCancel();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int delete(Predicate<Job> predicate) {
        int cnt = 0;
        List<Job> list = jobs;
        synchronized (list) {
            Iterator<Job> iter = jobs.iterator();
            while (iter.hasNext()) {
                Job job = iter.next();
                if (!predicate.test(job)) continue;
                iter.remove();
                ++cnt;
            }
        }
        return cnt;
    }

    public static void deleteLogs() {
        try (Stream<Path> stream = Files.walk(Paths.get(CommandTask.getLogPath(), new String[0]), new FileVisitOption[0]);){
            stream.filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).forEach(file -> {
                try {
                    Files.delete(file);
                }
                catch (IOException e) {
                    throw new UncheckedIOException(e);
                }
            });
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public static Job run(final ScriptRunnerContext ctx, Connection conn, ISQLCommand cmd, final String cmdToRun, String taskname, final List<String> wait4) {
        if (cmdToRun == null || cmdToRun.isBlank()) {
            throw new IllegalArgumentException(Messages.getString("NO_TASKS_AVAILABLE"));
        }
        String tname = taskname;
        if (tname == null || tname.isBlank()) {
            int allowedTaskNameLength = 32;
            tname = cmdToRun.replaceAll("[^a-zA-Z0-9\\.\\-_]", "");
            if (cmdToRun.length() > allowedTaskNameLength) {
                tname = tname.substring(0, allowedTaskNameLength);
            }
        }
        CommandTask task = new CommandTask(tname, false){

            @Override
            protected Void doWork() throws TaskException {
                if (wait4 != null && !wait4.isEmpty()) {
                    this.wait4(wait4);
                    JobsProcessor.checkFailedTasks(this, wait4);
                    try {
                        this.checkCanProceed();
                    }
                    catch (ExecutionException e) {
                        return null;
                    }
                }
                try (Connection clonedConnection = this.getConn();){
                    ScriptExecutor scriptExecutor = new ScriptExecutor(clonedConnection);
                    scriptExecutor.setScriptRunnerContext(this.getCtx());
                    scriptExecutor.setStmt(cmdToRun);
                    scriptExecutor.run();
                    if (Boolean.TRUE.equals(this.getCtx().getProperty("sqldev.error"))) {
                        String errorMsg = (String)this.getCtx().getProperty("sqldev.last.err.message");
                        this.getDescriptor().setMessage(errorMsg);
                        throw new TaskException(errorMsg);
                    }
                    this.getDescriptor().setMessage(Messages.getString("JOBS_RUN_SUCCESSFUL"));
                    this.getDescriptor().makeProgress(1);
                }
                catch (SQLException e) {
                    ctx.writeln(e.getMessage());
                }
                return null;
            }
        };
        ctx.putProperty("BACKGROUND", true);
        task.setCancellable(true);
        task.setPausable(true);
        task.setCtx(ctx);
        task.setConn(conn);
        task.setCmd(cmdToRun);
        RaptorTaskManager.getInstance().addTask(task);
        ctx.putProperty("BACKGROUND", false);
        return JobsProcessor.getJob(task);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void checkFailedTasks(CommandTask commandTask, List<String> tasks) throws TaskException {
        for (String task : tasks) {
            List<Job> list = jobs;
            synchronized (list) {
                for (Job job : jobs) {
                    if (!task.equals(job.getTask().getDescriptor().getName()) || job.getTask().getStatus() != IRaptorTaskStatus.FAILED) continue;
                    String message = Messages.format("JOBS_RUN_FAIL_DEPENDENT", job.getTask().getDescriptor().getName());
                    commandTask.getDescriptor().setMessage(message);
                    commandTask.getCtx().writeln(message);
                    throw new TaskException(message);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Job getJob(CommandTask task) {
        while (true) {
            List<Job> list = jobs;
            synchronized (list) {
                for (Job job : jobs) {
                    if (task != job.getTask()) continue;
                    return job;
                }
            }
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException e) {
                throw new JobNotFoundException(Messages.format("ERROR_SCHEDULING_JOB", e.getMessage()));
            }
        }
    }

    public static void wait4(List<String> taskList, Integer delay) {
        if (delay != null && delay > 0) {
            try {
                Thread.sleep(delay.intValue());
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        if (taskList != null && !taskList.isEmpty()) {
            RaptorTaskManager.getInstance().wait4(taskList, _waitLock);
        }
    }

    private static class JobsTaskTracker<V>
    implements ITaskTracker<V> {
        private JobsTaskTracker() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void add(RaptorTask<V> task, FutureTask<V> rfTask) {
            if (!this.isRaptorTaskCleanup(task)) {
                List<Job> list = jobs;
                synchronized (list) {
                    jobs.add(new Job(task, rfTask));
                }
            }
        }

        private boolean isRaptorTaskCleanup(RaptorTask<?> task) {
            return task.getClass().getName().equals("oracle.dbtools.raptor.backgroundTask.RaptorTaskManager$RaptorFutureTask$1$1");
        }
    }

    public static class Job {
        private final RaptorTask<?> task;
        private final FutureTask<?> rfTask;
        private final int id = nextId++;
        private static int nextId = 0;

        public Job(RaptorTask<?> task, FutureTask<?> rfTask) {
            this.task = task;
            this.rfTask = rfTask;
        }

        public int getId() {
            return this.id;
        }

        public RaptorTask<?> getTask() {
            return this.task;
        }

        public FutureTask<?> getRfTask() {
            return this.rfTask;
        }
    }
}

