/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.lsp.commands.arbori;

import java.util.Map;
import oracle.arbori.scripting.GlobalMap;
import oracle.dbtools.arbori.MaterializedPredicate;
import oracle.dbtools.arbori.Program;
import oracle.dbtools.arbori.ScriptException;
import oracle.dbtools.arbori.Tuple;
import oracle.dbtools.lsp.BackgroundParser;
import oracle.dbtools.lsp.LSP;
import oracle.dbtools.lsp.LanguageServer;
import oracle.dbtools.lsp.commands.CodeLens;
import oracle.dbtools.parser.Earley;
import oracle.dbtools.parser.ParseNode;
import oracle.dbtools.parser.json.ResponseError;
import oracle.dbtools.parser.json.Util;
import oracle.dbtools.parser.plsql.SqlEarley;

public class Query
extends CodeLens {
    static final String normalTitle = "Query:";

    public Query(ParseNode node, BackgroundParser parser) {
        this(node, parser, normalTitle);
    }

    public Query(ParseNode node, BackgroundParser parser, String title) {
        super(node, title, parser);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object executeCommand() {
        String statement = this.parser.text.substring(this.parser.src.get((int)this.node.from).begin, this.parser.src.get((int)(this.node.to - 1)).end);
        LanguageServer server = this.parser.languageServer;
        Object connection = this.parser.getRegistry().getConnection();
        try {
            GlobalMap _globals = this.parser.program.getGlobals();
            if (_globals != null) {
                _globals.put("parser", (Object)this.parser);
            }
            Program r = new Program((Earley)SqlEarley.getInstance(), null, this.parser.program.getEngine(), _globals, true){

                public Boolean getBoolBindVar(String name) {
                    return true;
                }
            };
            r.compile(this.parser.text, null, true);
            r.setStruct((Object)server);
            String conn = this.parser.getRegistry().fullConnString();
            if (conn.charAt(0) == '\"') {
                conn = conn.substring(1, conn.length() - 1);
            }
            r.setTargetFileName(conn);
            this.parser.resetDiagnostics();
            Map output = r.eval();
            if (this.node.contains("rule")) {
                String content = this.parser.src.get((int)this.node.from).content;
                MaterializedPredicate p = (MaterializedPredicate)output.get(content);
                String fileExt = ".output.csv";
                String uri = server.getLastUrl().substring(1, server.getLastUrl().length() - 1) + fileExt;
                server.getLSP().createFile(uri, Query.render(p, (BackgroundParser)connection));
            }
            LSP.windowShowMessage("Query finished", 3);
            String string = "OK";
            return string;
        }
        catch (Throwable e) {
            if (e instanceof ScriptException) {
                e = this.processScriptException(e);
            } else {
                e.printStackTrace();
            }
            ResponseError responseError = new ResponseError(-32603, Util.sugarcoatText((String)e.getMessage()), (Object)"");
            return responseError;
        }
        finally {
            this.parser.documentBump();
            ((BackgroundParser)connection).documentBump();
        }
    }

    static String render(MaterializedPredicate rs, BackgroundParser p) {
        StringBuilder ret = new StringBuilder();
        int cols = rs.arity();
        for (int i = 0; i < cols; ++i) {
            if (0 < i) {
                ret.append(",");
            }
            ret.append(rs.getAttribute(i));
        }
        ret.append("\n");
        String conn = p.docUrl;
        if (conn.charAt(0) == '\"') {
            conn = conn.substring(1, conn.length() - 1);
        }
        for (Tuple tu : rs.getTuples()) {
            for (int i = 0; i < cols; ++i) {
                String attr = rs.getAttribute(i);
                ParseNode pn = rs.getAttribute(tu, attr);
                if (0 < i) {
                    ret.append(",");
                }
                if (pn != null) {
                    int line = pn.rowNo() + p.src.size() + 3;
                    ret.append("\"" + pn.interval() + "  " + conn + ".tree#L" + line + "\"");
                    continue;
                }
                ret.append("?");
            }
            ret.append("\n");
        }
        return ret.toString();
    }
}

