/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.db;

import java.sql.Connection;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantLock;
import javax.swing.SwingUtilities;
import oracle.dbtools.db.LockManager;
import oracle.dbtools.util.Logger;

public class DefaultLockManager
extends LockManager {
    protected static final long DEFAULT_INITIAL_TIMEOUT_MS = 3000L;
    protected static final long DEFAULT_LAG_MARGIN_MS = 1000L;
    private final long initialWaitTime = this.initWaitTime();
    private final long lagMargin = this.initLagMargin();
    private long currentWaitTime = this.initialWaitTime;
    private Map<Connection, ReentrantLock> locks = new HashMap<Connection, ReentrantLock>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ReentrantLock getLock(Connection conn) {
        if (conn == null) {
            throw new IllegalArgumentException("Attempt to get the lock for a null Connection");
        }
        Map<Connection, ReentrantLock> map = this.locks;
        synchronized (map) {
            ReentrantLock lock = this.locks.get(conn);
            if (lock == null) {
                lock = new ReentrantLock();
                this.locks.put(conn, lock);
            }
            return lock;
        }
    }

    protected long initWaitTime() {
        return 3000L;
    }

    protected long initLagMargin() {
        return 1000L;
    }

    private void recalcWaitTime(long startTime) {
        long elapsed = System.currentTimeMillis() - startTime;
        this.currentWaitTime = elapsed < this.initialWaitTime ? this.initialWaitTime : elapsed + this.lagMargin;
    }

    @Override
    public final boolean lockImpl(Connection conn, boolean promptUser) {
        boolean haveLock;
        block6: {
            haveLock = false;
            long startTime = System.currentTimeMillis();
            long waitTimeMs = this.currentWaitTime;
            TimeUnit unit = TimeUnit.MILLISECONDS;
            ReentrantLock lock = this.getLock(conn);
            if (lock == null) break block6;
            try {
                while (true) {
                    if (lock.tryLock(waitTimeMs, unit)) {
                        haveLock = true;
                        this.recalcWaitTime(startTime);
                        break;
                    }
                    if (!promptUser) continue;
                    boolean reTry = true;
                    if (SwingUtilities.isEventDispatchThread()) {
                        reTry = this.prompt(conn);
                    } else {
                        Logger.fine(LockManager.class, "Connection is busy");
                    }
                    this.recalcWaitTime(startTime);
                    if (!reTry) break;
                }
            }
            catch (InterruptedException e) {
                Logger.fine(LockManager.class, "Interrupted while trying to get a lock");
            }
        }
        return haveLock;
    }

    @Override
    public final void unlockImpl(Connection conn) {
        ReentrantLock lock = this.getLock(conn);
        if (lock.isHeldByCurrentThread()) {
            lock.unlock();
        }
    }

    @Override
    public final boolean checkLockImpl(Connection conn) {
        ReentrantLock lock = this.getLock(conn);
        return lock.isHeldByCurrentThread();
    }

    @Override
    public boolean tryLockImpl(Connection conn, long timeout) {
        ReentrantLock lock = this.getLock(conn);
        if (lock != null) {
            try {
                return lock.tryLock(timeout, TimeUnit.MILLISECONDS);
            }
            catch (InterruptedException e) {
                Logger.fine(LockManager.class, "Interrupted while trying to get a lock");
            }
        }
        return false;
    }

    protected boolean prompt(Connection id) {
        return true;
    }
}

