/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.data.validators;

import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.dbtools.data.validators.CharValidator;
import oracle.dbtools.data.validators.DateValidator;
import oracle.dbtools.data.validators.ITypeValidator;
import oracle.dbtools.data.validators.NumberValidator;

public class DataTypeValidatorRegistry {
    private HashMap<String, DataTypeDef> _valMap = new HashMap();
    private static DataTypeValidatorRegistry INSTANCE;

    public synchronized void registerValidator(String type, Class<? extends ITypeValidator> validator, boolean isPrecisionAllowed, boolean isScaleAllowed, boolean isScaleImported) {
        if (this._valMap == null) {
            this._valMap = new HashMap();
        }
        DataTypeDef dataType = new DataTypeDef(validator, isPrecisionAllowed, isScaleAllowed, isScaleImported);
        this._valMap.put(type, dataType);
    }

    public synchronized void unregisterValidator(String type) {
        if (this._valMap != null) {
            this._valMap.remove(type);
        }
    }

    public ITypeValidator getValidator(String type) {
        if (this._valMap != null && type != null) {
            try {
                DataTypeDef dataType = this._valMap.get(type);
                if (dataType == null) {
                    return null;
                }
                ITypeValidator validator = dataType.getHandler().newInstance();
                validator.isPrecisionAllowed(dataType.isPrecisionAllowed());
                validator.isScaleAllowed(dataType.isScaleAllowed());
                validator.isScaleImported(dataType.isScaleImported());
                return validator;
            }
            catch (Exception e) {
                Logger.getLogger(this.getClass().getName()).log(Level.WARNING, e.getStackTrace()[0].toString(), e);
            }
        }
        return null;
    }

    private DataTypeValidatorRegistry() {
        this.registerValidator("NUMBER", NumberValidator.class, true, true, true);
        this.registerValidator("INTEGER", NumberValidator.class, false, false, false);
        this.registerValidator("LONG", NumberValidator.class, false, false, false);
        this.registerValidator("FLOAT", NumberValidator.class, false, false, true);
        this.registerValidator("BINARY_DOUBLE", NumberValidator.class, false, false, false);
        this.registerValidator("BINARY_FLOAT", NumberValidator.class, false, false, false);
        this.registerValidator("CHAR", CharValidator.class, true, false, false);
        this.registerValidator("NCHAR", CharValidator.class, true, false, false);
        this.registerValidator("VARCHAR2", CharValidator.class, true, false, false);
        this.registerValidator("NVARCHAR2", CharValidator.class, true, false, false);
        this.registerValidator("CLOB", CharValidator.class, false, false, false);
        this.registerValidator("DATE", DateValidator.class, false, false, false);
        this.registerValidator("TIMESTAMP WITH TIME ZONE", DateValidator.class, true, false, false);
        this.registerValidator("TIMESTAMP WITH LOCAL TIME ZONE", DateValidator.class, true, false, false);
        this.registerValidator("TIMESTAMP", DateValidator.class, true, false, false);
    }

    public static DataTypeValidatorRegistry getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new DataTypeValidatorRegistry();
        }
        return INSTANCE;
    }

    public class DataTypeDef {
        boolean m_isPrecisionAllowed;
        boolean m_isScaleAllowed;
        boolean m_isScaleImported;
        Class<? extends ITypeValidator> m_handler;

        public DataTypeDef(Class<? extends ITypeValidator> handler, boolean isPrecisionAllowed, boolean isScaleAllowed, boolean isScaleImported) {
            this.m_handler = handler;
            this.m_isPrecisionAllowed = isPrecisionAllowed;
            this.m_isScaleAllowed = isScaleAllowed;
            this.m_isScaleImported = isScaleImported;
        }

        Class<? extends ITypeValidator> getHandler() {
            return this.m_handler;
        }

        public boolean isPrecisionAllowed() {
            return this.m_isPrecisionAllowed;
        }

        public void isPrecisionAllowed(boolean isPrecisionAllowed) {
            this.m_isPrecisionAllowed = isPrecisionAllowed;
        }

        public boolean isScaleAllowed() {
            return this.m_isScaleAllowed;
        }

        public void isScaleAllowed(boolean isScaleAllowed) {
            this.m_isScaleAllowed = isScaleAllowed;
        }

        public boolean isScaleImported() {
            return this.m_isScaleImported;
        }

        public void isScaleImported(boolean isScaleImported) {
            this.m_isScaleImported = isScaleImported;
        }
    }
}

