/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.data.formattors;

import java.text.ParseException;
import java.text.ParsePosition;
import java.util.Locale;
import oracle.dbtools.data.formattors.BaseFormattor;
import oracle.dbtools.data.model.Column;
import oracle.dbtools.raptor.nls.NLSProvider;
import oracle.dbtools.raptor.nls.OraDATEFormat;
import oracle.dbtools.raptor.nls.OraTIMESTAMPFormat;
import oracle.dbtools.raptor.nls.OraTIMESTAMPLTZFormat;
import oracle.dbtools.raptor.nls.OraTIMESTAMPTZFormat;
import oracle.dbtools.raptor.nls.OracleNLSProvider;
import oracle.i18n.util.OraLocaleInfo;
import oracle.sql.DATE;
import oracle.sql.TIMESTAMP;
import oracle.sql.TIMESTAMPLTZ;
import oracle.sql.TIMESTAMPTZ;

public class DateFormattor
extends BaseFormattor {
    @Override
    public String formatColumn(Column col) {
        String retVal = null;
        retVal = this.addDoubleQuote(col.getName()) + " " + col.getType();
        if (col.getDefault() != null && col.getDefault().trim().length() > 0) {
            retVal = retVal + " DEFAULT " + col.getDefault();
        }
        if (!col.isNullable()) {
            retVal = retVal + " NOT NULL";
        }
        return retVal;
    }

    @Override
    public String formatData(Object data, Column c) {
        Object result = "NULL";
        String fmt = c.getFormat();
        Object fmtParm = "";
        if (fmt != null && fmt.length() > 0) {
            fmtParm = "', '" + fmt;
        }
        if (data != null) {
            result = c.getType().equalsIgnoreCase("timestamp") ? "to_timestamp('" + data.toString() + (String)fmtParm + "')" : (c.getType().equalsIgnoreCase("timestamp with time zone") || c.getType().equalsIgnoreCase("timestamp with local time zone") ? "to_timestamp_tz('" + data.toString() + (String)fmtParm + "')" : "to_date('" + data.toString() + (String)fmtParm + "')");
        }
        return result;
    }

    @Override
    public Object formatDataForJava(Object data, Column c) throws Exception {
        String dataStr;
        String result = "NULL";
        String fmt = c.getFormat();
        if (data != null && (dataStr = data.toString()).length() > 0 && !dataStr.equals("NULL")) {
            if (c.getType().equalsIgnoreCase("TIMESTAMP")) {
                OraTIMESTAMPFormat format = fmt == null || fmt.length() == 0 ? ((OracleNLSProvider)NLSProvider.getProvider(this.m_connection)).getOraTIMESTAMPFormat() : new OraTIMESTAMPFormat(fmt, OraLocaleInfo.getInstance((Locale)this.getLocale()));
                TIMESTAMP tst = format.parse(dataStr, new ParsePosition(0));
                result = tst;
            } else if (c.getType().equalsIgnoreCase("TIMESTAMP WITH TIME ZONE")) {
                OraTIMESTAMPTZFormat format = fmt == null || fmt.length() == 0 ? ((OracleNLSProvider)NLSProvider.getProvider(this.m_connection)).getOraTIMESTAMPTZFormat() : new OraTIMESTAMPTZFormat(fmt, OraLocaleInfo.getInstance((Locale)this.getLocale()));
                TIMESTAMPTZ tstz = format.parse(dataStr, new ParsePosition(0));
                result = tstz;
            } else if (c.getType().equalsIgnoreCase("TIMESTAMP WITH LOCAL TIME ZONE")) {
                OracleNLSProvider nlsProvider = (OracleNLSProvider)NLSProvider.getProvider(this.m_connection);
                OraTIMESTAMPLTZFormat format = fmt == null || fmt.length() == 0 ? nlsProvider.getOraTIMESTAMPLTZFormat() : new OraTIMESTAMPLTZFormat(fmt, OraLocaleInfo.getInstance((Locale)this.getLocale()), nlsProvider.getTimeZone(nlsProvider.getDBTimeZone()), nlsProvider.getSessionTimeZone());
                TIMESTAMPLTZ tst = format.parse(dataStr, new ParsePosition(0));
                result = tst;
            } else {
                OraDATEFormat format;
                if (fmt == null || fmt.length() == 0) {
                    try {
                        format = ((OracleNLSProvider)NLSProvider.getProvider(this.m_connection)).getOraDATEFormat();
                    }
                    catch (ParseException pe) {
                        format = null;
                    }
                } else {
                    format = new OraDATEFormat(fmt, OraLocaleInfo.getInstance((Locale)this.getLocale()));
                }
                DATE tst = format.parse(dataStr, new ParsePosition(0));
                return tst;
            }
        }
        return result;
    }

    @Override
    public int getSqlType(String type) {
        if (type.equals("DATE")) {
            return 91;
        }
        if (type.equals("TIMESTAMP WITH TIME ZONE")) {
            return -101;
        }
        if (type.equals("TIMESTAMP WITH LOCAL TIME ZONE")) {
            return 93;
        }
        return 93;
    }
}

