/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.dap;

import java.util.LinkedList;
import java.util.List;

public class StarterBlock {
    public int offset;
    public String pkg = null;
    public String name = null;
    public String type = null;
    public List<String> arguments = new LinkedList<String>();

    public StarterBlock(int offset) {
        this.offset = offset;
    }

    public int getOffset() {
        return this.offset;
    }

    public void setPkg(String pkg) {
        this.pkg = pkg;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public void setType(String type) {
        this.type = type;
    }

    public void addArgument(String arg) {
        this.arguments.add(arg);
    }

    public String getFullName() {
        StringBuilder ret = new StringBuilder();
        if (this.pkg != null) {
            ret.append(this.pkg + ".");
        }
        ret.append(this.name);
        return ret.toString();
    }

    public String toString() {
        StringBuilder ret = new StringBuilder("/* Auto generated starter block. */\n");
        ret.append("/* Please amend the call arguments before running or debuging. */\n");
        ret.append("declare\n");
        for (String arg : this.arguments) {
            ret.append("   " + this.lengtifyType(arg) + ";\n");
        }
        ret.append("begin\n");
        ret.append("   ");
        ret.append(this.getFullName());
        if (0 < this.arguments.size()) {
            ret.append("(");
        }
        int pos = 0;
        for (String arg : this.arguments) {
            if (0 < pos++) {
                ret.append(", ");
            }
            int ind = arg.indexOf(32);
            ret.append(arg.substring(0, ind));
        }
        if (0 < this.arguments.size()) {
            ret.append(")");
        }
        ret.append(";\n");
        ret.append("end;\n");
        return ret.toString();
    }

    private String lengtifyType(String arg) {
        if (arg.toUpperCase().endsWith("VARCHAR2")) {
            return arg + "(2000)";
        }
        return arg;
    }
}

