/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.sqlcl.commands.aq;

import jakarta.json.Json;
import jakarta.json.JsonReader;
import jakarta.json.JsonStructure;
import jakarta.json.stream.JsonParsingException;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.SQLType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import oracle.dbtools.common.utils.MetaResource;
import oracle.dbtools.db.DBUtil;
import oracle.dbtools.db.LockManager;
import oracle.dbtools.raptor.newscriptrunner.Messages;
import oracle.dbtools.raptor.newscriptrunner.parameterparser.exception.InvalidParameterException;
import oracle.dbtools.raptor.newscriptrunner.util.parser.Option;
import oracle.dbtools.raptor.query.Bind;
import oracle.dbtools.raptor.query.Query;
import oracle.dbtools.raptor.query.QueryXMLSupport;
import oracle.dbtools.sqlcl.commands.aq.AQException;
import oracle.dbtools.sqlcl.commands.aq.AQModel;
import oracle.dbtools.sqlcl.commands.aq.AQOptions;
import oracle.jdbc.OracleCallableStatement;
import oracle.jdbc.OracleType;
import oracle.sql.RAW;
import oracle.sql.json.OracleJsonValue;

public class AQProcessor {
    static final String AQ_PARAMS = "sqlcl.aq.params";
    static final String STRING_TYPE = String.class.getName();
    static final String INTEGER_TYPE = Integer.class.getName();
    static final String BOOLEAN_TYPE = Boolean.class.getName();

    private static void bind(OracleCallableStatement statement, List<Object> binds) throws SQLException {
        int bindIdx = 1;
        for (Object bind : binds) {
            if (bind == AQOptions.NULL_OBJECT || bind instanceof String && ((String)bind).equals("")) {
                statement.setNull(bindIdx, 12);
            } else if (bind instanceof String) {
                statement.setString(bindIdx, (String)bind);
            } else if (bind instanceof Integer) {
                statement.setInt(bindIdx, ((Integer)bind).intValue());
            } else if (bind instanceof JsonStructure) {
                statement.setObject(bindIdx, bind, (SQLType)OracleType.JSON);
            } else {
                statement.setObject(bindIdx, bind);
            }
            ++bindIdx;
        }
    }

    private static void bindPayload(String payload, List<Object> binds, int payloadType) {
        if (payloadType == AQOptions.JSON_MAPPING) {
            binds.add(AQProcessor.getJSON(payload));
        } else {
            binds.add(payload);
        }
    }

    private static List<Object> collectParams(AQModel model) throws InvalidParameterException {
        return AQProcessor.collectParams(model, null);
    }

    private static List<Object> collectParams(AQModel model, List<Option<?>> addToBinds) throws InvalidParameterException {
        ArrayList<Object> binds = new ArrayList<Object>();
        for (Option option : model.getCommand().getType().getOptions()) {
            model.getContext().getParameterInstance().putParameter(AQ_PARAMS, option.getName().toLowerCase(), model.getCommand().getOptionValue(option.getId()));
            if (addToBinds != null && !addToBinds.contains(option)) continue;
            binds.add(AQProcessor.getParameter(model, option));
        }
        return binds;
    }

    private static boolean containsParameter(AQModel model, Option<?> parameter) throws InvalidParameterException {
        return AQProcessor.getParameter(model, parameter) != null;
    }

    private static void executeQuery(AQModel model, String query, List<Object> binds) throws AQException {
        DBUtil dBUtil = DBUtil.getInstance((Connection)model.getConnection());
        dBUtil.execute(query, binds);
        SQLException e = dBUtil.getLastException();
        if (e != null) {
            throw new AQException(null, String.format(e.getMessage(), new Object[0]));
        }
    }

    private static JsonStructure getJSON(String payload) throws JsonParsingException {
        try (JsonReader jsonReader = Json.createReader((Reader)new StringReader(payload));){
            JsonStructure object;
            JsonStructure jsonStructure = object = jsonReader.read();
            return jsonStructure;
        }
    }

    private static Object getParameter(AQModel model, Option param) throws InvalidParameterException {
        if (AQProcessor.isBooleanAsString(param)) {
            return AQProcessor.getValue(model, Boolean.class, param.getName().toLowerCase());
        }
        return AQProcessor.getValue(model, param.getDataType(), param.getName().toLowerCase());
    }

    private static boolean isBooleanAsString(Option<?> param) {
        return param.getDataType() == String.class && "TRUE".equals(param.getDefaultValue());
    }

    private static void getPayload(AQModel model, OracleCallableStatement statement, int position, int payloadType) throws SQLException, InvalidParameterException, IOException {
        if (payloadType == AQOptions.JSON_MAPPING) {
            OracleJsonValue deqPayload = (OracleJsonValue)statement.getObject(position, OracleJsonValue.class);
            AQProcessor.writePayload(model, deqPayload.toString());
        } else {
            RAW deqPayload = statement.getRAW(position);
            AQProcessor.writePayload(model, deqPayload.stringValue());
        }
    }

    private static String getQuery(String id, Connection conn) {
        QueryXMLSupport xml = QueryXMLSupport.getQueryXMLSupport((MetaResource)new MetaResource(AQProcessor.class.getClassLoader(), "oracle/dbtools/sqlcl/commands/aq/aqQueries.xml"));
        Query q = xml.getQuery(id, conn);
        return q == null ? null : q.getSql();
    }

    private static Object getValue(AQModel model, Class<?> paramType, String paramName) throws InvalidParameterException {
        if (null != paramType) {
            if (paramType == String.class) {
                return model.getContext().getParameterInstance().getParameterAsString(AQ_PARAMS, paramName);
            }
            if (paramType == Integer.class) {
                return model.getContext().getParameterInstance().getParameterAsInt(AQ_PARAMS, paramName);
            }
            if (paramType == Boolean.class) {
                return model.getContext().getParameterInstance().getParameterAsBoolean(AQ_PARAMS, paramName);
            }
        }
        return null;
    }

    private static void registerPayloadParameter(OracleCallableStatement statement, int position, int payloadType) throws SQLException {
        if (payloadType == AQOptions.JSON_MAPPING) {
            statement.registerOutParameter(position, (SQLType)OracleType.JSON);
        } else {
            statement.registerOutParameter(position, (SQLType)OracleType.RAW);
        }
    }

    private static void writePayload(AQModel model, String payload) throws InvalidParameterException, IOException {
        if (AQProcessor.containsParameter(model, AQOptions.PAYLOAD_DEQ_O)) {
            System.out.println("Payload : " + payload);
        } else if (AQProcessor.containsParameter(model, AQOptions.FILENAME_DEQ_O)) {
            String fileName = (String)AQProcessor.getParameter(model, AQOptions.FILENAME_DEQ_O);
            Path filepath = Path.of(fileName, new String[0]);
            Files.writeString(filepath, (CharSequence)payload, StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING);
        }
    }

    public static void addSubscriber(AQModel model) throws InvalidParameterException, AQException {
        String query = AQProcessor.getQuery("addsub", model.getConnection());
        List<Object> binds = AQProcessor.collectParams(model);
        AQProcessor.executeQuery(model, query, binds);
    }

    public static void alterQueue(AQModel model) throws InvalidParameterException, AQException {
        String query = AQProcessor.getQuery("alterq", model.getConnection());
        AQProcessor.executeQuery(model, query, AQProcessor.collectParams(model));
    }

    public static void alterQueueTable(AQModel model) throws InvalidParameterException, AQException {
        String query = AQProcessor.getQuery("alterqt", model.getConnection());
        AQProcessor.executeQuery(model, query, AQProcessor.collectParams(model));
    }

    public static void alterShardedQueue(AQModel model) throws InvalidParameterException, AQException {
        String query = AQProcessor.getQuery("altersq", model.getConnection());
        AQProcessor.executeQuery(model, query, AQProcessor.collectParams(model));
    }

    public static void alterSubscriber(AQModel model) throws InvalidParameterException, AQException {
        String query = AQProcessor.getQuery("altersub", model.getConnection());
        AQProcessor.executeQuery(model, query, AQProcessor.collectParams(model));
    }

    public static void alterTransactionalEventQueue(AQModel model) throws InvalidParameterException, AQException {
        String query = AQProcessor.getQuery("alterteq", model.getConnection());
        AQProcessor.executeQuery(model, query, AQProcessor.collectParams(model));
    }

    public static void createEQExceptionQueue(AQModel model) throws InvalidParameterException, AQException {
        String query = AQProcessor.getQuery("createeqeq", model.getConnection());
        AQProcessor.executeQuery(model, query, AQProcessor.collectParams(model));
    }

    public static void createExceptionQueue(AQModel model) throws InvalidParameterException, AQException {
        String query = AQProcessor.getQuery("createeq", model.getConnection());
        AQProcessor.executeQuery(model, query, AQProcessor.collectParams(model));
    }

    public static void createQueue(AQModel model) throws InvalidParameterException, AQException {
        String query = AQProcessor.getQuery("createq", model.getConnection());
        AQProcessor.executeQuery(model, query, AQProcessor.collectParams(model));
    }

    public static void createQueueTable(AQModel model) throws InvalidParameterException, AQException {
        String query = AQProcessor.getQuery("createqt", model.getConnection());
        List<Object> binds = AQProcessor.collectParams(model);
        AQProcessor.executeQuery(model, query, binds);
    }

    public static void createShardedQueue(AQModel model) throws InvalidParameterException, AQException {
        String query = AQProcessor.getQuery("createsq", model.getConnection());
        List<Object> binds = AQProcessor.collectParams(model);
        AQProcessor.executeQuery(model, query, binds);
    }

    public static void createTransactionalEventQueue(AQModel model) throws InvalidParameterException, AQException {
        String query = AQProcessor.getQuery("createteq", model.getConnection());
        List<Object> binds = AQProcessor.collectParams(model);
        AQProcessor.executeQuery(model, query, binds);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void dequeue(AQModel model) throws InvalidParameterException, IOException, AQException {
        String query = AQProcessor.getQuery("deq", model.getConnection());
        List<Object> binds = AQProcessor.collectParams(model, Arrays.asList(AQOptions.CONSUMER_NAME_O, AQOptions.DEQUEUE_MODE_O, AQOptions.NAVIGATION_O, AQOptions.VISIBILITY_DEQ_O, AQOptions.DEQUEUE_WAIT_O, AQOptions.CORRELATION_DEQ_O, AQOptions.CONDITION_O, AQOptions.TRANSFORMATION_DEQ_O, AQOptions.MODE_DEQ_O));
        if (!AQProcessor.containsParameter(model, AQOptions.PAYLOAD_DEQ_O) && !AQProcessor.containsParameter(model, AQOptions.FILENAME_DEQ_O)) {
            throw new AQException(null, String.format(Messages.getString((String)"AQEXP.MISSING_COMPULSORY"), AQOptions.Symbol.PAYLOAD.getName() + " OR " + AQOptions.Symbol.FILENAME.getName()));
        }
        if (AQProcessor.containsParameter(model, AQOptions.PAYLOAD_DEQ_O) && AQProcessor.containsParameter(model, AQOptions.FILENAME_DEQ_O)) {
            throw new AQException(null, String.format(Messages.getString((String)"AQEXP.MUTUAL_EXCLUSION"), AQOptions.Symbol.PAYLOAD.getName() + " OR " + AQOptions.Symbol.FILENAME.getName()));
        }
        if (AQProcessor.containsParameter(model, AQOptions.MESSAGE_ID_O)) {
            String messageIdBind = (String)AQProcessor.getParameter(model, AQOptions.MESSAGE_ID_O);
            if (messageIdBind.length() > 0 && messageIdBind.charAt(0) == ':') {
                messageIdBind = messageIdBind.substring(1);
                if (!model.getContext().getVarMap().containsKey(messageIdBind.toUpperCase())) throw new AQException(null, String.format(Messages.getString((String)"AQEXP.INVALID_BIND"), messageIdBind.toUpperCase()));
                Bind msgIdBind = (Bind)model.getContext().getVarMap().get(messageIdBind.toUpperCase());
                binds.add(msgIdBind.getValue());
            } else {
                binds.add(messageIdBind);
            }
        } else {
            binds.add(null);
        }
        binds.add(AQProcessor.getParameter(model, AQOptions.NAME_OR));
        Integer payloadType = AQOptions.JSON_MAPPING;
        if (AQProcessor.containsParameter(model, AQOptions.PAYLOAD_TYPE_O)) {
            String payloadTy = (String)AQProcessor.getParameter(model, AQOptions.PAYLOAD_TYPE_O);
            if (!AQOptions.payloadTypes.containsKey(payloadTy.toLowerCase())) throw new AQException(null, String.format(Messages.getString((String)"AQEXP.INVALID_PAYLOAD"), payloadTy.toUpperCase()));
            payloadType = AQOptions.payloadTypes.get(payloadTy.toLowerCase());
        }
        OracleCallableStatement dequeueStatement = null;
        if (!LockManager.lock((Connection)model.getConnection())) return;
        try {
            Bind sBind;
            Bind eBind;
            Bind msgIdBind;
            String messageIdBind;
            RAW msg_id;
            dequeueStatement = (OracleCallableStatement)model.getConnection().prepareCall(query);
            AQProcessor.bind(dequeueStatement, binds);
            AQProcessor.registerPayloadParameter(dequeueStatement, binds.size() + 1, payloadType);
            dequeueStatement.registerOutParameter(binds.size() + 2, (SQLType)OracleType.RAW);
            dequeueStatement.registerOutParameter(binds.size() + 3, (SQLType)OracleType.NUMBER);
            dequeueStatement.registerOutParameter(binds.size() + 4, (SQLType)OracleType.NUMBER);
            dequeueStatement.registerOutParameter(binds.size() + 5, (SQLType)OracleType.NUMBER);
            dequeueStatement.registerOutParameter(binds.size() + 6, (SQLType)OracleType.VARCHAR2);
            dequeueStatement.registerOutParameter(binds.size() + 7, (SQLType)OracleType.NUMBER);
            dequeueStatement.registerOutParameter(binds.size() + 8, (SQLType)OracleType.VARCHAR2);
            dequeueStatement.registerOutParameter(binds.size() + 9, (SQLType)OracleType.DATE);
            dequeueStatement.registerOutParameter(binds.size() + 10, (SQLType)OracleType.NUMBER);
            dequeueStatement.registerOutParameter(binds.size() + 11, (SQLType)OracleType.VARCHAR2);
            dequeueStatement.registerOutParameter(binds.size() + 12, (SQLType)OracleType.RAW);
            dequeueStatement.registerOutParameter(binds.size() + 13, (SQLType)OracleType.NUMBER);
            dequeueStatement.executeUpdate();
            AQProcessor.getPayload(model, dequeueStatement, binds.size() + 1, payloadType);
            if (AQProcessor.containsParameter(model, AQOptions.OUT_MESSAGE_ID_DEQ_O)) {
                msg_id = dequeueStatement.getRAW(binds.size() + 2);
                messageIdBind = (String)AQProcessor.getParameter(model, AQOptions.OUT_MESSAGE_ID_DEQ_O);
                if (messageIdBind == null) {
                    System.out.println("Message ID : " + msg_id.stringValue());
                } else {
                    if (messageIdBind.charAt(0) == ':') {
                        messageIdBind = messageIdBind.substring(1);
                    }
                    if (model.getContext().getVarMap().containsKey(messageIdBind.toUpperCase())) {
                        msgIdBind = (Bind)model.getContext().getVarMap().get(messageIdBind.toUpperCase());
                        msgIdBind.setValue(msg_id.stringValue());
                        model.getContext().getVarMap().put(messageIdBind.toUpperCase(), msgIdBind);
                    } else {
                        System.out.println("Message ID : " + msg_id.stringValue());
                    }
                }
            }
            if (AQProcessor.containsParameter(model, AQOptions.OUT_PRIORITY_O)) {
                Integer out_priority = dequeueStatement.getInt(binds.size() + 3);
                String priorityBind = (String)AQProcessor.getParameter(model, AQOptions.OUT_PRIORITY_O);
                if (priorityBind == null) {
                    System.out.println("Priority : " + out_priority.toString());
                } else {
                    if (priorityBind.charAt(0) == ':') {
                        priorityBind = priorityBind.substring(1);
                    }
                    if (model.getContext().getVarMap().containsKey(priorityBind.toUpperCase())) {
                        Bind pBind = (Bind)model.getContext().getVarMap().get(priorityBind.toUpperCase());
                        pBind.setValue(out_priority.toString());
                        model.getContext().getVarMap().put(priorityBind.toUpperCase(), pBind);
                    } else {
                        System.out.println("Priority : " + out_priority.toString());
                    }
                }
            }
            if (AQProcessor.containsParameter(model, AQOptions.OUT_DELAY_O)) {
                Integer out_delay = dequeueStatement.getInt(binds.size() + 4);
                String delayBind = (String)AQProcessor.getParameter(model, AQOptions.OUT_DELAY_O);
                if (delayBind == null) {
                    System.out.println("Delay : " + out_delay.toString());
                } else {
                    if (delayBind.charAt(0) == ':') {
                        delayBind = delayBind.substring(1);
                    }
                    if (model.getContext().getVarMap().containsKey(delayBind.toUpperCase())) {
                        Bind dBind = (Bind)model.getContext().getVarMap().get(delayBind.toUpperCase());
                        dBind.setValue(out_delay.toString());
                        model.getContext().getVarMap().put(delayBind.toUpperCase(), dBind);
                    } else {
                        System.out.println("Delay : " + out_delay.toString());
                    }
                }
            }
            if (AQProcessor.containsParameter(model, AQOptions.OUT_EXPIRATION_O)) {
                Integer out_expiration = dequeueStatement.getInt(binds.size() + 5);
                String expBind = (String)AQProcessor.getParameter(model, AQOptions.OUT_EXPIRATION_O);
                if (expBind == null) {
                    System.out.println("Expiration : " + out_expiration.toString());
                } else {
                    if (expBind.charAt(0) == ':') {
                        expBind = expBind.substring(1);
                    }
                    if (model.getContext().getVarMap().containsKey(expBind.toUpperCase())) {
                        eBind = (Bind)model.getContext().getVarMap().get(expBind.toUpperCase());
                        eBind.setValue(out_expiration.toString());
                        model.getContext().getVarMap().put(expBind.toUpperCase(), eBind);
                    } else {
                        System.out.println("Expiration : " + out_expiration.toString());
                    }
                }
            }
            if (AQProcessor.containsParameter(model, AQOptions.OUT_CORRELATION_O)) {
                String out_correlation = dequeueStatement.getString(binds.size() + 6);
                String corrBind = (String)AQProcessor.getParameter(model, AQOptions.OUT_CORRELATION_O);
                if (corrBind == null) {
                    System.out.println("Correlation : " + out_correlation);
                } else {
                    if (corrBind.charAt(0) == ':') {
                        corrBind = corrBind.substring(1);
                    }
                    if (model.getContext().getVarMap().containsKey(corrBind.toUpperCase())) {
                        Bind cBind = (Bind)model.getContext().getVarMap().get(corrBind.toUpperCase());
                        cBind.setValue(out_correlation);
                        model.getContext().getVarMap().put(corrBind.toUpperCase(), cBind);
                    } else {
                        System.out.println("Correlation : " + out_correlation);
                    }
                }
            }
            if (AQProcessor.containsParameter(model, AQOptions.OUT_ATTEMPTS_O)) {
                Integer out_attempts = dequeueStatement.getInt(binds.size() + 7);
                String attBind = (String)AQProcessor.getParameter(model, AQOptions.OUT_ATTEMPTS_O);
                if (attBind == null) {
                    System.out.println("Attempts : " + out_attempts.toString());
                } else {
                    if (attBind.charAt(0) == ':') {
                        attBind = attBind.substring(1);
                    }
                    if (model.getContext().getVarMap().containsKey(attBind.toUpperCase())) {
                        Bind aBind = (Bind)model.getContext().getVarMap().get(attBind.toUpperCase());
                        aBind.setValue(out_attempts.toString());
                        model.getContext().getVarMap().put(attBind.toUpperCase(), aBind);
                    } else {
                        System.out.println("Attempts : " + out_attempts.toString());
                    }
                }
            }
            if (AQProcessor.containsParameter(model, AQOptions.OUT_EXCEPTION_QUEUE_O)) {
                String out_eq = dequeueStatement.getString(binds.size() + 8);
                String eqBind = (String)AQProcessor.getParameter(model, AQOptions.OUT_EXCEPTION_QUEUE_O);
                if (eqBind == null) {
                    System.out.println("Exception Queue : " + out_eq);
                } else {
                    if (eqBind.charAt(0) == ':') {
                        eqBind = eqBind.substring(1);
                    }
                    if (model.getContext().getVarMap().containsKey(eqBind.toUpperCase())) {
                        eBind = (Bind)model.getContext().getVarMap().get(eqBind.toUpperCase());
                        eBind.setValue(out_eq);
                        model.getContext().getVarMap().put(eqBind.toUpperCase(), eBind);
                    } else {
                        System.out.println("Exception Queue : " + out_eq);
                    }
                }
            }
            if (AQProcessor.containsParameter(model, AQOptions.OUT_ENQUEUE_TIME_O)) {
                String out_eq_time = dequeueStatement.getDate(binds.size() + 9).toString();
                String eqdBind = (String)AQProcessor.getParameter(model, AQOptions.OUT_ENQUEUE_TIME_O);
                if (eqdBind == null) {
                    System.out.println("Enqueue Time : " + out_eq_time);
                } else {
                    if (eqdBind.charAt(0) == ':') {
                        eqdBind = eqdBind.substring(1);
                    }
                    if (model.getContext().getVarMap().containsKey(eqdBind.toUpperCase())) {
                        Bind etBind = (Bind)model.getContext().getVarMap().get(eqdBind.toUpperCase());
                        etBind.setValue(out_eq_time);
                        model.getContext().getVarMap().put(eqdBind.toUpperCase(), etBind);
                    } else {
                        System.out.println("Enqueue Time : " + out_eq_time);
                    }
                }
            }
            if (AQProcessor.containsParameter(model, AQOptions.OUT_STATE_O)) {
                Integer out_state = dequeueStatement.getInt(binds.size() + 10);
                String stBind = (String)AQProcessor.getParameter(model, AQOptions.OUT_STATE_O);
                if (stBind == null) {
                    System.out.println("State : " + out_state.toString());
                } else {
                    if (stBind.charAt(0) == ':') {
                        stBind = stBind.substring(1);
                    }
                    if (model.getContext().getVarMap().containsKey(stBind.toUpperCase())) {
                        sBind = (Bind)model.getContext().getVarMap().get(stBind.toUpperCase());
                        sBind.setValue(out_state.toString());
                        model.getContext().getVarMap().put(stBind.toUpperCase(), sBind);
                    } else {
                        System.out.println("State : " + out_state.toString());
                    }
                }
            }
            if (AQProcessor.containsParameter(model, AQOptions.OUT_SENDER_ID_O)) {
                String out_sender = dequeueStatement.getString(binds.size() + 11);
                String srBind = (String)AQProcessor.getParameter(model, AQOptions.OUT_SENDER_ID_O);
                if (srBind == null) {
                    System.out.println("Sender ID : " + out_sender);
                } else {
                    if (srBind.charAt(0) == ':') {
                        srBind = srBind.substring(1);
                    }
                    if (model.getContext().getVarMap().containsKey(srBind.toUpperCase())) {
                        sBind = (Bind)model.getContext().getVarMap().get(srBind.toUpperCase());
                        sBind.setValue(out_sender);
                        model.getContext().getVarMap().put(srBind.toUpperCase(), sBind);
                    } else {
                        System.out.println("Sender ID : " + out_sender);
                    }
                }
            }
            if (AQProcessor.containsParameter(model, AQOptions.OUT_ORIGINAL_MESSAGE_ID_O)) {
                msg_id = dequeueStatement.getRAW(binds.size() + 12) == null ? null : dequeueStatement.getRAW(binds.size() + 12);
                messageIdBind = (String)AQProcessor.getParameter(model, AQOptions.OUT_ORIGINAL_MESSAGE_ID_O);
                if (messageIdBind == null) {
                    System.out.println("Original Message ID : " + (msg_id == null ? null : msg_id.stringValue()));
                } else {
                    if (messageIdBind.charAt(0) == ':') {
                        messageIdBind = messageIdBind.substring(1);
                    }
                    if (model.getContext().getVarMap().containsKey(messageIdBind.toUpperCase())) {
                        msgIdBind = (Bind)model.getContext().getVarMap().get(messageIdBind.toUpperCase());
                        msgIdBind.setValue(msg_id == null ? null : msg_id.stringValue());
                        model.getContext().getVarMap().put(messageIdBind.toUpperCase(), msgIdBind);
                    } else {
                        System.out.println("Original Message ID : " + (msg_id == null ? null : msg_id.stringValue()));
                    }
                }
            }
            if (!AQProcessor.containsParameter(model, AQOptions.OUT_MODE_O)) return;
            Integer out_mode = dequeueStatement.getInt(binds.size() + 13);
            String modeBind = (String)AQProcessor.getParameter(model, AQOptions.OUT_MODE_O);
            if (modeBind == null) {
                System.out.println("Mode : " + out_mode.toString());
                return;
            } else {
                if (modeBind.charAt(0) == ':') {
                    modeBind = modeBind.substring(1);
                }
                if (model.getContext().getVarMap().containsKey(modeBind.toUpperCase())) {
                    Bind mBind = (Bind)model.getContext().getVarMap().get(modeBind.toUpperCase());
                    mBind.setValue(out_mode.toString());
                    model.getContext().getVarMap().put(modeBind.toUpperCase(), mBind);
                    return;
                } else {
                    System.out.println("Mode : " + out_mode.toString());
                }
            }
            return;
        }
        catch (SQLException ex) {
            throw new AQException(null, String.format(ex.getMessage(), new Object[0]));
        }
        finally {
            if (dequeueStatement != null) {
                try {
                    dequeueStatement.close();
                }
                catch (SQLException e) {
                    throw new AQException(null, String.format(e.getMessage(), new Object[0]));
                }
            }
            LockManager.unlock((Connection)model.getConnection());
        }
    }

    public static void dropQueue(AQModel model) throws InvalidParameterException, AQException {
        String query = AQProcessor.getQuery("dropq", model.getConnection());
        AQProcessor.executeQuery(model, query, AQProcessor.collectParams(model));
    }

    public static void dropQueueTable(AQModel model) throws InvalidParameterException, AQException {
        String query = AQProcessor.getQuery("dropqt", model.getConnection());
        List<Object> binds = AQProcessor.collectParams(model);
        AQProcessor.executeQuery(model, query, binds);
    }

    public static void dropShardedQueue(AQModel model) throws InvalidParameterException, AQException {
        String query = AQProcessor.getQuery("dropsq", model.getConnection());
        List<Object> binds = AQProcessor.collectParams(model);
        AQProcessor.executeQuery(model, query, binds);
    }

    public static void dropTransactionalEventQueue(AQModel model) throws InvalidParameterException, AQException {
        String query = AQProcessor.getQuery("dropteq", model.getConnection());
        List<Object> binds = AQProcessor.collectParams(model);
        AQProcessor.executeQuery(model, query, binds);
    }

    public static void enqueue(AQModel model) throws InvalidParameterException, IOException, JsonParsingException, AQException {
        List<Object> binds = AQProcessor.collectParams(model, Arrays.asList(AQOptions.VISIBILITY_ENQ_O, AQOptions.TRANSFORMATION_ENQ_O, AQOptions.MODE_ENQ_O, AQOptions.PRIORITY_O, AQOptions.DELAY_O, AQOptions.EXPIRATION_O, AQOptions.CORRELATION_ENQ_O, AQOptions.EXCEPTION_QUEUE_O, AQOptions.NAME_OR));
        if (!AQProcessor.containsParameter(model, AQOptions.PAYLOAD_ENQ_O) && !AQProcessor.containsParameter(model, AQOptions.FILENAME_ENQ_O)) {
            throw new AQException(null, String.format(Messages.getString((String)"AQEXP.MISSING_COMPULSORY"), AQOptions.Symbol.PAYLOAD.getName() + " OR " + AQOptions.Symbol.FILENAME.getName()));
        }
        if (AQProcessor.containsParameter(model, AQOptions.PAYLOAD_ENQ_O) && AQProcessor.containsParameter(model, AQOptions.FILENAME_ENQ_O)) {
            throw new AQException(null, String.format(Messages.getString((String)"AQEXP.MUTUAL_EXCLUSION"), AQOptions.Symbol.PAYLOAD.getName() + " OR " + AQOptions.Symbol.FILENAME.getName()));
        }
        boolean isSenderPresent = false;
        Object senderVal = null;
        Integer payloadType = AQOptions.JSON_MAPPING;
        if (AQProcessor.containsParameter(model, AQOptions.SENDER_ID_O)) {
            String senderQuery = AQProcessor.getQuery("addsubenq", model.getConnection());
            ArrayList<Object> senderBinds = new ArrayList<Object>();
            senderVal = AQProcessor.getParameter(model, AQOptions.SENDER_ID_O);
            senderBinds.add(senderVal);
            senderQuery = String.format(senderQuery, (String)senderVal, (String)senderVal);
            AQProcessor.executeQuery(model, senderQuery, senderBinds);
            isSenderPresent = true;
        }
        String query = AQProcessor.getQuery("enq", model.getConnection());
        query = isSenderPresent ? String.format(query, "aq$_sender" + (String)senderVal) : String.format(query, "NULL");
        if (AQProcessor.containsParameter(model, AQOptions.PAYLOAD_TYPE_O)) {
            String payloadTy = (String)AQProcessor.getParameter(model, AQOptions.PAYLOAD_TYPE_O);
            if (AQOptions.payloadTypes.containsKey(payloadTy.toLowerCase())) {
                payloadType = AQOptions.payloadTypes.get(payloadTy.toLowerCase());
            } else {
                throw new AQException(null, String.format(Messages.getString((String)"AQEXP.INVALID_PAYLOAD"), payloadTy.toUpperCase()));
            }
        }
        if (AQProcessor.containsParameter(model, AQOptions.PAYLOAD_ENQ_O)) {
            String payload = (String)AQProcessor.getParameter(model, AQOptions.PAYLOAD_ENQ_O);
            AQProcessor.bindPayload(payload, binds, payloadType);
        } else if (AQProcessor.containsParameter(model, AQOptions.FILENAME_ENQ_O)) {
            String fileName = (String)AQProcessor.getParameter(model, AQOptions.FILENAME_ENQ_O);
            File file = new File(fileName);
            if (file.exists()) {
                Path filepath = Path.of(fileName, new String[0]);
                String payload = Files.readString(filepath);
                AQProcessor.bindPayload(payload, binds, payloadType);
            } else {
                throw new AQException(null, String.format(Messages.getString((String)"AQEXP.INVALID_FILE"), fileName.toUpperCase()));
            }
        }
        OracleCallableStatement enqueueStatement = null;
        if (LockManager.lock((Connection)model.getConnection())) {
            try {
                enqueueStatement = (OracleCallableStatement)model.getConnection().prepareCall(query);
                AQProcessor.bind(enqueueStatement, binds);
                enqueueStatement.registerOutParameter(binds.size() + 1, (SQLType)OracleType.RAW);
                enqueueStatement.executeUpdate();
                RAW msg_id = enqueueStatement.getRAW(binds.size() + 1);
                if (AQProcessor.containsParameter(model, AQOptions.OUT_MESSAGE_ID_ENQ_O)) {
                    String messageIdBind = (String)AQProcessor.getParameter(model, AQOptions.OUT_MESSAGE_ID_ENQ_O);
                    if (messageIdBind == null) {
                        System.out.println("Message ID : " + msg_id.stringValue());
                    } else {
                        if (messageIdBind.charAt(0) == ':') {
                            messageIdBind = messageIdBind.substring(1);
                        }
                        if (model.getContext().getVarMap().containsKey(messageIdBind.toUpperCase())) {
                            Bind msgIdBind = (Bind)model.getContext().getVarMap().get(messageIdBind.toUpperCase());
                            msgIdBind.setValue(msg_id.stringValue());
                            model.getContext().getVarMap().put(messageIdBind.toUpperCase(), msgIdBind);
                        } else {
                            System.out.println("Message ID : " + msg_id.stringValue());
                        }
                    }
                }
            }
            catch (SQLException e) {
                throw new AQException(null, String.format(e.getMessage(), new Object[0]));
            }
            finally {
                if (enqueueStatement != null) {
                    try {
                        enqueueStatement.close();
                    }
                    catch (SQLException e) {
                        throw new AQException(null, String.format(e.getMessage(), new Object[0]));
                    }
                }
                LockManager.unlock((Connection)model.getConnection());
            }
        }
    }

    public static void removeSubscriber(AQModel model) throws InvalidParameterException, AQException {
        String query = AQProcessor.getQuery("removesub", model.getConnection());
        AQProcessor.executeQuery(model, query, AQProcessor.collectParams(model));
    }

    public static void startQueue(AQModel model) throws InvalidParameterException, AQException {
        String query = AQProcessor.getQuery("startq", model.getConnection());
        List<Object> binds = AQProcessor.collectParams(model);
        AQProcessor.executeQuery(model, query, binds);
    }

    public static void stopQueue(AQModel model) throws InvalidParameterException, AQException {
        String query = AQProcessor.getQuery("stopq", model.getConnection());
        List<Object> binds = AQProcessor.collectParams(model);
        AQProcessor.executeQuery(model, query, binds);
    }
}

