/*
 * Decompiled with CFR 0.152.
 */
package org.jline.terminal.spi;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.util.Properties;
import org.jline.terminal.Attributes;
import org.jline.terminal.Size;
import org.jline.terminal.Terminal;
import org.jline.terminal.spi.SystemStream;

public interface TerminalProvider {
    public String name();

    public Terminal sysTerminal(String var1, String var2, boolean var3, Charset var4, Charset var5, Charset var6, boolean var7, Terminal.SignalHandler var8, boolean var9, SystemStream var10) throws IOException;

    public Terminal newTerminal(String var1, String var2, InputStream var3, OutputStream var4, Charset var5, Charset var6, Charset var7, Terminal.SignalHandler var8, boolean var9, Attributes var10, Size var11) throws IOException;

    public boolean isSystemStream(SystemStream var1);

    public String systemStreamName(SystemStream var1);

    public int systemStreamWidth(SystemStream var1);

    public static TerminalProvider load(String name) throws IOException {
        InputStream is;
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        if (cl == null) {
            cl = TerminalProvider.class.getClassLoader();
        }
        if ((is = cl.getResourceAsStream("META-INF/services/org/jline/terminal/provider/" + name)) != null) {
            Properties props = new Properties();
            try {
                props.load(is);
                String className = props.getProperty("class");
                if (className == null) {
                    throw new IOException("No class defined in terminal provider file " + name);
                }
                Class<?> clazz = cl.loadClass(className);
                return (TerminalProvider)clazz.getConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (Exception e) {
                throw new IOException("Unable to load terminal provider " + name + ": " + e.getMessage(), e);
            }
        }
        throw new IOException("Unable to find terminal provider " + name);
    }
}

