/*
 * Decompiled with CFR 0.152.
 */
package org.jline.builtins;

import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.io.Reader;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.PathMatcher;
import java.nio.file.Paths;
import java.nio.file.StandardWatchEventKinds;
import java.nio.file.WatchKey;
import java.nio.file.WatchService;
import java.nio.file.attribute.FileTime;
import java.nio.file.attribute.PosixFilePermission;
import java.nio.file.attribute.PosixFilePermissions;
import java.text.SimpleDateFormat;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TimeZone;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.IntBinaryOperator;
import java.util.function.IntConsumer;
import java.util.function.Predicate;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jline.builtins.Less;
import org.jline.builtins.Nano;
import org.jline.builtins.Options;
import org.jline.builtins.Source;
import org.jline.builtins.TTop;
import org.jline.terminal.Terminal;
import org.jline.utils.AttributedCharSequence;
import org.jline.utils.AttributedString;
import org.jline.utils.AttributedStringBuilder;
import org.jline.utils.InfoCmp;
import org.jline.utils.OSUtils;
import org.jline.utils.StyleResolver;

public class PosixCommands {
    private static final Map<String, String> DATE_FORMAT_CACHE = new ConcurrentHashMap<String, String>();
    private static final Map<Character, String> UNIX_TO_JAVA_FORMAT_MAP;
    public static final String DEFAULT_LS_COLORS = "dr=1;91:ex=1;92:sl=1;96:ot=34;43";
    public static final String DEFAULT_GREP_COLORS = "mt=1;31:fn=35:ln=32:se=36";
    private static final int DEFAULT_BUFFER_SIZE = 8192;
    private static final int DEFAULT_HEAD_LINES = 10;
    private static final int DEFAULT_TAIL_LINES = 10;
    private static final String[] SIZE_UNITS;
    private static final long SIZE_THRESHOLD = 1000L;
    private static final LinkOption[] EMPTY_LINK_OPTIONS;
    private static final LinkOption[] NO_FOLLOW_OPTIONS;
    private static final List<String> WINDOWS_EXECUTABLE_EXTENSIONS;
    private static final Pattern COLOR_FORMAT_PATTERN;

    private PosixCommands() {
    }

    public static void cd(Context context, String[] argv) throws Exception {
        PosixCommands.cd(context, argv, null);
    }

    public static void cd(Context context, String[] argv, Consumer<Path> directoryChanger) throws Exception {
        String target;
        String home;
        String[] usage = new String[]{"cd - change directory", "Usage: cd [OPTIONS] [DIRECTORY]", "  -? --help                show help", "  -P                       use physical directory structure", "  -L                       follow symbolic links (default)"};
        Options opt = PosixCommands.parseOptions(context, usage, argv);
        if (opt.args().size() != 1) {
            throw new IllegalArgumentException("usage: cd DIRECTORY");
        }
        Path cwd = context.currentDir();
        Path newDir = opt.args().isEmpty() ? ((home = System.getProperty("user.home")) != null ? Paths.get(home, new String[0]) : cwd) : ("-".equals(target = opt.args().get(0)) ? cwd : cwd.resolve(target));
        newDir = opt.isSet("P") ? newDir.toRealPath(new LinkOption[0]) : newDir.toAbsolutePath().normalize();
        if (!Files.exists(newDir, new LinkOption[0])) {
            throw new IOException("cd: no such file or directory: " + opt.args().get(0));
        }
        if (!Files.isDirectory(newDir, new LinkOption[0])) {
            throw new IOException("cd: not a directory: " + opt.args().get(0));
        }
        if (directoryChanger != null) {
            directoryChanger.accept(newDir);
        }
    }

    public static void pwd(Context context, String[] argv) throws Exception {
        String[] usage = new String[]{"pwd - print working directory", "Usage: pwd [OPTIONS]", "  -? --help                show help"};
        Options opt = PosixCommands.parseOptions(context, usage, argv);
        if (!opt.args().isEmpty()) {
            throw new IllegalArgumentException("usage: pwd");
        }
        context.out().println(context.currentDir());
    }

    public static void echo(Context context, String[] argv) throws Exception {
        String[] usage = new String[]{"echo - display text", "Usage: echo [OPTIONS] [ARGUMENTS]", "  -? --help                show help", "  -n                       no trailing new line"};
        Options opt = PosixCommands.parseOptions(context, usage, argv);
        List<String> args = opt.args();
        StringBuilder buf = new StringBuilder();
        if (args != null) {
            int totalLength = args.stream().mapToInt(String::length).sum() + args.size() - 1;
            buf = new StringBuilder(totalLength * 2);
            for (String arg : args) {
                if (buf.length() > 0) {
                    buf.append(' ');
                }
                PosixCommands.processEscapeSequences(arg, buf);
            }
        }
        if (opt.isSet("n")) {
            context.out().print(buf);
        } else {
            context.out().println(buf);
        }
    }

    private static void processEscapeSequences(String arg, StringBuilder buf) {
        int length = arg.length();
        for (int i = 0; i < length; ++i) {
            char c = arg.charAt(i);
            if (c == '\\' && i + 1 < length) {
                char nextChar = arg.charAt(++i);
                switch (nextChar) {
                    case 'a': {
                        buf.append('\u0007');
                        break;
                    }
                    case 'n': {
                        buf.append('\n');
                        break;
                    }
                    case 't': {
                        buf.append('\t');
                        break;
                    }
                    case 'r': {
                        buf.append('\r');
                        break;
                    }
                    case '\\': {
                        buf.append('\\');
                        break;
                    }
                    case '0': 
                    case '1': 
                    case '2': 
                    case '3': 
                    case '4': 
                    case '5': 
                    case '6': 
                    case '7': 
                    case '8': 
                    case '9': {
                        i += PosixCommands.parseOctalSequence(arg, i, length, buf, nextChar);
                        break;
                    }
                    case 'u': {
                        i += PosixCommands.parseUnicodeSequence(arg, i + 1, length, buf);
                        break;
                    }
                    default: {
                        buf.append(nextChar);
                        break;
                    }
                }
                continue;
            }
            buf.append(c);
        }
    }

    private static int parseUnicodeSequence(String arg, int startIndex, int length, StringBuilder buf) {
        int unicodeValue = 0;
        int consumed = 0;
        for (int j = 0; j < 4 && startIndex + consumed < length; ++j) {
            int hexDigit;
            char hexChar = arg.charAt(startIndex + consumed);
            switch (hexChar) {
                case '0': 
                case '1': 
                case '2': 
                case '3': 
                case '4': 
                case '5': 
                case '6': 
                case '7': 
                case '8': 
                case '9': {
                    hexDigit = hexChar - 48;
                    break;
                }
                case 'A': 
                case 'B': 
                case 'C': 
                case 'D': 
                case 'E': 
                case 'F': {
                    hexDigit = hexChar - 65 + 10;
                    break;
                }
                case 'a': 
                case 'b': 
                case 'c': 
                case 'd': 
                case 'e': 
                case 'f': {
                    hexDigit = hexChar - 97 + 10;
                    break;
                }
                default: {
                    buf.append((char)unicodeValue);
                    return consumed;
                }
            }
            unicodeValue = (unicodeValue << 4) + hexDigit;
            ++consumed;
        }
        buf.append((char)unicodeValue);
        return consumed;
    }

    private static int parseOctalSequence(String arg, int startIndex, int length, StringBuilder buf, char firstDigit) {
        int octalValue = firstDigit - 48;
        int consumed = 0;
        block3: for (int j = 0; j < 2 && startIndex + 1 + consumed < length; ++j) {
            char octalChar = arg.charAt(startIndex + 1 + consumed);
            switch (octalChar) {
                case '0': 
                case '1': 
                case '2': 
                case '3': 
                case '4': 
                case '5': 
                case '6': 
                case '7': {
                    octalValue = (octalValue << 3) + (octalChar - 48);
                    ++consumed;
                    continue block3;
                }
                default: {
                    buf.append((char)octalValue);
                    return consumed;
                }
            }
        }
        buf.append((char)octalValue);
        return consumed;
    }

    public static void echo(Context context, Object[] argv) throws Exception {
        String[] stringArgv = new String[argv.length];
        for (int i = 0; i < argv.length; ++i) {
            stringArgv[i] = argv[i] != null ? argv[i].toString() : "";
        }
        PosixCommands.echo(context, stringArgv);
    }

    public static void cat(Context context, String[] argv) throws Exception {
        String[] usage = new String[]{"cat - concatenate and print FILES", "Usage: cat [OPTIONS] [FILES]", "  -? --help                show help", "  -n                       number the output lines, starting at 1"};
        Options opt = PosixCommands.parseOptions(context, usage, argv);
        List<Source> expanded = PosixCommands.getSources(context, opt.args());
        for (Source src : expanded) {
            PosixCommands.cat(context, src.reader(), opt.isSet("n"));
        }
    }

    private static void cat(Context context, BufferedReader reader, boolean numbered) throws IOException {
        int lineno = 1;
        try (BufferedReader bufferedReader = reader;){
            String line;
            while ((line = reader.readLine()) != null) {
                if (numbered) {
                    context.out().printf("%6d\t%s%n", lineno++, line);
                    continue;
                }
                context.out().println(line);
            }
        }
    }

    public static void date(Context context, String[] argv) throws Exception {
        String arg;
        List<String> args;
        String[] usage = new String[]{"date - display date", "Usage: date [OPTIONS] [+FORMAT]", "  -? --help                    Show help", "  -u --utc                     Use UTC timezone", "  -r --reference=SECONDS       Print the date represented by 'seconds' since January 1, 1970", "  -d --date=STRING             Display time described by STRING", "  -f --file=DATEFILE           Like --date once for each line of DATEFILE", "  -I --iso-8601[=TIMESPEC]     Output date/time in ISO 8601 format", "  -R --rfc-2822                Output date and time in RFC 2822 format", "     --rfc-3339=TIMESPEC       Output date and time in RFC 3339 format"};
        Options opt = Options.compile(usage).parse(argv);
        if (opt.isSet("help")) {
            throw new Options.HelpException(opt.usage());
        }
        Date input = new Date();
        String output = null;
        boolean useUtc = opt.isSet("utc");
        if (opt.isSet("reference")) {
            long seconds = Long.parseLong(opt.get("reference"));
            input = new Date(seconds * 1000L);
        }
        if (opt.isSet("date")) {
            String dateStr = opt.get("date");
            try {
                SimpleDateFormat[] formats = new SimpleDateFormat[]{new SimpleDateFormat("yyyy-MM-dd HH:mm:ss"), new SimpleDateFormat("yyyy-MM-dd"), new SimpleDateFormat("MM/dd/yyyy"), new SimpleDateFormat("dd-MM-yyyy"), new SimpleDateFormat("yyyy/MM/dd")};
                boolean parsed = false;
                for (SimpleDateFormat format : formats) {
                    try {
                        input = format.parse(dateStr);
                        parsed = true;
                        break;
                    }
                    catch (Exception exception) {
                    }
                }
                if (!parsed) {
                    throw new IllegalArgumentException("Unable to parse date: " + dateStr);
                }
            }
            catch (Exception e) {
                throw new IllegalArgumentException("Invalid date string: " + dateStr);
            }
        }
        if (opt.isSet("iso-8601")) {
            String timespec = opt.get("iso-8601");
            if (timespec == null || "date".equals(timespec)) {
                output = "%Y-%m-%d";
            } else if ("hours".equals(timespec)) {
                output = "%Y-%m-%dT%H%z";
            } else if ("minutes".equals(timespec)) {
                output = "%Y-%m-%dT%H:%M%z";
            } else if ("seconds".equals(timespec)) {
                output = "%Y-%m-%dT%H:%M:%S%z";
            } else if ("ns".equals(timespec)) {
                output = "%Y-%m-%dT%H:%M:%S,%N%z";
            }
        }
        if (opt.isSet("rfc-2822")) {
            output = "%a, %d %b %Y %H:%M:%S %z";
        }
        if (opt.isSet("rfc-3339")) {
            String timespec = opt.get("rfc-3339");
            if ("date".equals(timespec)) {
                output = "%Y-%m-%d";
            } else if ("seconds".equals(timespec)) {
                output = "%Y-%m-%d %H:%M:%S%z";
            } else if ("ns".equals(timespec)) {
                output = "%Y-%m-%d %H:%M:%S.%N%z";
            }
        }
        if (!(args = opt.args()).isEmpty() && (arg = args.get(0)).startsWith("+")) {
            output = arg.substring(1);
        }
        if (output == null) {
            output = "%c";
        }
        SimpleDateFormat formatter = new SimpleDateFormat(PosixCommands.toJavaDateFormat(output));
        if (useUtc) {
            formatter.setTimeZone(TimeZone.getTimeZone("UTC"));
        }
        context.out().println(formatter.format(input));
    }

    private static String toJavaDateFormat(String format) {
        return DATE_FORMAT_CACHE.computeIfAbsent(format, PosixCommands::convertUnixToJavaFormat);
    }

    private static String convertUnixToJavaFormat(String format) {
        if (format == null || format.isEmpty()) {
            return format;
        }
        StringBuilder sb = new StringBuilder(format.length() * 2);
        boolean inQuotes = false;
        for (int i = 0; i < format.length(); ++i) {
            char c = format.charAt(i);
            if (c == '%' && i + 1 < format.length()) {
                char nextChar = format.charAt(i + 1);
                String javaPattern = UNIX_TO_JAVA_FORMAT_MAP.get(Character.valueOf(nextChar));
                if (javaPattern != null) {
                    boolean needsQuotes;
                    boolean bl = needsQuotes = nextChar == 'n' || nextChar == 't' || nextChar == '%';
                    if (inQuotes != needsQuotes) {
                        sb.append('\'');
                        inQuotes = !inQuotes;
                    }
                    sb.append(javaPattern);
                    ++i;
                    continue;
                }
                if (!inQuotes) {
                    sb.append('\'');
                    inQuotes = true;
                }
                sb.append(c);
                continue;
            }
            boolean needsQuotes = Character.isLetter(c);
            if (inQuotes != needsQuotes) {
                sb.append('\'');
                inQuotes = !inQuotes;
            }
            sb.append(c);
        }
        if (inQuotes) {
            sb.append('\'');
        }
        return sb.toString();
    }

    public static void sleep(Context context, String[] argv) throws Exception {
        String[] usage = new String[]{"sleep - suspend execution for an interval of time", "Usage: sleep seconds", "  -? --help                    show help"};
        Options opt = PosixCommands.parseOptions(context, usage, argv);
        List<String> args = opt.args();
        if (args.size() != 1) {
            throw new IllegalArgumentException("usage: sleep seconds");
        }
        int s = Integer.parseInt(args.get(0));
        Thread.sleep((long)s * 1000L);
    }

    public static void watch(Context context, String[] argv) throws Exception {
        PosixCommands.watch(context, argv, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void watch(Context context, String[] argv, CommandExecutor executor) throws Exception {
        String[] usage = new String[]{"watch - watches & refreshes the output of a command", "Usage: watch [OPTIONS] COMMAND", "  -? --help                    Show help", "  -n --interval=SECONDS        Interval between executions of the command in seconds", "  -a --append                  The output should be appended but not clear the console"};
        Options opt = PosixCommands.parseOptions(context, usage, argv);
        List<String> args = opt.args();
        if (args.isEmpty()) {
            throw new IllegalArgumentException("usage: watch COMMAND");
        }
        int intervalValue = 1;
        if (opt.isSet("interval") && (intervalValue = opt.getNumber("interval")) < 1) {
            intervalValue = 1;
        }
        int interval = intervalValue;
        boolean append = opt.isSet("append");
        String command = String.join((CharSequence)" ", args);
        ArrayList<String> finalArgs = new ArrayList<String>(args);
        ScheduledExecutorService executorService = Executors.newSingleThreadScheduledExecutor();
        try {
            Runnable task = () -> {
                try {
                    if (!append && context.isTty()) {
                        context.terminal().puts(InfoCmp.Capability.clear_screen, new Object[0]);
                        context.terminal().flush();
                    } else if (!append) {
                        context.out().println();
                    }
                    context.out().println("Every " + interval + "s: " + command + "    " + String.valueOf(LocalDateTime.now()));
                    context.out().println();
                    if (executor != null) {
                        try {
                            String output = executor.execute(finalArgs);
                            context.out().print(output);
                        }
                        catch (Exception e) {
                            context.err().println("Command execution failed: " + e.getMessage());
                        }
                    } else {
                        try {
                            Process process = new ProcessBuilder(finalArgs).start();
                            try (BufferedReader reader = new BufferedReader(new InputStreamReader(process.getInputStream()));){
                                String line;
                                while ((line = reader.readLine()) != null) {
                                    context.out().println(line);
                                }
                            }
                            process.waitFor();
                        }
                        catch (Exception e) {
                            context.out().println("Command: " + command);
                            context.out().println("(Command execution requires shell integration - use gogo implementation for full functionality)");
                        }
                    }
                    context.out().flush();
                }
                catch (Exception e) {
                    context.err().println("Error executing command: " + e.getMessage());
                }
            };
            executorService.scheduleAtFixedRate(task, 0L, interval, TimeUnit.SECONDS);
            if (context.isTty()) {
                context.out().println("Press any key to stop...");
                context.in().read();
            } else {
                Thread.sleep(10000L);
            }
        }
        finally {
            executorService.shutdownNow();
        }
    }

    public static void ttop(Context context, String[] argv) throws Exception {
        TTop.ttop(context.terminal(), context.out(), context.err(), argv);
    }

    public static void nano(Context context, String[] argv) throws Exception {
        Options opt = PosixCommands.parseOptions(context, Nano.usage(), argv);
        Nano nano = new Nano(context.terminal(), context.currentDir(), opt);
        nano.open(opt.args());
        nano.run();
    }

    public static void less(Context context, String[] argv) throws Exception {
        Options opt = PosixCommands.parseOptions(context, Less.usage(), argv);
        List<Source> sources = PosixCommands.getSources(context, opt.args());
        if (!context.isTty()) {
            for (Source source : sources) {
                BufferedReader reader = source.reader();
                try {
                    reader.lines().forEach(context.out()::println);
                }
                finally {
                    if (reader == null) continue;
                    reader.close();
                }
            }
            return;
        }
        Less less = new Less(context.terminal(), context.currentDir(), opt);
        less.run(sources);
    }

    public static void clear(Context context, String[] argv) throws Exception {
        String[] usage = new String[]{"clear - clear screen", "Usage: clear [OPTIONS]", "  -? --help                    Show help"};
        Options opt = PosixCommands.parseOptions(context, usage, argv);
        if (context.isTty()) {
            context.terminal().puts(InfoCmp.Capability.clear_screen, new Object[0]);
            context.terminal().flush();
        }
    }

    public static void wc(Context context, String[] argv) throws Exception {
        boolean hasMultipleOutputs;
        String[] usage = new String[]{"wc - word, line, character, and byte count", "Usage: wc [OPTIONS] [FILES]", "  -? --help                    Show help", "  -l --lines                   Print line counts", "  -c --bytes                   Print byte counts", "  -m --chars                   Print character counts", "  -w --words                   Print word counts"};
        Options opt = PosixCommands.parseOptions(context, usage, argv);
        List<Source> sources = PosixCommands.getSources(context, opt.args());
        boolean showLines = opt.isSet("lines");
        boolean showWords = opt.isSet("words");
        boolean showChars = opt.isSet("chars");
        boolean showBytes = opt.isSet("bytes");
        if (!(showLines || showWords || showChars || showBytes)) {
            showLines = true;
            showWords = true;
            showBytes = true;
        }
        StringBuilder formatBuilder = new StringBuilder();
        boolean bl = hasMultipleOutputs = (showLines ? 1 : 0) + (showWords ? 1 : 0) + (showChars ? 1 : 0) + (showBytes ? 1 : 0) > 1;
        if (showLines) {
            formatBuilder.append(hasMultipleOutputs ? "%1$8d" : "%1$d");
        }
        if (showWords) {
            formatBuilder.append(hasMultipleOutputs ? "%2$8d" : "%2$d");
        }
        if (showChars) {
            formatBuilder.append(hasMultipleOutputs ? "%3$8d" : "%3$d");
        }
        if (showBytes) {
            formatBuilder.append(hasMultipleOutputs ? "%4$8d" : "%4$d");
        }
        if (sources.size() > 1 || sources.size() == 1 && sources.get(0).getName() != null) {
            formatBuilder.append("  %5$8s");
        }
        formatBuilder.append("%n");
        String format = formatBuilder.toString();
        long totalLines = 0L;
        long totalWords = 0L;
        long totalChars = 0L;
        long totalBytes = 0L;
        for (Source source : sources) {
            InputStream is = source.read();
            try {
                AtomicInteger lines = new AtomicInteger();
                final AtomicInteger bytes = new AtomicInteger();
                AtomicInteger chars = new AtomicInteger();
                AtomicInteger words = new AtomicInteger();
                AtomicBoolean inWord = new AtomicBoolean();
                AtomicBoolean lastNl = new AtomicBoolean(true);
                FilterInputStream isc = new FilterInputStream(is){

                    @Override
                    public int read() throws IOException {
                        int b = super.read();
                        if (b >= 0) {
                            bytes.incrementAndGet();
                        }
                        return b;
                    }

                    @Override
                    public int read(byte[] b, int off, int len) throws IOException {
                        int nb = super.read(b, off, len);
                        if (nb > 0) {
                            bytes.addAndGet(nb);
                        }
                        return nb;
                    }
                };
                IntConsumer consumer = cp -> {
                    chars.incrementAndGet();
                    boolean ws = Character.isWhitespace(cp);
                    if (inWord.getAndSet(!ws) && ws) {
                        words.incrementAndGet();
                    }
                    if (cp == 10) {
                        lines.incrementAndGet();
                        lastNl.set(true);
                    } else {
                        lastNl.set(false);
                    }
                };
                InputStreamReader reader = new InputStreamReader(isc);
                while (true) {
                    int h;
                    if (Character.isHighSurrogate((char)(h = ((Reader)reader).read()))) {
                        int l = ((Reader)reader).read();
                        if (Character.isLowSurrogate((char)l)) {
                            int cp2 = Character.toCodePoint((char)h, (char)l);
                            consumer.accept(cp2);
                            continue;
                        }
                        consumer.accept(h);
                        if (l < 0) break;
                        consumer.accept(l);
                        continue;
                    }
                    if (h < 0) break;
                    consumer.accept(h);
                }
                if (inWord.get()) {
                    words.incrementAndGet();
                }
                if (!lastNl.get()) {
                    lines.incrementAndGet();
                }
                context.out().printf(format, lines.get(), words.get(), chars.get(), bytes.get(), source.getName());
                totalBytes += (long)bytes.get();
                totalChars += (long)chars.get();
                totalWords += (long)words.get();
                totalLines += (long)lines.get();
            }
            finally {
                if (is == null) continue;
                is.close();
            }
        }
        if (sources.size() > 1) {
            context.out().printf(format, totalLines, totalWords, totalChars, totalBytes, "total");
        }
    }

    public static void head(Context context, String[] argv) throws Exception {
        String[] usage = new String[]{"head - display first lines of files", "Usage: head [-n lines | -c bytes] [file ...]", "  -? --help                    Show help", "  -n --lines=LINES             Print line counts", "  -c --bytes=BYTES             Print byte counts"};
        Options opt = PosixCommands.parseOptions(context, usage, argv);
        if (opt.isSet("lines") && opt.isSet("bytes")) {
            throw new IllegalArgumentException("usage: head [-n # | -c #] [file ...]");
        }
        int nbLines = Integer.MAX_VALUE;
        int nbBytes = Integer.MAX_VALUE;
        if (opt.isSet("lines")) {
            nbLines = opt.getNumber("lines");
        } else if (opt.isSet("bytes")) {
            nbBytes = opt.getNumber("bytes");
        } else {
            nbLines = 10;
        }
        List<Source> sources = PosixCommands.getSources(context, opt.args());
        for (Source src : sources) {
            int bytes = nbBytes;
            int lines = nbLines;
            if (sources.size() > 1) {
                if (src != sources.get(0)) {
                    context.out().println();
                }
                context.out().println("==> " + src.getName() + " <==");
            }
            InputStream is = src.read();
            try {
                int nb;
                byte[] buf = new byte[8192];
                do {
                    if ((nb = is.read(buf)) <= 0 || lines <= 0 || bytes <= 0) continue;
                    nb = Math.min(nb, bytes);
                    for (int i = 0; i < nb; ++i) {
                        if (buf[i] != 10 || --lines > 0) continue;
                        nb = i + 1;
                        break;
                    }
                    bytes -= nb;
                    context.out().write(buf, 0, nb);
                } while (nb > 0 && lines > 0 && bytes > 0);
            }
            finally {
                if (is == null) continue;
                is.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void tail(final Context context, String[] argv) throws Exception {
        class Input
        implements Closeable {
            final Source source;
            Path path;
            Reader reader;
            StringBuilder buffer;
            long ino;
            long size;

            Input(Source source) {
                this.source = source;
                this.buffer = new StringBuilder();
            }

            public void open() {
                if (this.reader == null) {
                    try {
                        InputStream is = this.source.read();
                        if (this.source instanceof Source.PathSource) {
                            this.path = ((Source.PathSource)this.source).getPath();
                            if (opt.isSet("FOLLOW")) {
                                try {
                                    this.ino = (Long)Files.getAttribute(this.path, "unix:ino", new LinkOption[0]);
                                }
                                catch (Exception exception) {
                                    // empty catch block
                                }
                            }
                            this.size = Files.size(this.path);
                        }
                        this.reader = new InputStreamReader(is);
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
            }

            @Override
            public void close() throws IOException {
                if (this.reader != null) {
                    try {
                        this.reader.close();
                    }
                    finally {
                        this.reader = null;
                    }
                }
            }

            public boolean tail() throws IOException {
                this.open();
                if (this.reader != null) {
                    if (this.buffer != null) {
                        Path parent;
                        int nb;
                        char[] buf = new char[1024];
                        while ((nb = this.reader.read(buf)) > 0) {
                            this.buffer.append(buf, 0, nb);
                            if (bytes > 0 && this.buffer.length() > bytes) {
                                this.buffer.delete(0, this.buffer.length() - bytes);
                                continue;
                            }
                            int l = 0;
                            int i = -1;
                            while ((i = this.buffer.indexOf("\n", i + 1)) >= 0) {
                                ++l;
                            }
                            if (l <= lines) continue;
                            i = -1;
                            l -= lines;
                            while (--l >= 0) {
                                i = this.buffer.indexOf("\n", i + 1);
                            }
                            this.buffer.delete(0, i + 1);
                        }
                        String toPrint = this.buffer.toString();
                        this.print(toPrint);
                        this.buffer = null;
                        if (follow && this.path != null && !watched.contains(parent = this.path.getParent())) {
                            parent.register(watchService, StandardWatchEventKinds.ENTRY_CREATE, StandardWatchEventKinds.ENTRY_DELETE, StandardWatchEventKinds.ENTRY_MODIFY);
                            watched.add(parent);
                        }
                        return follow;
                    }
                    if (follow && this.path != null) {
                        while (true) {
                            long newSize;
                            if (this.size != (newSize = Files.size(this.path))) {
                                int nb;
                                char[] buf = new char[1024];
                                while ((nb = this.reader.read(buf)) > 0) {
                                    this.print(new String(buf, 0, nb));
                                }
                                this.size = newSize;
                            }
                            if (!opt.isSet("FOLLOW")) break;
                            long newIno = 0L;
                            try {
                                newIno = (Long)Files.getAttribute(this.path, "unix:ino", new LinkOption[0]);
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                            if (this.ino == newIno) break;
                            this.close();
                            this.open();
                            this.ino = newIno;
                            this.size = -1L;
                        }
                        return true;
                    }
                    return false;
                }
                Path parent = this.path.getParent();
                if (follow && !watched.contains(parent)) {
                    parent.register(watchService, StandardWatchEventKinds.ENTRY_CREATE, StandardWatchEventKinds.ENTRY_DELETE, StandardWatchEventKinds.ENTRY_MODIFY);
                    watched.add(parent);
                }
                return true;
            }

            private void print(String toPrint) {
                if (lastPrinted.get() != this && opt.args().size() > 1 && !opt.isSet("quiet")) {
                    context.out().println();
                    context.out().println("==> " + this.source.getName() + " <==");
                }
                context.out().print(toPrint);
                lastPrinted.set(this);
            }
        }
        String[] usage = new String[]{"tail - display last lines of files", "Usage: tail [-f] [-q] [-c # | -n #] [file ...]", "  -? --help                    Show help", "  -f --follow                  Do not stop at end of file", "  -F --FOLLOW                  Follow and check for file renaming or rotation", "  -n --lines=LINES             Number of lines to print", "  -c --bytes=BYTES             Number of bytes to print"};
        final Options opt = PosixCommands.parseOptions(context, usage, argv);
        if (opt.isSet("lines") && opt.isSet("bytes")) {
            throw new IllegalArgumentException("usage: tail [-f] [-q] [-c # | -n #] [file ...]");
        }
        final int lines = opt.isSet("lines") ? opt.getNumber("lines") : 10;
        final int bytes = opt.isSet("bytes") ? opt.getNumber("bytes") : -1;
        final boolean follow = opt.isSet("follow") || opt.isSet("FOLLOW");
        final AtomicReference lastPrinted = new AtomicReference();
        final WatchService watchService = follow ? context.currentDir().getFileSystem().newWatchService() : null;
        final HashSet watched = new HashSet();
        List<Source> sources = PosixCommands.getSources(context, opt.args());
        List inputs = sources.stream().map(x$0 -> new Input((Source)x$0)).collect(Collectors.toList());
        try {
            boolean cont = true;
            while (cont) {
                cont = false;
                for (Input input : inputs) {
                    cont |= input.tail();
                }
                if (!cont || !follow) continue;
                WatchKey key = watchService.take();
                key.pollEvents();
                key.reset();
            }
        }
        catch (InterruptedException interruptedException) {
            for (Input input : inputs) {
                input.close();
            }
        }
        finally {
            for (Input input : inputs) {
                input.close();
            }
        }
    }

    public static void grep(Context context, String[] argv) throws Exception {
        boolean filenameHeader;
        boolean colored;
        String color;
        String lineFmt;
        Pattern p2;
        Pattern p;
        String[] usage = new String[]{"grep -  search for PATTERN in each FILE or standard input.", "Usage: grep [OPTIONS] PATTERN [FILES]", "  -? --help                Show help", "  -i --ignore-case         Ignore case distinctions", "  -n --line-number         Prefix each line with line number within its input file", "  -q --quiet, --silent     Suppress all normal output", "  -v --invert-match        Select non-matching lines", "  -w --word-regexp         Select only whole words", "  -x --line-regexp         Select only whole lines", "  -c --count               Only print a count of matching lines per file", "  -z --zero                When used with -c, don't print a count of zero", "  -H --with-filename       Display filename header for each file (defaults to true if multiple files are given)", "  -h --no-filename         Do not display filename header", "     --color=WHEN          Use markers to distinguish the matching string, may be `always', `never' or `auto'", "  -B --before-context=NUM  Print NUM lines of leading context before matching lines", "  -A --after-context=NUM   Print NUM lines of trailing context after matching lines", "  -C --context=NUM         Print NUM lines of output context", "     --pad-lines           Pad line numbers"};
        Options opt = PosixCommands.parseOptions(context, usage, argv);
        Map<String, String> colorMap = PosixCommands.getColorMap(context, "GREP", DEFAULT_GREP_COLORS);
        List<String> args = opt.args();
        if (args.isEmpty()) {
            throw new IllegalArgumentException("no pattern supplied");
        }
        String regex = args.remove(0);
        Object regexp = regex;
        if (opt.isSet("word-regexp")) {
            regexp = "\\b" + (String)regexp + "\\b";
        }
        regexp = opt.isSet("line-regexp") ? "^" + (String)regexp + "$" : ".*" + (String)regexp + ".*";
        if (opt.isSet("ignore-case")) {
            p = Pattern.compile((String)regexp, 2);
            p2 = Pattern.compile(regex, 2);
        } else {
            p = Pattern.compile((String)regexp);
            p2 = Pattern.compile(regex);
        }
        int after = opt.isSet("after-context") ? opt.getNumber("after-context") : -1;
        int before = opt.isSet("before-context") ? opt.getNumber("before-context") : -1;
        int contextLines = opt.isSet("context") ? opt.getNumber("context") : 0;
        String string = lineFmt = opt.isSet("pad-lines") ? "%6d" : "%d";
        if (after < 0) {
            after = contextLines;
        }
        if (before < 0) {
            before = contextLines;
        }
        boolean count = opt.isSet("count");
        boolean zero = opt.isSet("zero");
        boolean quiet = opt.isSet("quiet");
        boolean invert = opt.isSet("invert-match");
        boolean lineNumber = opt.isSet("line-number");
        switch (color = opt.isSet("color") ? opt.get("color") : "auto") {
            case "always": 
            case "yes": 
            case "force": {
                colored = true;
                break;
            }
            case "never": 
            case "no": 
            case "none": {
                colored = false;
                break;
            }
            case "auto": 
            case "tty": 
            case "if-tty": {
                colored = context.isTty();
                break;
            }
            default: {
                throw new IllegalArgumentException("invalid argument '" + color + "' for '--color'");
            }
        }
        Map<String, String> colors = colored ? (colorMap != null ? colorMap : PosixCommands.getColorMap(DEFAULT_GREP_COLORS)) : Collections.emptyMap();
        List<Source> sources = PosixCommands.getSources(context, args);
        boolean bl = filenameHeader = sources.size() > 1;
        if (opt.isSet("with-filename")) {
            filenameHeader = true;
        } else if (opt.isSet("no-filename")) {
            filenameHeader = false;
        }
        boolean match = false;
        for (Source src : sources) {
            ArrayList<String> lines = new ArrayList<String>();
            boolean firstPrint = true;
            int nb = 0;
            InputStream is = src.read();
            try {
                try (BufferedReader r = new BufferedReader(new InputStreamReader(is));){
                    String line;
                    int lineno = 1;
                    int lineMatch = 0;
                    while ((line = r.readLine()) != null) {
                        boolean matches = p.matcher(line).matches();
                        if (invert) {
                            matches = !matches;
                        }
                        AttributedStringBuilder sbl = new AttributedStringBuilder();
                        if (matches) {
                            ++nb;
                            if (!count && !quiet) {
                                if (filenameHeader) {
                                    if (colored) {
                                        PosixCommands.applyStyle(sbl, colors, "fn");
                                    }
                                    sbl.append(src.getName());
                                    if (colored) {
                                        PosixCommands.applyStyle(sbl, colors, "se");
                                    }
                                    sbl.append(":");
                                }
                                if (lineNumber) {
                                    if (colored) {
                                        PosixCommands.applyStyle(sbl, colors, "ln");
                                    }
                                    sbl.append(String.format(lineFmt, lineno));
                                    if (colored) {
                                        PosixCommands.applyStyle(sbl, colors, "se");
                                    }
                                    sbl.append(":");
                                }
                                if (colored) {
                                    Matcher matcher2 = p2.matcher(line);
                                    int cur = 0;
                                    while (matcher2.find()) {
                                        PosixCommands.applyStyle(sbl, colors, "se");
                                        sbl.append(line, cur, matcher2.start());
                                        PosixCommands.applyStyle(sbl, colors, "ms");
                                        sbl.append(line, matcher2.start(), matcher2.end());
                                        PosixCommands.applyStyle(sbl, colors, "se");
                                        cur = matcher2.end();
                                    }
                                    sbl.append(line, cur, line.length());
                                } else {
                                    sbl.append(line);
                                }
                                while (lineMatch > after && !lines.isEmpty()) {
                                    context.out().println((String)lines.remove(0));
                                    --lineMatch;
                                }
                                lineMatch = Math.min(before, lines.size()) + after + 1;
                            }
                        } else if (lineMatch > 0) {
                            context.out().println((String)lines.remove(0));
                            --lineMatch;
                            if (filenameHeader) {
                                if (colored) {
                                    PosixCommands.applyStyle(sbl, colors, "fn");
                                }
                                sbl.append(src.getName());
                                if (colored) {
                                    PosixCommands.applyStyle(sbl, colors, "se");
                                }
                                sbl.append("-");
                            }
                            if (lineNumber) {
                                if (colored) {
                                    PosixCommands.applyStyle(sbl, colors, "ln");
                                }
                                sbl.append(String.format(lineFmt, lineno));
                                if (colored) {
                                    PosixCommands.applyStyle(sbl, colors, "se");
                                }
                                sbl.append("-");
                            }
                            if (colored) {
                                PosixCommands.applyStyle(sbl, colors, "se");
                            }
                            sbl.append(line);
                        } else {
                            if (filenameHeader) {
                                if (colored) {
                                    PosixCommands.applyStyle(sbl, colors, "fn");
                                }
                                sbl.append(src.getName());
                                if (colored) {
                                    PosixCommands.applyStyle(sbl, colors, "se");
                                }
                                sbl.append("-");
                            }
                            if (lineNumber) {
                                if (colored) {
                                    PosixCommands.applyStyle(sbl, colors, "ln");
                                }
                                sbl.append(String.format(lineFmt, lineno));
                                if (colored) {
                                    PosixCommands.applyStyle(sbl, colors, "se");
                                }
                                sbl.append("-");
                            }
                            if (colored) {
                                PosixCommands.applyStyle(sbl, colors, "se");
                            }
                            sbl.append(line);
                            while (lines.size() > before) {
                                lines.remove(0);
                            }
                            lineMatch = 0;
                        }
                        lines.add(sbl.toAnsi(context.terminal()));
                        while (lineMatch == 0 && lines.size() > before) {
                            lines.remove(0);
                        }
                        ++lineno;
                    }
                    if (!count && lineMatch > 0) {
                        if (!firstPrint && before + after > 0) {
                            AttributedStringBuilder sbl2 = new AttributedStringBuilder();
                            if (colored) {
                                PosixCommands.applyStyle(sbl2, colors, "se");
                            }
                            sbl2.append("--");
                            context.out().println(sbl2.toAnsi(context.terminal()));
                        } else {
                            firstPrint = false;
                        }
                        for (int i = 0; i < lineMatch && i < lines.size(); ++i) {
                            context.out().println((String)lines.get(i));
                        }
                    }
                    if (count && (nb != 0 || !zero)) {
                        AttributedStringBuilder sbl = new AttributedStringBuilder();
                        if (filenameHeader) {
                            if (colored) {
                                PosixCommands.applyStyle(sbl, colors, "fn");
                            }
                            sbl.append(src.getName());
                            if (colored) {
                                PosixCommands.applyStyle(sbl, colors, "se");
                            }
                            sbl.append(":");
                        }
                        sbl.append(Integer.toString(nb));
                        context.out().println(sbl.toAnsi(context.terminal()));
                    }
                    match |= nb > 0;
                }
                context.out().flush();
            }
            finally {
                if (is == null) continue;
                is.close();
            }
        }
    }

    public static void sort(Context context, String[] argv) throws Exception {
        String[] usage = new String[]{"sort -  writes sorted concatenation of files or standard input.", "Usage: sort [OPTIONS] [FILES]", "  -? --help                    show help", "  -f --ignore-case             fold lower case to upper case characters", "  -r --reverse                 reverse the result of comparisons", "  -u --unique                  output only the first of an equal run", "  -t --field-separator=SEP     use SEP instead of non-blank to blank transition", "  -b --ignore-leading-blanks   ignore leading blanks", "     --numeric-sort            compare according to string numerical value", "  -k --key=KEY                 fields to use for sorting separated by whitespaces"};
        Options opt = PosixCommands.parseOptions(context, usage, argv);
        ArrayList<String> lines = new ArrayList<String>();
        for (Source source : PosixCommands.getSources(context, opt.args())) {
            BufferedReader reader = source.reader();
            try {
                lines.addAll(reader.lines().collect(Collectors.toList()));
            }
            finally {
                if (reader == null) continue;
                reader.close();
            }
        }
        String separator = opt.get("field-separator");
        boolean caseInsensitive = opt.isSet("ignore-case");
        boolean reverse = opt.isSet("reverse");
        boolean ignoreBlanks = opt.isSet("ignore-leading-blanks");
        boolean numeric = opt.isSet("numeric-sort");
        boolean unique = opt.isSet("unique");
        List<String> sortFields = opt.getList("key");
        char sep = separator == null || separator.isEmpty() ? (char)'\u0000' : separator.charAt(0);
        lines.sort(new SortComparator(caseInsensitive, reverse, ignoreBlanks, numeric, sep, sortFields));
        String last = null;
        for (String s : lines) {
            if (!unique || !s.equals(last)) {
                context.out().println(s);
            }
            last = s;
        }
    }

    public static void ls(Context context, String[] argv) throws Exception {
        class PathEntry
        implements Comparable<PathEntry> {
            final Path abs;
            final Path path;
            final Map<String, Object> attributes;

            public PathEntry(Path abs, Path root) {
                this.abs = abs;
                try {
                    this.path = Files.isSameFile(abs, root) ? Paths.get(".", new String[0]) : (abs.startsWith(root) ? root.relativize(abs) : abs);
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
                this.attributes = this.readAttributes(abs);
            }

            @Override
            public int compareTo(PathEntry o) {
                int c = this.doCompare(o);
                return opt.isSet("r") ? -c : c;
            }

            private int doCompare(PathEntry o) {
                if (opt.isSet("f")) {
                    return -1;
                }
                if (opt.isSet("S")) {
                    long s1;
                    long s0 = this.attributes.get("size") != null ? ((Number)this.attributes.get("size")).longValue() : 0L;
                    long l = s1 = o.attributes.get("size") != null ? ((Number)o.attributes.get("size")).longValue() : 0L;
                    return s0 > s1 ? -1 : (s0 < s1 ? 1 : this.path.toString().compareTo(o.path.toString()));
                }
                if (opt.isSet("t")) {
                    long t1;
                    long t0 = this.attributes.get("lastModifiedTime") != null ? ((FileTime)this.attributes.get("lastModifiedTime")).toMillis() : 0L;
                    long l = t1 = o.attributes.get("lastModifiedTime") != null ? ((FileTime)o.attributes.get("lastModifiedTime")).toMillis() : 0L;
                    return t0 > t1 ? -1 : (t0 < t1 ? 1 : this.path.toString().compareTo(o.path.toString()));
                }
                return this.path.toString().compareTo(o.path.toString());
            }

            boolean isNotDirectory() {
                return this.is("isRegularFile") || this.is("isSymbolicLink") || this.is("isOther");
            }

            boolean isDirectory() {
                return this.is("isDirectory");
            }

            private boolean is(String attr) {
                Object d = this.attributes.get(attr);
                return d instanceof Boolean && (Boolean)d != false;
            }

            String display() {
                String suffix;
                String type;
                Object link = "";
                if (this.is("isSymbolicLink")) {
                    type = "sl";
                    suffix = "@";
                    try {
                        Path l = Files.readSymbolicLink(this.abs);
                        link = " -> " + l.toString();
                    }
                    catch (IOException l) {}
                } else if (this.is("isDirectory")) {
                    type = "dr";
                    suffix = "/";
                } else if (this.is("isExecutable")) {
                    type = "ex";
                    suffix = "*";
                } else if (this.is("isOther")) {
                    type = "ot";
                    suffix = "";
                } else {
                    type = "";
                    suffix = "";
                }
                boolean addSuffix = opt.isSet("F");
                return PosixCommands.applyStyle(this.path.toString(), (Map<String, String>)colors, type) + (addSuffix ? suffix : "") + (String)link;
            }

            String longDisplay() {
                String username = Objects.toString(this.attributes.get("owner"), "owner");
                String group = Objects.toString(this.attributes.get("group"), "group");
                String size = this.formatSize();
                EnumSet<PosixFilePermission> perms = (EnumSet<PosixFilePermission>)this.attributes.get("permissions");
                String permissions = PosixFilePermissions.toString(perms != null ? perms : EnumSet.noneOf(PosixFilePermission.class));
                String fileType = this.is("isDirectory") ? "d" : (this.is("isSymbolicLink") ? "l" : (this.is("isOther") ? "o" : "-"));
                String linkCount = Objects.toString(this.attributes.get("nlink"), "1");
                String modTime = this.toString((FileTime)this.attributes.get("lastModifiedTime"));
                String fileName = this.display();
                return String.format("%s%s %3s %-8.8s %-8.8s %8s %s %s", fileType, permissions, linkCount, username, group, size, modTime, fileName);
            }

            private String formatSize() {
                Number length = (Number)this.attributes.get("size");
                if (length == null) {
                    length = 0L;
                }
                if (opt.isSet("h")) {
                    int unitIndex;
                    long bytes = length.longValue();
                    if (bytes < 1000L) {
                        return bytes + "B";
                    }
                    double size = bytes;
                    for (unitIndex = 0; size >= 1000.0 && unitIndex < SIZE_UNITS.length - 1; size /= 1024.0, ++unitIndex) {
                    }
                    String format = size < 10.0 && bytes > 1000L ? "%.1f" : "%.0f";
                    return String.format(format, size) + SIZE_UNITS[unitIndex];
                }
                return length.toString();
            }

            protected String toString(FileTime time) {
                long millis;
                long l = millis = time != null ? time.toMillis() : -1L;
                if (millis < 0L) {
                    return "------------";
                }
                ZonedDateTime dt = Instant.ofEpochMilli(millis).atZone(ZoneId.systemDefault());
                if (System.currentTimeMillis() - millis < 15811200000L) {
                    return DateTimeFormatter.ofPattern("MMM ppd HH:mm").format(dt);
                }
                return DateTimeFormatter.ofPattern("MMM ppd  yyyy").format(dt);
            }

            protected Map<String, Object> readAttributes(Path path) {
                TreeMap<String, Object> attrs = new TreeMap<String, Object>(String.CASE_INSENSITIVE_ORDER);
                for (String view : path.getFileSystem().supportedFileAttributeViews()) {
                    try {
                        Map<String, Object> ta = Files.readAttributes(path, view + ":*", PosixCommands.getLinkOptions(opt.isSet("L")));
                        ta.forEach(attrs::putIfAbsent);
                    }
                    catch (IOException iOException) {}
                }
                attrs.computeIfAbsent("isExecutable", s -> Files.isExecutable(path));
                attrs.computeIfAbsent("permissions", s -> PosixCommands.getPermissionsFromFile(path));
                return attrs;
            }
        }
        boolean colored;
        String color;
        String[] usage = new String[]{"ls - list files", "Usage: ls [OPTIONS] [PATTERNS...]", "  -? --help                show help", "  -1                       list one entry per line", "  -C                       multi-column output", "     --color=WHEN          colorize the output, may be `always', `never' or `auto'", "  -a                       list entries starting with .", "  -F                       append file type indicators", "  -m                       comma separated", "  -l                       long listing", "  -S                       sort by size", "  -f                       output is not sorted", "  -r                       reverse sort order", "  -t                       sort by modification time", "  -x                       sort horizontally", "  -L                       list referenced file for links", "  -h                       print sizes in human readable form"};
        final Options opt = PosixCommands.parseOptions(context, usage, argv);
        Map<String, String> colorMap = PosixCommands.getLsColorMap(context);
        switch (color = opt.isSet("color") ? opt.get("color") : "auto") {
            case "always": 
            case "yes": 
            case "force": {
                colored = true;
                break;
            }
            case "never": 
            case "no": 
            case "none": {
                colored = false;
                break;
            }
            case "auto": 
            case "tty": 
            case "if-tty": {
                colored = context.isTty();
                break;
            }
            default: {
                throw new IllegalArgumentException("invalid argument '" + color + "' for '--color'");
            }
        }
        final Map colors = colored ? (colorMap != null ? colorMap : PosixCommands.getLsColorMap(DEFAULT_LS_COLORS)) : Collections.emptyMap();
        Path currentDir = context.currentDir();
        ArrayList<Path> expanded = new ArrayList<Path>();
        if (opt.args().isEmpty()) {
            expanded.add(currentDir);
        } else {
            opt.args().stream().flatMap(s -> PosixCommands.maybeExpandGlob(context, s)).forEach(expanded::add);
        }
        boolean listAll = opt.isSet("a");
        Predicate<Path> filter = p -> listAll || p.getFileName().toString().equals(".") || p.getFileName().toString().equals("..") || !p.getFileName().toString().startsWith(".");
        List all = expanded.stream().filter(filter).map(p -> new PathEntry((Path)p, currentDir)).sorted().collect(Collectors.toList());
        List files = all.stream().filter(PathEntry::isNotDirectory).collect(Collectors.toList());
        PrintStream out = context.out();
        Consumer<Stream> display = s -> {
            boolean optLine = opt.isSet("1");
            boolean optComma = opt.isSet("m");
            boolean optLong = opt.isSet("l");
            boolean optCol = opt.isSet("C");
            if (!(optLine || optComma || optLong || optCol)) {
                if (context.isTty()) {
                    optCol = true;
                } else {
                    optLine = true;
                }
            }
            if (optLine) {
                s.map(PathEntry::display).forEach(out::println);
            } else if (optComma) {
                out.println(s.map(PathEntry::display).collect(Collectors.joining(", ")));
            } else if (optLong) {
                s.map(PathEntry::longDisplay).forEach(out::println);
            } else {
                PosixCommands.toColumn(context, out, s.map(PathEntry::display), opt.isSet("x"));
            }
        };
        boolean space = false;
        if (!files.isEmpty()) {
            display.accept(files.stream());
            space = true;
        }
        List directories = all.stream().filter(PathEntry::isDirectory).collect(Collectors.toList());
        for (PathEntry entry : directories) {
            if (space) {
                out.println();
            }
            space = true;
            Path path = currentDir.resolve(entry.path);
            if (expanded.size() > 1) {
                out.println(currentDir.relativize(path).toString() + ":");
            }
            Stream<Path> pathStream = Files.list(path);
            try {
                display.accept(Stream.concat(Stream.of(".", "..").map(path::resolve), pathStream).filter(filter).map(p -> new PathEntry((Path)p, path)).sorted());
            }
            finally {
                if (pathStream == null) continue;
                pathStream.close();
            }
        }
    }

    private static List<Source> getSources(Context context, List<String> args) {
        return (args.isEmpty() ? Stream.of("-") : args.stream()).flatMap(arg -> PosixCommands.getSources(context, arg)).collect(Collectors.toList());
    }

    private static Stream<? extends Source> getSources(Context context, String arg) {
        if ("-".equals(arg)) {
            return Stream.of(new Source.StdInSource(context.in()));
        }
        return PosixCommands.maybeExpandGlob(context, arg).map(path -> new Source.PathSource((Path)path, path.toString()));
    }

    private static Stream<Path> maybeExpandGlob(Context context, String pattern) {
        Stream<Path> stream;
        block14: {
            String globPart;
            Path base;
            int idxStar = pattern.indexOf(42);
            int idxQuestion = pattern.indexOf(63);
            int idxBrace = pattern.indexOf(123);
            int idx = -1;
            if (idxStar >= 0) {
                int n = idx = idx < 0 ? idxStar : Math.min(idx, idxStar);
            }
            if (idxQuestion >= 0) {
                int n = idx = idx < 0 ? idxQuestion : Math.min(idx, idxQuestion);
            }
            if (idxBrace >= 0) {
                int n = idx = idx < 0 ? idxBrace : Math.min(idx, idxBrace);
            }
            if (idx < 0) {
                return Stream.of(context.currentDir().resolve(pattern));
            }
            int sep = pattern.substring(0, idx).lastIndexOf(File.separatorChar);
            if (sep < 0) {
                base = context.currentDir();
                globPart = pattern;
            } else {
                base = context.currentDir().resolve(pattern.substring(0, sep));
                globPart = pattern.substring(sep + 1);
            }
            globPart = globPart.replaceAll("\\*\\*/", "{**/,}");
            PathMatcher matcher = FileSystems.getDefault().getPathMatcher("glob:" + globPart);
            Stream<Path> walkStream = Files.walk(base, new FileVisitOption[0]);
            try {
                List matches = walkStream.filter(p -> !p.equals(base)).filter(p -> {
                    Path relativePath = base.relativize((Path)p);
                    return matcher.matches(relativePath);
                }).collect(Collectors.toList());
                stream = matches.stream();
                if (walkStream == null) break block14;
            }
            catch (Throwable throwable) {
                try {
                    if (walkStream != null) {
                        try {
                            walkStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    return Stream.empty();
                }
            }
            walkStream.close();
        }
        return stream;
    }

    private static void toColumn(Context context, PrintStream out, Stream<String> ansi, boolean horizontal) {
        Terminal terminal = context.terminal();
        int width = context.isTty() ? terminal.getWidth() : 80;
        List strings = ansi.map(AttributedString::fromAnsi).collect(Collectors.toList());
        if (!strings.isEmpty()) {
            int c;
            int max = strings.stream().mapToInt(AttributedCharSequence::columnLength).max().getAsInt();
            for (c = Math.max(1, width / max); c > 1 && c * max + (c - 1) >= width; --c) {
            }
            int columns = c;
            int lines = (strings.size() + columns - 1) / columns;
            IntBinaryOperator index = horizontal ? (i, j) -> i * columns + j : (i, j) -> j * lines + i;
            AttributedStringBuilder sb = new AttributedStringBuilder();
            for (int i2 = 0; i2 < lines; ++i2) {
                for (int j2 = 0; j2 < columns; ++j2) {
                    int idx = index.applyAsInt(i2, j2);
                    if (idx >= strings.size()) continue;
                    AttributedString str = (AttributedString)strings.get(idx);
                    boolean hasRightItem = j2 < columns - 1 && index.applyAsInt(i2, j2 + 1) < strings.size();
                    sb.append(str);
                    if (!hasRightItem) continue;
                    for (int k = 0; k <= max - str.length(); ++k) {
                        sb.append(' ');
                    }
                }
                sb.append('\n');
            }
            out.print(sb.toAnsi(terminal));
        }
    }

    public static Map<String, String> getLsColorMap(String colorString) {
        return PosixCommands.getColorMap(colorString != null ? colorString : DEFAULT_LS_COLORS);
    }

    public static Map<String, String> getColorMap(String colorString) {
        String str;
        String string = str = colorString != null ? colorString : "";
        if (str.isEmpty()) {
            return Collections.emptyMap();
        }
        String sep = COLOR_FORMAT_PATTERN.matcher(str).matches() ? ":" : " ";
        return Arrays.stream(str.split(sep)).collect(Collectors.toMap(s -> s.substring(0, s.indexOf(61)), s -> s.substring(s.indexOf(61) + 1)));
    }

    public static Map<String, String> getLsColorMap(Context session) {
        return PosixCommands.getColorMap(session, "LS", DEFAULT_LS_COLORS);
    }

    public static Map<String, String> getColorMap(Context session, String name, String def) {
        return PosixCommands.getColorMap(session::get, name, def);
    }

    public static Map<String, String> getColorMap(Function<String, Object> variables, String name, String def) {
        String str;
        Object obj = variables.apply(name + "_COLORS");
        String string = str = obj != null ? obj.toString() : null;
        if (str == null) {
            str = def;
        }
        String sep = COLOR_FORMAT_PATTERN.matcher(str).matches() ? ":" : " ";
        return Arrays.stream(str.split(sep)).collect(Collectors.toMap(s -> s.substring(0, s.indexOf(61)), s -> s.substring(s.indexOf(61) + 1)));
    }

    public static String applyStyle(String text, Map<String, String> colors, String ... types) {
        String t = null;
        for (String type : types) {
            if (colors.get(type) == null) continue;
            t = type;
            break;
        }
        return new AttributedString(text, new StyleResolver(colors::get).resolve("." + t)).toAnsi();
    }

    public static void applyStyle(AttributedStringBuilder sb, Map<String, String> colors, String ... types) {
        String t = null;
        for (String type : types) {
            if (colors.get(type) == null) continue;
            t = type;
            break;
        }
        sb.style(new StyleResolver(colors::get).resolve("." + t));
    }

    private static LinkOption[] getLinkOptions(boolean followLinks) {
        if (followLinks) {
            return EMPTY_LINK_OPTIONS;
        }
        return (LinkOption[])NO_FOLLOW_OPTIONS.clone();
    }

    private static boolean isWindowsExecutable(String fileName) {
        if (fileName == null || fileName.length() <= 0) {
            return false;
        }
        for (String suffix : WINDOWS_EXECUTABLE_EXTENSIONS) {
            if (!fileName.endsWith(suffix)) continue;
            return true;
        }
        return false;
    }

    private static Set<PosixFilePermission> getPermissionsFromFile(Path f) {
        HashSet<PosixFilePermission> perms = new HashSet();
        try {
            perms = Files.getPosixFilePermissions(f, new LinkOption[0]);
        }
        catch (IOException | UnsupportedOperationException exception) {
            // empty catch block
        }
        if (OSUtils.IS_WINDOWS && PosixCommands.isWindowsExecutable(f.getFileName().toString())) {
            perms.add(PosixFilePermission.OWNER_EXECUTE);
            perms.add(PosixFilePermission.GROUP_EXECUTE);
            perms.add(PosixFilePermission.OTHERS_EXECUTE);
        }
        return perms;
    }

    protected static Options parseOptions(Context context, String[] usage, Object[] argv) throws Exception {
        Options opt = Options.compile(usage, s -> PosixCommands.get(context, s)).parse(argv, true);
        if (opt.isSet("help")) {
            throw new Options.HelpException(opt.usage());
        }
        return opt;
    }

    protected static String get(Context context, String name) {
        Object o = context.get(name);
        return o != null ? o.toString() : null;
    }

    static {
        HashMap<Character, String> formatMap = new HashMap<Character, String>();
        formatMap.put(Character.valueOf('a'), "EEE");
        formatMap.put(Character.valueOf('A'), "EEEE");
        formatMap.put(Character.valueOf('b'), "MMM");
        formatMap.put(Character.valueOf('B'), "MMMM");
        formatMap.put(Character.valueOf('c'), "EEE MMM d HH:mm:ss yyyy");
        formatMap.put(Character.valueOf('C'), "yy");
        formatMap.put(Character.valueOf('d'), "dd");
        formatMap.put(Character.valueOf('D'), "MM/dd/yy");
        formatMap.put(Character.valueOf('e'), "d");
        formatMap.put(Character.valueOf('F'), "yyyy-MM-dd");
        formatMap.put(Character.valueOf('G'), "YYYY");
        formatMap.put(Character.valueOf('g'), "YY");
        formatMap.put(Character.valueOf('H'), "HH");
        formatMap.put(Character.valueOf('h'), "MMM");
        formatMap.put(Character.valueOf('I'), "hh");
        formatMap.put(Character.valueOf('j'), "DDD");
        formatMap.put(Character.valueOf('k'), "H");
        formatMap.put(Character.valueOf('l'), "h");
        formatMap.put(Character.valueOf('M'), "mm");
        formatMap.put(Character.valueOf('m'), "MM");
        formatMap.put(Character.valueOf('N'), "SSS");
        formatMap.put(Character.valueOf('n'), "\n");
        formatMap.put(Character.valueOf('P'), "a");
        formatMap.put(Character.valueOf('p'), "a");
        formatMap.put(Character.valueOf('r'), "hh:mm:ss a");
        formatMap.put(Character.valueOf('R'), "HH:mm");
        formatMap.put(Character.valueOf('S'), "ss");
        formatMap.put(Character.valueOf('s'), "X");
        formatMap.put(Character.valueOf('T'), "HH:mm:ss");
        formatMap.put(Character.valueOf('t'), "\t");
        formatMap.put(Character.valueOf('U'), "ww");
        formatMap.put(Character.valueOf('u'), "u");
        formatMap.put(Character.valueOf('V'), "ww");
        formatMap.put(Character.valueOf('v'), "d-MMM-yyyy");
        formatMap.put(Character.valueOf('W'), "ww");
        formatMap.put(Character.valueOf('w'), "e");
        formatMap.put(Character.valueOf('X'), "HH:mm:ss");
        formatMap.put(Character.valueOf('x'), "MM/dd/yy");
        formatMap.put(Character.valueOf('Y'), "yyyy");
        formatMap.put(Character.valueOf('y'), "yy");
        formatMap.put(Character.valueOf('Z'), "zzz");
        formatMap.put(Character.valueOf('z'), "Z");
        formatMap.put(Character.valueOf('%'), "%");
        formatMap.put(Character.valueOf('+'), "EEE MMM d HH:mm:ss yyyy");
        UNIX_TO_JAVA_FORMAT_MAP = Collections.unmodifiableMap(formatMap);
        SIZE_UNITS = new String[]{"B", "K", "M", "G", "T", "P"};
        EMPTY_LINK_OPTIONS = new LinkOption[0];
        NO_FOLLOW_OPTIONS = new LinkOption[]{LinkOption.NOFOLLOW_LINKS};
        WINDOWS_EXECUTABLE_EXTENSIONS = List.of(".bat", ".exe", ".cmd");
        COLOR_FORMAT_PATTERN = Pattern.compile("[a-z]{2}=[0-9]*(;[0-9]+)*(:[a-z]{2}=[0-9]*(;[0-9]+)*)*");
    }

    public static class Context {
        private final InputStream in;
        private final PrintStream out;
        private final PrintStream err;
        private final Path currentDir;
        private final Terminal terminal;
        private final Function<String, Object> variables;

        public Context(InputStream in, PrintStream out, PrintStream err, Path currentDir, Terminal terminal, Function<String, Object> variables) {
            this.in = in;
            this.out = out;
            this.err = err;
            this.currentDir = currentDir;
            this.terminal = terminal;
            this.variables = variables;
        }

        public InputStream in() {
            return this.in;
        }

        public PrintStream out() {
            return this.out;
        }

        public PrintStream err() {
            return this.err;
        }

        public Path currentDir() {
            return this.currentDir;
        }

        public Terminal terminal() {
            return this.terminal;
        }

        public boolean isTty() {
            return this.terminal != null;
        }

        public Object get(String name) {
            return this.variables.apply(name);
        }
    }

    public static interface CommandExecutor {
        public String execute(List<String> var1) throws Exception;
    }

    public static class SortComparator
    implements Comparator<String> {
        private static Pattern fpPattern;
        private final boolean caseInsensitive;
        private final boolean reverse;
        private final boolean ignoreBlanks;
        private final boolean numeric;
        private final char separator;
        private final List<Key> sortKeys;

        public SortComparator(boolean caseInsensitive, boolean reverse, boolean ignoreBlanks, boolean numeric, char separator, List<String> sortFields) {
            this.caseInsensitive = caseInsensitive;
            this.reverse = reverse;
            this.separator = separator;
            this.ignoreBlanks = ignoreBlanks;
            this.numeric = numeric;
            if (sortFields == null || sortFields.isEmpty()) {
                sortFields = new ArrayList<String>();
                sortFields.add("1");
            }
            this.sortKeys = sortFields.stream().map(x$0 -> new Key((String)x$0)).collect(Collectors.toList());
        }

        @Override
        public int compare(String o1, String o2) {
            int res = 0;
            List<Integer> fi1 = this.getFieldIndexes(o1);
            List<Integer> fi2 = this.getFieldIndexes(o2);
            for (Key key : this.sortKeys) {
                int[] k1 = this.getSortKey(o1, fi1, key);
                int[] k2 = this.getSortKey(o2, fi2, key);
                if (key.numeric) {
                    Double d1 = this.getDouble(o1, k1[0], k1[1]);
                    Double d2 = this.getDouble(o2, k2[0], k2[1]);
                    res = d1.compareTo(d2);
                } else {
                    res = this.compareRegion(o1, k1[0], k1[1], o2, k2[0], k2[1], key.caseInsensitive);
                }
                if (res == 0) continue;
                if (!key.reverse) break;
                res = -res;
                break;
            }
            return res;
        }

        protected Double getDouble(String s, int start, int end) {
            String field = s.substring(start, end);
            Matcher m = fpPattern.matcher(field);
            if (m.find()) {
                return Double.valueOf(field.substring(m.start(1), m.end(1)));
            }
            return 0.0;
        }

        protected int compareRegion(String s1, int start1, int end1, String s2, int start2, int end2, boolean caseInsensitive) {
            int i1 = start1;
            for (int i2 = start2; i1 < end1 && i2 < end2; ++i1, ++i2) {
                char c2;
                char c1 = s1.charAt(i1);
                if (c1 == (c2 = s2.charAt(i2))) continue;
                if (caseInsensitive) {
                    if ((c1 = Character.toUpperCase(c1)) == (c2 = Character.toUpperCase(c2)) || (c1 = Character.toLowerCase(c1)) == (c2 = Character.toLowerCase(c2))) continue;
                    return c1 - c2;
                }
                return c1 - c2;
            }
            return end1 - end2;
        }

        protected int[] getSortKey(String str, List<Integer> fields, Key key) {
            int end;
            int start;
            if (key.startField * 2 <= fields.size()) {
                if (key.ignoreBlanksStart) {
                    for (start = fields.get((key.startField - 1) * 2).intValue(); start < fields.get((key.startField - 1) * 2 + 1) && Character.isWhitespace(str.charAt(start)); ++start) {
                    }
                }
                if (key.startChar > 0) {
                    start = Math.min(start + key.startChar - 1, fields.get((key.startField - 1) * 2 + 1));
                }
            } else {
                start = 0;
            }
            if (key.endField > 0 && key.endField * 2 <= fields.size()) {
                if (key.ignoreBlanksEnd) {
                    for (end = fields.get((key.endField - 1) * 2).intValue(); end < fields.get((key.endField - 1) * 2 + 1) && Character.isWhitespace(str.charAt(end)); ++end) {
                    }
                }
                if (key.endChar > 0) {
                    end = Math.min(end + key.endChar - 1, fields.get((key.endField - 1) * 2 + 1));
                }
            } else {
                end = str.length();
            }
            return new int[]{start, end};
        }

        protected List<Integer> getFieldIndexes(String o) {
            ArrayList<Integer> fields = new ArrayList<Integer>();
            if (!o.isEmpty()) {
                if (this.separator == '\u0000') {
                    fields.add(0);
                    for (int idx = 1; idx < o.length(); ++idx) {
                        if (!Character.isWhitespace(o.charAt(idx)) || Character.isWhitespace(o.charAt(idx - 1))) continue;
                        fields.add(idx - 1);
                        fields.add(idx);
                    }
                    fields.add(o.length() - 1);
                } else {
                    int last = -1;
                    int idx = o.indexOf(this.separator);
                    while (idx >= 0) {
                        if (last >= 0) {
                            fields.add(last);
                            fields.add(idx - 1);
                        } else if (idx > 0) {
                            fields.add(0);
                            fields.add(idx - 1);
                        }
                        last = idx + 1;
                        idx = o.indexOf(this.separator, idx + 1);
                    }
                    if (last < o.length()) {
                        fields.add(Math.max(last, 0));
                        fields.add(o.length() - 1);
                    }
                }
            }
            return fields;
        }

        static {
            String Digits = "(\\p{Digit}+)";
            String HexDigits = "(\\p{XDigit}+)";
            String Exp = "[eE][+-]?(\\p{Digit}+)";
            String fpRegex = "([\\x00-\\x20]*[+-]?(NaN|Infinity|((((\\p{Digit}+)(\\.)?((\\p{Digit}+)?)([eE][+-]?(\\p{Digit}+))?)|(\\.((\\p{Digit}+))([eE][+-]?(\\p{Digit}+))?)|(((0[xX](\\p{XDigit}+)(\\.)?)|(0[xX](\\p{XDigit}+)?(\\.)(\\p{XDigit}+)))[pP][+-]?(\\p{Digit}+)))[fFdD]?))[\\x00-\\x20]*)(.*)";
            fpPattern = Pattern.compile("([\\x00-\\x20]*[+-]?(NaN|Infinity|((((\\p{Digit}+)(\\.)?((\\p{Digit}+)?)([eE][+-]?(\\p{Digit}+))?)|(\\.((\\p{Digit}+))([eE][+-]?(\\p{Digit}+))?)|(((0[xX](\\p{XDigit}+)(\\.)?)|(0[xX](\\p{XDigit}+)?(\\.)(\\p{XDigit}+)))[pP][+-]?(\\p{Digit}+)))[fFdD]?))[\\x00-\\x20]*)(.*)");
        }

        public class Key {
            int startField;
            int startChar;
            int endField;
            int endChar;
            boolean ignoreBlanksStart;
            boolean ignoreBlanksEnd;
            boolean caseInsensitive;
            boolean reverse;
            boolean numeric;

            public Key(String str) {
                boolean modifiers = false;
                boolean startPart = true;
                boolean inField = true;
                boolean inChar = false;
                block9: for (char c : str.toCharArray()) {
                    switch (c) {
                        case '0': 
                        case '1': 
                        case '2': 
                        case '3': 
                        case '4': 
                        case '5': 
                        case '6': 
                        case '7': 
                        case '8': 
                        case '9': {
                            if (!inField && !inChar) {
                                throw new IllegalArgumentException("Bad field syntax: " + str);
                            }
                            if (startPart) {
                                if (inChar) {
                                    this.startChar = this.startChar * 10 + (c - 48);
                                    continue block9;
                                }
                                this.startField = this.startField * 10 + (c - 48);
                                continue block9;
                            }
                            if (inChar) {
                                this.endChar = this.endChar * 10 + (c - 48);
                                continue block9;
                            }
                            this.endField = this.endField * 10 + (c - 48);
                            continue block9;
                        }
                        case '.': {
                            if (!inField) {
                                throw new IllegalArgumentException("Bad field syntax: " + str);
                            }
                            inField = false;
                            inChar = true;
                            continue block9;
                        }
                        case 'n': {
                            inField = false;
                            inChar = false;
                            modifiers = true;
                            this.numeric = true;
                            continue block9;
                        }
                        case 'f': {
                            inField = false;
                            inChar = false;
                            modifiers = true;
                            this.caseInsensitive = true;
                            continue block9;
                        }
                        case 'r': {
                            inField = false;
                            inChar = false;
                            modifiers = true;
                            this.reverse = true;
                            continue block9;
                        }
                        case 'b': {
                            inField = false;
                            inChar = false;
                            modifiers = true;
                            if (startPart) {
                                this.ignoreBlanksStart = true;
                                continue block9;
                            }
                            this.ignoreBlanksEnd = true;
                            continue block9;
                        }
                        case ',': {
                            inField = true;
                            inChar = false;
                            startPart = false;
                            continue block9;
                        }
                        default: {
                            throw new IllegalArgumentException("Bad field syntax: " + str);
                        }
                    }
                }
                if (!modifiers) {
                    this.ignoreBlanksStart = this.ignoreBlanksEnd = SortComparator.this.ignoreBlanks;
                    this.reverse = SortComparator.this.reverse;
                    this.caseInsensitive = SortComparator.this.caseInsensitive;
                    this.numeric = SortComparator.this.numeric;
                }
                if (this.startField < 1) {
                    throw new IllegalArgumentException("Bad field syntax: " + str);
                }
            }
        }
    }
}

