Rem
Rem $Header: dbgendev/src/langdata/backend/sql/create_triggers.sql 
Rem saloshah_dbai_311/1 2024/11/13 10:28:27 saloshah Exp $
Rem
Rem create_triggers.sql
Rem
Rem Copyright (c) 2024, 2025, Oracle and/or its affiliates.
Rem
Rem    NAME
Rem      create_triggers.sql - Triggers for automatic version increment
Rem                            and trigger on annotation changes
Rem
Rem    DESCRIPTION
Rem      This script defines triggers langdata$trg_auto_increment_version_report
Rem      and langdata$trg_auto_increment_version_drilldown that automatically
Rem      increment the version number for records in the
Rem      langdata$reportdescriptions and langdata$drilldowndescriptions tables
Rem      when new entries are inserted. langdata$trigger_on_alter_user_tables
Rem      is a trigger used to trigger all the changes required when an
Rem 	 annotation gets updated.
Rem
Rem    NOTES
Rem      None
Rem
Rem    BEGIN SQL_FILE_METADATA
Rem    SQL_SOURCE_FILE: dbgendev/src/langdata/backend/sql/create_triggers.sql
Rem    SQL_SHIPPED_FILE:
Rem    SQL_PHASE:
Rem    SQL_STARTUP_MODE: NORMAL
Rem    SQL_IGNORABLE_ERRORS: NONE
Rem    END SQL_FILE_METADATA
Rem
Rem    MODIFIED   (MM/DD/YY)
Rem    ruohli      07/24/25 - DBAI-1076: Added trigger
Rem                           trg_langdata_domains_updated
Rem    jiangnhu    07/07/25 - DBAI-871: Add trigger
Rem                           langdata$trg_auto_increment_version_samplequery
Rem    saloshah    06/18/25 - DBAI-860-862: Added triggers to update updated_at 
Rem                           column
Rem    jiangnhu    06/03/25 - Replace langdata$trigger_on_alter_user_tables with
Rem                           polling
Rem    jiangnhu    04/09/25 - DBAI-731: Remove
Rem                           langdata$trg_prevent_user_index_drop
Rem    deveverm    03/11/25 - DBAI-546: added schema_name for cross_schema
Rem                           support
Rem    jiangnhu    03/07/25 - Fix langdata$trg_prevent_user_index_drop
Rem    jiangnhu    02/25/25 - Update user_objects to all_objects
Rem    jiangnhu    02/13/25 - DBAI-555: Add
Rem                           langdata$trg_prevent_user_index_drop; Fix
Rem                           langdata$trigger_on_alter_user_tables: use regex
Rem                           to catch column name
Rem    jiangnhu    02/06/25 - Update trigger 
Rem                           langdata$trigger_on_alter_user_tables
Rem    jiangnhu    12/12/24 - DBAI-463: Add langdata$ prefix for triggers
Rem    saloshah    11/28/24 - DBAI-311: Added triggers for annotations
Rem    deveverm    10/24/24 - removed autonomous transaction
Rem    jiangnhu    10/18/24 - Fix text wrapping
Rem    jiangnhu    10/17/24 - Modify header
Rem    pryarla     10/16/24 - Created
Rem

CREATE OR REPLACE TRIGGER langdata$trg_auto_increment_version_report
BEFORE INSERT ON langdata$reportdescriptions
FOR EACH ROW
DECLARE
    max_version NUMBER;
BEGIN
    SELECT COALESCE(MAX(version), 0)
    INTO max_version
    FROM langdata$reportdescriptions
    WHERE report_id = :new.report_id;

    :new.version := max_version + 1;
END;
/

CREATE OR REPLACE TRIGGER langdata$trg_auto_increment_version_drilldown
BEFORE INSERT ON langdata$drilldowndescriptions
FOR EACH ROW
DECLARE
    max_version NUMBER;
BEGIN
    SELECT COALESCE(MAX(version), 0)
    INTO max_version
    FROM langdata$drilldowndescriptions
    WHERE drilldown_id = :new.drilldown_id;

    :new.version := max_version + 1;
END;
/

CREATE OR REPLACE TRIGGER langdata$trg_auto_increment_version_samplequery
BEFORE INSERT ON langdata$samplequeries
FOR EACH ROW
DECLARE
    max_version NUMBER;
BEGIN
    SELECT COALESCE(MAX(version), 0)
    INTO max_version
    FROM langdata$samplequeries
    WHERE report_id = :new.report_id;

    :new.version := max_version + 1;
END;
/

CREATE OR REPLACE TRIGGER langdata$trg_reports_updated
  BEFORE INSERT OR UPDATE ON langdata$reports
  FOR EACH ROW
BEGIN
  :NEW.updated_at := CURRENT_TIMESTAMP;
END;
/

CREATE OR REPLACE TRIGGER langdata$trg_report_descriptions_updated
  BEFORE INSERT OR UPDATE ON langdata$reportdescriptions
  FOR EACH ROW
BEGIN
  :NEW.updated_at := CURRENT_TIMESTAMP;
END;
/

CREATE OR REPLACE TRIGGER langdata$trg_drilldowns_updated
  BEFORE INSERT OR UPDATE ON langdata$drilldowndocuments
  FOR EACH ROW
BEGIN
  :NEW.updated_at := CURRENT_TIMESTAMP;
END;
/

CREATE OR REPLACE TRIGGER langdata$trg_drilldown_descriptions_updated
  BEFORE INSERT OR UPDATE ON langdata$drilldowndescriptions
  FOR EACH ROW
BEGIN
  :NEW.updated_at := CURRENT_TIMESTAMP;
END;
/

CREATE OR REPLACE TRIGGER langdata$trg_sample_queries_updated
  BEFORE INSERT OR UPDATE ON langdata$samplequeries
  FOR EACH ROW
BEGIN
  :NEW.updated_at := CURRENT_TIMESTAMP;
END;
/

CREATE OR REPLACE TRIGGER langdata$trg_searchrecords_updated
  BEFORE INSERT OR UPDATE ON langdata$searchrecords
  FOR EACH ROW
BEGIN
  :NEW.updated_at := CURRENT_TIMESTAMP;
END;
/

CREATE OR REPLACE TRIGGER langdata$trg_domains_updated
  BEFORE INSERT OR UPDATE ON langdata$domains
  FOR EACH ROW
BEGIN
  :NEW.updated_at := CURRENT_TIMESTAMP;
END;
/
