Rem
Rem $Header: dbgendev/src/langdata/plsql/logging/logging_pkg.pks /main/3 2025/06/03 08:18:13 lachoud Exp $
Rem
Rem logging_pkg.pls
Rem
Rem Copyright (c) 2024, 2025, Oracle and/or its affiliates.
Rem
Rem    NAME
Rem      logging_pkg.pls - <one-line expansion of the name>
Rem
Rem    DESCRIPTION
Rem      <short description of component this file declares/defines>
Rem
Rem    NOTES
Rem      <other useful comments, qualifications, etc.>
Rem
Rem    BEGIN SQL_FILE_METADATA
Rem    SQL_SOURCE_FILE: dbgendev/src/langdata/plsql/logging/logging_pkg.pks
Rem    SQL_SHIPPED_FILE:
Rem    SQL_PHASE:
Rem    SQL_STARTUP_MODE: NORMAL
Rem    SQL_IGNORABLE_ERRORS: NONE
Rem    END SQL_FILE_METADATA
Rem
Rem    MODIFIED   (MM/DD/YY)
Rem    pryarla     10/16/24 - Created
Rem

CREATE OR REPLACE PACKAGE lang_data_logger_pkg IS

    -- Log level configuration variable name
    C_LOG_LEVEL CONSTANT VARCHAR2(20) := 'LANG_DATA_LOG_LEVEL';

    /*
    FUNCTION get_log_level
    ----------------------------------------------------------------------
    Description:
        Retrieves the current log level from the configuration table.
        If the log level is not set, it defaults to 5 (C_LOG_LEVEL_ERROR).

    Parameters:
        None

    Returns:
        The current log level as a PLS_INTEGER.
    */
    FUNCTION get_log_level RETURN PLS_INTEGER;

    -- Log level constants
    C_LOG_LEVEL_DEBUG CONSTANT PLS_INTEGER := 1;
    C_LOG_LEVEL_TRACE CONSTANT PLS_INTEGER := 2;
    C_LOG_LEVEL_INFO  CONSTANT PLS_INTEGER := 3;
    C_LOG_LEVEL_WARN  CONSTANT PLS_INTEGER := 4;
    C_LOG_LEVEL_ERROR CONSTANT PLS_INTEGER := 5; -- Default
    C_LOG_LEVEL_FATAL CONSTANT PLS_INTEGER := 6;

    /*
    PROCEDURE refresh_log_level
    ----------------------------------------------------------------------
    Description:
        Resets the cached log level by setting the global variable 
        `g_log_level` to NULL. This forces the system to re-fetch the log 
        level from the configuration table on next access via get_log_level.

    Parameters:
        None

    Returns:
        None
    */
    PROCEDURE refresh_log_level;

    -- Logging procedures by severity
    PROCEDURE log_debug(p_message VARCHAR2);
    PROCEDURE log_info(p_message VARCHAR2);
    PROCEDURE log_warn(p_message VARCHAR2);
    PROCEDURE log_error(p_message VARCHAR2);
    PROCEDURE log_fatal(p_message VARCHAR2);
	PROCEDURE log_trace(p_message VARCHAR2);

	/*
	FUNCTION parse_call_stack
	----------------------------------------------------------------------
	Description:
		Parses the call stack to extract the calling method name.

	Parameters:
		None

	Returns:
		The name of the calling method as a VARCHAR2.
	*/
	FUNCTION parse_call_stack RETURN VARCHAR2;

END lang_data_logger_pkg;
/
--adding this alias to make calling logging signature api shorter to avoid
--using the full package name and to have backward compatibility with existing
--code that uses the old package name. So now ld_logger.debug and 
--lang_data_logger_pkg.debug are equivalent.
CREATE OR REPLACE PACKAGE ld_logger IS
		PROCEDURE trace(p_message VARCHAR2);
		PROCEDURE debug(p_message VARCHAR2);
		PROCEDURE info(p_message VARCHAR2);
		PROCEDURE warn(p_message VARCHAR2);
		PROCEDURE error(p_message VARCHAR2);
		PROCEDURE fatal(p_message VARCHAR2);
END ld_logger;
/
