Rem
Rem $Header: dbgendev/src/langdata/plsql/drilldowns/drilldowns_pkg.pks /main/17 2025/08/06 08:08:53 saloshah Exp $
Rem
Rem drilldowns_pkg.pls
Rem
Rem Copyright (c) 2024, 2025, Oracle and/or its affiliates.
Rem
Rem    NAME
Rem      drilldowns_pkg.pks - Package Specification of drilldowns_pkg
Rem
Rem    DESCRIPTION
Rem       This package contains specifications of functions/procedures for 
Rem       managing drilldown documents and their descriptions.
Rem
Rem    NOTES
Rem      NONE
Rem
Rem    BEGIN SQL_FILE_METADATA
Rem    SQL_SOURCE_FILE: dbgendev/src/langdata/plsql/drilldowns/drilldowns_pkg.pks
Rem    SQL_SHIPPED_FILE:
Rem    SQL_PHASE:
Rem    SQL_STARTUP_MODE: NORMAL
Rem    SQL_IGNORABLE_ERRORS: NONE
Rem    END SQL_FILE_METADATA
Rem
Rem    MODIFIED   (MM/DD/YY)
Rem    saloshah    07/30/25 - DBAI-1100: Added exceptions for non existent id
Rem                           for update_drilldown_description
Rem    dadoshi     07/24/25 - JIRA_DBAI1080: Add
Rem                           get_drilldown_match_document_by_id
Rem    dadoshi     07/22/25 - JIRA_DBAI1080: Added get_drilldown_status_by_id
Rem    jiangnhu    06/09/25 - DBAI-871: Implement APIs to get ID by unique
Rem                           combination of title, version, etc.
Rem    deveverm    05/16/25 - DBAI-761: changed
Rem                           get_drilldown_description_regression to
Rem                           get_drilldown_regression, changed
Rem                           calculate_drilldown_description_regression to
Rem                           calculate_drilldown_regression
Rem    deveverm    04/01/25 - DBAI-523: added
Rem                           get_drilldown_description_regression and modified
Rem                           regression logic
Rem    jiangnhu    03/26/25 - DBAI-692: make report_id, description_id OUT
Rem                           parameter, make enumeration limit a config
Rem    jiangnhu    03/19/25 - DBAI-543: Better naming conventions for
Rem                           augmentation/amending
Rem    jiangnhu    03/15/25 - DBAI-661: Implement
Rem                           replace_drilldown_filter_enumerable_set
Rem    arevathi    03/11/25 - Add Update status API's
Rem    jiangnhu    02/14/25 - DBAI-575: Remove c_unknown_exception_code
Rem    jiangnhu    02/07/25 - Remove update_expected_drilldown_id: duplicate
Rem                           with lang_data_feedback_pkg
Rem    dadoshi     01/22/25 - JIRA_DBAI-507: update create_drilldown to have
Rem                           id, and, description_id as optional args
Rem    dadoshi     11/07/24 - Fix get_drilldown_description()
Rem    dadoshi     11/07/24 - Add get_drilldown()
Rem    dadoshi     11/04/24 - Update execute_drilldown_sql to handle large
Rem                           number of rows
Rem    arevathi    10/30/24 - Added drilldown description change regression
Rem                           count
Rem    dadoshi     10/29/24 - Add get_drilldown_descriptions()
Rem    dadoshi     10/29/24 - Format drilldowns_pkg
Rem    dadoshi     10/29/24 - Add documentation
Rem    dadoshi     10/25/24 - Implement drilldowns-specific functionality
Rem    dadoshi     10/25/24 - Created
Rem

create or replace package lang_data_drilldowns_pkg is
    /*
    ----------------------------------------------------------------------------
    Package Name: lang_data_drilldowns_pkg
    Description: This package contains procedures related to the drilldown
	and drilldown descriptions. These procedures are designed to handle 
    CRUD and validation operations on drilldown documents and their 
    descriptions.
    ----------------------------------------------------------------------------
    Author: Daksh Doshi
    Created: 10/08/2024
    ----------------------------------------------------------------------------
    Public Procedures:
    ----------------------------------------------------------------------------
    Procedure get_drilldown_descriptions_paginated
    ----------------------------------------------------------------------------
    Description:
        Retrieves paginated drilldown descriptions for a specific report 
        from the langdata$drilldowndescriptions table. It enables 
        controlled data retrieval using pagination via a serialized cursor.
        
        The descriptions include fields such as ID, description text, 
        version, status, and enhanced text.
    ----------------------------------------------------------------------------
    Parameters:
    - p_id (IN VARCHAR2):
        The unique identifier of the report for which the descriptions 
        are being retrieved.

    - p_limit (IN NUMBER DEFAULT 10):
        Specifies the maximum number of description rows to fetch in one 
        call. The default value is set to 10 if not provided.

    - p_cursor (IN OUT VARCHAR2):
        An optional serialized pagination cursor, represented in the 
        format `created_at|id`. On the first page, this value is NULL. 
        The procedure will return the next cursor value for subsequent 
        pages of data.

    - p_descriptions (OUT SYS_REFCURSOR):
        A cursor that returns the result set of report descriptions, 
        including fields such as ID, description text, version, status, 
        and enhanced text.
    ----------------------------------------------------------------------------
    Exceptions:
    - c_unauthorized_code (-20002):
        Raised when the user does not have the required role 
        (LANG_DATA_APP_EXPERT) to access the procedure. This triggers a 
        custom error with code -20002 using the lang_data_errors_pkg package.
    ----------------------------------------------------------------------------
    Procedure: get_drilldown_paginated
    ----------------------------------------------------------------------------
    Description:
        Retrieves detailed information about a specific drilldown and its
        related data, including descriptions and sample queries, with 
        pagination support. The procedure fetches the drilldown document's
        data from the langdata$drilldowndocuments table and paginated 
        descriptions and sample queries using separate procedures. It 
        ensures that only authorized users can access this data.
    ----------------------------------------------------------------------------
    Parameters:
    - p_id (IN VARCHAR2):
        The unique identifier of the drilldown document whose details are
        being fetched.

    - p_report_id (OUT VARCHAR2):
        The ID of the report linked to the drilldown.

    - p_title (OUT VARCHAR2):
        The title of the drilldown document.

    - p_match_document (OUT JSON):
        The match document of the drilldown document stored as a JSON object.

    - p_status (OUT VARCHAR2):
        The status of the drilldown report.

    - p_descriptions (OUT SYS_REFCURSOR):
        A cursor to return the result set of descriptions related to the 
        drilldown document, fetched using the paginated query.

    - p_descriptions_cur (IN OUT VARCHAR2):
        The serialized pagination cursor for fetching descriptions in 
        subsequent calls. It follows the format `created_at|id`.

    - p_descriptions_limit (IN NUMBER DEFAULT 10):
        Specifies the maximum number of description rows to fetch per call. 
        The default value is 10.

    - p_sample_queries (OUT SYS_REFCURSOR):
        A cursor to return the result set of sample queries related to the 
        drilldown document.

    - p_sample_query_cur (IN OUT VARCHAR2):
        The serialized pagination cursor for fetching sample queries in 
        subsequent calls. It follows the format `created_at|id`.

    - p_sample_query_limit (IN NUMBER DEFAULT 10):
        Specifies the maximum number of sample query rows to fetch per call. 
        The default value is 10.
    ----------------------------------------------------------------------------
    Exceptions:
    - c_unauthorized_code (-20002):
        Raised when the user does not have the required role 
        (LANG_DATA_APP_EXPERT) to access the procedure. This triggers a 
        custom error with code -20002 using the lang_data_errors_pkg package.

    - c_resource_not_found (-20004):
        Raised when no drilldown is found for the provided ID.

    ----------------------------------------------------------------------------
    Procedure: get_all_drilldowns
    ----------------------------------------------------------------------------
    Description:
        Retrieves paginated drilldowns from the langdata$drilldowndocuments 
        table and descriptions from langdata$drilldowndescriptions table. 
        It allows filtering using the report_id and status of the drilldowns.
        It enables controlled data retrieval using pagination via a serialized
        cursor.
    ----------------------------------------------------------------------------
    Parameters:
        - p_report_id (IN VARCHAR2 DEFAULT NULL)
            The report_id for filtering out based on report_id set to NULL
            for fetching all the drilldowns Default is NULL.

        - p_status (IN VARCHAR2 DEFAULT NULL):
            The status for filtering out  based on status, set to NULL 
            for fetching all the drilldowns. Default is NULL.
        
        - p_cursor (IN OUT VARCHAR2):
            An optional serialized pagination cursor, represented in the 
            format `created_at|id`. On the first page, this value is NULL. 
            The procedure will return the next cursor value for subsequent 
            pages of data.
        
        - p_limit (IN NUMBER):
            Specifies the maximum number of description rows to fetch in one 
            call. The default value is set to 10 if not provided. Set to NULL
            for fetching all drilldowns without pagination.
        
        - p_drilldowns (OUT SYS_REFCURSOR):
            A cursor that returns the result set of drilldowns.
            
            The drilldowns contains the following fields:
            - id                VARCHAR2 
            - title             VARCHAR2 
            - match_document    JSON        
            - status            VARCHAR2
            - report_id         VARCHAR2
            - domain_id         VARCHAR2
            - description       VARCHAR2
        
            Note: description is the latest descriptions of the drilldown with 
            Published status.
            
    Exceptions:
        - c_unauthorized_code (-20000):
            Raised when the user does not have the required role 
            (LANG_DATA_APP_EXPERT) to access the procedure. This triggers a 
            custom error with code -20002 using the lang_data_errors_pkg 
            package.
        
        - c_invalid_parameters_code (-20002):
            Raised when the drilldown or description parameters are invalid. 
            Logged as an error before raising.
    
    ----------------------------------------------------------------------------
    Procedure: delete_drilldown
    ----------------------------------------------------------------------------
    Description:
        Deletes a drilldown document from the `langdata$drilldowndocuments`
        table based on the provided drilldown ID. The procedure checks if
        the user is authorized to perform the deletion before executing 
        the SQL delete operation. It also handles specific errors, 
        including when the resource is not found or the user is 
        unauthorized, and logs the relevant information.
    ----------------------------------------------------------------------------
    Parameters:
    - p_drilldown_id (IN VARCHAR2):
        The unique identifier of the drilldown document to be deleted.
    ----------------------------------------------------------------------------
    Exceptions:

    - c_unauthorized_code (-20003):
        Custom error code for when the user is unauthorized to delete the
        drilldown document.
    
    - c_resource_not_found (-20004):
        Custom error code for when the specified drilldown document
        is not found.
    ----------------------------------------------------------------------------
    Procedure: delete_drilldown_description
    ----------------------------------------------------------------------------
    Description:
        Deletes a drilldown description from the `langdata$drilldowndescriptions`
        table based on the provided description ID. The procedure first
        checks if the user is authorized to perform the deletion. It then
        verifies whether there is at least one description associated with
        the specified drilldown ID. If there is only one description, an 
        error is raised. If the deletion is performed, it checks whether 
        the deletion was successful and handles any relevant errors, logging
        necessary information along the way.
    ----------------------------------------------------------------------------
    Parameters:
    - p_description_id (IN VARCHAR2):
        The unique identifier of the drilldown description to be deleted.
    ----------------------------------------------------------------------------
    Exceptions:
    - c_description_invalid_deletion:
        Custom error raised when attempting to delete a drilldown 
        description while it is the only one associated with its drilldown.

    - c_resource_not_found (-20004):
        Custom error code for when the specified drilldown description is 
        not found after attempting to delete it.

    - c_unauthorized_code (-20003):
        Custom error code for when the user is unauthorized to delete the
        drilldown description.
    ----------------------------------------------------------------------------
    PROCEDURE update_drilldown_description
    ----------------------------------------------------------------------------
    Description:
        This procedure updates an existing drilldown description in the user 
        database. It verifies the provided description ID, validates the length
        and uniqueness of the new description, and generates a vector embedding
        for the updated description text. The procedure also checks for 
        necessary permissions and ensures that only drilldowns with a 
        "Pending Review" status are updated.
    ----------------------------------------------------------------------------
    Parameters:
        - p_drilldown_description_id (IN VARCHAR2):
            The unique identifier for the drilldown description to be updated.

        - p_new_description (IN VARCHAR2):
            The new text for the drilldown description. Its length must not 
            exceed 2000 characters, and the MD5 hash of the text is used to 
            ensure uniqueness.

    ----------------------------------------------------------------------------
    Exceptions:
        - c_unauthorized_code (-20002):
            Raised when the user does not have the required role 
            (LANG_DATA_APP_EXPERT) to access the procedure. This triggers a 
            custom error with code -20002 using the `lang_data_errors_pkg` 
            package.

        - c_invalid_parameters_code (-20003):
            Raised in the following cases:
              * The length of `p_new_description` exceeds 2000 characters.
              * No drilldown description exists with the provided ID.
              * The drilldown status is not 'Pending Review'.
              * The MD5 hash of `p_new_description` matches an existing 
                description, indicating a duplicate entry. Each scenario is 
                logged as an error before raising this exception.

        - c_resource_not_found (-20004):
            Raised when no description with the given description id is found.
    ----------------------------------------------------------------------------
    PROCEDURE create_drilldown
    ----------------------------------------------------------------------------
    Description:
        This procedure creates a new drilldown document and its 
        corresponding description . It also allows adding sample queries
        associated with the drilldown document and generates value vectors
        for match document enumeration.
    ----------------------------------------------------------------------------
    Parameters:
        - p_title (IN VARCHAR2):
            The title of the drilldown document. The length of the title
            is validated to ensure it does not exceed 255 characters.

        - p_report_id (IN VARCHAR2):
            The unique identifier for the report in which the drilldown
            document is to be created.
        
        - p_match_document (IN JSON):
            A JSON document that contains the SQL queries and filters 
            associated with the drilldown document. The structure of the
            match document is validated to ensure correctness.
        
        - p_description_text (IN VARCHAR2):
            The text of the drilldown document description.
        
        - p_description_status (IN VARCHAR2):
            The status of the drilldown document description. It can have
            one of the following values: 
            'Pending Review', 'Approved', 'Rejected', 'Published', 
            'Inactive', or 'Archived'.
        
        - p_drilldown_status (IN VARCHAR2):
            The status of the drilldown document to be created. 
            It can have one of the following values: 
            'Pending Review', 'Approved', 'Rejected', 'Published', 
            'Inactive', or 'Archived'
        
        - p_sample_queries (IN SYS.ODCIVARCHAR2LIST):
            A list of sample queries associated with the drilldown.
        
        - p_domain (IN VARCHAR2 DEFAULT NULL):
            The domain name that needs to be linked with the drillown. If this
            is not provided, we inherit the domain from the parent report.

        
        - p_drilldown_id (OUT VARCHAR2):
            The unique identifier for the drilldown document to be created.
        
        - p_description_id (OUT VARCHAR2):
            The unique identifier for the drilldown description.
    ----------------------------------------------------------------------------
    Exceptions:
        - c_unauthorized_code (-20002):
            Raised when the user does not have the required role 
            (LANG_DATA_APP_EXPERT) to access the procedure. This triggers a 
            custom error with code -20002 using the lang_data_errors_pkg package.

        - c_invalid_parameters_code (-20003):
            Raised when the drilldown or description parameters are invalid. 
            Logged as an error before raising.
        
        - c_invalid_match_document (-20005):
            Raised when the match document's structure is invalid. 
            This is validated using the `validate_match_document` function.
        
        - c_resource_already_exists (-20006):
            Raised when a description with the same MD5 hash already exists 
            in the `langdata$drilldowndescriptions` table. This prevents 
            duplicate entries for the same description.
    ----------------------------------------------------------------------------
    PROCEDURE add_drilldown_description
    ----------------------------------------------------------------------------
    Description:
        This procedure adds a new description to an existing drilldown document.
        It includes creating an MD5 hash to ensure description uniqueness, 
        generating an enhanced description by augmentation and including any
        relevant filter descriptions from the match document, and embedding the 
        enhanced description as a vector for further analysis.
    ----------------------------------------------------------------------------
    Parameters:
        - p_drilldown_id (IN VARCHAR2):
            The unique identifier for the drilldown document to which the 
            description will be added.
        
        - p_text (IN VARCHAR2):
            The text content of the description. This is validated to ensure 
            that the length does not exceed 2000 characters.
        
        - p_status (IN VARCHAR2):
            The status of the description being added. Allowed values include: 
            'Pending Review', 'Approved', 'Rejected', 'Published', 'Inactive', 
            or 'Archived'.

        - p_description_id (OUT VARCHAR2):
            ID for the description to be created.
    ----------------------------------------------------------------------------
    Exceptions:
        - c_unauthorized_code (-20002):
            Raised when the user does not have the required role 
            (LANG_DATA_APP_EXPERT) to access the procedure. This triggers a 
            custom error with code -20002 using the lang_data_errors_pkg 
            package.

        - c_invalid_parameters_code (-20003):
            Raised when the description parameters are invalid, such as 
            when the description text exceeds the character limit or if 
            the MD5 hash of the description already exists in the table. 
            Logged as an error before raising.
        
        - c_resource_already_exists (-20006):
            Raised when a description with the same MD5 hash already exists 
            in the `langdata$drilldowndescriptions` table, preventing duplicate 
            entries for the same description.
    ----------------------------------------------------------------------------
    Procedure: execute_drilldown_sql
    ----------------------------------------------------------------------------
    Description:
        Executes a dynamic SQL query for a drilldown based on the provided 
        drilldown ID and filter values. The procedure retrieves the SQL 
        statement associated with the drilldown ID from the 
        `langdata$drilldowndocuments` table and binds filter values 
        extracted from a JSON object. It describes the result set to 
        determine the column names and fetches the result rows, storing 
        the column names in the output parameter `p_columns` and the row data 
        in the output parameter `p_data`. The procedure also handles exceptions 
        related to missing drilldown IDs and logs relevant information 
        throughout its execution.
    ----------------------------------------------------------------------------
    Parameters:
    - p_drilldown_id (IN VARCHAR2):
        The unique identifier for the drilldown for which the SQL 
        query is to be executed.

    - p_filter_values (IN JSON):
        A JSON object containing key-value pairs used to filter 
        the results of the SQL query.

    - p_columns (OUT SYS.ODCIVARCHAR2LIST):
        An output parameter that returns a list of column names 
        from the executed SQL query.

    - p_data (OUT CLOB):
        An output parameter that returns a LOB of concatenated 
        row data from the executed SQL query, with each row represented 
        as a JSON object of the format: {"columnName": "value", ...}
    ----------------------------------------------------------------------------
    Exceptions:
    - NO_DATA_FOUND:
        Raised when no drilldown is found for the specified 
        drilldown ID. This triggers logging an error message and 
        raises a custom error for resource not found.

    - OTHERS:
        A catch-all exception handler for any unknown issues 
        encountered during execution. This logs a fatal message 
        and raises a custom error with code -20001 for unknown 
        exceptions, ensuring that all errors are captured and handled.
    ----------------------------------------------------------------------------
    PROCEDURE update_expected_drilldown_id
    ----------------------------------------------------------------------------
    Description:
        This procedure updates the `expected_drilldown_id` for a specific search 
        record in the `langdata$searchrecords` table. It first checks if the new 
        `expected_drilldown_id` is the same as the existing one, raising an 
        error if they are identical to avoid unnecessary updates. If the record
        is not found or any other error occurs, appropriate error handling is
        triggered.
    ----------------------------------------------------------------------------
    Parameters:
        - p_search_id (IN VARCHAR2):
            The unique identifier of the search record that is to be updated.

        - p_expected_drilldown_id (IN VARCHAR2):
            The new `expected_drilldown_id` that will replace the existing value 
            in the search record.
    ----------------------------------------------------------------------------
    Exceptions:
        - c_resource_not_found (-20004):
            Raised when the specified `search_id` does not exist in the 
            `langdata$searchrecords` table. This triggers a custom error with 
            code -20004, and an error message is logged indicating that no 
            matching search record was found.

        - c_invalid_update (-20005):
            Raised if the existing `expected_drilldown_id` matches the new 
            `expected_drilldown_id`, indicating an attempt to update with the 
            same value. This prevents unnecessary operations and is logged as an
            error.
    ----------------------------------------------------------------------------
    PROCEDURE get_drilldown_description
    ----------------------------------------------------------------------------
    Description:
        This procedure retrieves detailed information about a drilldown 
        description from the `langdata$drilldowndescriptions` table based on a 
        given description ID. If the provided ID is invalid or not found, 
        appropriate error handling is triggered. The result is returned in a 
        cursor, `p_description`, containing fields such as `id`, `text`, 
        `version`, `status`, `drilldown_id`, and `enhanced_text`.
    ----------------------------------------------------------------------------
    Parameters:
        - p_description_id (IN VARCHAR2):
            The unique identifier of the drilldown description to be retrieved. 
            If NULL, an error is raised as it is required for the query.

        - p_description (OUT SYS_REFCURSOR):
            A reference cursor used to return the result set of the query 
            containing details of the drilldown description such as `id`, 
            `text`, `version`, `status`, `drilldown_id`, and `enhanced_text`.
    ----------------------------------------------------------------------------
    Exceptions:
        - c_invalid_parameters_code (-20002):
            Raised if `p_description_id` is NULL. This error code -20002 
            indicates invalid input parameters, and an error message is logged.

        - c_resource_not_found (-20004):
            Raised if no matching record is found for the given 
            `p_description_id` in the `langdata$drilldowndescriptions` table. 
            A custom error code -20004 is logged to indicate the resource was 
            not found.
    ----------------------------------------------------------------------------
    Procedure: get_drilldown_descriptions
    ----------------------------------------------------------------------------
    Description:
        Retrieves detailed descriptions for a specific drilldown documents
        identified by its ID. This procedure opens a cursor that provides access
        to the description data stored in the langdata$drilldowndescriptions
        table. The results are ordered by the creation date in descending order.
    ----------------------------------------------------------------------------
    Parameters:
    - p_drilldown_id (IN VARCHAR2):
        The unique identifier of the drilldown whose descriptions are
        being retrieved.

    - p_descriptions (OUT SYS_REFCURSOR):
        A cursor that returns the result set of descriptions related to the 
        specified drilldown ID, including details such as text, version, 
        status, and enhanced text.
    ----------------------------------------------------------------------------
    Exceptions:
    - c_resource_not_found (-20004):
        Raised when no drilldown descriptions are found for the provided ID. 
        The error is logged, and a custom error is raised using 
        lang_data_errors_pkg.
    ----------------------------------------------------------------------------
    PROCEDURE calculate_drilldown_regression
    ----------------------------------------------------------------------------
    Description:
        This procedure calculates the regression count for a new description in 
        relation to a its parent report. This procedures calculates whether a 
        new description in a given drilldown or a new drilldown introduce any 
        regression, w.r.t user search records.
    ----------------------------------------------------------------------------
    Parameters:
        - p_new_description_id (IN VARCHAR2):
            The unique identifier of the drilldown description for which 
            regression analysis is being performed.
        
        - p_new_sample_query_id (IN VARCHAR2):
            The unique identifier of the drilldown sample query for which 
            regression analysis is being performed

    ----------------------------------------------------------------------------
    Exceptions:
        - c_invalid_parameters_code(-20002):
            Raised when the description being checked for regression is not in 
            'Pending Regression' state.
    ----------------------------------------------------------------------------
    Procedure replace_drilldown_filter_enumerable_set
    ----------------------------------------------------------------------------
    Description:
        This procedure replaces the enumerable set of a specific filter in 
        a drilldown's match document with a new enumerable set. If the filter 
        does not exist or does not contain an enumerable set, an error is raised.

    Parameters:
        - p_drilldown_id (IN VARCHAR2):
            The unique identifier of the drilldown whose filter is to be updated.

        - p_filter_name (IN VARCHAR2):
            The name of the filter whose enumerable set should be replaced.

        - p_new_enumerable_set (IN JSON_ARRAY_T):
            The new enumerable set to be assigned to the specified filter.

    Exception: 
        - c_invalid_parameters_code (-20003):
            Raised if the specified filter does not exist or does not have 
            an enumerable set.

    Notes:
        - If the update is successful, a background job is scheduled to 
          update the value vectors for the modified enumerable set.

    ----------------------------------------------------------------------------
    Procedure add_into_drilldown_filter_enumerable_set
    ----------------------------------------------------------------------------
    Description:
        This procedure adds new values to the enumerable set of a specific 
        filter in a drilldown's match document. The updated enumerable set 
        consists of the union of the existing values and the new values.

    Parameters:
        - p_drilldown_id (IN VARCHAR2):
            The unique identifier of the drilldown whose filter is to be updated.

        - p_filter_name (IN VARCHAR2):
            The name of the filter whose enumerable set should be modified.

        - p_enumerable_set_to_add (IN JSON_ARRAY_T):
            The enumerable set containing values to be added to the existing set.

    Exception: 
        - c_invalid_parameters_code (-20003):
            Raised if the specified filter does not exist or does not have 
            an enumerable set.

    Notes:
        - The function merges the old and new enumerable sets, keeping only 
          distinct values.
        - If the update is successful, a background job is scheduled to 
          update the value vectors for the modified enumerable set.
    
    ----------------------------------------------------------------------------
    Procedure remove_from_drilldown_filter_enumerable_set
    ----------------------------------------------------------------------------
    Description:
        This procedure removes specific values from the enumerable set of 
        a filter in a drilldown's match document. The updated enumerable set 
        consists of the existing values minus the values provided in the 
        input enumerable set.

    Parameters:
        - p_drilldown_id (IN VARCHAR2):
            The unique identifier of the drilldown whose filter is to be updated.

        - p_filter_name (IN VARCHAR2):
            The name of the filter whose enumerable set should be modified.

        - p_enumerable_set_to_remove (IN JSON_ARRAY_T):
            The enumerable set containing values to be removed from the existing
            set.

    Exception: 
        - c_invalid_parameters_code (-20003):
            Raised if the specified filter does not exist or does not have 
            an enumerable set.

    Notes:
        - The function removes only the specified values from the existing 
          enumerable set while retaining all other values.
        - If the update is successful, a background job is scheduled to 
          update the value vectors for the modified enumerable set.

    ----------------------------------------------------------------------
    PROCEDURE update_drilldown_status
    ----------------------------------------------------------------------
    Description:
        This procedure updates the status of a drilldown to a new status.

    Parameters:
        - p_id (IN VARCHAR2):
            ID of the drilldown whose status is to be updated.
        
        - p_status (IN VARCHAR2):
            The current status of the drilldown. It can have one of the 
            following values: 'Pending Review', 'Approved', 'Rejected', 
            'Published', 'Inactive', or 'Archived'.
    
    Exceptions:
        - c_invalid_parameters_code (-20002):
            Raised when the status or drilldown ID is invalid.

    ----------------------------------------------------------------------
    PROCEDURE update_drilldown_description_status
    ----------------------------------------------------------------------
    Description:
        This procedure updates the status of a drilldown description.

    Parameters:
        - p_id (IN VARCHAR2):
            ID of the drilldown description whose status is to be updated.
        
        - p_status (IN VARCHAR2):
            The current status of the drilldown description. It can have one of 
            the following values: 'Pending Review', 'Approved', 'Rejected', 
            'Published', 'Inactive', or 'Archived'.
    
    Exceptions:    
        - c_invalid_parameters_code (-20002):
            Raised when the status or drilldown desc ID is invalid.

    ----------------------------------------------------------------------
    PROCEDURE get_drilldown_regression
    ----------------------------------------------------------------------
    Description:
        This procedure fetches regression data for a drilldown description. 
        In case no regression data exists, it calls 
        calculate_drilldown_regression and generates regression json

    Parameters:
        - p_description_id (IN VARCHAR2):
            ID of the drilldown description.

        - p_sample_query_id (IN VARCHAR2):
            ID of the sample query
        
        - p_force (IN BOOLEAN):
            If set to true calls calculate_drilldown_regression and 
            invalidates all previous data. If not set to true it returns 
            previous regression data if available, if previous regression is 
            still being calculated, returns null.

        - p_json (OUT JSON):


    Exceptions:    
        - c_invalid_parameters_code (-20002):
            Raised when drilldown description ID is invalid.

    ----------------------------------------------------------------------
    FUNCTION get_drilldown_id_by_title
    ----------------------------------------------------------------------
    Description:
        This function retrieves the unique drilldown ID corresponding to the 
        given drilldown title.

    Parameters:
        - p_title (IN VARCHAR2):
            The title of the drilldown to look up.

    Returns:
        - VARCHAR2:
            The unique ID of the drilldown matching the given title.

    Exceptions:
        - c_resource_not_found (-20004):
            Raised when no drilldown is found for the given drilldown title.
            A custom error with code -20004 is raised, using the 
            lang_data_errors_pkg package, with the message "Resource not found".
    
    ----------------------------------------------------------------------
    FUNCTION get_desc_id_by_drilldown_id_version
    ----------------------------------------------------------------------
    Description:
        This function retrieves the description ID for a specific version 
        of a given drilldown.

    Parameters:
        - p_drilldown_id (IN VARCHAR2):
            The unique ID of the drilldown.

        - p_version (IN NUMBER):
            The version number of the drilldown description to retrieve.

    Returns:
        - VARCHAR2:
            The description ID for the given drilldown ID and version.

    Exceptions:
        - c_resource_not_found (-20004):
            Raised when no drilldown description is found for the given 
            drilldown id and version. A custom error with code -20004 is raised,
            using the lang_data_errors_pkg package, with the message "Resource
            not found".    
    */

    PROCEDURE get_drilldown_descriptions_paginated (
        p_id            IN VARCHAR2,
        p_limit         IN NUMBER DEFAULT 10,
        p_cursor        IN OUT VARCHAR2,
        p_descriptions  OUT SYS_REFCURSOR
    );
    
	-- Public procedure declaration for retriving a drilldown
    PROCEDURE get_drilldown_paginated (
        p_id                  IN VARCHAR2,
        p_report_id           OUT VARCHAR2,
        p_title               OUT VARCHAR2,
		p_match_document      OUT JSON,
		p_status              OUT VARCHAR2,
        p_descriptions        OUT SYS_REFCURSOR,
        p_descriptions_cur    IN OUT VARCHAR2,
        p_descriptions_limit  IN NUMBER DEFAULT 10,
        p_sample_queries      OUT SYS_REFCURSOR,
        p_sample_query_cur    IN OUT VARCHAR2,
        p_sample_query_limit  IN NUMBER DEFAULT 10
    );

    PROCEDURE get_all_drilldowns(
        p_report_id    IN VARCHAR2 DEFAULT NULL,
        p_status       IN VARCHAR2 DEFAULT NULL,
        p_cursor       IN OUT VARCHAR2,
        p_limit        IN NUMBER DEFAULT 10,
        p_drilldowns   OUT SYS_REFCURSOR
    );

    PROCEDURE delete_drilldown (
        p_drilldown_id IN VARCHAR2
    );

    PROCEDURE delete_drilldown_description (
        p_description_id IN VARCHAR2
    );

    PROCEDURE update_drilldown_description (
        p_drilldown_description_id IN  VARCHAR2,
        p_new_description          IN  VARCHAR2
    );

    PROCEDURE create_drilldown(
        p_title               IN VARCHAR2,
        p_report_id           IN VARCHAR2,
        p_match_document      IN JSON,
        p_description_text    IN VARCHAR2,
        p_description_status  IN VARCHAR2,
        p_drilldown_status    IN VARCHAR2,
        p_sample_queries      IN SYS.ODCIVARCHAR2LIST,
        p_domain              IN VARCHAR2 DEFAULT NULL,
        p_drilldown_id        OUT VARCHAR2,
        p_description_id      OUT VARCHAR2
    );

    PROCEDURE add_drilldown_description(
        p_drilldown_id          IN VARCHAR2,
        p_text                  IN VARCHAR2,
        p_status                IN VARCHAR2,
        p_description_id        OUT VARCHAR2
    );

    PROCEDURE execute_drilldown_sql(
        p_drilldown_id   IN VARCHAR2,
        p_filter_values  IN JSON,
        p_columns        OUT SYS.ODCIVARCHAR2LIST,
        p_data           OUT CLOB
    );

    PROCEDURE get_drilldown_description (
        p_description_id  IN VARCHAR2,
        p_text OUT VARCHAR2,
        p_version OUT NUMBER,
        p_status OUT VARCHAR2,
        p_drilldown_id OUT VARCHAR2,
        p_enhanced_text OUT VARCHAR2
    );

    PROCEDURE get_drilldown_descriptions (
        p_drilldown_id IN VARCHAR2,
        p_descriptions OUT SYS_REFCURSOR
    );

    PROCEDURE calculate_drilldown_regression(
        p_new_description_id  IN VARCHAR2 DEFAULT NULL,
        p_new_sample_query_id IN VARCHAR2 DEFAULT NULL
    );

    PROCEDURE replace_drilldown_filter_enumerable_set (
        p_drilldown_id          IN  VARCHAR2,
        p_filter_name           IN  VARCHAR2,
        p_new_enumerable_set    IN  JSON_ARRAY_T
    );

    PROCEDURE add_into_drilldown_filter_enumerable_set (
        p_drilldown_id             IN  VARCHAR2,
        p_filter_name              IN  VARCHAR2,
        p_enumerable_set_to_add    IN  JSON_ARRAY_T
    );

    PROCEDURE remove_from_drilldown_filter_enumerable_set (
        p_drilldown_id                   IN  VARCHAR2,
        p_filter_name                 IN  VARCHAR2,
        p_enumerable_set_to_remove    IN  JSON_ARRAY_T
    );

    PROCEDURE update_drilldown_status(
        p_id                IN VARCHAR2,
        p_status            IN VARCHAR2
    );

    PROCEDURE update_drilldown_description_status(
        p_id                IN VARCHAR2,
        p_status            IN VARCHAR2
    );

    PROCEDURE get_drilldown_regression(
        p_description_id  IN VARCHAR2 DEFAULT NULL,
        p_sample_query_id IN VARCHAR2 DEFAULT NULL,
        p_force           IN BOOLEAN,
        p_json            OUT JSON
    );

    FUNCTION get_drilldown_id_by_title(
        p_title IN VARCHAR2
    ) RETURN VARCHAR2;

    FUNCTION get_desc_id_by_drilldown_id_version(
        p_drilldown_id    IN VARCHAR2,
        p_version         IN NUMBER
    ) RETURN VARCHAR2;

    FUNCTION get_drilldown_status_by_id (
        p_drilldown_id     IN VARCHAR2
    ) RETURN VARCHAR2;

    FUNCTION get_drilldown_match_document_by_id(
        p_drilldown_id         VARCHAR2
    ) RETURN CLOB;
    
end lang_data_drilldowns_pkg;
/

