Rem
Rem $Header: dbgendev/src/langdata/plsql/cleanup/cleanup_pkg.pks /main/7 2025/07/07 06:01:45 arevathi Exp $
Rem
Rem cleanup_pkg.pks
Rem
Rem Copyright (c) 2024, 2025, Oracle and/or its affiliates.
Rem
Rem    NAME
Rem      cleanup_pkg.pks - Package specification of cleanup_pkg.
Rem
Rem    DESCRIPTION
Rem      Specifies the procedures/functions responsible for cleanup of the 
Rem      database.
Rem
Rem    NOTES
Rem      NONE
Rem
Rem    BEGIN SQL_FILE_METADATA
Rem    SQL_SOURCE_FILE: dbgendev/src/langdata/plsql/cleanup/cleanup_pkg.pks
Rem    SQL_SHIPPED_FILE:
Rem    SQL_PHASE:
Rem    SQL_STARTUP_MODE: NORMAL
Rem    SQL_IGNORABLE_ERRORS: NONE
Rem    END SQL_FILE_METADATA
Rem
Rem    MODIFIED   (MM/DD/YY)
Rem    arevathi    06/03/25 - Add archive_search_records procedure
Rem    jiangnhu    02/14/25 - DBAI-575: Remove c_unknown_exception_code
Rem    jiangnhu    12/05/24 - DBAI-421: Add drop_resource_plan
Rem    jiangnhu    10/30/24 - DBAI-383: Add drop_user_table_indexes
Rem    dadoshi     10/21/24 - Remove text wrapping
Rem    dadoshi     10/18/24 - JIRA_DBAI399: Update template
Rem    pryarla     10/16/24 - Created
Rem

CREATE OR REPLACE PACKAGE lang_data_cleanup_pkg AS
    /*
    ----------------------------------------------------------------------
    Package Name: lang_data_cleanup_pkg
    Description: This package contains procedures responsible for performing 
                 database cleanup tasks, including the dropping of all the 
                 Lang-Data related jobs, triggers, and tables.
    ----------------------------------------------------------------------
    Author: Daksh Doshi
    Created: 09/26/2024
    ----------------------------------------------------------------------
    Public Procedures:
    ----------------------------------------------------------------------

    PROCEDURE drop_all_jobs
    -----------------------
    Description:
        This procedure drops all scheduled jobs related to Lang-Data from the 
        current schema's `user_scheduler_jobs` table. The procedure iterates 
        through each job using a cursor and attempts to drop the job using 
        `DBMS_SCHEDULER.drop_job`.

        For each job:
        - The procedure logs the job name before and after dropping it.
        - If an error occurs while dropping a job, the procedure logs the error 
          and raises a custom exception using the `lang_data_errors_pkg`.

        If a fatal error occurs during the cursor operation or job fetch, the 
        procedure ensures the cursor is closed and logs the error.

    Parameters:
        None

    Exceptions:
        - None.

    PROCEDURE drop_foreign_keys
    ---------------------------
    Description:
        This procedure drops all foreign key constraints from a specified table.
        It uses a cursor to iterate through each foreign key constraint 
        (constraint type 'R') found in the `user_constraints` view for the given
        table name.

        For each foreign key constraint:
        - The procedure attempts to drop the foreign key using `ALTER TABLE`.
        - If successful, a log entry is created for the dropped foreign key.
        - If an error occurs while dropping a foreign key, the procedure logs
          the error and raises a custom exception.

    Parameters:
        - p_table_name (IN VARCHAR2): The name of the table whose foreign keys
                                      are to be dropped.

    Exceptions:
        - None.

    PROCEDURE drop_tables
    ---------------------
    Description:
        This procedure drops all tables from the schema that match the 
        pattern `LANGDATA$%` and ensures any associated foreign key 
        constraints are dropped before dropping the tables. It uses 
        a cursor to select all the matching table names from `user_tables`, 
        and then for each table:
        
        - Drops any foreign key constraints associated with the table using the
          `drop_foreign_keys` procedure.
        - Drops the table itself using `CASCADE CONSTRAINTS` to ensure 
          all dependent objects are also removed.

        In case of any errors during the drop operations, it logs the error 
        using `lang_data_logger_pkg` and raises a custom error using 
        `lang_data_errors_pkg`.

    Parameters:
        None

    Exceptions:
        - None.

    PROCEDURE drop_triggers
    -----------------------
    Description:
        This procedure drops all triggers in the current schema. It uses a
        cursor to fetch all trigger names from the `user_triggers` view and
        iterates through each trigger to drop it using `EXECUTE IMMEDIATE`.

        For each trigger:
        - The procedure attempts to drop the trigger.
        - If successful, it logs the dropped trigger.
        - If an error occurs, the procedure logs the error and raises a custom 
          exception using `lang_data_errors_pkg`.

    Parameters:
        None
    
    Exceptions:
        - None.

    PROCEDURE: drop_user_table_indexes
    -----------------------
    Description:
        Drops all indexes created on `VARCHAR2` and `CLOB` columns for 
        user tables in the schema, excluding metadata tables.

        The procedure iterates over each user table and, for each table, 
        identifies indexes on text columns (`VARCHAR2` or `CLOB` data types).
        It then attempts to drop each index using `DROP INDEX`.

        If an index cannot be dropped, an error is logged but does not halt 
        the procedure.

    Parameters:
        None

    Exceptions:
        - None.
    
    PROCEDURE drop_resource_plan
    ----------------------------
    Description:
        This procedure manages the cleanup of Oracle Resource Manager objects
        related to the Lang-Data schema, including the resource plan, job 
        class, directives, and consumer groups.

        The procedure performs the following actions:
        - Drops the `LangdataJobClass` job class.
        - Deactivates the current resource plan using `SWITCH_PLAN(NULL)`.
        - Deletes all plan directives associated with the resource plan 
          `langdataResourcePlan`.
        - Deletes the consumer group `langdataResourceGroup`.
        - Deletes the resource plan `langdataResourcePlan`.

        Each step is logged for auditing purposes.

    Parameters:
        None

    Exceptions:
        - None.

    Notes:
        - Ensure no jobs or active operations are using the resource plan before
          invoking this procedure.
        - Only authorized users with the necessary role 
          (`lang_data_app_expert`) can execute this procedure.

    PROCEDURE cleanup_langdata
    --------------------------
    Description:
        This is the main procedure that performs the cleanup operation for 
        Lang-Data objects. It sequentially drops all Lang-Data related jobs, 
        triggers, and tables.
        
        - First, it checks if the user has the correct authorization by calling 
          `lang_data_auth_pkg.is_role_enabled`.
        - Then, it calls the `drop_all_jobs`, `drop_triggers`, and `drop_tables`
          procedures to remove all jobs, triggers, and tables related to 
          Lang-Data.
        - If any errors occur during the cleanup process, they are logged, and 
          a custom error is raised. If unauthorized access is detected, the 
          error is raised immediately.

        The procedure ensures that all operations are performed in a transaction
        (with a `COMMIT` at the end). If an error occurs, it rolls back the 
        changes.

    Parameters:
        None

    Exceptions:
        - c_unauthorized_code (-20001):
            Raised if the user does not have the necessary role 
            (`lang_data_app_expert`).
        - None.
    */

    PROCEDURE drop_all_jobs;
    PROCEDURE drop_foreign_keys(p_table_name IN VARCHAR2);
    PROCEDURE drop_tables;
    PROCEDURE drop_triggers;
    PROCEDURE drop_types;
    PROCEDURE drop_user_table_indexes;
    PROCEDURE drop_resource_plan;
    PROCEDURE cleanup_langdata;
    
    /*
    PROCEDURE delete_search_records
    -------------------------------
    Description:
        Delete search records older than given cutoff time.
        
    Parameters:
        - p_cutoff_time (IN TIMESTAMP DEFAULT NULL):
            cutoff timestamp.

    */
    PROCEDURE delete_search_records(
        p_cutoff_time  IN TIMESTAMP
    );
    
    /*
    PROCEDURE archive_search_records
    -------------------------------
    Description:
        Archive search records older than given cutoff time.
        
    Parameters:
        - p_cutoff_time (IN TIMESTAMP DEFAULT NULL):
            cutoff timestamp.

    */
    PROCEDURE archive_search_records(
        p_cutoff_time  IN TIMESTAMP
    );

    /*
    PROCEDURE purge_outdated_search_records 
    -------------------------------
    Description:
        This procedure allows for systematic cleanup by either archiving or 
        deleting outdated records. 
        Either p_cutoff_time or p_days must be provided to determine the 
        cutoff if p_cutoff_time is null, the procedure uses SYSDATE - p_days as
        the cutoff timestamp.
        
    Parameters:
        - p_days (IN NUMBER DEFAULT 180):
            Records created earlier than this number of days ago are considered
            old default is 180 days (6 Months).
            
        - p_cutoff_time (IN TIMESTAMP DEFAULT NULL):
            Optional parameter specifying an explicit cutoff timestamp.
            
        - p_action (IN VARCHAR2 DEFAULT 'ARCHIVE'):
            Action to perform. Must be either 'ARCHIVE' (default) or 'DELETE'.
            
        - p_output_msg (OUT VARCHAR2):
            Output message to indicate if the operation was successful.

    Exceptions:
        - c_invalid_parameters_code:
            Raised if an invalid value is passed to p_action.
    */
    PROCEDURE purge_outdated_search_records (
        p_days         IN NUMBER DEFAULT 180,
        p_cutoff_time  IN TIMESTAMP DEFAULT NULL,
        p_action       IN VARCHAR2 DEFAULT 'ARCHIVE',
        p_output_msg   OUT VARCHAR2
    );

END lang_data_cleanup_pkg;
/ 

