Rem
Rem $Header: dbgendev/src/langdata/plsql/annotations/annotations_pkg.pkb 
Rem saloshah_dbai_327/3 2024/11/18 09:01:40 saloshah Exp $
Rem
Rem annotations_pkg.pkb
Rem
Rem Copyright (c) 2024, 2025, Oracle and/or its affiliates.
Rem
Rem    NAME
Rem      annotations_pkg.pkb - Package body of annotations_pkg
Rem
Rem    DESCRIPTION
Rem      Defines the procedures used for adding and updating annotations
Rem
Rem    NOTES
Rem      NONE
Rem
Rem    BEGIN SQL_FILE_METADATA
Rem    SQL_SOURCE_FILE: dbgendev/src/langdata/plsql/annotations/
Rem    annotations_pkg.pkb
Rem    SQL_SHIPPED_FILE:
Rem    SQL_PHASE:
Rem    SQL_STARTUP_MODE: NORMAL
Rem    SQL_IGNORABLE_ERRORS: NONE
Rem    END SQL_FILE_METADATA
Rem
Rem    MODIFIED   (MM/DD/YY)
Rem    fgurrola    07/29/25 - DBAI-1070: Change UPPER by normalization in the
Rem                           schema name.
Rem    deveverm    03/11/25 - DBAI-546: added schema_name for cross_schema
Rem                           support
Rem    jiangnhu    03/07/25 - Move re_augmented_affected_texts,
Rem                           update_affected_texts to utils pkg
Rem    jiangnhu    02/25/25 - DBAI-542: Add v_current_user. as prefix to user
Rem                           table
Rem    jiangnhu    02/18/25 - Update update_annotation_values to use
Rem                           lang_data_utils_pkg.get_annotation
Rem    jiangnhu    02/14/25 - DBAI-575: Remove c_unknown_exception_code
Rem    jiangnhu    02/06/25 - Update update_annotation_values
Rem    jiangnhu    02/03/25 - DBAI-511: Update annotation workflow to both
Rem                           augment/amend queries/descriptions
Rem    dadoshi     12/18/24 - Fix error-code errors
Rem    jiangnhu    12/03/24 - JIRA_DBAI-421: Update
Rem                          check_annotation_changes_table_column
Rem    jiangnhu    12/03/24 - JIRA_DBAI-383: Remove update_drilldown_values
Rem    saloshah    12/02/24 - DBAI-439: Added edge cases error handling
Rem    saloshah    11/12/24 - Created
Rem

CREATE OR REPLACE PACKAGE BODY lang_data_annotations_pkg AS

    PROCEDURE update_annotation_values(
        p_table_name       IN VARCHAR2,
        p_column_name      IN VARCHAR2,
        p_annotation_value IN VARCHAR2,
        p_schema_name      IN VARCHAR2
    ) 
    IS
        v_table_name        VARCHAR2(255);
        v_column_name       VARCHAR2(255);
        v_schema_name       VARCHAR2(128);
        v_annotation_value  VARCHAR2(4000);
        v_operation         VARCHAR2(10);
        v_table_exists      NUMBER;
        v_column_exists     NUMBER;
    BEGIN
        v_table_name := UPPER(p_table_name);
        v_column_name := UPPER(p_column_name);
        v_schema_name := lang_data_utils_pkg.normalize_schema_name(
            p_schema_name
        );
        
        IF NOT lang_data_utils_pkg.check_column_exists(
            v_table_name, v_column_name, v_schema_name
        ) THEN
            lang_data_logger_pkg.log_error(
                'Invalid combination of table name and column name'
            );
            lang_data_errors_pkg.raise_error(
                lang_data_errors_pkg.c_invalid_parameters_code
            );
        END IF;
        
        IF p_annotation_value IS NULL THEN
            lang_data_logger_pkg.log_error(
                'Annotation value cannot be NULL'
            );
            lang_data_errors_pkg.raise_error(
                lang_data_errors_pkg.c_invalid_parameters_code
            );
        END IF;

        IF LENGTH(p_annotation_value) > 4000 THEN 
            lang_data_logger_pkg.log_error(
                'Annotation value cannot exceed 4000 characters'
            );
            lang_data_errors_pkg.raise_error(
                lang_data_errors_pkg.c_max_text_length_exceeded
            );
        END IF;

        -- Fetch the current annotation value for the given table and column
        v_annotation_value := lang_data_utils_pkg.get_annotation(
            v_table_name, v_column_name, v_schema_name, 'DESCRIPTION'
        );

        IF v_annotation_value IS NULL THEN
            v_operation := 'ADD';
        ELSE
            -- If annotation value matches the input, raise an exception
            IF v_annotation_value = p_annotation_value THEN
                lang_data_logger_pkg.log_error(
                    'Annotation value same as before'
                );
                lang_data_errors_pkg.raise_error(
                    lang_data_errors_pkg.c_invalid_parameters_code
                );      

            ELSE
                -- Perform REPLACE operation if the value is different
                v_operation := 'REPLACE';
            END IF;
        END IF;

        -- Based on the operation (REPLACE/ADD), 
        -- execute the ALTER TABLE statement       
        EXECUTE IMMEDIATE 'ALTER TABLE ' || v_schema_name ||'.' || v_table_name ||
                        ' MODIFY ' || v_column_name ||
                        ' ANNOTATIONS (' || v_operation || ' Description 
                        ''' || p_annotation_value || ''')';
        lang_data_logger_pkg.log_info(
            'Annotation ' || v_operation 
            || ' operation performed successfully.'
        );
        EXCEPTION
            WHEN OTHERS THEN
            IF SQLCODE IN (
                lang_data_errors_pkg.c_invalid_parameters_code,
                lang_data_errors_pkg.c_max_text_length_exceeded
            ) THEN
                RAISE;
            ELSE
                lang_data_logger_pkg.log_fatal(
                    'An unknown error occurred ' || '. Error: ' 
                    || SQLERRM
                );
                RAISE;
            END IF;
    END update_annotation_values;
END lang_data_annotations_pkg;
/

