Rem
Rem $Header: dbgendev/src/langdata/install/setup_dbfs.sql /main/2 2025/07/28 08:13:40 arevathi Exp $
Rem
Rem setup_dbfs.sql
Rem
Rem Copyright (c) 2025, Oracle and/or its affiliates.
Rem
Rem    NAME
Rem      setup_dbfs.sql - Setup script for mounting DBFS
Rem
Rem    DESCRIPTION
Rem      This script creates and mounts an Oracle DBFS file system for 
Rem      langdata_requirements under the specified directory in the provided 
Rem      PDB container.
Rem
Rem    NOTES
Rem      None.
Rem
Rem    BEGIN SQL_FILE_METADATA
Rem    SQL_SOURCE_FILE: dbgendev/src/langdata/install/setup_dbfs.sql
Rem    SQL_SHIPPED_FILE:
Rem    SQL_PHASE:
Rem    SQL_STARTUP_MODE: NORMAL
Rem    SQL_IGNORABLE_ERRORS: NONE
Rem    END SQL_FILE_METADATA
Rem
Rem    MODIFIED   (MM/DD/YY)
Rem    arevathi    07/09/25 - remove unmounting as part of setup
Rem    dadoshi     04/08/25 - Created
Rem

DEFINE DBS_DIR = '&1'
DEFINE PDB_NAME = '&2'
DEFINE FS_NAME = '&3'
DEFINE TABLESPACE_NAME = '&4'

alter session set container=&PDB_NAME;

DECLARE
  fs_exists NUMBER := 0;
BEGIN
  -- Check if the mount path exists
  SELECT COUNT(*) INTO fs_exists
    FROM V$OFSMOUNT
    WHERE OFS_FSPATH = LOWER('&FS_NAME') AND OFS_MNTPATH = LOWER('&DBS_DIR/langdata/langdata_mnt/');

  IF fs_exists = 0 THEN

    DBMS_FS.MAKE_ORACLE_FS(
      'dbfs', 
      '&FS_NAME', 
      'tablespace=&TABLESPACE_NAME'
    ); 

     DBMS_FS.MOUNT_ORACLE_FS(
      'dbfs', 
      '&FS_NAME', 
      '&DBS_DIR/langdata/langdata_mnt/', 
      'db_access, ofs_cache_attr_time=20, persist');

  END IF;

END;
/

select mount, pathname, property_name, property_type 
from DBFS_CONTENT_PROPERTIES;