with
      v$metricname as (
          /* version 3 */
          select
              ''              as project
              ,'oracle_db'    as fleet
              ,host_name      as host
              ,'"lifecycle":"'||
                  case
                      when
                          (regexp_like(instance_name,'(9[0-9])') and host_name not like '%.r1') or
                          regexp_like(host_name,'(dev|sandbox)') or
                          regexp_like(lower(sys_context('USERENV','DB_DOMAIN')),'(dev|sand)')
                          then 'DEV'
                      when
                          (regexp_like(instance_name,'(9[0-9])') and host_name like '%.r1%') or
                          regexp_like(host_name,'(test|tst)') or
                          regexp_like(lower(sys_context('USERENV','DB_DOMAIN')),'(test|tst)')
                          then 'TEST'
                      else 'PROD'
                  end || '"' ||
            ',"hostclass":"'|| nvl(regexp_substr(host_name,'^([^.]*)-',1,1,NULL,1),'N/A') || '"' ||
            ',"instance_name":"'     || instance_name    || '"' ||
            ',"db_name":"'           || nvl(name,'N/A')             || '"' ||
            ',"db_domain":"'         || nvl(sys_context('USERENV','DB_DOMAIN'),'N/A') || '"' ||
            ',"db_unique_name":"'    || db_unique_name   || '"' ||
            ',"database_role":"'     || database_role    || '"' ||
            ',"fsfo_role":"'||
                  case
                      when database_role = 'PRIMARY' then 'PRIMARY'
                      when database_role = 'PHYSICAL STANDBY' and lower(db_unique_name)  = lower(fs_failover_current_target) then 'STANDBY'
                      when database_role = 'PHYSICAL STANDBY' and lower(db_unique_name) != lower(fs_failover_current_target) then 'BYSTANDER'
                      else 'NONE'
                  end || '"' as metric_dimensions
          from v$database, v$instance
      ),
      v$metric_history as (
      select
            case when
                (regexp_like(message_text,'(ORA-0*(600))'))
                then 'ORA-600'
                when
                (regexp_like(message_text,'(ORA-0*(7445))'))
                then 'ORA-7445'
                when
                (regexp_like(message_text,'(ORA-0*(257))'))
                then 'Archiver Hung'
                when
                (regexp_like(message_text,'(ORA-0*(1578))'))
                then 'Data Block Corruption'
                when
                  (regexp_like(message_text,'(ORA-13831)'))
                then 'ORA-13831'
                else 'OTHER'
                end as ora_err_code
             from x$dbgalertext
             where originating_timestamp  > (sysdate - 1/24)
             and message_text like 'ORA-%'
      ),
      v$metric as (
          select 'DBGAlertText.ORAErrors' as metric_name
            ,',"ORA_Err_Code":"'   ||ora_err_code|| '"'  as metric_dimensions
            , count(*) as metric_value
          from v$metric_history
          where ora_err_code <> 'OTHER'
          group by ORA_Err_Code
     )
     select
         v$metricname.project                        as project
         ,v$metricname.fleet                         as fleet
         ,v$metricname.host                          as host
         ,v$metric.metric_name                       as metric_name
         ,v$metric.metric_value                      as metric_value
       ,'{'||v$metricname.metric_dimensions||v$metric.metric_dimensions||'}' as metric_dimensions
     from v$metricname,v$metric
