<xsl:stylesheet version="1.0"   xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:ku="http://xmlns.oracle.com/ku" exclude-result-prefixes="ku">
    <xsl:output method="xml" omit-xml-declaration="yes"  encoding="UTF-8" indent="yes"/>
    <xsl:strip-space elements="*"/>

    <!-- Copy everything as is -->
    <xsl:template match="node()|@*">
        <xsl:copy>
            <xsl:apply-templates select="node()|@*"/>
        </xsl:copy>
    </xsl:template>

    <xsl:template match="text()">
        <xsl:value-of select="normalize-space(.)"/>
    </xsl:template>

    <xsl:template match="*">
        <xsl:variable name="new-name">
            <xsl:choose>
                <xsl:when test="name()='DEFAULT_PHYSICAL_PROPERTIES'">PHYSICAL_PROPERTIES</xsl:when>
                <xsl:otherwise>
                    <xsl:value-of select="name()"/>
                </xsl:otherwise>
            </xsl:choose>
        </xsl:variable>
        <xsl:element name="{$new-name}">
            <xsl:apply-templates/>
        </xsl:element>
    </xsl:template>

<!--     Special handling for CHECK_CONSTRAINT_LIST -->
    <xsl:template match="ku:CHECK_CONSTRAINT_LIST">
        <xsl:copy>
            <!-- Sort CHECK_CONSTRAINT_LIST_ITEM by NAME -->
            <xsl:apply-templates select="ku:CHECK_CONSTRAINT_LIST_ITEM">
                <xsl:sort select="ku:NAME"/>
            </xsl:apply-templates>
        </xsl:copy>
    </xsl:template>

    <xsl:template match="ku:ROWID_CONSTRAINT_LIST">
        <xsl:copy>
            <!-- Sort ROW_CONSTRAINT_LIST_ITEM by NAME -->
            <xsl:apply-templates select="ku:ROW_CONSTRAINT_LIST_ITEM">
                <xsl:sort select="ku:COL"/>
            </xsl:apply-templates>
        </xsl:copy>
    </xsl:template>

    <xsl:template match="ku:FOREIGN_KEY_CONSTRAINT_LIST">
        <xsl:copy>
            <!-- Sort FK_CONSTRAINT_LIST_ITEM by NAME -->
            <xsl:apply-templates select="ku:FOREIGN_KEY_CONSTRAINT_LIST_ITEM">
                <xsl:sort select="ku:NAME"/>
            </xsl:apply-templates>
        </xsl:copy>
    </xsl:template>

</xsl:stylesheet>