/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.common.ddl;

import java.io.BufferedOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.sql.Connection;
import java.util.ArrayList;
import oracle.dbtools.common.config.IEnvironmentConfig;
import oracle.dbtools.common.ddl.DDLFormat;
import oracle.dbtools.common.ddl.DDLMetaObject;
import oracle.dbtools.common.ddl.DDLRegistry;
import oracle.dbtools.common.ddl.DDLResources;
import oracle.dbtools.common.ddl.IObjectDDL;
import oracle.dbtools.common.utils.BasicDBObject;
import oracle.dbtools.db.ConnectionResolver;
import oracle.dbtools.db.LockManager;
import oracle.dbtools.util.Logger;

public class DDLGenerator {
    private static final Object LOCK = new Object();
    private static DDLGenerator _generator;
    DDLFormat _format;
    Writer _out = null;
    String _file = null;
    String _enc = null;
    ArrayList<DDLMetaObject> _objects = new ArrayList();

    private DDLGenerator() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DDLGenerator getInstance() {
        Object object = LOCK;
        synchronized (object) {
            if (_generator == null) {
                _generator = new DDLGenerator();
            }
        }
        return _generator;
    }

    public void setFormating(DDLFormat format) {
        this._format = format;
    }

    public DDLFormat getFormating() {
        return this._format;
    }

    public void setFile(String file, String enc) {
        this._file = file;
        this._enc = enc != null ? enc : IEnvironmentConfig.Storage.getInstance().getString("ENV_ENCODING");
    }

    public boolean openFile() throws Exception {
        if (this._file == null || this._enc == null) {
            Logger.warn(this.getClass(), (String)DDLResources.getString("FILE_OPEN_ERR"));
            return false;
        }
        FileOutputStream fout = new FileOutputStream(this._file);
        BufferedOutputStream bout = new BufferedOutputStream(fout);
        this._out = new OutputStreamWriter((OutputStream)bout, this._enc);
        return true;
    }

    public void closeFile() throws IOException {
        this._out.flush();
        this._out.close();
    }

    private void checkFormat() {
        if (this._format == null) {
            this._format = new DDLFormat();
        }
    }

    public void setWriter(Writer out) {
        this._out = out;
    }

    public Writer getWriter() {
        return this._out;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayList<BasicDBObject> getSchemaObjects(Connection conn, String schema, String type, String key) {
        if (LockManager.lock((Connection)conn)) {
            try {
                ArrayList<BasicDBObject> arrayList = DDLRegistry.getInstanceFor(key).getSchemaObjects(conn, schema, type);
                return arrayList;
            }
            catch (Exception e) {
                ArrayList<BasicDBObject> arrayList = null;
                return arrayList;
            }
            finally {
                LockManager.unlock((Connection)conn);
            }
        }
        return null;
    }

    public String getGrants(BasicDBObject basicDBObject) throws Exception {
        try {
            this.checkFormat();
            IObjectDDL registry = this.getRegistry(basicDBObject);
            return registry != null ? registry.getGrantsDDL(basicDBObject) : this.getDDLNotAvailable(basicDBObject);
        }
        catch (Exception e) {
            Logger.warn(this.getClass(), (String)("getGrantsDDL - " + e.getMessage()));
            throw e;
        }
    }

    public String getDDL(BasicDBObject basicDBObject) throws Exception {
        try {
            this.checkFormat();
            IObjectDDL registry = this.getRegistry(basicDBObject);
            return registry != null ? registry.getDDL(basicDBObject) : this.getDDLNotAvailable(basicDBObject);
        }
        catch (Exception e) {
            Logger.warn(this.getClass(), (String)("getDDL - " + e.getMessage()));
            throw e;
        }
    }

    public String getDDL(BasicDBObject basicDBObject, String action) throws Exception {
        try {
            this.checkFormat();
            IObjectDDL registry = this.getRegistry(basicDBObject);
            return registry != null ? registry.getDDL(basicDBObject, action) : this.getDDLNotAvailable(basicDBObject);
        }
        catch (Exception e) {
            Logger.warn(this.getClass(), (String)("getDDL - " + e.getMessage()));
            throw e;
        }
    }

    private IObjectDDL getRegistry(BasicDBObject basicDBObject) {
        String key = this.getKey(basicDBObject);
        IObjectDDL registry = DDLRegistry.getInstanceFor(key);
        return registry;
    }

    private String getDDLNotAvailable(BasicDBObject basicDBObject) {
        return DDLResources.format("DDL_NOT_AVAIL", ConnectionResolver.getDisplayName((String)basicDBObject.getConnectionName()), basicDBObject.getSchemaName(), basicDBObject.getObjectType(), basicDBObject.getObjectName());
    }

    private String getKey(BasicDBObject basicDBObject) {
        String key = basicDBObject.getKey().replace(" ", "_");
        if ("Oracle#PUBLIC_SYNONYM".equals(key)) {
            key = "Oracle#SYNONYM";
        } else if ("Oracle#PUBLIC_DATABASE_LINK".equals(key)) {
            key = "Oracle#DATABASE_LINK";
        }
        return key;
    }

    public String getCopyDDL(BasicDBObject basicDBObject) throws Exception {
        try {
            this.checkFormat();
            IObjectDDL registry = this.getRegistry(basicDBObject);
            return registry != null ? registry.getCopyDDL(basicDBObject) : this.getDDLNotAvailable(basicDBObject);
        }
        catch (Exception e) {
            Logger.warn(this.getClass(), (String)("getDDL - " + e.getMessage()));
            throw e;
        }
    }

    public String getScriptDDL(BasicDBObject basicDBObject) throws Exception {
        try {
            this.checkFormat();
            IObjectDDL registry = this.getRegistry(basicDBObject);
            return registry != null ? registry.getScriptDDL(basicDBObject) : this.getDDLNotAvailable(basicDBObject);
        }
        catch (Exception e) {
            Logger.warn(this.getClass(), (String)("getDDL - " + e.getMessage()));
            throw e;
        }
    }
}

