/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.extension.pushdpopddirs.commands.pushd;

import java.sql.Connection;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import oracle.dbtools.extension.pushdpopddirs.commands.Messages;
import oracle.dbtools.extension.pushdpopddirs.commands.pushd.DirectoryAction;
import oracle.dbtools.extension.pushdpopddirs.service.DirectoryManager;
import oracle.dbtools.raptor.newscriptrunner.CommandListener;
import oracle.dbtools.raptor.newscriptrunner.IHelp;
import oracle.dbtools.raptor.newscriptrunner.ISQLCommand;
import oracle.dbtools.raptor.newscriptrunner.ScriptRunnerContext;
import oracle.dbtools.raptor.newscriptrunner.util.help.HelpPages;
import oracle.dbtools.raptor.newscriptrunner.util.help.HelpPagesBuilder;
import oracle.dbtools.raptor.newscriptrunner.util.parser.CommandPageAssemblers;
import oracle.dbtools.raptor.newscriptrunner.util.parser.ExpressionBuilder;
import oracle.dbtools.raptor.newscriptrunner.util.parser.Factory;
import oracle.dbtools.raptor.newscriptrunner.util.parser.Grammar;
import oracle.dbtools.raptor.newscriptrunner.util.parser.Id;
import oracle.dbtools.raptor.newscriptrunner.util.parser.ParsedCommand;
import oracle.dbtools.raptor.newscriptrunner.util.parser.Parser;
import oracle.dbtools.raptor.newscriptrunner.util.parser.Type;

public class PushdCommand
extends CommandListener
implements IHelp {
    private final String PUSHD_CMD = "PUSHD";

    public boolean handleEvent(Connection conn, ScriptRunnerContext ctx, ISQLCommand cmd) {
        if (!this.matches(cmd.getSql())) {
            return false;
        }
        String command = this.handleMinusCase(cmd);
        Type type = this.getParserType();
        Parser parser = new Parser(type, ctx.getEnvironment());
        Optional parsedCommand = parser.parse(command, arg_0 -> ((ScriptRunnerContext)ctx).writeln(arg_0));
        if (parsedCommand.isPresent()) {
            BiConsumer biConsumer = (BiConsumer)((ParsedCommand)parsedCommand.get()).getGrammarValue();
            boolean isFlagSet = ((ParsedCommand)parsedCommand.get()).isFlagSet((Id)Symbol.N);
            if (!Objects.isNull(biConsumer)) {
                biConsumer.accept(ctx, (ParsedCommand)parsedCommand.get());
            } else if (!isFlagSet) {
                DirectoryManager directoryManager = (DirectoryManager)ctx.getService(DirectoryManager.class);
                String navigateToFirstPositionParam = "+1";
                directoryManager.navigateStack(ctx, directoryManager, "+1", directoryManager::pushPlus);
            } else {
                ctx.writeln(Messages.getString("COMMAND_NOT_SUPPORTED"));
                ctx.writeln("Command not supported");
            }
        }
        return true;
    }

    private String handleMinusCase(ISQLCommand command) {
        String trimmedCmd = command.getSql().trim();
        if (trimmedCmd.length() > "PUSHD".length()) {
            int firstSpaceIndex = 6;
            String cmdParam = trimmedCmd.substring(6).trim();
            boolean minusIndex = true;
            if (cmdParam.startsWith("-") && cmdParam.substring(1).chars().allMatch(Character::isDigit)) {
                command.setSql("pushd _" + cmdParam.substring(1));
            }
        }
        return command.getSql();
    }

    public void beginEvent(Connection conn, ScriptRunnerContext ctx, ISQLCommand cmd) {
    }

    public void endEvent(Connection conn, ScriptRunnerContext ctx, ISQLCommand cmd) {
    }

    public Type getParserType() {
        return this.createType();
    }

    public String getCommand() {
        return "PUSHD";
    }

    public Optional<String> getHelp(ScriptRunnerContext ctx, String pagePath) {
        return this.createHelpPages(ctx, this.createType()).get(pagePath);
    }

    public boolean isSqlPlus() {
        return false;
    }

    public Type createType() {
        Grammar grammar = Factory.grammar().dataType(BiConsumer.class).add(Factory.rule((Id)Symbol.START_RULE).helpId().eq((ExpressionBuilder)Factory.qmark((ExpressionBuilder)Factory.ref(DirectoryAction::new, (Id)Symbol.DIRECTORY_RULE)))).add(Factory.rule((Id)Symbol.DIRECTORY_RULE).helpId().flattened().eq((ExpressionBuilder)Factory.var((String)"directory-path", String.class))).build();
        return Factory.type((Id)Symbol.PUSHD).add(Factory.option((Id)Symbol.N).name("n").flag().build()).set(grammar).build();
    }

    private boolean matches(String line) {
        String command;
        String trimmed = line.trim();
        if (trimmed.equalsIgnoreCase(command = this.getCommand())) {
            return true;
        }
        int firstSpace = trimmed.indexOf(" ");
        if (firstSpace > 0) {
            String firstWord = line.substring(0, firstSpace);
            return firstWord.equalsIgnoreCase(command);
        }
        return false;
    }

    private HelpPages createHelpPages(ScriptRunnerContext ctx, Type type) {
        return new HelpPagesBuilder(ctx.getEnvironment()).enableColorCode(ctx.isCommandLine()).addHelpContainerFor((Object)this).addPages((Iterable)new CommandPageAssemblers(type, new Type[0])).build();
    }

    public static enum Symbol implements Id
    {
        START_RULE,
        PUSHD,
        DIRECTORY_RULE,
        N;

    }
}

