/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.premigration.reports.text.serialization;

import com.oracle.premigration.commons.lang.Language;
import com.oracle.premigration.reports.PDBAnalysisSummary;
import com.oracle.premigration.reports.text.TextReportContext;
import com.oracle.premigration.reports.text.TextReportSection;
import com.oracle.premigration.reports.text.serialization.TextReportField;
import com.oracle.premigration.reports.text.serialization.TextReportPdbSummary;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;

public class TextReportPdbSummaryList
extends TextReportField {
    Language lang = Language.getInstance();
    List<TextReportPdbSummary> pdbSummaryList = new ArrayList<TextReportPdbSummary>();

    public TextReportPdbSummaryList(TextReportContext reportContext, Field field, Object owningObject) {
        super(reportContext, field, owningObject);
        this.ingestPdbList(owningObject);
    }

    private void ingestPdbList(Object owningObject) {
        List pdbSummaries = (List)this.value;
        for (PDBAnalysisSummary pdbAnalysisSummary : pdbSummaries) {
            TextReportPdbSummary pdbTextSummary = new TextReportPdbSummary(this.reportContext, this.field, owningObject, pdbAnalysisSummary);
            this.pdbSummaryList.add(pdbTextSummary);
        }
    }

    @Override
    public void printText(TextReportSection section) {
        this.reportContext.getPrintWriter().println();
        this.reportContext.getPrintWriter().println(this.reportContext.getDashedLine());
        this.reportContext.getPrintWriter().println(this.lang.txt(this.getLabelKey()));
        for (TextReportPdbSummary pdbSummary : this.pdbSummaryList) {
            pdbSummary.printText(section);
        }
        this.reportContext.getPrintWriter().println(this.reportContext.getDashedLine());
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TextReportPdbSummaryList)) {
            return false;
        }
        TextReportPdbSummaryList other = (TextReportPdbSummaryList)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Language this$lang = this.lang;
        Language other$lang = other.lang;
        if (this$lang == null ? other$lang != null : !this$lang.equals(other$lang)) {
            return false;
        }
        List<TextReportPdbSummary> this$pdbSummaryList = this.pdbSummaryList;
        List<TextReportPdbSummary> other$pdbSummaryList = other.pdbSummaryList;
        return !(this$pdbSummaryList == null ? other$pdbSummaryList != null : !((Object)this$pdbSummaryList).equals(other$pdbSummaryList));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof TextReportPdbSummaryList;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Language $lang = this.lang;
        result = result * 59 + ($lang == null ? 43 : $lang.hashCode());
        List<TextReportPdbSummary> $pdbSummaryList = this.pdbSummaryList;
        result = result * 59 + ($pdbSummaryList == null ? 43 : ((Object)$pdbSummaryList).hashCode());
        return result;
    }
}

