/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.premigration.dbinspector.checks;

import com.oracle.premigration.commons.enums.LockdownProfile;
import com.oracle.premigration.commons.enums.MigrationMethod;
import com.oracle.premigration.commons.enums.TargetCloud;
import com.oracle.premigration.dbinspector.Check;
import com.oracle.premigration.dbinspector.CheckResult;
import com.oracle.premigration.dbinspector.ExecutionContext;
import com.oracle.premigration.helpers.SqlUtils;
import java.util.Arrays;
import java.util.List;

public class has_owner_mismatch_index_table
extends Check {
    public has_owner_mismatch_index_table() {
        this.getLockdownProfiles().addAll(Arrays.asList(LockdownProfile.PAAS_ATPD, LockdownProfile.ADW_ADWD, LockdownProfile.NONE, LockdownProfile.DWCS_ADWS, LockdownProfile.OLTP_ATPS, LockdownProfile.ADB_UNSUPPORTED, LockdownProfile.NOT_AUTONOMOUS));
        this.getTargetCloud().addAll(Arrays.asList(TargetCloud.ADWD, TargetCloud.ADWS, TargetCloud.ATPD, TargetCloud.ATPS, TargetCloud.DEFAULT));
        this.getMigrationMethods().addAll(Arrays.asList(MigrationMethod.GOLDENGATE, MigrationMethod.DATAPUMP, MigrationMethod.DATAPUMP_DBLINK, MigrationMethod.ALL));
        this.setScope(Check.Scope.SCHEMA);
        this.setDeclarativeResult(CheckResult.WARNING);
        this.setGrouping(Check.Group.SOURCE);
    }

    @Override
    public void prepare(ExecutionContext exeCtx) {
        List<String> targetSchemas = exeCtx.getSourceSchemas();
        List<String> excludeSchemas = exeCtx.getExcludeSchemas();
        if (targetSchemas != null && !targetSchemas.isEmpty()) {
            targetSchemas.add("SYS");
            targetSchemas.add("SYSTEM");
        } else {
            excludeSchemas.remove("SYS");
            excludeSchemas.remove("SYSTEM");
        }
        String ownerClause = SqlUtils.createConjunctionClauseForColumn(exeCtx, "a.OWNER", "");
        String ownerTableClause = SqlUtils.createConjunctionClauseForColumn(exeCtx, "a.table_owner", "OR");
        String sqlQuery = "select a.table_owner, a.table_name, a.owner, a.index_name from dba_indexes a, dba_indexes b  where a.table_owner = b.table_owner and a.table_name = b.table_name and a.owner = b.owner and a.index_name = b.index_name  and a.table_owner <> b.owner  AND (" + ownerClause + ownerTableClause + ")";
        this.setSqlQuery(sqlQuery);
    }
}

