/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.premigration.dbinspector.checks;

import com.oracle.premigration.commons.enums.Version;
import com.oracle.premigration.dbinspector.CheckResult;
import com.oracle.premigration.dbinspector.ExecutionContext;
import com.oracle.premigration.dbinspector.checks.gg_not_unique_base;
import com.oracle.premigration.helpers.SqlUtils;

public class gg_not_unique
extends gg_not_unique_base {
    public gg_not_unique() {
        this.setDeclarativeResult(CheckResult.WARNING);
    }

    @Override
    public void prepare(ExecutionContext exeCtx) {
        boolean is19cOrHigher;
        boolean bl = is19cOrHigher = Version.V19_1_0_0.compare(exeCtx.getDatabaseVersion()) <= 0;
        if (!is19cOrHigher) {
            this.skipCheck(this.lang.txt("CHECK_SKIPPED_BECAUSE_UNSUPPORTED_VERSION", this.getName(), "19c", "higher"), CheckResult.PASS);
            return;
        }
        String whereClause = SqlUtils.createWhereClauseForOwnerColumn(exeCtx);
        String sqlQuery = "WITH redo_compat as        (select p.value compat from v$parameter p          where p.name = 'compatible'), mod_dba_goldengate_not_unique AS (select * from (select owner, name table_name,         decode((select count(c.obj#)                 from sys.col$ c                 where c.obj# = l.obj#                 and ((c.type# in (8,                             /* LONG */                                   24,                        /* LONG RAW */                                   58,                             /* XML */                                   112,                           /* CLOB */                                   113,                           /* BLOB */                                   121,                            /* ADT */                                   123                     /* Named Array */                      ))                 or (c.type# in (1,23) and bitand(c.property, 128) = 128))),                 /* 32k varchar */                 0, 'N', 'Y') bad_column  from (    select u.owner, u.name, u.type#, u.obj#, u.gensby    from sys.ogg_support_tab_11_2 u, redo_compat c    where c.compat like '11.2%' and c.compat not like '11.2.0.3%'                                and c.compat not like '11.2.0.4%'    UNION ALL    select u.owner, u.name, u.type#, u.obj#, u.gensby    from sys.ogg_support_tab_11_2b u, redo_compat c    where c.compat like '11.2.0.3%' or c.compat like '11.2.0.4%'    UNION ALL    select u.owner, u.name, u.type#, u.obj#, u.gensby    from sys.ogg_support_tab_12_1 u, redo_compat c    where c.compat like '12.0%' or c.compat like '12.1%'    UNION ALL    select u.owner, u.name, u.type#, u.obj#, u.gensby    from sys.ogg_support_tab_12_2 u, redo_compat c    where c.compat like '12.2%' and c.compat not like '12.2.0.2%'    UNION ALL    select u.owner, u.name, u.type#, u.obj#, u.gensby    from sys.ogg_support_tab_12_2_0_2 u, redo_compat c    where c.compat like '12.2.0.2%' or c.compat like '18.0%'          or c.compat like '18.1%'    UNION ALL    select u.owner, u.name, u.type#, u.obj#, u.gensby    from sys.ogg_support_tab_19 u,  redo_compat c    where c.compat like '19.%'  ) l, sys.tab$ t, (select i.bo# obj# from sys.ind$ i, sys.icol$ ic, sys.col$ c        where 1=1          and ic.obj# = i.obj#          and c.col# = ic.col#          and c.obj# = i.bo#          and i.type# = 1                                          /* Btree */          and bitand(i.property, 1) = 1                           /* Unique */          and bitand(c.property, 8) = 0                      /* not virtual */          and not exists (select null            from sys.icol$ icol2, sys.col$ col2            where              icol2.obj# = i.obj# and              icol2.bo#  = col2.obj# and              icol2.intcol# = col2.intcol# and              (bitand(col2.property, 1192) != 0 and        /* 1024+128+32+8 */               bitand(col2.property, 4503599627370496) = 0)) union select cd.obj# from sys.cdef$ cd                       /*       bit 0x4: sys validated */        where 1=1              /*       bit 0x20: rely         */          and cd.type# = 2          and bitand(cd.defer, 37) in (4, 32, 36)          and not exists (select null            from sys.ccol$ ccol3, sys.col$ col3            where ccol3.con# = cd.con# and                  ccol3.obj# = cd.obj# and                  ccol3.obj# = col3.obj# and                  ccol3.intcol# = col3.intcol# and                  (bitand(col3.property, 1192) != 0 and    /* 1024+128+32+8 */                   bitand(col3.property, 4503599627370496) = 0))) uniqobj  where gensby in (0,1,2)    and l.type# = 2    and l.obj# = t.obj#    and (bitand(t.property, 4097) != 1) /* 0x1 & ~0x1000 => TT w/sys-gen OID */                                            /* Typed tables with sys-gen OID */                                                  /* always have a valid key */    and l.obj# = uniqobj.obj#(+)    and uniqobj.obj# IS NULL /* this, with the above outer join is equivalent to NOT EXISTS */        /* These schemas are special to OGG and not returned by above query*/        and owner not in                ('AURORA$JIS$UTILITY$',                'AURORA$ORB$UNAUTHENTICATED',                'DSSYS',                'OSE$HTTP$ADMIN',                'PERFSTAT',                'REPADMIN',                'TRACESVR',                'VECSYS',                /* exclude internal schemas from system.logstdby$skip_support where action = 0 */                'ANONYMOUS',                'APPQOSSYS',                'AUDSYS',                'BI',                'CTXSYS',                'DBSFWUSER',                'DBSNMP',                'DIP',                'DMSYS',                'DVF',                'DVSYS',                'EXDSYS',                'EXFSYS',                'GGSYS',                'GSMADMIN_INTERNAL',                'GSMCATUSER',                'GSMROOTUSER',                'GSMUSER',                'LBACSYS',                'MDSYS',                'MGMT_VIEW',                'MTSSYS',                'ODM',                'ODM_MTR',                'OJVMSYS',                'OLAPSYS',                'ORACLE_OCM',                'ORDDATA',                'ORDPLUGINS',                'ORDSYS',                'OUTLN',                'REMOTE_SCHEDULER_AGENT',                'SI_INFORMTN_SCHEMA',                'SPATIAL_CSW_ADMIN',                'SPATIAL_CSW_ADMIN_USR',                'SPATIAL_WFS_ADMIN',                'SPATIAL_WFS_ADMIN_USR',                'SYS',                'SYS$UMF',                'SYSBACKUP',                'SYSDG',                'SYSKM',                'SYSMAN',                'SYSRAC',                'SYSTEM',                'TSMSYS',                'WKPROXY',                'WKSYS',                'WK_TEST',                'WMSYS',                'XDB',                'XS$NULL',                'XTISYS')        /* exclude internal tables*/        and name not like 'AQ$%'        and name not like 'DR$%$%'        and name not like 'M%_%$$'        and name not like 'MLOG$%'        and name not like 'OGGQT$%'        and name not like 'OGG$%'        and name not like 'RUPD$%'        and name not like 'SYS_C%'        and name not like 'MDR%_%$'        and name not like 'SYS_IMPORT_TABLE%'        and name not like 'ET$%'        and name not like 'CMP%$%'        and name not like 'DBMS_TABCOMP_TEMP_%'        and name not like 'SCHEDULER$_%_ARG'        and name not like 'MDXT_%$%'        and name not like '%IOT_OVER%'        and name not like 'DT$_%'        /* Exclude DM$ tables */        and t.obj# not in (select obj# from sys.modeltab$)) where rownum > 0), nonuniqtabs AS (SELECT tab.* FROM mod_dba_goldengate_not_unique g, (SELECT t.owner, t.table_name, t.num_rows,   nvl(sysdate - last_analyzed, -1) AS since_analysis   FROM dba_tables t where rownum > 0) tab WHERE tab.owner = g.owner AND tab.table_name = g.table_name), tabdata AS (SELECT * FROM (select t.owner, t.table_name, sum(nvl(p.num_rows,t.num_rows)) nokeyrows, nvl(sum(nvl(sp.bytes,st.bytes))/(1024*1024*1024),-1) tabszgb, any_value(t.since_analysis) days_since_analysis, any_value(m.ins/t.since_analysis)  ins, any_value(m.upd/t.since_analysis) upd, any_value(m.del/t.since_analysis) del from nonuniqtabs t, (select * from dba_segments where rownum > 0) st, (select * from dba_tab_partitions where rownum > 0) p, (select * from dba_segments where rownum > 0) sp, (select * from (select table_owner, table_name, sum(inserts) ins, sum(updates) upd,    sum(deletes) del, 0 disallowed    from dba_tab_modifications group by table_owner, table_name) where rownum > 0) m where 1=1 and t.table_name = m.table_name(+) and t.owner = m.table_owner(+) and since_analysis != m.disallowed(+) and st.segment_name(+) = t.table_name and st.owner(+) = t.owner and st.segment_type(+) != 'TABLE_PARTITION' and p.table_name(+) = t.table_name and p.table_owner(+) = t.owner and sp.owner(+) = p.table_owner and sp.segment_name(+) = p.table_name and sp.partition_name(+) = p.partition_name and sp.segment_type(+) = 'TABLE_PARTITION' and t.owner NOT IN ('CTXSYS','DVSYS', 'LBACSYS','MDSYS','ORDSYS','SYS','SYSTEM') and t.table_name not like '%$%' group by t.owner, t.table_name) WHERE ROWNUM > 0), inddata AS (SELECT * FROM (select t.owner, t.table_name, count(distinct t.owner||','||i.index_name) nokeyinds, sum(nvl(p.num_rows,i.num_rows)) nokeyrows, nvl(sum(nvl(sp.bytes,st.bytes))/(1024*1024*1024),-1) nokeyindszgb from (select * from mod_dba_goldengate_not_unique where rownum > 0) g, dba_tables t, (select * from dba_indexes where rownum > 0) i, (select * from dba_segments where rownum > 0) st, (select * from dba_ind_partitions where rownum > 0) p, (select * from dba_segments where rownum > 0) sp where g.table_name = t.table_name and g.owner = t.owner and t.owner = i.table_owner and t.table_name = i.table_name and st.segment_name(+) = i.index_name and st.owner(+) = i.owner and st.segment_type(+) != 'INDEX PARTITION' and p.index_name(+) = i.index_name and p.index_owner(+) = i.owner and sp.owner(+) = p.index_owner and sp.segment_name(+) = p.index_name and sp.partition_name(+) = p.partition_name and sp.segment_type(+) = 'INDEX PARTITION' and t.owner NOT IN ('CTXSYS','DVSYS', 'LBACSYS','MDSYS','ORDSYS','SYS','SYSTEM') and t.table_name not like '%$%' group by t.owner, t.table_name) WHERE ROWNUM > 0), gglines as (SELECT t.owner, t.table_name, t.nokeyrows, t.tabszgb, t.days_since_analysis, (NVL(t.upd,0)+NVL(t.del,0))/t.days_since_analysis updplusdelperday, nvl(i.nokeyinds, 0) nokeyinds,  nvl(i.nokeyindszgb,0) indsszgb FROM tabdata t, inddata i where t.owner = i.owner(+) AND t.table_name = i.table_name(+)), ggparams as (select 160.375 impexpsecpergb, 270.833 indimpsecpergb, 102.5 ggwind,        54.582 ggwoind, 7 safedayssince, 0.01 fracsaferows, 1 targetratio,       100 minggcutoversec from dual), gglinescalc as (select ggl.*, (p.impexpsecpergb*greatest(ggl.TABSZGB,0)+                p.indimpsecpergb*greatest(ggl.INDSSZGB,0))/3600 impexphr,        ggl.UPDPLUSDELPERDAY*DECODE(ggl.NOKEYINDS,0,                                     ggl.TABSZGB*p.ggwoind/1000,                                     p.ggwind/1000000)/3600 ggcalchrperday,        (CASE WHEN DAYS_SINCE_ANALYSIS < safedayssince                THEN ggl.NOKEYROWS*p.fracsaferows        ELSE ggl.UPDPLUSDELPERDAY END)*DECODE(ggl.NOKEYINDS,0,                                     ggl.TABSZGB*p.ggwoind/1000,                                     p.ggwind/1000000)/3600 ggsafehrperday,        p.targetratio, p.safedayssince, p.minggcutoversec                        FROM gglines ggl, ggparams p), gglinescalc2 as (select ggl.*, DECODE(impexphr,0,0,ggcalchrperday/impexphr) ggratiocalc,        DECODE(impexphr,0,0,ggsafehrperday/impexphr) ggratiosafe        from gglinescalc ggl), gglinescalc3 as (select ggl.*, CASE WHEN (ggratiocalc > targetratio                          AND ggratiocalc >= ggratiosafe                           AND ggcalchrperday*3600 > minggcutoversec)                THEN 1 ELSE 0 END calcflag        from gglinescalc2 ggl), gglinescalc4 as (select ggl.*, CASE WHEN (calcflag = 0                AND ggratiosafe > targetratio                AND ggsafehrperday*3600 > minggcutoversec)        THEN 1 ELSE 0 END safeflag from gglinescalc3 ggl), ggsummary as (SELECT 'summary_of' owner, count(*)||'_gg_nonuniq_tables' table_name,        sum(calcflag) calctables, sum(safeflag) safetables,        sum(DECODE(calcflag,1,impexphr,0)) calccutoverhrs,        sum(DECODE(safeflag,1,impexphr,0)) safecutoverhrs,        sum(impexphr) all_empexphr,        sum(CASE WHEN (calcflag=0 and safeflag=0)                THEN greatest(ggcalchrperday,ggsafehrperday)                ELSE 0 END) gghrsperday,        9999 ggworstratio,        9999 days_since_analysis,        sum(TABSZGB+INDSSZGB) tab_plus_ind_sz_gb,        sum(NOKEYROWS) NOKEYROWS,        sum(updplusdelperday) calc_dmlperday         from gglinescalc4) SELECT owner, table_name FROM gglinescalc4" + whereClause + " AND calcflag+safeflag > 0  ORDER BY 1, 2";
        this.setSqlQuery(sqlQuery);
    }
}

