/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.premigration.dbinspector.checks;

import com.oracle.premigration.commons.enums.LockdownProfile;
import com.oracle.premigration.commons.enums.MigrationMethod;
import com.oracle.premigration.commons.enums.TargetCloud;
import com.oracle.premigration.dbinspector.Check;
import com.oracle.premigration.dbinspector.CheckResult;
import com.oracle.premigration.dbinspector.ExecutionContext;
import com.oracle.premigration.dbinspector.fixups.Fixable;
import com.oracle.premigration.dbinspector.fixups.Fixup;
import com.oracle.premigration.helpers.SqlUtils;
import com.oracle.premigration.helpers.Utilities;
import com.oracle.premigration.logger.PremigrationLogger;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;

public class dp_has_low_streams_pool_size
extends Check
implements Fixable {
    private static final PremigrationLogger log = PremigrationLogger.getLogger(dp_has_low_streams_pool_size.class.getName());
    private static final List<String> PARAMS = Arrays.asList("streams_pool_size", "sga_target", "memory_target");
    boolean usingOGG = false;

    public dp_has_low_streams_pool_size() {
        this.getLockdownProfiles().addAll(Arrays.asList(LockdownProfile.NONE, LockdownProfile.NOT_AUTONOMOUS));
        this.getTargetCloud().addAll(Arrays.asList(TargetCloud.ATPS, TargetCloud.ATPD, TargetCloud.ADWD, TargetCloud.ADWS, TargetCloud.DEFAULT));
        this.getMigrationMethods().addAll(Arrays.asList(MigrationMethod.DATAPUMP, MigrationMethod.DATAPUMP_DBLINK));
        this.setScope(Check.Scope.UNIVERSAL);
        this.setGrouping(Check.Group.SOURCE);
    }

    @Override
    public void prepare(ExecutionContext exeCtx) {
        this.setSqlQuery("SELECT LOWER(NAME) AS NAME,CAST(VALUE AS VARCHAR2(100)) AS VALUE FROM V$PARAMETER " + SqlUtils.createWhereInClause("LOWER(NAME)", PARAMS));
        this.usingOGG = exeCtx.isUsingOGG();
    }

    @Override
    public CheckResult determineResult() {
        if (this.getRelevantObjectsData() == null || this.getRelevantObjectsData().size() != PARAMS.size()) {
            this.processInvalidValue("Database Parameters");
            return CheckResult.FATAL;
        }
        long streamsPoolSize = 0L;
        long sgaTarget = 0L;
        long memoryTarget = 0L;
        block12: for (int i = 0; i < PARAMS.size(); ++i) {
            long numValue;
            String key = this.getRelevantObjectsData().get(i).get("NAME");
            String strValue = this.getRelevantObjectsData().get(i).get("VALUE");
            try {
                numValue = Utilities.stringToLong(strValue);
            }
            catch (Exception e) {
                this.processInvalidValue(key, e);
                return CheckResult.FATAL;
            }
            switch (key) {
                case "streams_pool_size": {
                    streamsPoolSize = numValue;
                    continue block12;
                }
                case "sga_target": {
                    sgaTarget = numValue;
                    continue block12;
                }
                case "memory_target": {
                    memoryTarget = numValue;
                    continue block12;
                }
                default: {
                    throw new IllegalArgumentException("Unexpected key: " + key);
                }
            }
        }
        log.trace("using " + sgaTarget + " as " + "sga_target");
        log.trace("using " + streamsPoolSize + " as " + "streams_pool_size");
        log.trace("using " + memoryTarget + " as " + "memory_target");
        if (streamsPoolSize > 0L) {
            if (this.usingOGG && streamsPoolSize < 0x50000000L) {
                String oggActionAddendum = this.lang.txt("CHECK.DP_HAS_LOW_STREAMS_POOL_SIZE.ACTION_WITH_OGG");
                this.setAction(this.getAction() + oggActionAddendum);
            }
            return CheckResult.PASS;
        }
        if (sgaTarget > 0L || memoryTarget > 0L) {
            return CheckResult.INFORMATIONAL;
        }
        return CheckResult.PASS;
    }

    @Override
    public void generateFixups(ExecutionContext exeCtx) throws IOException {
        String parentFolderPath = exeCtx.getOutputFilenamesContainer().getOutDir();
        String fixupName = "dp_set_streams_pool_size";
        Fixup.Locus locus = Fixup.Locus.source;
        Fixup fixupObject = Fixup.createStaticSqlFixupBuilder("dp_set_streams_pool_size", locus, parentFolderPath).runAtCDBLevel(exeCtx.isDatabaseIsCDB()).restartRequired(true).build();
        this.generateStaticFixup(fixupObject);
    }
}

