/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.premigration.dbinspector.addinform.supplemental;

import com.oracle.premigration.dbinspector.ExecutionContext;
import com.oracle.premigration.helpers.SqlUtils;
import com.oracle.premigration.helpers.Utilities;
import com.oracle.premigration.logger.PremigrationLogger;
import com.oracle.premigration.reports.html.sections.HtmlProperty;
import com.oracle.premigration.reports.html.sections.HtmlReportSectionName;
import com.oracle.premigration.reports.json.CpatJsonPropertyDescription;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;

public class HighWaterMarkStat {
    private static final PremigrationLogger log = PremigrationLogger.getLogger(HighWaterMarkStat.class.getName());
    @HtmlProperty(labelKey="SRC_HWM_DBID", section=HtmlReportSectionName.SRC_SUPPLEMENTAL_INFORMATION, isClassInfo=false)
    @CpatJsonPropertyDescription(value="The DBID")
    private Long dbid;
    @HtmlProperty(labelKey="SRC_HWM_NAME", section=HtmlReportSectionName.SRC_SUPPLEMENTAL_INFORMATION, isClassInfo=false)
    @CpatJsonPropertyDescription(value="The name of the high water mark statistic")
    private String name;
    @HtmlProperty(labelKey="SRC_HWM_VERSION", section=HtmlReportSectionName.SRC_SUPPLEMENTAL_INFORMATION, isClassInfo=false)
    @CpatJsonPropertyDescription(value="The version for the high water mark statistic")
    private String version;
    @HtmlProperty(labelKey="SRC_HWM_VALUE", section=HtmlReportSectionName.SRC_SUPPLEMENTAL_INFORMATION, isClassInfo=false)
    @CpatJsonPropertyDescription(value="The high water value of the high water mark statistic")
    private Double highWaterValue;
    @HtmlProperty(labelKey="SRC_HWM_LAST_VALUE", section=HtmlReportSectionName.SRC_SUPPLEMENTAL_INFORMATION, isClassInfo=false)
    @CpatJsonPropertyDescription(value="The last value of the high water mark statistic")
    private Double lastValue;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<HighWaterMarkStat> getHighWaterMarkData(ExecutionContext exeCtx) throws SQLException {
        ArrayList<HighWaterMarkStat> highWaterMarkData = new ArrayList<HighWaterMarkStat>();
        Connection conn = null;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        String highWaterMarkDataQuery = "SELECT h.DBID, h.NAME, h.VERSION, h.HIGHWATER, h.LAST_VALUE  FROM SYS.DBA_HIGH_WATER_MARK_STATISTICS h WHERE h.DBID IN (SELECT d.DBID FROM V$DATABASE d) ORDER BY 1, 2";
        log.fine("Fetching HWM data with query: SELECT h.DBID, h.NAME, h.VERSION, h.HIGHWATER, h.LAST_VALUE  FROM SYS.DBA_HIGH_WATER_MARK_STATISTICS h WHERE h.DBID IN (SELECT d.DBID FROM V$DATABASE d) ORDER BY 1, 2");
        long startTime = System.currentTimeMillis();
        try {
            conn = exeCtx.getConnection();
            stmt = SqlUtils.createPreparedStatement(conn, "SELECT h.DBID, h.NAME, h.VERSION, h.HIGHWATER, h.LAST_VALUE  FROM SYS.DBA_HIGH_WATER_MARK_STATISTICS h WHERE h.DBID IN (SELECT d.DBID FROM V$DATABASE d) ORDER BY 1, 2");
            rs = stmt.executeQuery();
            while (rs.next()) {
                Long dbID = rs.getLong("DBID");
                String name = rs.getString("NAME");
                String version = rs.getString("VERSION");
                Double highwater = rs.getDouble("HIGHWATER");
                Double lastValue = rs.getDouble("LAST_VALUE");
                HighWaterMarkStat hwmData = new HighWaterMarkStat(dbID, name, version, highwater, lastValue);
                highWaterMarkData.add(hwmData);
            }
            log.info("Elapsed time for query: " + Utilities.formatTimeInterval(System.currentTimeMillis() - startTime));
        }
        catch (Throwable throwable) {
            exeCtx.closeIfNotNull(rs, stmt, conn);
            throw throwable;
        }
        exeCtx.closeIfNotNull(rs, stmt, conn);
        log.fine("Count of HWM stats: " + highWaterMarkData.size());
        return highWaterMarkData;
    }

    public static HighWaterMarkStat createEmptyHighWaterMarkStat() {
        return HighWaterMarkStat.builder().build();
    }

    public static HighWaterMarkStatBuilder builder() {
        return new HighWaterMarkStatBuilder();
    }

    private HighWaterMarkStat(Long dbid, String name, String version, Double highWaterValue, Double lastValue) {
        this.dbid = dbid;
        this.name = name;
        this.version = version;
        this.highWaterValue = highWaterValue;
        this.lastValue = lastValue;
    }

    public Long getDbid() {
        return this.dbid;
    }

    public String getName() {
        return this.name;
    }

    public String getVersion() {
        return this.version;
    }

    public Double getHighWaterValue() {
        return this.highWaterValue;
    }

    public Double getLastValue() {
        return this.lastValue;
    }

    public static class HighWaterMarkStatBuilder {
        private Long dbid;
        private String name;
        private String version;
        private Double highWaterValue;
        private Double lastValue;

        HighWaterMarkStatBuilder() {
        }

        public HighWaterMarkStatBuilder dbid(Long dbid) {
            this.dbid = dbid;
            return this;
        }

        public HighWaterMarkStatBuilder name(String name) {
            this.name = name;
            return this;
        }

        public HighWaterMarkStatBuilder version(String version) {
            this.version = version;
            return this;
        }

        public HighWaterMarkStatBuilder highWaterValue(Double highWaterValue) {
            this.highWaterValue = highWaterValue;
            return this;
        }

        public HighWaterMarkStatBuilder lastValue(Double lastValue) {
            this.lastValue = lastValue;
            return this;
        }

        public HighWaterMarkStat build() {
            return new HighWaterMarkStat(this.dbid, this.name, this.version, this.highWaterValue, this.lastValue);
        }

        public String toString() {
            return "HighWaterMarkStat.HighWaterMarkStatBuilder(dbid=" + this.dbid + ", name=" + this.name + ", version=" + this.version + ", highWaterValue=" + this.highWaterValue + ", lastValue=" + this.lastValue + ")";
        }
    }
}

