/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.premigration.dbinspector.addinform.supplemental;

import com.oracle.premigration.dbinspector.ExecutionContext;
import com.oracle.premigration.helpers.SqlUtils;
import com.oracle.premigration.helpers.Utilities;
import com.oracle.premigration.logger.PremigrationLogger;
import com.oracle.premigration.reports.html.sections.HtmlProperty;
import com.oracle.premigration.reports.html.sections.HtmlReportSectionName;
import com.oracle.premigration.reports.json.CpatJsonPropertyDescription;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;

public class DatabaseTrigger {
    private static final PremigrationLogger log = PremigrationLogger.getLogger(DatabaseTrigger.class.getName());
    @HtmlProperty(labelKey="SRC_TRIGGER_OWNER", section=HtmlReportSectionName.SRC_SUPPLEMENTAL_INFORMATION, isClassInfo=false)
    @CpatJsonPropertyDescription(value="The owner of the trigger")
    String owner;
    @HtmlProperty(labelKey="SRC_TRIGGER_NAME", section=HtmlReportSectionName.SRC_SUPPLEMENTAL_INFORMATION, isClassInfo=false)
    @CpatJsonPropertyDescription(value="Name of the trigger")
    String triggerName;
    @HtmlProperty(labelKey="SRC_TRIGGER_TYPE", section=HtmlReportSectionName.SRC_SUPPLEMENTAL_INFORMATION, isClassInfo=false)
    @CpatJsonPropertyDescription(value="When the trigger fires. e.g. 'AFTER EVENT'")
    String triggerType;
    @HtmlProperty(labelKey="SRC_TRIGGER_EVENT", section=HtmlReportSectionName.SRC_SUPPLEMENTAL_INFORMATION, isClassInfo=false)
    @CpatJsonPropertyDescription(value="DML, DDL, or database event that fires the trigger")
    String triggeringEvent;
    @HtmlProperty(labelKey="SRC_TRIGGER_TABLE_OWNER", section=HtmlReportSectionName.SRC_SUPPLEMENTAL_INFORMATION, isClassInfo=false)
    @CpatJsonPropertyDescription(value="Owner of the table on which the trigger is defined")
    String tableOwner;
    @HtmlProperty(labelKey="SRC_TRIGGER_OBJECT_TYPE", section=HtmlReportSectionName.SRC_SUPPLEMENTAL_INFORMATION, isClassInfo=false)
    @CpatJsonPropertyDescription(value="Base object on which the trigger is defined")
    String baseObjectType;
    @HtmlProperty(labelKey="SRC_TRIGGER_TABLE_NAME", section=HtmlReportSectionName.SRC_SUPPLEMENTAL_INFORMATION, isClassInfo=false)
    @CpatJsonPropertyDescription(value="If the base object type of the trigger is SCHEMA or DATABASE, then this column is NULL; if the base object type of the trigger is TABLE or VIEW, then this column indicates the table or view name on which the trigger is defined")
    String tableName;
    @HtmlProperty(labelKey="SRC_TRIGGER_COLUMN_NAME", section=HtmlReportSectionName.SRC_SUPPLEMENTAL_INFORMATION, isClassInfo=false)
    @CpatJsonPropertyDescription(value="Name of the nested table column (if a nested table trigger), else NULL")
    String columnName;
    @HtmlProperty(labelKey="SRC_TRIGGER_REF_NAMES", section=HtmlReportSectionName.SRC_SUPPLEMENTAL_INFORMATION, isClassInfo=false)
    @CpatJsonPropertyDescription(value="Names used for referencing OLD and NEW column values from within the trigger")
    String referencingNames;
    @HtmlProperty(labelKey="SRC_TRIGGER_WHEN_CLAUSE", section=HtmlReportSectionName.SRC_SUPPLEMENTAL_INFORMATION, isClassInfo=false)
    @CpatJsonPropertyDescription(value="Must evaluate to TRUE for TRIGGER_BODY to execute")
    String whenClause;
    @HtmlProperty(labelKey="SRC_TRIGGER_STATUS", section=HtmlReportSectionName.SRC_SUPPLEMENTAL_INFORMATION, isClassInfo=false)
    @CpatJsonPropertyDescription(value="Indicates whether the trigger is enabled (ENABLED) or disabled (DISABLED); a disabled trigger will not fire")
    String status;
    @HtmlProperty(labelKey="SRC_TRIGGER_DESCRIPTION", section=HtmlReportSectionName.SRC_SUPPLEMENTAL_INFORMATION, isClassInfo=false)
    @CpatJsonPropertyDescription(value="Trigger description; useful for re-creating a trigger creation statement")
    String description;
    @HtmlProperty(labelKey="SRC_TRIGGER_ACTION_TYPE", section=HtmlReportSectionName.SRC_SUPPLEMENTAL_INFORMATION, isClassInfo=false)
    @CpatJsonPropertyDescription(value="Action type of the trigger body: 'CALL' or 'PL/SQL'")
    String actionType;
    @HtmlProperty(labelKey="SRC_TRIGGER_CROSS_EDITION", section=HtmlReportSectionName.SRC_SUPPLEMENTAL_INFORMATION, isClassInfo=false)
    @CpatJsonPropertyDescription(value="Type of crossedition trigger: FORWARD, REVERSE, NO")
    String crossedition;
    @HtmlProperty(labelKey="SRC_TRIGGER_BEFORE_STMT", section=HtmlReportSectionName.SRC_SUPPLEMENTAL_INFORMATION, isClassInfo=false)
    @CpatJsonPropertyDescription(value="Indicates whether the trigger has a BEFORE STATEMENT section (YES) or not (NO)")
    String beforeStatement;
    @HtmlProperty(labelKey="SRC_TRIGGER_BEFORE_ROW", section=HtmlReportSectionName.SRC_SUPPLEMENTAL_INFORMATION, isClassInfo=false)
    @CpatJsonPropertyDescription(value="Indicates whether the trigger has a BEFORE EACH ROW section (YES) or not (NO)")
    String beforeRow;
    @HtmlProperty(labelKey="SRC_TRIGGER_AFTER_ROW", section=HtmlReportSectionName.SRC_SUPPLEMENTAL_INFORMATION, isClassInfo=false)
    @CpatJsonPropertyDescription(value="Indicates whether the trigger has an AFTER EACH ROW section (YES) or not (NO)")
    String afterRow;
    @HtmlProperty(labelKey="SRC_TRIGGER_AFTER_STMT", section=HtmlReportSectionName.SRC_SUPPLEMENTAL_INFORMATION, isClassInfo=false)
    @CpatJsonPropertyDescription(value="Indicates whether the trigger has an AFTER STATEMENT section (YES) or not (NO)")
    String afterStatement;
    @HtmlProperty(labelKey="SRC_TRIGGER_INSTEAD_OF_ROW", section=HtmlReportSectionName.SRC_SUPPLEMENTAL_INFORMATION, isClassInfo=false)
    @CpatJsonPropertyDescription(value="Indicates whether the trigger has an INSTEAD OF section (YES) or not (NO)")
    String insteadOfRow;
    @HtmlProperty(labelKey="SRC_TRIGGER_FIRE_ONCE", section=HtmlReportSectionName.SRC_SUPPLEMENTAL_INFORMATION, isClassInfo=false)
    @CpatJsonPropertyDescription(value="Indicates whether the trigger will fire only for user processes making changes (YES) or whether the trigger will also fire for Replication Apply or SQL Apply processes (NO)")
    String fireOnce;
    @HtmlProperty(labelKey="SRC_TRIGGER_APPLY_SERVER_ONLY", section=HtmlReportSectionName.SRC_SUPPLEMENTAL_INFORMATION, isClassInfo=false)
    @CpatJsonPropertyDescription(value="Indicates whether the trigger will only fire for a Replication Apply or SQL Apply process (YES) or not (NO). If set to YES, then the setting of FIRE_ONCE does not matter.")
    String applyServerOnly;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<DatabaseTrigger> getLogonTriggerData(ExecutionContext exeCtx) throws SQLException {
        ArrayList<DatabaseTrigger> logonTriggerList = new ArrayList<DatabaseTrigger>();
        Connection conn = null;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        String logonTriggerQuery = "SELECT OWNER, TRIGGER_NAME, TRIGGER_TYPE, TRIGGERING_EVENT, TABLE_OWNER,  TRIM(BASE_OBJECT_TYPE) AS BASE_OBJECT_TYPE, TABLE_NAME, COLUMN_NAME,  REFERENCING_NAMES, WHEN_CLAUSE, STATUS, DESCRIPTION, ACTION_TYPE, CROSSEDITION, BEFORE_STATEMENT, BEFORE_ROW, AFTER_ROW, AFTER_STATEMENT,  INSTEAD_OF_ROW, FIRE_ONCE, APPLY_SERVER_ONLY FROM SYS.DBA_TRIGGERS WHERE TRIM(BASE_OBJECT_TYPE) IN ('DATABASE', 'SCHEMA') AND STATUS='ENABLED' AND OWNER NOT IN ('MDSYS','GSMADMIN_INTERNAL') ORDER BY BASE_OBJECT_TYPE, OWNER, TRIGGER_NAME";
        log.fine("Fetching logon trigger data with query: SELECT OWNER, TRIGGER_NAME, TRIGGER_TYPE, TRIGGERING_EVENT, TABLE_OWNER,  TRIM(BASE_OBJECT_TYPE) AS BASE_OBJECT_TYPE, TABLE_NAME, COLUMN_NAME,  REFERENCING_NAMES, WHEN_CLAUSE, STATUS, DESCRIPTION, ACTION_TYPE, CROSSEDITION, BEFORE_STATEMENT, BEFORE_ROW, AFTER_ROW, AFTER_STATEMENT,  INSTEAD_OF_ROW, FIRE_ONCE, APPLY_SERVER_ONLY FROM SYS.DBA_TRIGGERS WHERE TRIM(BASE_OBJECT_TYPE) IN ('DATABASE', 'SCHEMA') AND STATUS='ENABLED' AND OWNER NOT IN ('MDSYS','GSMADMIN_INTERNAL') ORDER BY BASE_OBJECT_TYPE, OWNER, TRIGGER_NAME");
        long startTime = System.currentTimeMillis();
        try {
            conn = exeCtx.getConnection();
            stmt = SqlUtils.createPreparedStatement(conn, "SELECT OWNER, TRIGGER_NAME, TRIGGER_TYPE, TRIGGERING_EVENT, TABLE_OWNER,  TRIM(BASE_OBJECT_TYPE) AS BASE_OBJECT_TYPE, TABLE_NAME, COLUMN_NAME,  REFERENCING_NAMES, WHEN_CLAUSE, STATUS, DESCRIPTION, ACTION_TYPE, CROSSEDITION, BEFORE_STATEMENT, BEFORE_ROW, AFTER_ROW, AFTER_STATEMENT,  INSTEAD_OF_ROW, FIRE_ONCE, APPLY_SERVER_ONLY FROM SYS.DBA_TRIGGERS WHERE TRIM(BASE_OBJECT_TYPE) IN ('DATABASE', 'SCHEMA') AND STATUS='ENABLED' AND OWNER NOT IN ('MDSYS','GSMADMIN_INTERNAL') ORDER BY BASE_OBJECT_TYPE, OWNER, TRIGGER_NAME");
            rs = stmt.executeQuery();
            while (rs.next()) {
                String owner = rs.getString("OWNER");
                String triggerName = rs.getString("TRIGGER_NAME");
                String triggerType = rs.getString("TRIGGER_TYPE");
                String triggeringEvent = rs.getString("TRIGGERING_EVENT");
                String tableOwner = rs.getString("TABLE_OWNER");
                String baseObjectType = rs.getString("BASE_OBJECT_TYPE");
                String tableName = rs.getString("TABLE_NAME");
                String columnName = rs.getString("COLUMN_NAME");
                String referencingNames = rs.getString("REFERENCING_NAMES");
                String whenClause = rs.getString("WHEN_CLAUSE");
                String status = rs.getString("STATUS");
                String description = rs.getString("DESCRIPTION");
                String actionType = rs.getString("ACTION_TYPE");
                String crossedition = rs.getString("CROSSEDITION");
                String beforeStatement = rs.getString("BEFORE_STATEMENT");
                String beforeRow = rs.getString("BEFORE_ROW");
                String afterRow = rs.getString("AFTER_ROW");
                String afterStatement = rs.getString("AFTER_STATEMENT");
                String insteadOfRow = rs.getString("INSTEAD_OF_ROW");
                String fireOnce = rs.getString("FIRE_ONCE");
                String applyServerOnly = rs.getString("APPLY_SERVER_ONLY");
                DatabaseTrigger logonTrigger = new DatabaseTrigger(owner, triggerName, triggerType, triggeringEvent, tableOwner, baseObjectType, tableName, columnName, referencingNames, whenClause, status, description, actionType, crossedition, beforeStatement, beforeRow, afterRow, afterStatement, insteadOfRow, fireOnce, applyServerOnly);
                logonTriggerList.add(logonTrigger);
            }
            log.info("Elapsed time for query: " + Utilities.formatTimeInterval(System.currentTimeMillis() - startTime));
        }
        catch (Throwable throwable) {
            exeCtx.closeIfNotNull(rs, stmt, conn);
            throw throwable;
        }
        exeCtx.closeIfNotNull(rs, stmt, conn);
        log.fine("Count of logon triggers: " + logonTriggerList.size());
        return logonTriggerList;
    }

    public static DatabaseTrigger createEmptyDatabaseTriggerInstance() {
        return DatabaseTrigger.builder().build();
    }

    public static DatabaseTriggerBuilder builder() {
        return new DatabaseTriggerBuilder();
    }

    private DatabaseTrigger(String owner, String triggerName, String triggerType, String triggeringEvent, String tableOwner, String baseObjectType, String tableName, String columnName, String referencingNames, String whenClause, String status, String description, String actionType, String crossedition, String beforeStatement, String beforeRow, String afterRow, String afterStatement, String insteadOfRow, String fireOnce, String applyServerOnly) {
        this.owner = owner;
        this.triggerName = triggerName;
        this.triggerType = triggerType;
        this.triggeringEvent = triggeringEvent;
        this.tableOwner = tableOwner;
        this.baseObjectType = baseObjectType;
        this.tableName = tableName;
        this.columnName = columnName;
        this.referencingNames = referencingNames;
        this.whenClause = whenClause;
        this.status = status;
        this.description = description;
        this.actionType = actionType;
        this.crossedition = crossedition;
        this.beforeStatement = beforeStatement;
        this.beforeRow = beforeRow;
        this.afterRow = afterRow;
        this.afterStatement = afterStatement;
        this.insteadOfRow = insteadOfRow;
        this.fireOnce = fireOnce;
        this.applyServerOnly = applyServerOnly;
    }

    public String getOwner() {
        return this.owner;
    }

    public String getTriggerName() {
        return this.triggerName;
    }

    public String getTriggerType() {
        return this.triggerType;
    }

    public String getTriggeringEvent() {
        return this.triggeringEvent;
    }

    public String getTableOwner() {
        return this.tableOwner;
    }

    public String getBaseObjectType() {
        return this.baseObjectType;
    }

    public String getTableName() {
        return this.tableName;
    }

    public String getColumnName() {
        return this.columnName;
    }

    public String getReferencingNames() {
        return this.referencingNames;
    }

    public String getWhenClause() {
        return this.whenClause;
    }

    public String getStatus() {
        return this.status;
    }

    public String getDescription() {
        return this.description;
    }

    public String getActionType() {
        return this.actionType;
    }

    public String getCrossedition() {
        return this.crossedition;
    }

    public String getBeforeStatement() {
        return this.beforeStatement;
    }

    public String getBeforeRow() {
        return this.beforeRow;
    }

    public String getAfterRow() {
        return this.afterRow;
    }

    public String getAfterStatement() {
        return this.afterStatement;
    }

    public String getInsteadOfRow() {
        return this.insteadOfRow;
    }

    public String getFireOnce() {
        return this.fireOnce;
    }

    public String getApplyServerOnly() {
        return this.applyServerOnly;
    }

    public static class DatabaseTriggerBuilder {
        private String owner;
        private String triggerName;
        private String triggerType;
        private String triggeringEvent;
        private String tableOwner;
        private String baseObjectType;
        private String tableName;
        private String columnName;
        private String referencingNames;
        private String whenClause;
        private String status;
        private String description;
        private String actionType;
        private String crossedition;
        private String beforeStatement;
        private String beforeRow;
        private String afterRow;
        private String afterStatement;
        private String insteadOfRow;
        private String fireOnce;
        private String applyServerOnly;

        DatabaseTriggerBuilder() {
        }

        public DatabaseTriggerBuilder owner(String owner) {
            this.owner = owner;
            return this;
        }

        public DatabaseTriggerBuilder triggerName(String triggerName) {
            this.triggerName = triggerName;
            return this;
        }

        public DatabaseTriggerBuilder triggerType(String triggerType) {
            this.triggerType = triggerType;
            return this;
        }

        public DatabaseTriggerBuilder triggeringEvent(String triggeringEvent) {
            this.triggeringEvent = triggeringEvent;
            return this;
        }

        public DatabaseTriggerBuilder tableOwner(String tableOwner) {
            this.tableOwner = tableOwner;
            return this;
        }

        public DatabaseTriggerBuilder baseObjectType(String baseObjectType) {
            this.baseObjectType = baseObjectType;
            return this;
        }

        public DatabaseTriggerBuilder tableName(String tableName) {
            this.tableName = tableName;
            return this;
        }

        public DatabaseTriggerBuilder columnName(String columnName) {
            this.columnName = columnName;
            return this;
        }

        public DatabaseTriggerBuilder referencingNames(String referencingNames) {
            this.referencingNames = referencingNames;
            return this;
        }

        public DatabaseTriggerBuilder whenClause(String whenClause) {
            this.whenClause = whenClause;
            return this;
        }

        public DatabaseTriggerBuilder status(String status) {
            this.status = status;
            return this;
        }

        public DatabaseTriggerBuilder description(String description) {
            this.description = description;
            return this;
        }

        public DatabaseTriggerBuilder actionType(String actionType) {
            this.actionType = actionType;
            return this;
        }

        public DatabaseTriggerBuilder crossedition(String crossedition) {
            this.crossedition = crossedition;
            return this;
        }

        public DatabaseTriggerBuilder beforeStatement(String beforeStatement) {
            this.beforeStatement = beforeStatement;
            return this;
        }

        public DatabaseTriggerBuilder beforeRow(String beforeRow) {
            this.beforeRow = beforeRow;
            return this;
        }

        public DatabaseTriggerBuilder afterRow(String afterRow) {
            this.afterRow = afterRow;
            return this;
        }

        public DatabaseTriggerBuilder afterStatement(String afterStatement) {
            this.afterStatement = afterStatement;
            return this;
        }

        public DatabaseTriggerBuilder insteadOfRow(String insteadOfRow) {
            this.insteadOfRow = insteadOfRow;
            return this;
        }

        public DatabaseTriggerBuilder fireOnce(String fireOnce) {
            this.fireOnce = fireOnce;
            return this;
        }

        public DatabaseTriggerBuilder applyServerOnly(String applyServerOnly) {
            this.applyServerOnly = applyServerOnly;
            return this;
        }

        public DatabaseTrigger build() {
            return new DatabaseTrigger(this.owner, this.triggerName, this.triggerType, this.triggeringEvent, this.tableOwner, this.baseObjectType, this.tableName, this.columnName, this.referencingNames, this.whenClause, this.status, this.description, this.actionType, this.crossedition, this.beforeStatement, this.beforeRow, this.afterRow, this.afterStatement, this.insteadOfRow, this.fireOnce, this.applyServerOnly);
        }

        public String toString() {
            return "DatabaseTrigger.DatabaseTriggerBuilder(owner=" + this.owner + ", triggerName=" + this.triggerName + ", triggerType=" + this.triggerType + ", triggeringEvent=" + this.triggeringEvent + ", tableOwner=" + this.tableOwner + ", baseObjectType=" + this.baseObjectType + ", tableName=" + this.tableName + ", columnName=" + this.columnName + ", referencingNames=" + this.referencingNames + ", whenClause=" + this.whenClause + ", status=" + this.status + ", description=" + this.description + ", actionType=" + this.actionType + ", crossedition=" + this.crossedition + ", beforeStatement=" + this.beforeStatement + ", beforeRow=" + this.beforeRow + ", afterRow=" + this.afterRow + ", afterStatement=" + this.afterStatement + ", insteadOfRow=" + this.insteadOfRow + ", fireOnce=" + this.fireOnce + ", applyServerOnly=" + this.applyServerOnly + ")";
        }
    }
}

