/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.premigration.dbinspector.addinform.redo;

import com.oracle.premigration.dbinspector.ExecutionContext;
import com.oracle.premigration.helpers.SqlUtils;
import com.oracle.premigration.helpers.Utilities;
import com.oracle.premigration.logger.PremigrationLogger;
import com.oracle.premigration.reports.html.sections.HtmlProperty;
import com.oracle.premigration.reports.html.sections.HtmlReportSectionName;
import com.oracle.premigration.reports.json.CpatJsonPropertyDescription;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

public class RedoSize {
    private static final PremigrationLogger log = PremigrationLogger.getLogger(RedoSize.class.getName());
    @HtmlProperty(labelKey="SRC_REDO_SIZE_INSTANCE_ID", section=HtmlReportSectionName.SRC_REDO_INFORMATION, isClassInfo=false)
    @CpatJsonPropertyDescription(value="The instance identifier associated with the redo")
    private int instanceId;
    @HtmlProperty(labelKey="SRC_REDO_SIZE_SIZE_IN_MB", section=HtmlReportSectionName.SRC_REDO_INFORMATION, isClassInfo=false)
    @CpatJsonPropertyDescription(value="Redo size in MB")
    private Double redoSizeInMB;
    @HtmlProperty(labelKey="SRC_REDO_SIZE_OPEN_TIME", section=HtmlReportSectionName.SRC_REDO_INFORMATION, isClassInfo=false)
    @CpatJsonPropertyDescription(value="The date-time the database was opened in ISO_DATE_TIME format. For example: 2023-12-15T08:43:41Z")
    private Date instanceOpenTime;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<RedoSize> getRedoSizeData(ExecutionContext exeCtx) throws SQLException {
        ArrayList<RedoSize> redoSizeData = new ArrayList<RedoSize>();
        long startTime = System.currentTimeMillis();
        Connection conn = null;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        String redoSizeQuery = "SELECT   A.INST_ID AS INST_ID,   CASE     WHEN ROUND(A.VALUE / 1024 / 1024, 1) > 0 THEN ROUND(A.VALUE / 1024 / 1024, 1)     WHEN ROUND(A.VALUE / 1024 / 1024, 2) > 0 THEN ROUND(A.VALUE / 1024 / 1024, 2)     WHEN ROUND(A.VALUE / 1024 / 1024, 3) > 0 THEN ROUND(A.VALUE / 1024 / 1024, 3)     ELSE ROUND(A.VALUE / 1024 / 1024, 4)   END AS REDO_SIZE_IN_MB,   B.STARTUP_TIME AS STARTUP_TIME FROM GV$SYSSTAT A,   GV$INSTANCE B  WHERE A.INST_ID=B.INST_ID   AND A.NAME = 'redo size'   ORDER BY 1";
        log.fine("Fetching Redo size data with query: SELECT   A.INST_ID AS INST_ID,   CASE     WHEN ROUND(A.VALUE / 1024 / 1024, 1) > 0 THEN ROUND(A.VALUE / 1024 / 1024, 1)     WHEN ROUND(A.VALUE / 1024 / 1024, 2) > 0 THEN ROUND(A.VALUE / 1024 / 1024, 2)     WHEN ROUND(A.VALUE / 1024 / 1024, 3) > 0 THEN ROUND(A.VALUE / 1024 / 1024, 3)     ELSE ROUND(A.VALUE / 1024 / 1024, 4)   END AS REDO_SIZE_IN_MB,   B.STARTUP_TIME AS STARTUP_TIME FROM GV$SYSSTAT A,   GV$INSTANCE B  WHERE A.INST_ID=B.INST_ID   AND A.NAME = 'redo size'   ORDER BY 1");
        try {
            conn = exeCtx.getConnection();
            stmt = SqlUtils.createPreparedStatement(conn, "SELECT   A.INST_ID AS INST_ID,   CASE     WHEN ROUND(A.VALUE / 1024 / 1024, 1) > 0 THEN ROUND(A.VALUE / 1024 / 1024, 1)     WHEN ROUND(A.VALUE / 1024 / 1024, 2) > 0 THEN ROUND(A.VALUE / 1024 / 1024, 2)     WHEN ROUND(A.VALUE / 1024 / 1024, 3) > 0 THEN ROUND(A.VALUE / 1024 / 1024, 3)     ELSE ROUND(A.VALUE / 1024 / 1024, 4)   END AS REDO_SIZE_IN_MB,   B.STARTUP_TIME AS STARTUP_TIME FROM GV$SYSSTAT A,   GV$INSTANCE B  WHERE A.INST_ID=B.INST_ID   AND A.NAME = 'redo size'   ORDER BY 1");
            rs = stmt.executeQuery();
            while (rs.next()) {
                int instanceId = rs.getInt("INST_ID");
                double redoSizeInMB = rs.getDouble("REDO_SIZE_IN_MB");
                java.sql.Date startupTime = rs.getDate("STARTUP_TIME");
                RedoSize redoSize = new RedoSize(instanceId, redoSizeInMB, startupTime);
                redoSizeData.add(redoSize);
            }
            log.info("Elapsed time for query: " + Utilities.formatTimeInterval(System.currentTimeMillis() - startTime));
        }
        catch (Throwable throwable) {
            exeCtx.closeIfNotNull(rs, stmt, conn);
            throw throwable;
        }
        exeCtx.closeIfNotNull(rs, stmt, conn);
        return redoSizeData;
    }

    public static RedoSize createEmptyRedoSizeInstance() {
        return new RedoSize(0, 0.0, new Date());
    }

    private RedoSize(int instanceId, Double redoSizeInMB, Date instanceOpenTime) {
        this.instanceId = instanceId;
        this.redoSizeInMB = redoSizeInMB;
        this.instanceOpenTime = instanceOpenTime;
    }

    public int getInstanceId() {
        return this.instanceId;
    }

    public Double getRedoSizeInMB() {
        return this.redoSizeInMB;
    }

    public Date getInstanceOpenTime() {
        return this.instanceOpenTime;
    }
}

