/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.premigration.dbinspector.addinform.oee;

import com.oracle.premigration.commons.io.ResourceFinder;
import com.oracle.premigration.dbinspector.ExecutionContext;
import com.oracle.premigration.helpers.SqlUtils;
import com.oracle.premigration.helpers.Utilities;
import com.oracle.premigration.logger.PremigrationLogger;
import java.sql.SQLException;

public class MpackMetrics {
    private static final PremigrationLogger log = PremigrationLogger.getLogger(MpackMetrics.class.getName());
    private String data;

    public static MpackMetrics getMpackMetrics(ExecutionContext exeCtx) throws SQLException {
        long startTime = System.currentTimeMillis();
        String mpackScript = new ResourceFinder("common/oee/oee_mpack_metrics.sql").getResourceAsText();
        log.fine("Fetching MPACK metrics by running PL/SQL script oee_mpack_metrics.sql");
        String mpackDbInfo = SqlUtils.getDbmsOutputFromPlSql(mpackScript, exeCtx.getConnection());
        MpackMetrics mpackMetrics = MpackMetrics.builder().data(mpackDbInfo).build();
        log.info("Elapsed time for query: " + Utilities.formatTimeInterval(System.currentTimeMillis() - startTime));
        return mpackMetrics;
    }

    public static MpackMetricsBuilder builder() {
        return new MpackMetricsBuilder();
    }

    private MpackMetrics(String data) {
        this.data = data;
    }

    public String getData() {
        return this.data;
    }

    public static class MpackMetricsBuilder {
        private String data;

        MpackMetricsBuilder() {
        }

        public MpackMetricsBuilder data(String data) {
            this.data = data;
            return this;
        }

        public MpackMetrics build() {
            return new MpackMetrics(this.data);
        }

        public String toString() {
            return "MpackMetrics.MpackMetricsBuilder(data=" + this.data + ")";
        }
    }
}

