/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.premigration.dbinspector.addinform.oee;

import com.oracle.premigration.dbinspector.ExecutionContext;
import com.oracle.premigration.helpers.SqlUtils;
import com.oracle.premigration.helpers.Utilities;
import com.oracle.premigration.logger.PremigrationLogger;
import com.oracle.premigration.reports.html.sections.HtmlProperty;
import com.oracle.premigration.reports.html.sections.HtmlReportSectionName;
import com.oracle.premigration.reports.json.CpatJsonPropertyDescription;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;

public class MemoryCPUInfo {
    private static final PremigrationLogger log = PremigrationLogger.getLogger(MemoryCPUInfo.class.getName());
    private static final String MEM_CPU_QUERY = "WITH   system_params AS (    SELECT       SUM(CASE WHEN name = 'memory_target' THEN value END) AS memory_target,      SUM(CASE WHEN name = 'sga_target' THEN value END) AS sga_target,      SUM(CASE WHEN name = 'pga_aggregate_target' THEN value END) AS pga_target,      SUM(CASE WHEN name = 'vector_memory_size' THEN value END) AS vector_memory_size    FROM       GV$SYSTEM_PARAMETER2  ),  os_statistics AS (    SELECT       SUM(CASE WHEN stat_name = 'NUM_CPU_CORES' THEN value END) AS cpu_core_count,      SUM(CASE WHEN stat_name = 'NUM_CPUS' THEN value END) AS cpu_count,      SUM(CASE WHEN stat_name = 'PHYSICAL_MEMORY_BYTES' THEN value END) AS physical_memory_bytes    FROM       GV$OSSTAT  ),  instance_info AS (    SELECT       COUNT(*) AS instance_count    FROM       GV$INSTANCE  ),  in_memory_size AS (    SELECT       SUM(value) AS total_in_memory_size    FROM       GV$SGA    WHERE       name = 'In-Memory Area'  ) SELECT   ii.instance_count as INSTANCE_COUNT,  ROUND((sp.sga_target + sp.pga_target) / POWER(1024, 3), 4) AS DATABASE_MEMORY_GB,  ROUND(sp.sga_target / POWER(1024, 3), 4) AS SGA_GB,  ROUND(sp.pga_target / POWER(1024, 3), 4) AS PGA_GB,  ROUND(sp.vector_memory_size / POWER(1024, 3), 4) AS VECTOR_MEM_GB,  CASE     WHEN sp.memory_target > 0 THEN 'AMM'     ELSE CASE       WHEN sp.sga_target > 0 THEN 'ASMM'       ELSE 'MANUAL'     END   END AS MEMORY_MANAGEMENT_TYPE,  os.cpu_core_count,  os.cpu_count,  ROUND(os.physical_memory_bytes / POWER(1024, 3), 4) AS PHYSICAL_MEMORY_GB,  ROUND(ims.total_in_memory_size / POWER(1024, 3), 4) AS IN_MEMORY_SIZE_GB FROM   system_params sp,  os_statistics os,  instance_info ii,  in_memory_size ims";
    @HtmlProperty(labelKey="SRC_DB_MEMORY_CPU_INSTCNT_LABEL", section=HtmlReportSectionName.SRC_DATABASE_DETAILS, isClassInfo=false)
    @CpatJsonPropertyDescription(value="Number of instances in the database.")
    private Long instanceCount;
    @HtmlProperty(labelKey="SRC_DB_MEMORY_CPU_MGMTTYPE_LABEL", section=HtmlReportSectionName.SRC_DATABASE_DETAILS, isClassInfo=false)
    @CpatJsonPropertyDescription(value="Type of memory management used by the database (e.g., AMM, ASMM, MANUAL).")
    private String memoryManagementType;
    @HtmlProperty(labelKey="SRC_DB_MEMORY_CPU_DBMEMGB_LABEL", section=HtmlReportSectionName.SRC_DATABASE_DETAILS, isClassInfo=false)
    @CpatJsonPropertyDescription(value="Total amount of memory allocated to the database in GB.")
    private Double databaseMemoryGB;
    @HtmlProperty(labelKey="SRC_DB_MEMORY_CPU_PHYSMEMGB_LABEL", section=HtmlReportSectionName.SRC_DATABASE_DETAILS, isClassInfo=false)
    @CpatJsonPropertyDescription(value="Amount of physical memory available on the host machine in GB.")
    private Double physicalMemoryGB;
    @HtmlProperty(labelKey="SRC_DB_MEMORY_CPU_INMEMGB_LABEL", section=HtmlReportSectionName.SRC_DATABASE_DETAILS, isClassInfo=false)
    @CpatJsonPropertyDescription(value="Size of the in-memory area in GB.")
    private Double inMemorySizeGB;
    @HtmlProperty(labelKey="SRC_DB_MEMORY_CPU_SGAGB_LABEL", section=HtmlReportSectionName.SRC_DATABASE_DETAILS, isClassInfo=false)
    @CpatJsonPropertyDescription(value="Size of the System Global Area (SGA) in GB.")
    private Double sgaGB;
    @HtmlProperty(labelKey="SRC_DB_MEMORY_CPU_PGAGB_LABEL", section=HtmlReportSectionName.SRC_DATABASE_DETAILS, isClassInfo=false)
    @CpatJsonPropertyDescription(value="Size of the Program Global Area (PGA) in GB.")
    private Double pgaGB;
    @HtmlProperty(labelKey="SRC_DB_MEMORY_CPU_VECMEMGB_LABEL", section=HtmlReportSectionName.SRC_DATABASE_DETAILS, isClassInfo=false)
    @CpatJsonPropertyDescription(value="Vector memory size in GB.")
    private Double vectorMemorySizeGB;
    @HtmlProperty(labelKey="SRC_DB_MEMORY_CPU_CORECNT_LABEL", section=HtmlReportSectionName.SRC_DATABASE_DETAILS, isClassInfo=false)
    @CpatJsonPropertyDescription(value="Number of CPU cores available on the host machine.")
    private Integer cpuCoreCount;
    @HtmlProperty(labelKey="SRC_DB_MEMORY_CPU_CPUCNT_LABEL", section=HtmlReportSectionName.SRC_DATABASE_DETAILS, isClassInfo=false)
    @CpatJsonPropertyDescription(value="Number of CPUs available on the host machine.")
    private Integer cpuCount;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static MemoryCPUInfo getMemoryCPUInfo(ExecutionContext exeCtx) throws SQLException {
        MemoryCPUInfo memCpuInfo = null;
        long startTime = System.currentTimeMillis();
        Connection conn = null;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        String memCpuQuery = MEM_CPU_QUERY;
        log.fine("Fetching Memory and CPU Info with query: WITH   system_params AS (    SELECT       SUM(CASE WHEN name = 'memory_target' THEN value END) AS memory_target,      SUM(CASE WHEN name = 'sga_target' THEN value END) AS sga_target,      SUM(CASE WHEN name = 'pga_aggregate_target' THEN value END) AS pga_target,      SUM(CASE WHEN name = 'vector_memory_size' THEN value END) AS vector_memory_size    FROM       GV$SYSTEM_PARAMETER2  ),  os_statistics AS (    SELECT       SUM(CASE WHEN stat_name = 'NUM_CPU_CORES' THEN value END) AS cpu_core_count,      SUM(CASE WHEN stat_name = 'NUM_CPUS' THEN value END) AS cpu_count,      SUM(CASE WHEN stat_name = 'PHYSICAL_MEMORY_BYTES' THEN value END) AS physical_memory_bytes    FROM       GV$OSSTAT  ),  instance_info AS (    SELECT       COUNT(*) AS instance_count    FROM       GV$INSTANCE  ),  in_memory_size AS (    SELECT       SUM(value) AS total_in_memory_size    FROM       GV$SGA    WHERE       name = 'In-Memory Area'  ) SELECT   ii.instance_count as INSTANCE_COUNT,  ROUND((sp.sga_target + sp.pga_target) / POWER(1024, 3), 4) AS DATABASE_MEMORY_GB,  ROUND(sp.sga_target / POWER(1024, 3), 4) AS SGA_GB,  ROUND(sp.pga_target / POWER(1024, 3), 4) AS PGA_GB,  ROUND(sp.vector_memory_size / POWER(1024, 3), 4) AS VECTOR_MEM_GB,  CASE     WHEN sp.memory_target > 0 THEN 'AMM'     ELSE CASE       WHEN sp.sga_target > 0 THEN 'ASMM'       ELSE 'MANUAL'     END   END AS MEMORY_MANAGEMENT_TYPE,  os.cpu_core_count,  os.cpu_count,  ROUND(os.physical_memory_bytes / POWER(1024, 3), 4) AS PHYSICAL_MEMORY_GB,  ROUND(ims.total_in_memory_size / POWER(1024, 3), 4) AS IN_MEMORY_SIZE_GB FROM   system_params sp,  os_statistics os,  instance_info ii,  in_memory_size ims");
        try {
            conn = exeCtx.getConnection();
            stmt = SqlUtils.createPreparedStatement(conn, MEM_CPU_QUERY);
            rs = stmt.executeQuery();
            if (rs.next()) {
                memCpuInfo = MemoryCPUInfo.builder().instanceCount(rs.getLong("INSTANCE_COUNT")).databaseMemoryGB(rs.getDouble("DATABASE_MEMORY_GB")).sgaGB(rs.getDouble("SGA_GB")).pgaGB(rs.getDouble("PGA_GB")).vectorMemorySizeGB(rs.getDouble("VECTOR_MEM_GB")).memoryManagementType(rs.getString("MEMORY_MANAGEMENT_TYPE")).physicalMemoryGB(rs.getDouble("PHYSICAL_MEMORY_GB")).inMemorySizeGB(rs.getDouble("IN_MEMORY_SIZE_GB")).cpuCoreCount(rs.getInt("CPU_CORE_COUNT")).cpuCount(rs.getInt("CPU_COUNT")).build();
            }
            log.info("Elapsed time for query: " + Utilities.formatTimeInterval(System.currentTimeMillis() - startTime));
        }
        catch (Throwable throwable) {
            exeCtx.closeIfNotNull(rs, stmt, conn);
            throw throwable;
        }
        exeCtx.closeIfNotNull(rs, stmt, conn);
        return memCpuInfo;
    }

    public static MemoryCPUInfoBuilder builder() {
        return new MemoryCPUInfoBuilder();
    }

    private MemoryCPUInfo(Long instanceCount, String memoryManagementType, Double databaseMemoryGB, Double physicalMemoryGB, Double inMemorySizeGB, Double sgaGB, Double pgaGB, Double vectorMemorySizeGB, Integer cpuCoreCount, Integer cpuCount) {
        this.instanceCount = instanceCount;
        this.memoryManagementType = memoryManagementType;
        this.databaseMemoryGB = databaseMemoryGB;
        this.physicalMemoryGB = physicalMemoryGB;
        this.inMemorySizeGB = inMemorySizeGB;
        this.sgaGB = sgaGB;
        this.pgaGB = pgaGB;
        this.vectorMemorySizeGB = vectorMemorySizeGB;
        this.cpuCoreCount = cpuCoreCount;
        this.cpuCount = cpuCount;
    }

    public Long getInstanceCount() {
        return this.instanceCount;
    }

    public String getMemoryManagementType() {
        return this.memoryManagementType;
    }

    public Double getDatabaseMemoryGB() {
        return this.databaseMemoryGB;
    }

    public Double getPhysicalMemoryGB() {
        return this.physicalMemoryGB;
    }

    public Double getInMemorySizeGB() {
        return this.inMemorySizeGB;
    }

    public Double getSgaGB() {
        return this.sgaGB;
    }

    public Double getPgaGB() {
        return this.pgaGB;
    }

    public Double getVectorMemorySizeGB() {
        return this.vectorMemorySizeGB;
    }

    public Integer getCpuCoreCount() {
        return this.cpuCoreCount;
    }

    public Integer getCpuCount() {
        return this.cpuCount;
    }

    public static class MemoryCPUInfoBuilder {
        private Long instanceCount;
        private String memoryManagementType;
        private Double databaseMemoryGB;
        private Double physicalMemoryGB;
        private Double inMemorySizeGB;
        private Double sgaGB;
        private Double pgaGB;
        private Double vectorMemorySizeGB;
        private Integer cpuCoreCount;
        private Integer cpuCount;

        MemoryCPUInfoBuilder() {
        }

        public MemoryCPUInfoBuilder instanceCount(Long instanceCount) {
            this.instanceCount = instanceCount;
            return this;
        }

        public MemoryCPUInfoBuilder memoryManagementType(String memoryManagementType) {
            this.memoryManagementType = memoryManagementType;
            return this;
        }

        public MemoryCPUInfoBuilder databaseMemoryGB(Double databaseMemoryGB) {
            this.databaseMemoryGB = databaseMemoryGB;
            return this;
        }

        public MemoryCPUInfoBuilder physicalMemoryGB(Double physicalMemoryGB) {
            this.physicalMemoryGB = physicalMemoryGB;
            return this;
        }

        public MemoryCPUInfoBuilder inMemorySizeGB(Double inMemorySizeGB) {
            this.inMemorySizeGB = inMemorySizeGB;
            return this;
        }

        public MemoryCPUInfoBuilder sgaGB(Double sgaGB) {
            this.sgaGB = sgaGB;
            return this;
        }

        public MemoryCPUInfoBuilder pgaGB(Double pgaGB) {
            this.pgaGB = pgaGB;
            return this;
        }

        public MemoryCPUInfoBuilder vectorMemorySizeGB(Double vectorMemorySizeGB) {
            this.vectorMemorySizeGB = vectorMemorySizeGB;
            return this;
        }

        public MemoryCPUInfoBuilder cpuCoreCount(Integer cpuCoreCount) {
            this.cpuCoreCount = cpuCoreCount;
            return this;
        }

        public MemoryCPUInfoBuilder cpuCount(Integer cpuCount) {
            this.cpuCount = cpuCount;
            return this;
        }

        public MemoryCPUInfo build() {
            return new MemoryCPUInfo(this.instanceCount, this.memoryManagementType, this.databaseMemoryGB, this.physicalMemoryGB, this.inMemorySizeGB, this.sgaGB, this.pgaGB, this.vectorMemorySizeGB, this.cpuCoreCount, this.cpuCount);
        }

        public String toString() {
            return "MemoryCPUInfo.MemoryCPUInfoBuilder(instanceCount=" + this.instanceCount + ", memoryManagementType=" + this.memoryManagementType + ", databaseMemoryGB=" + this.databaseMemoryGB + ", physicalMemoryGB=" + this.physicalMemoryGB + ", inMemorySizeGB=" + this.inMemorySizeGB + ", sgaGB=" + this.sgaGB + ", pgaGB=" + this.pgaGB + ", vectorMemorySizeGB=" + this.vectorMemorySizeGB + ", cpuCoreCount=" + this.cpuCoreCount + ", cpuCount=" + this.cpuCount + ")";
        }
    }
}

