/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.premigration.dbinspector.addinform;

import com.oracle.premigration.commons.enums.GatherDetailsOptions;
import com.oracle.premigration.dbinspector.ExecutionContext;
import com.oracle.premigration.dbinspector.addinform.schemasummary.ApplicationSchemaObjects;
import com.oracle.premigration.dbinspector.addinform.schemasummary.ColumnTypeDistribution;
import com.oracle.premigration.dbinspector.addinform.schemasummary.InvalidObjects;
import com.oracle.premigration.dbinspector.addinform.schemasummary.Largest50Objects;
import com.oracle.premigration.dbinspector.addinform.schemasummary.Largest50Tables;
import com.oracle.premigration.dbinspector.addinform.schemasummary.ObjectTypeDistribution;
import com.oracle.premigration.dbinspector.addinform.schemasummary.OwnerIndexSegments;
import com.oracle.premigration.dbinspector.addinform.schemasummary.OwnerLobSegments;
import com.oracle.premigration.dbinspector.addinform.schemasummary.OwnerTableSegments;
import com.oracle.premigration.dbinspector.addinform.schemasummary.ReservedTablespaceSegments;
import com.oracle.premigration.dbinspector.addinform.schemasummary.SecureFiles;
import com.oracle.premigration.logger.PremigrationLogger;
import java.sql.SQLException;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;

public class SchemaSummary {
    private static final PremigrationLogger log = PremigrationLogger.getLogger(SchemaSummary.class.getName());
    private List<ApplicationSchemaObjects> applicationSchemaObjects;
    private List<ObjectTypeDistribution> objectTypeDistribution;
    private List<ColumnTypeDistribution> columnTypeDistribution;
    private List<InvalidObjects> invalidObjects;
    private List<Largest50Tables> largest50Tables;
    private List<Largest50Objects> largest50Objects;
    private List<OwnerTableSegments> ownerTableSegments;
    private List<OwnerIndexSegments> ownerIndexSegments;
    private List<OwnerLobSegments> ownerLobSegments;
    private List<ReservedTablespaceSegments> reservedTablespaceSegments;
    private List<SecureFiles> secureFiles;

    public static SchemaSummary getSchemaSummaryData(ExecutionContext exeCtx) throws SQLException {
        return SchemaSummary.builder().objectTypeDistribution(ObjectTypeDistribution.getObjectTypeDistributionStats(exeCtx)).columnTypeDistribution(ColumnTypeDistribution.getColumnTypeDistributionStats(exeCtx)).reservedTablespaceSegments(ReservedTablespaceSegments.getSegmentDistributionStats(exeCtx)).applicationSchemaObjects(ApplicationSchemaObjects.getApplicationSchemaObjectStats(exeCtx)).invalidObjects(InvalidObjects.getInvalidObjectStats(exeCtx)).ownerTableSegments(OwnerTableSegments.getOwnerTableSegmentStats(exeCtx)).ownerIndexSegments(OwnerIndexSegments.getOwnerIndexSegmentStats(exeCtx)).ownerLobSegments(OwnerLobSegments.getOwnerLobSegmentStats(exeCtx)).secureFiles(SecureFiles.getSecureFileStats(exeCtx)).largest50Objects(Largest50Objects.getLargest50Objects(exeCtx)).largest50Tables(Largest50Tables.getLargest50Tables(exeCtx)).build();
    }

    public static boolean isSchemaSummaryRequested(List<GatherDetailsOptions> gatherDetailsOptions) {
        EnumSet<GatherDetailsOptions> optionsForGeneratingSchemaSummary = EnumSet.of(GatherDetailsOptions.SCHEMA_OBJECTS, GatherDetailsOptions.ALL);
        return !Collections.disjoint(gatherDetailsOptions, optionsForGeneratingSchemaSummary);
    }

    SchemaSummary(List<ApplicationSchemaObjects> applicationSchemaObjects, List<ObjectTypeDistribution> objectTypeDistribution, List<ColumnTypeDistribution> columnTypeDistribution, List<InvalidObjects> invalidObjects, List<Largest50Tables> largest50Tables, List<Largest50Objects> largest50Objects, List<OwnerTableSegments> ownerTableSegments, List<OwnerIndexSegments> ownerIndexSegments, List<OwnerLobSegments> ownerLobSegments, List<ReservedTablespaceSegments> reservedTablespaceSegments, List<SecureFiles> secureFiles) {
        this.applicationSchemaObjects = applicationSchemaObjects;
        this.objectTypeDistribution = objectTypeDistribution;
        this.columnTypeDistribution = columnTypeDistribution;
        this.invalidObjects = invalidObjects;
        this.largest50Tables = largest50Tables;
        this.largest50Objects = largest50Objects;
        this.ownerTableSegments = ownerTableSegments;
        this.ownerIndexSegments = ownerIndexSegments;
        this.ownerLobSegments = ownerLobSegments;
        this.reservedTablespaceSegments = reservedTablespaceSegments;
        this.secureFiles = secureFiles;
    }

    public static SchemaSummaryBuilder builder() {
        return new SchemaSummaryBuilder();
    }

    public List<ApplicationSchemaObjects> getApplicationSchemaObjects() {
        return this.applicationSchemaObjects;
    }

    public List<ObjectTypeDistribution> getObjectTypeDistribution() {
        return this.objectTypeDistribution;
    }

    public List<ColumnTypeDistribution> getColumnTypeDistribution() {
        return this.columnTypeDistribution;
    }

    public List<InvalidObjects> getInvalidObjects() {
        return this.invalidObjects;
    }

    public List<Largest50Tables> getLargest50Tables() {
        return this.largest50Tables;
    }

    public List<Largest50Objects> getLargest50Objects() {
        return this.largest50Objects;
    }

    public List<OwnerTableSegments> getOwnerTableSegments() {
        return this.ownerTableSegments;
    }

    public List<OwnerIndexSegments> getOwnerIndexSegments() {
        return this.ownerIndexSegments;
    }

    public List<OwnerLobSegments> getOwnerLobSegments() {
        return this.ownerLobSegments;
    }

    public List<ReservedTablespaceSegments> getReservedTablespaceSegments() {
        return this.reservedTablespaceSegments;
    }

    public List<SecureFiles> getSecureFiles() {
        return this.secureFiles;
    }

    public static class SchemaSummaryBuilder {
        private List<ApplicationSchemaObjects> applicationSchemaObjects;
        private List<ObjectTypeDistribution> objectTypeDistribution;
        private List<ColumnTypeDistribution> columnTypeDistribution;
        private List<InvalidObjects> invalidObjects;
        private List<Largest50Tables> largest50Tables;
        private List<Largest50Objects> largest50Objects;
        private List<OwnerTableSegments> ownerTableSegments;
        private List<OwnerIndexSegments> ownerIndexSegments;
        private List<OwnerLobSegments> ownerLobSegments;
        private List<ReservedTablespaceSegments> reservedTablespaceSegments;
        private List<SecureFiles> secureFiles;

        SchemaSummaryBuilder() {
        }

        public SchemaSummaryBuilder applicationSchemaObjects(List<ApplicationSchemaObjects> applicationSchemaObjects) {
            this.applicationSchemaObjects = applicationSchemaObjects;
            return this;
        }

        public SchemaSummaryBuilder objectTypeDistribution(List<ObjectTypeDistribution> objectTypeDistribution) {
            this.objectTypeDistribution = objectTypeDistribution;
            return this;
        }

        public SchemaSummaryBuilder columnTypeDistribution(List<ColumnTypeDistribution> columnTypeDistribution) {
            this.columnTypeDistribution = columnTypeDistribution;
            return this;
        }

        public SchemaSummaryBuilder invalidObjects(List<InvalidObjects> invalidObjects) {
            this.invalidObjects = invalidObjects;
            return this;
        }

        public SchemaSummaryBuilder largest50Tables(List<Largest50Tables> largest50Tables) {
            this.largest50Tables = largest50Tables;
            return this;
        }

        public SchemaSummaryBuilder largest50Objects(List<Largest50Objects> largest50Objects) {
            this.largest50Objects = largest50Objects;
            return this;
        }

        public SchemaSummaryBuilder ownerTableSegments(List<OwnerTableSegments> ownerTableSegments) {
            this.ownerTableSegments = ownerTableSegments;
            return this;
        }

        public SchemaSummaryBuilder ownerIndexSegments(List<OwnerIndexSegments> ownerIndexSegments) {
            this.ownerIndexSegments = ownerIndexSegments;
            return this;
        }

        public SchemaSummaryBuilder ownerLobSegments(List<OwnerLobSegments> ownerLobSegments) {
            this.ownerLobSegments = ownerLobSegments;
            return this;
        }

        public SchemaSummaryBuilder reservedTablespaceSegments(List<ReservedTablespaceSegments> reservedTablespaceSegments) {
            this.reservedTablespaceSegments = reservedTablespaceSegments;
            return this;
        }

        public SchemaSummaryBuilder secureFiles(List<SecureFiles> secureFiles) {
            this.secureFiles = secureFiles;
            return this;
        }

        public SchemaSummary build() {
            return new SchemaSummary(this.applicationSchemaObjects, this.objectTypeDistribution, this.columnTypeDistribution, this.invalidObjects, this.largest50Tables, this.largest50Objects, this.ownerTableSegments, this.ownerIndexSegments, this.ownerLobSegments, this.reservedTablespaceSegments, this.secureFiles);
        }

        public String toString() {
            return "SchemaSummary.SchemaSummaryBuilder(applicationSchemaObjects=" + this.applicationSchemaObjects + ", objectTypeDistribution=" + this.objectTypeDistribution + ", columnTypeDistribution=" + this.columnTypeDistribution + ", invalidObjects=" + this.invalidObjects + ", largest50Tables=" + this.largest50Tables + ", largest50Objects=" + this.largest50Objects + ", ownerTableSegments=" + this.ownerTableSegments + ", ownerIndexSegments=" + this.ownerIndexSegments + ", ownerLobSegments=" + this.ownerLobSegments + ", reservedTablespaceSegments=" + this.reservedTablespaceSegments + ", secureFiles=" + this.secureFiles + ")";
        }
    }
}

