/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.premigration.commons.enums;

public enum TargetInstanceProp {
    CPAT_VERSION(null, null, null, false, PostQueryProcessing.NONE),
    ALLOW_ROWID_COLUMN_TYPE("SELECT VALUE FROM V$PARAMETER WHERE LOWER(NAME)='allow_rowid_column_type'", "FALSE"),
    CLOUD_SERVICE("SELECT UPPER(SYS_CONTEXT('USERENV', 'CLOUD_SERVICE')) AS CLOUD_SERVICE FROM DUAL", "", true),
    DB_BLOCK_SIZE("SELECT VALUE FROM V$PARAMETER WHERE LOWER(NAME) = 'db_block_size'", ""),
    DB_PLATFORM_ID("SELECT PLATFORM_ID FROM V$DATABASE", ""),
    DB_TIME_ZONE("SELECT DBTIMEZONE FROM DUAL", "", "[^a-zA-Z0-9+-:._\\-/]"),
    DIRECTORIES("SELECT DIRECTORY_NAME FROM SYS.DBA_DIRECTORIES ORDER BY DIRECTORY_NAME", "", "[^a-zA-Z0-9.,_#$\\s]", false, PostQueryProcessing.LISTAGG),
    JAVAVM_STATUS("SELECT STATUS AS JAVAVM_STATUS FROM SYS.DBA_REGISTRY WHERE comp_id = 'JAVAVM'", ""),
    NLS_NCHAR_CHARACTERSET("SELECT VALUE FROM SYS.NLS_DATABASE_PARAMETERS WHERE LOWER(PARAMETER) = 'nls_nchar_characterset'", "AL16UTF16"),
    MAX_STRING_SIZE("SELECT VALUE FROM V$PARAMETER WHERE LOWER(NAME) = 'max_string_size'", "EXTENDED"),
    PDB_LOCKDOWN("SELECT UPPER(VALUE) AS PDB_LOCKDOWN FROM V$PARAMETER WHERE UPPER(NAME) = 'PDB_LOCKDOWN'", ""),
    PROFILES("SELECT DISTINCT PROFILE FROM SYS.DBA_PROFILES ORDER BY PROFILE ", "", PostQueryProcessing.LISTAGG),
    ROLEPRIVILEGE("SELECT DISTINCT GRANTED_ROLE FROM SYS.DBA_ROLE_PRIVS START WITH GRANTEE IN ('ADMIN') CONNECT BY PRIOR GRANTED_ROLE = GRANTEE AND ADMIN_OPTION='YES' ORDER BY GRANTED_ROLE", "", PostQueryProcessing.LISTAGG),
    SYSPRIVILEGE("SELECT DISTINCT PRIVILEGE FROM DBA_SYS_PRIVS  WHERE (GRANTEE = 'ADMIN' AND ADMIN_OPTION='YES')  OR (GRANTEE IN (    SELECT DISTINCT GRANTED_ROLE FROM DBA_ROLE_PRIVS CONNECT BY PRIOR GRANTED_ROLE = GRANTEE START WITH GRANTEE = 'ADMIN') AND ADMIN_OPTION='YES') ORDER BY PRIVILEGE", "", PostQueryProcessing.LISTAGG),
    TABLESPACES("SELECT TABLESPACE_NAME FROM SYS.DBA_TABLESPACES ORDER BY TABLESPACE_NAME", "", PostQueryProcessing.LISTAGG),
    TZ_VERSION("SELECT CAST(VERSION AS VARCHAR2(100)) AS TZ_VERSION FROM V$TIMEZONE_FILE", ""),
    NLS_CHARACTERSET("SELECT VALUE FROM SYS.NLS_DATABASE_PARAMETERS WHERE LOWER(PARAMETER) = 'nls_characterset'", "AL32UTF8"),
    DB_VERSION(null, ""),
    TABLESPACE_BLOCK_SIZE(null, "");

    private final String propertyKey = ((Object)((Object)this)).getClass().getSimpleName() + "." + this.name();
    private final String sqlQuery;
    private final String defaultValue;
    private final String regexFilter;
    private final Boolean ignoreSQLException;
    PostQueryProcessing postQueryProcessing;

    private TargetInstanceProp(String sqlQuery, String defaultValue, String regexFilter, boolean ignoreSQLException, PostQueryProcessing postQueryProcessing) {
        this.defaultValue = defaultValue;
        this.sqlQuery = sqlQuery;
        this.regexFilter = regexFilter;
        this.ignoreSQLException = ignoreSQLException;
        this.postQueryProcessing = postQueryProcessing;
    }

    private TargetInstanceProp(String sqlQuery, String defaultValue, String regexFilter) {
        this(sqlQuery, defaultValue, regexFilter, false, PostQueryProcessing.NONE);
    }

    private TargetInstanceProp(String sqlQuery, String defaultValue, boolean ignoreSQLException) {
        this(sqlQuery, defaultValue, "[^a-zA-Z0-9.,_#\\s]", ignoreSQLException, PostQueryProcessing.NONE);
    }

    private TargetInstanceProp(String sqlQuery, String defaultValue, PostQueryProcessing postQueryProcessing) {
        this(sqlQuery, defaultValue, "[^a-zA-Z0-9.,_#\\s]", false, postQueryProcessing);
    }

    private TargetInstanceProp(String sqlQuery, String defaultValue) {
        this(sqlQuery, defaultValue, "[^a-zA-Z0-9.,_#\\s]", false, PostQueryProcessing.NONE);
    }

    public String toString() {
        return this.propertyKey;
    }

    public String getKey() {
        return this.propertyKey;
    }

    public String getKey(String suffix) {
        return this.propertyKey + "." + suffix;
    }

    public String getSqlQuery() {
        return this.sqlQuery;
    }

    public String getDefaultValue() {
        return this.defaultValue;
    }

    public String getRegexFilter() {
        return this.regexFilter;
    }

    public Boolean getIgnoreSQLException() {
        return this.ignoreSQLException;
    }

    public PostQueryProcessing getPostQueryProcessing() {
        return this.postQueryProcessing;
    }

    public static enum PostQueryProcessing {
        NONE,
        LISTAGG;

    }
}

