/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.premigration.cli;

import com.oracle.premigration.cli.CliOption;
import com.oracle.premigration.commons.EnvironmentContext;
import com.oracle.premigration.commons.enums.GatherDetailsOptions;
import com.oracle.premigration.commons.enums.MigrationMethod;
import com.oracle.premigration.commons.enums.ReportFormat;
import com.oracle.premigration.commons.enums.ResultLevel;
import com.oracle.premigration.commons.enums.TargetCloud;
import com.oracle.premigration.commons.io.StdUtil;
import com.oracle.premigration.helpers.Utilities;
import com.oracle.premigration.logger.PremigrationLogger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;

public class CommandLineArgs {
    private static final PremigrationLogger log = PremigrationLogger.getLogger(CommandLineArgs.class.getName());
    private final String username;
    private final char[] password;
    private final String connectString;
    private final Boolean sysdba;
    private List<String> pdbNames;
    private final List<String> schemas;
    private final List<String> excludeSchemas;
    private final Boolean help;
    private final Boolean version;
    private final Boolean simpleVersion;
    private final String compareVersion;
    private final Boolean checkForUpdates;
    private final String outdir;
    private final String outFilePrefix;
    private TargetCloud targetCloud;
    private final List<MigrationMethod> migrationMethods;
    private final List<ReportFormat> reportFormats;
    private final Boolean fetchTargetProps;
    private final String analysisPropertiesFile;
    private final Boolean sqlInTextReport;
    private Integer maxTextRows;
    private final Level loggingLevel;
    private final Boolean forceFull;
    private Integer maxRelevantObjects;
    private final Boolean quiet;
    private final ResultLevel resultLevel;
    private final Boolean genFixups;
    private final Boolean genZipFile;
    private Integer maxSubprocesses;
    private final String configurationFile;
    private final Boolean loadPassword;
    private final List<GatherDetailsOptions> gatherDetailsOptions;
    private final Boolean noconsole;
    private final String cpatKey;

    public void nullifyPassword() {
        Utilities.clearCharArray(this.password);
    }

    public void nullifyAllSchemaNames() {
        if (this.schemas != null) {
            this.schemas.clear();
        }
        if (this.excludeSchemas != null) {
            this.excludeSchemas.clear();
        }
    }

    public List<Object> getReconstitutedArgArray() {
        return this.getReconstitutedArgArray(false);
    }

    public List<Object> getReconstitutedArgArray(boolean omitPDBNames) {
        ArrayList<Object> arguments = new ArrayList<Object>();
        if (this.connectString != null) {
            arguments.add(CliOption.CONNECT_STRING.getDashedLongOpt());
            arguments.add(this.connectString);
        }
        if (this.targetCloud != null) {
            arguments.add(CliOption.TARGET_CLOUD.getDashedLongOpt());
            arguments.add(this.targetCloud);
        }
        if (this.username != null) {
            arguments.add(CliOption.USERNAME.getDashedLongOpt());
            arguments.add(this.username);
        }
        if (Boolean.TRUE.equals(this.sysdba)) {
            arguments.add(CliOption.SYSDBA.getDashedLongOpt());
        }
        if (Boolean.TRUE.equals(this.fetchTargetProps)) {
            arguments.add(CliOption.GETTARGETPROPS.getDashedLongOpt());
        }
        if (this.analysisPropertiesFile != null) {
            arguments.add(CliOption.ANALYSISPROPS.getDashedLongOpt());
            arguments.add(this.analysisPropertiesFile);
        }
        if (this.configurationFile != null) {
            arguments.add(CliOption.PARFILE.getDashedLongOpt());
            arguments.add(this.configurationFile);
        }
        if (this.isPdbNameSpecified() && !omitPDBNames) {
            arguments.add(CliOption.PDBNAME.getDashedLongOpt());
            arguments.addAll(this.pdbNames);
        }
        if (Boolean.TRUE.equals(this.forceFull)) {
            arguments.add(CliOption.FULL.getDashedLongOpt());
        }
        if (this.schemas != null && !this.schemas.isEmpty()) {
            arguments.add(CliOption.SCHEMAS.getDashedLongOpt());
            arguments.addAll(this.schemas);
        }
        if (this.excludeSchemas != null && !this.excludeSchemas.isEmpty()) {
            arguments.add(CliOption.EXCLUDE_SCHEMAS.getDashedLongOpt());
            arguments.addAll(this.excludeSchemas);
        }
        if (this.outdir != null && !this.outdir.isEmpty()) {
            arguments.add(CliOption.OUTDIR.getDashedLongOpt());
            arguments.add(this.outdir);
        }
        if (this.loggingLevel != null) {
            arguments.add(CliOption.LOGGINGLEVEL.getDashedLongOpt());
            arguments.add(this.loggingLevel.getName());
        }
        if (this.outFilePrefix != null) {
            arguments.add(CliOption.OUTFILEPREFIX.getDashedLongOpt());
            arguments.add(this.outFilePrefix);
        }
        if (this.migrationMethods != null && !this.migrationMethods.isEmpty()) {
            arguments.add(CliOption.MIGRATION_METHOD.getDashedLongOpt());
            arguments.addAll(this.migrationMethods);
        }
        if (this.reportFormats != null && !this.reportFormats.isEmpty()) {
            arguments.add(CliOption.REPORT_FORMAT.getDashedLongOpt());
            arguments.addAll(this.reportFormats);
        }
        if (this.maxTextRows != null) {
            arguments.add(CliOption.MAXTEXTROWS.getDashedLongOpt());
            arguments.add(this.maxTextRows);
        }
        if (this.maxRelevantObjects != null) {
            arguments.add(CliOption.MAXRELEVANTOBJECTS.getDashedLongOpt());
            arguments.add(this.maxRelevantObjects);
        }
        if (Boolean.TRUE.equals(this.sqlInTextReport)) {
            arguments.add(CliOption.SQL_IN_TEXT_REPORT.getDashedLongOpt());
        }
        if (Boolean.TRUE.equals(this.help)) {
            arguments.add(CliOption.HELP.getDashedLongOpt());
        }
        if (Boolean.TRUE.equals(this.version)) {
            arguments.add(CliOption.VERSION.getDashedLongOpt());
        }
        if (Boolean.TRUE.equals(this.simpleVersion)) {
            arguments.add(CliOption.SIMPLE_VERSION.getDashedLongOpt());
        }
        if (this.compareVersion != null && !this.compareVersion.isEmpty()) {
            arguments.add(CliOption.COMPARE_VERSION.getDashedLongOpt());
            arguments.add(this.compareVersion);
        }
        if (Boolean.TRUE.equals(this.checkForUpdates)) {
            arguments.add(CliOption.UPDATE_CHECK.getDashedLongOpt());
        }
        if (Boolean.TRUE.equals(this.quiet)) {
            arguments.add(CliOption.QUIET.getDashedLongOpt());
        }
        if (this.resultLevel != null) {
            arguments.add(CliOption.RESULT_LEVEL.getDashedLongOpt());
            arguments.add(this.resultLevel);
        }
        if (Boolean.TRUE.equals(this.genFixups)) {
            arguments.add(CliOption.GENFIXUPS.getDashedLongOpt());
        }
        if (Boolean.TRUE.equals(this.genZipFile)) {
            arguments.add(CliOption.ZIP.getDashedLongOpt());
        }
        if (this.maxSubprocesses != null) {
            arguments.add(CliOption.MAXSUBPROCESSES.getDashedLongOpt());
            arguments.add(this.maxSubprocesses);
        }
        if (Boolean.TRUE.equals(this.loadPassword)) {
            arguments.add(CliOption.LOADPASSWORD.getDashedLongOpt());
        }
        if (this.gatherDetailsOptions != null && !this.gatherDetailsOptions.isEmpty()) {
            arguments.add(CliOption.GATHERDETAILS.getDashedLongOpt());
            arguments.addAll(this.gatherDetailsOptions);
        }
        if (this.cpatKey != null) {
            arguments.add(CliOption.CPATKEY.getDashedLongOpt());
            arguments.add(this.cpatKey);
        }
        if (Boolean.TRUE.equals(this.noconsole)) {
            arguments.add(CliOption.NOCONSOLE.getDashedLongOpt());
        }
        return arguments;
    }

    public String getReconstitutedArgs() {
        return Utilities.join(" ", this.getReconstitutedArgArray());
    }

    public void validate(EnvironmentContext envCtx) {
        String errorMessage;
        if (this.maxTextRows != null && !this.reportFormats.contains(ReportFormat.TEXT)) {
            errorMessage = Utilities.getErrorText("ERROR1009", new String[0]);
            Utilities.printAndLogErrorMessage(errorMessage, envCtx, Level.INFO);
            this.maxTextRows = null;
        }
        if (this.maxTextRows != null && this.maxTextRows < 0) {
            errorMessage = Utilities.getErrorText("ERROR1008", CliOption.MAXTEXTROWS.getDashedLongOpt());
            Utilities.printAndLogErrorMessage(errorMessage, envCtx, Level.INFO);
            this.maxTextRows = null;
        }
        if (this.maxRelevantObjects != null && this.maxRelevantObjects < 0) {
            errorMessage = Utilities.getErrorText("ERROR1008", CliOption.MAXRELEVANTOBJECTS.getDashedLongOpt());
            log.info(errorMessage);
            StdUtil.errPrintln(errorMessage);
            this.maxRelevantObjects = null;
        }
        if (this.maxTextRows != null && this.maxRelevantObjects != null && this.maxRelevantObjects < this.maxTextRows) {
            errorMessage = Utilities.getErrorText("ERROR1012", new String[0]);
            Utilities.printAndLogErrorMessage(errorMessage, envCtx, Level.INFO);
            this.maxTextRows = this.maxRelevantObjects;
        }
        if (this.maxTextRows == null && this.maxRelevantObjects != null && this.reportFormats.contains(ReportFormat.TEXT)) {
            this.maxTextRows = this.maxRelevantObjects;
        }
        if (this.migrationMethods != null && this.migrationMethods.contains(MigrationMethod.DATAPUMP) && this.migrationMethods.contains(MigrationMethod.DATAPUMP_DBLINK)) {
            errorMessage = Utilities.getErrorText("ERROR1010", new String[0]);
            Utilities.printAndLogErrorMessage(errorMessage, envCtx, Level.INFO);
            this.migrationMethods.remove(MigrationMethod.DATAPUMP);
        }
        if (this.maxSubprocesses != null && this.maxSubprocesses < 1) {
            errorMessage = Utilities.getErrorText("ERROR1020", CliOption.MAXSUBPROCESSES.getDashedLongOpt());
            log.info(errorMessage);
            StdUtil.errPrintln(errorMessage);
            this.maxSubprocesses = null;
        }
        if (Boolean.TRUE.equals(this.fetchTargetProps) && this.isPdbNameSpecified() && this.pdbNames.size() != 1) {
            errorMessage = Utilities.getErrorText("ERROR1019", new String[0]);
            Utilities.printAndLogErrorMessage(errorMessage, envCtx, Level.WARNING);
        }
    }

    public boolean isForceFull() {
        return Boolean.TRUE.equals(this.getForceFull());
    }

    public boolean isSysdba() {
        return Boolean.TRUE.equals(this.getSysdba());
    }

    public boolean isGenFixups() {
        return Boolean.TRUE.equals(this.getGenFixups());
    }

    public boolean isQuiet() {
        return Boolean.TRUE.equals(this.getQuiet());
    }

    public boolean isHelp() {
        return Boolean.TRUE.equals(this.getHelp());
    }

    public boolean isVersion() {
        return Boolean.TRUE.equals(this.getVersion());
    }

    public boolean isSimpleVersion() {
        return Boolean.TRUE.equals(this.getSimpleVersion());
    }

    public boolean isCheckForUpdates() {
        return Boolean.TRUE.equals(this.getCheckForUpdates());
    }

    public boolean isFetchTargetProps() {
        return Boolean.TRUE.equals(this.getFetchTargetProps());
    }

    public boolean isSqlInTextReport() {
        return Boolean.TRUE.equals(this.getSqlInTextReport());
    }

    public boolean isGenZipFile() {
        return Boolean.TRUE.equals(this.getGenZipFile());
    }

    public boolean isPdbNameSpecified() {
        return this.pdbNames != null && !this.pdbNames.isEmpty();
    }

    public boolean isLoadPassword() {
        return Boolean.TRUE.equals(this.getLoadPassword());
    }

    public boolean isNoConsole() {
        return Boolean.TRUE.equals(this.getNoconsole());
    }

    public String getPdbName() {
        if (this.isPdbNameSpecified()) {
            return this.pdbNames.get(0);
        }
        return null;
    }

    public void setPdbName(String pdbName) {
        if (this.pdbNames == null) {
            this.pdbNames = new ArrayList<String>();
        }
        this.pdbNames.add(0, pdbName);
    }

    public static CommandLineArgs applyDefaultValuesCommandLine(CommandLineArgs parsedCla) {
        CommandLineArgsBuilder claBuilder = parsedCla.toBuilder();
        if (parsedCla.getLoggingLevel() == null) {
            String defaultLoggingLevel = CliOption.LOGGINGLEVEL.getDefaultValue().name();
            claBuilder.loggingLevel(Level.parse(defaultLoggingLevel));
        }
        if (parsedCla.getOutdir() == null) {
            claBuilder.outdir(System.getProperty("user.dir"));
        }
        if (parsedCla.getResultLevel() == null) {
            claBuilder.resultLevel((ResultLevel)CliOption.RESULT_LEVEL.getDefaultValue());
        }
        if (parsedCla.getSchemas() == null) {
            claBuilder.schemas(Collections.emptyList());
        }
        if (parsedCla.getExcludeSchemas() == null) {
            claBuilder.excludeSchemas(Collections.emptyList());
        }
        if (parsedCla.getMigrationMethods().isEmpty()) {
            MigrationMethod defaultValueMigration = (MigrationMethod)CliOption.MIGRATION_METHOD.getDefaultValue();
            claBuilder.migrationMethod(defaultValueMigration);
        }
        if (parsedCla.getReportFormats().isEmpty()) {
            for (Enum defaultReportFormat : CliOption.REPORT_FORMAT.getDefaultValues()) {
                ReportFormat reportFormat = ReportFormat.valueOf(defaultReportFormat.name());
                claBuilder.reportFormat(reportFormat);
            }
        }
        return claBuilder.build();
    }

    CommandLineArgs(String username, char[] password, String connectString, Boolean sysdba, List<String> pdbNames, List<String> schemas, List<String> excludeSchemas, Boolean help, Boolean version, Boolean simpleVersion, String compareVersion, Boolean checkForUpdates, String outdir, String outFilePrefix, TargetCloud targetCloud, List<MigrationMethod> migrationMethods, List<ReportFormat> reportFormats, Boolean fetchTargetProps, String analysisPropertiesFile, Boolean sqlInTextReport, Integer maxTextRows, Level loggingLevel, Boolean forceFull, Integer maxRelevantObjects, Boolean quiet, ResultLevel resultLevel, Boolean genFixups, Boolean genZipFile, Integer maxSubprocesses, String configurationFile, Boolean loadPassword, List<GatherDetailsOptions> gatherDetailsOptions, Boolean noconsole, String cpatKey) {
        this.username = username;
        this.password = password;
        this.connectString = connectString;
        this.sysdba = sysdba;
        this.pdbNames = pdbNames;
        this.schemas = schemas;
        this.excludeSchemas = excludeSchemas;
        this.help = help;
        this.version = version;
        this.simpleVersion = simpleVersion;
        this.compareVersion = compareVersion;
        this.checkForUpdates = checkForUpdates;
        this.outdir = outdir;
        this.outFilePrefix = outFilePrefix;
        this.targetCloud = targetCloud;
        this.migrationMethods = migrationMethods;
        this.reportFormats = reportFormats;
        this.fetchTargetProps = fetchTargetProps;
        this.analysisPropertiesFile = analysisPropertiesFile;
        this.sqlInTextReport = sqlInTextReport;
        this.maxTextRows = maxTextRows;
        this.loggingLevel = loggingLevel;
        this.forceFull = forceFull;
        this.maxRelevantObjects = maxRelevantObjects;
        this.quiet = quiet;
        this.resultLevel = resultLevel;
        this.genFixups = genFixups;
        this.genZipFile = genZipFile;
        this.maxSubprocesses = maxSubprocesses;
        this.configurationFile = configurationFile;
        this.loadPassword = loadPassword;
        this.gatherDetailsOptions = gatherDetailsOptions;
        this.noconsole = noconsole;
        this.cpatKey = cpatKey;
    }

    public static CommandLineArgsBuilder builder() {
        return new CommandLineArgsBuilder();
    }

    public CommandLineArgsBuilder toBuilder() {
        CommandLineArgsBuilder builder = new CommandLineArgsBuilder().username(this.username).password(this.password).connectString(this.connectString).sysdba(this.sysdba).schemas(this.schemas).excludeSchemas(this.excludeSchemas).help(this.help).version(this.version).simpleVersion(this.simpleVersion).compareVersion(this.compareVersion).checkForUpdates(this.checkForUpdates).outdir(this.outdir).outFilePrefix(this.outFilePrefix).targetCloud(this.targetCloud).fetchTargetProps(this.fetchTargetProps).analysisPropertiesFile(this.analysisPropertiesFile).sqlInTextReport(this.sqlInTextReport).maxTextRows(this.maxTextRows).loggingLevel(this.loggingLevel).forceFull(this.forceFull).maxRelevantObjects(this.maxRelevantObjects).quiet(this.quiet).resultLevel(this.resultLevel).genFixups(this.genFixups).genZipFile(this.genZipFile).maxSubprocesses(this.maxSubprocesses).configurationFile(this.configurationFile).loadPassword(this.loadPassword).noconsole(this.noconsole).cpatKey(this.cpatKey);
        if (this.pdbNames != null) {
            builder.pdbNames(this.pdbNames);
        }
        if (this.migrationMethods != null) {
            builder.migrationMethods(this.migrationMethods);
        }
        if (this.reportFormats != null) {
            builder.reportFormats(this.reportFormats);
        }
        if (this.gatherDetailsOptions != null) {
            builder.gatherDetailsOptions(this.gatherDetailsOptions);
        }
        return builder;
    }

    public String getUsername() {
        return this.username;
    }

    public char[] getPassword() {
        return this.password;
    }

    public String getConnectString() {
        return this.connectString;
    }

    public Boolean getSysdba() {
        return this.sysdba;
    }

    public List<String> getPdbNames() {
        return this.pdbNames;
    }

    public List<String> getSchemas() {
        return this.schemas;
    }

    public List<String> getExcludeSchemas() {
        return this.excludeSchemas;
    }

    public Boolean getHelp() {
        return this.help;
    }

    public Boolean getVersion() {
        return this.version;
    }

    public Boolean getSimpleVersion() {
        return this.simpleVersion;
    }

    public String getCompareVersion() {
        return this.compareVersion;
    }

    public Boolean getCheckForUpdates() {
        return this.checkForUpdates;
    }

    public String getOutdir() {
        return this.outdir;
    }

    public String getOutFilePrefix() {
        return this.outFilePrefix;
    }

    public TargetCloud getTargetCloud() {
        return this.targetCloud;
    }

    public List<MigrationMethod> getMigrationMethods() {
        return this.migrationMethods;
    }

    public List<ReportFormat> getReportFormats() {
        return this.reportFormats;
    }

    public Boolean getFetchTargetProps() {
        return this.fetchTargetProps;
    }

    public String getAnalysisPropertiesFile() {
        return this.analysisPropertiesFile;
    }

    public Boolean getSqlInTextReport() {
        return this.sqlInTextReport;
    }

    public Integer getMaxTextRows() {
        return this.maxTextRows;
    }

    public Level getLoggingLevel() {
        return this.loggingLevel;
    }

    public Boolean getForceFull() {
        return this.forceFull;
    }

    public Integer getMaxRelevantObjects() {
        return this.maxRelevantObjects;
    }

    public Boolean getQuiet() {
        return this.quiet;
    }

    public ResultLevel getResultLevel() {
        return this.resultLevel;
    }

    public Boolean getGenFixups() {
        return this.genFixups;
    }

    public Boolean getGenZipFile() {
        return this.genZipFile;
    }

    public Integer getMaxSubprocesses() {
        return this.maxSubprocesses;
    }

    public String getConfigurationFile() {
        return this.configurationFile;
    }

    public Boolean getLoadPassword() {
        return this.loadPassword;
    }

    public List<GatherDetailsOptions> getGatherDetailsOptions() {
        return this.gatherDetailsOptions;
    }

    public Boolean getNoconsole() {
        return this.noconsole;
    }

    public String getCpatKey() {
        return this.cpatKey;
    }

    public void setPdbNames(List<String> pdbNames) {
        this.pdbNames = pdbNames;
    }

    public void setTargetCloud(TargetCloud targetCloud) {
        this.targetCloud = targetCloud;
    }

    public void setMaxTextRows(Integer maxTextRows) {
        this.maxTextRows = maxTextRows;
    }

    public void setMaxRelevantObjects(Integer maxRelevantObjects) {
        this.maxRelevantObjects = maxRelevantObjects;
    }

    public void setMaxSubprocesses(Integer maxSubprocesses) {
        this.maxSubprocesses = maxSubprocesses;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CommandLineArgs)) {
            return false;
        }
        CommandLineArgs other = (CommandLineArgs)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Boolean this$sysdba = this.getSysdba();
        Boolean other$sysdba = other.getSysdba();
        if (this$sysdba == null ? other$sysdba != null : !((Object)this$sysdba).equals(other$sysdba)) {
            return false;
        }
        Boolean this$help = this.getHelp();
        Boolean other$help = other.getHelp();
        if (this$help == null ? other$help != null : !((Object)this$help).equals(other$help)) {
            return false;
        }
        Boolean this$version = this.getVersion();
        Boolean other$version = other.getVersion();
        if (this$version == null ? other$version != null : !((Object)this$version).equals(other$version)) {
            return false;
        }
        Boolean this$simpleVersion = this.getSimpleVersion();
        Boolean other$simpleVersion = other.getSimpleVersion();
        if (this$simpleVersion == null ? other$simpleVersion != null : !((Object)this$simpleVersion).equals(other$simpleVersion)) {
            return false;
        }
        Boolean this$checkForUpdates = this.getCheckForUpdates();
        Boolean other$checkForUpdates = other.getCheckForUpdates();
        if (this$checkForUpdates == null ? other$checkForUpdates != null : !((Object)this$checkForUpdates).equals(other$checkForUpdates)) {
            return false;
        }
        Boolean this$fetchTargetProps = this.getFetchTargetProps();
        Boolean other$fetchTargetProps = other.getFetchTargetProps();
        if (this$fetchTargetProps == null ? other$fetchTargetProps != null : !((Object)this$fetchTargetProps).equals(other$fetchTargetProps)) {
            return false;
        }
        Boolean this$sqlInTextReport = this.getSqlInTextReport();
        Boolean other$sqlInTextReport = other.getSqlInTextReport();
        if (this$sqlInTextReport == null ? other$sqlInTextReport != null : !((Object)this$sqlInTextReport).equals(other$sqlInTextReport)) {
            return false;
        }
        Integer this$maxTextRows = this.getMaxTextRows();
        Integer other$maxTextRows = other.getMaxTextRows();
        if (this$maxTextRows == null ? other$maxTextRows != null : !((Object)this$maxTextRows).equals(other$maxTextRows)) {
            return false;
        }
        Boolean this$forceFull = this.getForceFull();
        Boolean other$forceFull = other.getForceFull();
        if (this$forceFull == null ? other$forceFull != null : !((Object)this$forceFull).equals(other$forceFull)) {
            return false;
        }
        Integer this$maxRelevantObjects = this.getMaxRelevantObjects();
        Integer other$maxRelevantObjects = other.getMaxRelevantObjects();
        if (this$maxRelevantObjects == null ? other$maxRelevantObjects != null : !((Object)this$maxRelevantObjects).equals(other$maxRelevantObjects)) {
            return false;
        }
        Boolean this$quiet = this.getQuiet();
        Boolean other$quiet = other.getQuiet();
        if (this$quiet == null ? other$quiet != null : !((Object)this$quiet).equals(other$quiet)) {
            return false;
        }
        Boolean this$genFixups = this.getGenFixups();
        Boolean other$genFixups = other.getGenFixups();
        if (this$genFixups == null ? other$genFixups != null : !((Object)this$genFixups).equals(other$genFixups)) {
            return false;
        }
        Boolean this$genZipFile = this.getGenZipFile();
        Boolean other$genZipFile = other.getGenZipFile();
        if (this$genZipFile == null ? other$genZipFile != null : !((Object)this$genZipFile).equals(other$genZipFile)) {
            return false;
        }
        Integer this$maxSubprocesses = this.getMaxSubprocesses();
        Integer other$maxSubprocesses = other.getMaxSubprocesses();
        if (this$maxSubprocesses == null ? other$maxSubprocesses != null : !((Object)this$maxSubprocesses).equals(other$maxSubprocesses)) {
            return false;
        }
        Boolean this$loadPassword = this.getLoadPassword();
        Boolean other$loadPassword = other.getLoadPassword();
        if (this$loadPassword == null ? other$loadPassword != null : !((Object)this$loadPassword).equals(other$loadPassword)) {
            return false;
        }
        Boolean this$noconsole = this.getNoconsole();
        Boolean other$noconsole = other.getNoconsole();
        if (this$noconsole == null ? other$noconsole != null : !((Object)this$noconsole).equals(other$noconsole)) {
            return false;
        }
        String this$username = this.getUsername();
        String other$username = other.getUsername();
        if (this$username == null ? other$username != null : !this$username.equals(other$username)) {
            return false;
        }
        if (!Arrays.equals(this.getPassword(), other.getPassword())) {
            return false;
        }
        String this$connectString = this.getConnectString();
        String other$connectString = other.getConnectString();
        if (this$connectString == null ? other$connectString != null : !this$connectString.equals(other$connectString)) {
            return false;
        }
        List<String> this$pdbNames = this.getPdbNames();
        List<String> other$pdbNames = other.getPdbNames();
        if (this$pdbNames == null ? other$pdbNames != null : !((Object)this$pdbNames).equals(other$pdbNames)) {
            return false;
        }
        List<String> this$schemas = this.getSchemas();
        List<String> other$schemas = other.getSchemas();
        if (this$schemas == null ? other$schemas != null : !((Object)this$schemas).equals(other$schemas)) {
            return false;
        }
        List<String> this$excludeSchemas = this.getExcludeSchemas();
        List<String> other$excludeSchemas = other.getExcludeSchemas();
        if (this$excludeSchemas == null ? other$excludeSchemas != null : !((Object)this$excludeSchemas).equals(other$excludeSchemas)) {
            return false;
        }
        String this$compareVersion = this.getCompareVersion();
        String other$compareVersion = other.getCompareVersion();
        if (this$compareVersion == null ? other$compareVersion != null : !this$compareVersion.equals(other$compareVersion)) {
            return false;
        }
        String this$outdir = this.getOutdir();
        String other$outdir = other.getOutdir();
        if (this$outdir == null ? other$outdir != null : !this$outdir.equals(other$outdir)) {
            return false;
        }
        String this$outFilePrefix = this.getOutFilePrefix();
        String other$outFilePrefix = other.getOutFilePrefix();
        if (this$outFilePrefix == null ? other$outFilePrefix != null : !this$outFilePrefix.equals(other$outFilePrefix)) {
            return false;
        }
        TargetCloud this$targetCloud = this.getTargetCloud();
        TargetCloud other$targetCloud = other.getTargetCloud();
        if (this$targetCloud == null ? other$targetCloud != null : !this$targetCloud.equals(other$targetCloud)) {
            return false;
        }
        List<MigrationMethod> this$migrationMethods = this.getMigrationMethods();
        List<MigrationMethod> other$migrationMethods = other.getMigrationMethods();
        if (this$migrationMethods == null ? other$migrationMethods != null : !((Object)this$migrationMethods).equals(other$migrationMethods)) {
            return false;
        }
        List<ReportFormat> this$reportFormats = this.getReportFormats();
        List<ReportFormat> other$reportFormats = other.getReportFormats();
        if (this$reportFormats == null ? other$reportFormats != null : !((Object)this$reportFormats).equals(other$reportFormats)) {
            return false;
        }
        String this$analysisPropertiesFile = this.getAnalysisPropertiesFile();
        String other$analysisPropertiesFile = other.getAnalysisPropertiesFile();
        if (this$analysisPropertiesFile == null ? other$analysisPropertiesFile != null : !this$analysisPropertiesFile.equals(other$analysisPropertiesFile)) {
            return false;
        }
        Level this$loggingLevel = this.getLoggingLevel();
        Level other$loggingLevel = other.getLoggingLevel();
        if (this$loggingLevel == null ? other$loggingLevel != null : !((Object)this$loggingLevel).equals(other$loggingLevel)) {
            return false;
        }
        ResultLevel this$resultLevel = this.getResultLevel();
        ResultLevel other$resultLevel = other.getResultLevel();
        if (this$resultLevel == null ? other$resultLevel != null : !this$resultLevel.equals(other$resultLevel)) {
            return false;
        }
        String this$configurationFile = this.getConfigurationFile();
        String other$configurationFile = other.getConfigurationFile();
        if (this$configurationFile == null ? other$configurationFile != null : !this$configurationFile.equals(other$configurationFile)) {
            return false;
        }
        List<GatherDetailsOptions> this$gatherDetailsOptions = this.getGatherDetailsOptions();
        List<GatherDetailsOptions> other$gatherDetailsOptions = other.getGatherDetailsOptions();
        if (this$gatherDetailsOptions == null ? other$gatherDetailsOptions != null : !((Object)this$gatherDetailsOptions).equals(other$gatherDetailsOptions)) {
            return false;
        }
        String this$cpatKey = this.getCpatKey();
        String other$cpatKey = other.getCpatKey();
        return !(this$cpatKey == null ? other$cpatKey != null : !this$cpatKey.equals(other$cpatKey));
    }

    protected boolean canEqual(Object other) {
        return other instanceof CommandLineArgs;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Boolean $sysdba = this.getSysdba();
        result = result * 59 + ($sysdba == null ? 43 : ((Object)$sysdba).hashCode());
        Boolean $help = this.getHelp();
        result = result * 59 + ($help == null ? 43 : ((Object)$help).hashCode());
        Boolean $version = this.getVersion();
        result = result * 59 + ($version == null ? 43 : ((Object)$version).hashCode());
        Boolean $simpleVersion = this.getSimpleVersion();
        result = result * 59 + ($simpleVersion == null ? 43 : ((Object)$simpleVersion).hashCode());
        Boolean $checkForUpdates = this.getCheckForUpdates();
        result = result * 59 + ($checkForUpdates == null ? 43 : ((Object)$checkForUpdates).hashCode());
        Boolean $fetchTargetProps = this.getFetchTargetProps();
        result = result * 59 + ($fetchTargetProps == null ? 43 : ((Object)$fetchTargetProps).hashCode());
        Boolean $sqlInTextReport = this.getSqlInTextReport();
        result = result * 59 + ($sqlInTextReport == null ? 43 : ((Object)$sqlInTextReport).hashCode());
        Integer $maxTextRows = this.getMaxTextRows();
        result = result * 59 + ($maxTextRows == null ? 43 : ((Object)$maxTextRows).hashCode());
        Boolean $forceFull = this.getForceFull();
        result = result * 59 + ($forceFull == null ? 43 : ((Object)$forceFull).hashCode());
        Integer $maxRelevantObjects = this.getMaxRelevantObjects();
        result = result * 59 + ($maxRelevantObjects == null ? 43 : ((Object)$maxRelevantObjects).hashCode());
        Boolean $quiet = this.getQuiet();
        result = result * 59 + ($quiet == null ? 43 : ((Object)$quiet).hashCode());
        Boolean $genFixups = this.getGenFixups();
        result = result * 59 + ($genFixups == null ? 43 : ((Object)$genFixups).hashCode());
        Boolean $genZipFile = this.getGenZipFile();
        result = result * 59 + ($genZipFile == null ? 43 : ((Object)$genZipFile).hashCode());
        Integer $maxSubprocesses = this.getMaxSubprocesses();
        result = result * 59 + ($maxSubprocesses == null ? 43 : ((Object)$maxSubprocesses).hashCode());
        Boolean $loadPassword = this.getLoadPassword();
        result = result * 59 + ($loadPassword == null ? 43 : ((Object)$loadPassword).hashCode());
        Boolean $noconsole = this.getNoconsole();
        result = result * 59 + ($noconsole == null ? 43 : ((Object)$noconsole).hashCode());
        String $username = this.getUsername();
        result = result * 59 + ($username == null ? 43 : $username.hashCode());
        result = result * 59 + Arrays.hashCode(this.getPassword());
        String $connectString = this.getConnectString();
        result = result * 59 + ($connectString == null ? 43 : $connectString.hashCode());
        List<String> $pdbNames = this.getPdbNames();
        result = result * 59 + ($pdbNames == null ? 43 : ((Object)$pdbNames).hashCode());
        List<String> $schemas = this.getSchemas();
        result = result * 59 + ($schemas == null ? 43 : ((Object)$schemas).hashCode());
        List<String> $excludeSchemas = this.getExcludeSchemas();
        result = result * 59 + ($excludeSchemas == null ? 43 : ((Object)$excludeSchemas).hashCode());
        String $compareVersion = this.getCompareVersion();
        result = result * 59 + ($compareVersion == null ? 43 : $compareVersion.hashCode());
        String $outdir = this.getOutdir();
        result = result * 59 + ($outdir == null ? 43 : $outdir.hashCode());
        String $outFilePrefix = this.getOutFilePrefix();
        result = result * 59 + ($outFilePrefix == null ? 43 : $outFilePrefix.hashCode());
        TargetCloud $targetCloud = this.getTargetCloud();
        result = result * 59 + ($targetCloud == null ? 43 : $targetCloud.hashCode());
        List<MigrationMethod> $migrationMethods = this.getMigrationMethods();
        result = result * 59 + ($migrationMethods == null ? 43 : ((Object)$migrationMethods).hashCode());
        List<ReportFormat> $reportFormats = this.getReportFormats();
        result = result * 59 + ($reportFormats == null ? 43 : ((Object)$reportFormats).hashCode());
        String $analysisPropertiesFile = this.getAnalysisPropertiesFile();
        result = result * 59 + ($analysisPropertiesFile == null ? 43 : $analysisPropertiesFile.hashCode());
        Level $loggingLevel = this.getLoggingLevel();
        result = result * 59 + ($loggingLevel == null ? 43 : ((Object)$loggingLevel).hashCode());
        ResultLevel $resultLevel = this.getResultLevel();
        result = result * 59 + ($resultLevel == null ? 43 : $resultLevel.hashCode());
        String $configurationFile = this.getConfigurationFile();
        result = result * 59 + ($configurationFile == null ? 43 : $configurationFile.hashCode());
        List<GatherDetailsOptions> $gatherDetailsOptions = this.getGatherDetailsOptions();
        result = result * 59 + ($gatherDetailsOptions == null ? 43 : ((Object)$gatherDetailsOptions).hashCode());
        String $cpatKey = this.getCpatKey();
        result = result * 59 + ($cpatKey == null ? 43 : $cpatKey.hashCode());
        return result;
    }

    public String toString() {
        return "CommandLineArgs(username=" + this.getUsername() + ", password=" + Arrays.toString(this.getPassword()) + ", connectString=" + this.getConnectString() + ", sysdba=" + this.getSysdba() + ", pdbNames=" + this.getPdbNames() + ", schemas=" + this.getSchemas() + ", excludeSchemas=" + this.getExcludeSchemas() + ", help=" + this.getHelp() + ", version=" + this.getVersion() + ", simpleVersion=" + this.getSimpleVersion() + ", compareVersion=" + this.getCompareVersion() + ", checkForUpdates=" + this.getCheckForUpdates() + ", outdir=" + this.getOutdir() + ", outFilePrefix=" + this.getOutFilePrefix() + ", targetCloud=" + this.getTargetCloud() + ", migrationMethods=" + this.getMigrationMethods() + ", reportFormats=" + this.getReportFormats() + ", fetchTargetProps=" + this.getFetchTargetProps() + ", analysisPropertiesFile=" + this.getAnalysisPropertiesFile() + ", sqlInTextReport=" + this.getSqlInTextReport() + ", maxTextRows=" + this.getMaxTextRows() + ", loggingLevel=" + this.getLoggingLevel() + ", forceFull=" + this.getForceFull() + ", maxRelevantObjects=" + this.getMaxRelevantObjects() + ", quiet=" + this.getQuiet() + ", resultLevel=" + this.getResultLevel() + ", genFixups=" + this.getGenFixups() + ", genZipFile=" + this.getGenZipFile() + ", maxSubprocesses=" + this.getMaxSubprocesses() + ", configurationFile=" + this.getConfigurationFile() + ", loadPassword=" + this.getLoadPassword() + ", gatherDetailsOptions=" + this.getGatherDetailsOptions() + ", noconsole=" + this.getNoconsole() + ", cpatKey=" + this.getCpatKey() + ")";
    }

    public static class CommandLineArgsBuilder {
        private String username;
        private char[] password;
        private String connectString;
        private Boolean sysdba;
        private ArrayList<String> pdbNames;
        private List<String> schemas;
        private List<String> excludeSchemas;
        private Boolean help;
        private Boolean version;
        private Boolean simpleVersion;
        private String compareVersion;
        private Boolean checkForUpdates;
        private String outdir;
        private String outFilePrefix;
        private TargetCloud targetCloud;
        private ArrayList<MigrationMethod> migrationMethods;
        private ArrayList<ReportFormat> reportFormats;
        private Boolean fetchTargetProps;
        private String analysisPropertiesFile;
        private Boolean sqlInTextReport;
        private Integer maxTextRows;
        private Level loggingLevel;
        private Boolean forceFull;
        private Integer maxRelevantObjects;
        private Boolean quiet;
        private ResultLevel resultLevel;
        private Boolean genFixups;
        private Boolean genZipFile;
        private Integer maxSubprocesses;
        private String configurationFile;
        private Boolean loadPassword;
        private ArrayList<GatherDetailsOptions> gatherDetailsOptions;
        private Boolean noconsole;
        private String cpatKey;

        CommandLineArgsBuilder() {
        }

        public CommandLineArgsBuilder username(String username) {
            this.username = username;
            return this;
        }

        public CommandLineArgsBuilder password(char[] password) {
            this.password = password;
            return this;
        }

        public CommandLineArgsBuilder connectString(String connectString) {
            this.connectString = connectString;
            return this;
        }

        public CommandLineArgsBuilder sysdba(Boolean sysdba) {
            this.sysdba = sysdba;
            return this;
        }

        public CommandLineArgsBuilder pdbName(String pdbName) {
            if (this.pdbNames == null) {
                this.pdbNames = new ArrayList();
            }
            this.pdbNames.add(pdbName);
            return this;
        }

        public CommandLineArgsBuilder pdbNames(Collection<? extends String> pdbNames) {
            if (pdbNames == null) {
                throw new NullPointerException("pdbNames cannot be null");
            }
            if (this.pdbNames == null) {
                this.pdbNames = new ArrayList();
            }
            this.pdbNames.addAll(pdbNames);
            return this;
        }

        public CommandLineArgsBuilder clearPdbNames() {
            if (this.pdbNames != null) {
                this.pdbNames.clear();
            }
            return this;
        }

        public CommandLineArgsBuilder schemas(List<String> schemas) {
            this.schemas = schemas;
            return this;
        }

        public CommandLineArgsBuilder excludeSchemas(List<String> excludeSchemas) {
            this.excludeSchemas = excludeSchemas;
            return this;
        }

        public CommandLineArgsBuilder help(Boolean help) {
            this.help = help;
            return this;
        }

        public CommandLineArgsBuilder version(Boolean version) {
            this.version = version;
            return this;
        }

        public CommandLineArgsBuilder simpleVersion(Boolean simpleVersion) {
            this.simpleVersion = simpleVersion;
            return this;
        }

        public CommandLineArgsBuilder compareVersion(String compareVersion) {
            this.compareVersion = compareVersion;
            return this;
        }

        public CommandLineArgsBuilder checkForUpdates(Boolean checkForUpdates) {
            this.checkForUpdates = checkForUpdates;
            return this;
        }

        public CommandLineArgsBuilder outdir(String outdir) {
            this.outdir = outdir;
            return this;
        }

        public CommandLineArgsBuilder outFilePrefix(String outFilePrefix) {
            this.outFilePrefix = outFilePrefix;
            return this;
        }

        public CommandLineArgsBuilder targetCloud(TargetCloud targetCloud) {
            this.targetCloud = targetCloud;
            return this;
        }

        public CommandLineArgsBuilder migrationMethod(MigrationMethod migrationMethod) {
            if (this.migrationMethods == null) {
                this.migrationMethods = new ArrayList();
            }
            this.migrationMethods.add(migrationMethod);
            return this;
        }

        public CommandLineArgsBuilder migrationMethods(Collection<? extends MigrationMethod> migrationMethods) {
            if (migrationMethods == null) {
                throw new NullPointerException("migrationMethods cannot be null");
            }
            if (this.migrationMethods == null) {
                this.migrationMethods = new ArrayList();
            }
            this.migrationMethods.addAll(migrationMethods);
            return this;
        }

        public CommandLineArgsBuilder clearMigrationMethods() {
            if (this.migrationMethods != null) {
                this.migrationMethods.clear();
            }
            return this;
        }

        public CommandLineArgsBuilder reportFormat(ReportFormat reportFormat) {
            if (this.reportFormats == null) {
                this.reportFormats = new ArrayList();
            }
            this.reportFormats.add(reportFormat);
            return this;
        }

        public CommandLineArgsBuilder reportFormats(Collection<? extends ReportFormat> reportFormats) {
            if (reportFormats == null) {
                throw new NullPointerException("reportFormats cannot be null");
            }
            if (this.reportFormats == null) {
                this.reportFormats = new ArrayList();
            }
            this.reportFormats.addAll(reportFormats);
            return this;
        }

        public CommandLineArgsBuilder clearReportFormats() {
            if (this.reportFormats != null) {
                this.reportFormats.clear();
            }
            return this;
        }

        public CommandLineArgsBuilder fetchTargetProps(Boolean fetchTargetProps) {
            this.fetchTargetProps = fetchTargetProps;
            return this;
        }

        public CommandLineArgsBuilder analysisPropertiesFile(String analysisPropertiesFile) {
            this.analysisPropertiesFile = analysisPropertiesFile;
            return this;
        }

        public CommandLineArgsBuilder sqlInTextReport(Boolean sqlInTextReport) {
            this.sqlInTextReport = sqlInTextReport;
            return this;
        }

        public CommandLineArgsBuilder maxTextRows(Integer maxTextRows) {
            this.maxTextRows = maxTextRows;
            return this;
        }

        public CommandLineArgsBuilder loggingLevel(Level loggingLevel) {
            this.loggingLevel = loggingLevel;
            return this;
        }

        public CommandLineArgsBuilder forceFull(Boolean forceFull) {
            this.forceFull = forceFull;
            return this;
        }

        public CommandLineArgsBuilder maxRelevantObjects(Integer maxRelevantObjects) {
            this.maxRelevantObjects = maxRelevantObjects;
            return this;
        }

        public CommandLineArgsBuilder quiet(Boolean quiet) {
            this.quiet = quiet;
            return this;
        }

        public CommandLineArgsBuilder resultLevel(ResultLevel resultLevel) {
            this.resultLevel = resultLevel;
            return this;
        }

        public CommandLineArgsBuilder genFixups(Boolean genFixups) {
            this.genFixups = genFixups;
            return this;
        }

        public CommandLineArgsBuilder genZipFile(Boolean genZipFile) {
            this.genZipFile = genZipFile;
            return this;
        }

        public CommandLineArgsBuilder maxSubprocesses(Integer maxSubprocesses) {
            this.maxSubprocesses = maxSubprocesses;
            return this;
        }

        public CommandLineArgsBuilder configurationFile(String configurationFile) {
            this.configurationFile = configurationFile;
            return this;
        }

        public CommandLineArgsBuilder loadPassword(Boolean loadPassword) {
            this.loadPassword = loadPassword;
            return this;
        }

        public CommandLineArgsBuilder gatherDetailsOption(GatherDetailsOptions gatherDetailsOption) {
            if (this.gatherDetailsOptions == null) {
                this.gatherDetailsOptions = new ArrayList();
            }
            this.gatherDetailsOptions.add(gatherDetailsOption);
            return this;
        }

        public CommandLineArgsBuilder gatherDetailsOptions(Collection<? extends GatherDetailsOptions> gatherDetailsOptions) {
            if (gatherDetailsOptions == null) {
                throw new NullPointerException("gatherDetailsOptions cannot be null");
            }
            if (this.gatherDetailsOptions == null) {
                this.gatherDetailsOptions = new ArrayList();
            }
            this.gatherDetailsOptions.addAll(gatherDetailsOptions);
            return this;
        }

        public CommandLineArgsBuilder clearGatherDetailsOptions() {
            if (this.gatherDetailsOptions != null) {
                this.gatherDetailsOptions.clear();
            }
            return this;
        }

        public CommandLineArgsBuilder noconsole(Boolean noconsole) {
            this.noconsole = noconsole;
            return this;
        }

        public CommandLineArgsBuilder cpatKey(String cpatKey) {
            this.cpatKey = cpatKey;
            return this;
        }

        public CommandLineArgs build() {
            List<GatherDetailsOptions> gatherDetailsOptions;
            List<ReportFormat> reportFormats;
            List<MigrationMethod> migrationMethods;
            List<String> pdbNames;
            switch (this.pdbNames == null ? 0 : this.pdbNames.size()) {
                case 0: {
                    pdbNames = Collections.emptyList();
                    break;
                }
                case 1: {
                    pdbNames = Collections.singletonList(this.pdbNames.get(0));
                    break;
                }
                default: {
                    pdbNames = Collections.unmodifiableList(new ArrayList<String>(this.pdbNames));
                }
            }
            switch (this.migrationMethods == null ? 0 : this.migrationMethods.size()) {
                case 0: {
                    migrationMethods = Collections.emptyList();
                    break;
                }
                case 1: {
                    migrationMethods = Collections.singletonList(this.migrationMethods.get(0));
                    break;
                }
                default: {
                    migrationMethods = Collections.unmodifiableList(new ArrayList<MigrationMethod>(this.migrationMethods));
                }
            }
            switch (this.reportFormats == null ? 0 : this.reportFormats.size()) {
                case 0: {
                    reportFormats = Collections.emptyList();
                    break;
                }
                case 1: {
                    reportFormats = Collections.singletonList(this.reportFormats.get(0));
                    break;
                }
                default: {
                    reportFormats = Collections.unmodifiableList(new ArrayList<ReportFormat>(this.reportFormats));
                }
            }
            switch (this.gatherDetailsOptions == null ? 0 : this.gatherDetailsOptions.size()) {
                case 0: {
                    gatherDetailsOptions = Collections.emptyList();
                    break;
                }
                case 1: {
                    gatherDetailsOptions = Collections.singletonList(this.gatherDetailsOptions.get(0));
                    break;
                }
                default: {
                    gatherDetailsOptions = Collections.unmodifiableList(new ArrayList<GatherDetailsOptions>(this.gatherDetailsOptions));
                }
            }
            return new CommandLineArgs(this.username, this.password, this.connectString, this.sysdba, pdbNames, this.schemas, this.excludeSchemas, this.help, this.version, this.simpleVersion, this.compareVersion, this.checkForUpdates, this.outdir, this.outFilePrefix, this.targetCloud, migrationMethods, reportFormats, this.fetchTargetProps, this.analysisPropertiesFile, this.sqlInTextReport, this.maxTextRows, this.loggingLevel, this.forceFull, this.maxRelevantObjects, this.quiet, this.resultLevel, this.genFixups, this.genZipFile, this.maxSubprocesses, this.configurationFile, this.loadPassword, gatherDetailsOptions, this.noconsole, this.cpatKey);
        }

        public String toString() {
            return "CommandLineArgs.CommandLineArgsBuilder(username=" + this.username + ", password=" + Arrays.toString(this.password) + ", connectString=" + this.connectString + ", sysdba=" + this.sysdba + ", pdbNames=" + this.pdbNames + ", schemas=" + this.schemas + ", excludeSchemas=" + this.excludeSchemas + ", help=" + this.help + ", version=" + this.version + ", simpleVersion=" + this.simpleVersion + ", compareVersion=" + this.compareVersion + ", checkForUpdates=" + this.checkForUpdates + ", outdir=" + this.outdir + ", outFilePrefix=" + this.outFilePrefix + ", targetCloud=" + this.targetCloud + ", migrationMethods=" + this.migrationMethods + ", reportFormats=" + this.reportFormats + ", fetchTargetProps=" + this.fetchTargetProps + ", analysisPropertiesFile=" + this.analysisPropertiesFile + ", sqlInTextReport=" + this.sqlInTextReport + ", maxTextRows=" + this.maxTextRows + ", loggingLevel=" + this.loggingLevel + ", forceFull=" + this.forceFull + ", maxRelevantObjects=" + this.maxRelevantObjects + ", quiet=" + this.quiet + ", resultLevel=" + this.resultLevel + ", genFixups=" + this.genFixups + ", genZipFile=" + this.genZipFile + ", maxSubprocesses=" + this.maxSubprocesses + ", configurationFile=" + this.configurationFile + ", loadPassword=" + this.loadPassword + ", gatherDetailsOptions=" + this.gatherDetailsOptions + ", noconsole=" + this.noconsole + ", cpatKey=" + this.cpatKey + ")";
        }
    }
}

