/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.database.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.database.model.DbBackupConfig;
import com.oracle.bmc.database.model.EncryptionKeyLocationDetails;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import com.oracle.bmc.http.internal.BmcEnum;
import java.beans.ConstructorProperties;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class CreateDatabaseDetails
extends ExplicitlySetBmcModel {
    @JsonProperty(value="dbName")
    private final String dbName;
    @JsonProperty(value="dbUniqueName")
    private final String dbUniqueName;
    @JsonProperty(value="databaseSoftwareImageId")
    private final String databaseSoftwareImageId;
    @JsonProperty(value="pdbName")
    private final String pdbName;
    @JsonProperty(value="adminPassword")
    private final String adminPassword;
    @JsonProperty(value="tdeWalletPassword")
    private final String tdeWalletPassword;
    @JsonProperty(value="characterSet")
    private final String characterSet;
    @JsonProperty(value="ncharacterSet")
    private final String ncharacterSet;
    @JsonProperty(value="dbWorkload")
    private final DbWorkload dbWorkload;
    @JsonProperty(value="dbBackupConfig")
    private final DbBackupConfig dbBackupConfig;
    @JsonProperty(value="freeformTags")
    private final Map<String, String> freeformTags;
    @JsonProperty(value="definedTags")
    private final Map<String, Map<String, Object>> definedTags;
    @JsonProperty(value="kmsKeyId")
    private final String kmsKeyId;
    @JsonProperty(value="kmsKeyVersionId")
    private final String kmsKeyVersionId;
    @JsonProperty(value="vaultId")
    private final String vaultId;
    @JsonProperty(value="sidPrefix")
    private final String sidPrefix;
    @JsonProperty(value="keyStoreId")
    private final String keyStoreId;
    @JsonProperty(value="encryptionKeyLocationDetails")
    private final EncryptionKeyLocationDetails encryptionKeyLocationDetails;

    @Deprecated
    @ConstructorProperties(value={"dbName", "dbUniqueName", "databaseSoftwareImageId", "pdbName", "adminPassword", "tdeWalletPassword", "characterSet", "ncharacterSet", "dbWorkload", "dbBackupConfig", "freeformTags", "definedTags", "kmsKeyId", "kmsKeyVersionId", "vaultId", "sidPrefix", "keyStoreId", "encryptionKeyLocationDetails"})
    public CreateDatabaseDetails(String dbName, String dbUniqueName, String databaseSoftwareImageId, String pdbName, String adminPassword, String tdeWalletPassword, String characterSet, String ncharacterSet, DbWorkload dbWorkload, DbBackupConfig dbBackupConfig, Map<String, String> freeformTags, Map<String, Map<String, Object>> definedTags, String kmsKeyId, String kmsKeyVersionId, String vaultId, String sidPrefix, String keyStoreId, EncryptionKeyLocationDetails encryptionKeyLocationDetails) {
        this.dbName = dbName;
        this.dbUniqueName = dbUniqueName;
        this.databaseSoftwareImageId = databaseSoftwareImageId;
        this.pdbName = pdbName;
        this.adminPassword = adminPassword;
        this.tdeWalletPassword = tdeWalletPassword;
        this.characterSet = characterSet;
        this.ncharacterSet = ncharacterSet;
        this.dbWorkload = dbWorkload;
        this.dbBackupConfig = dbBackupConfig;
        this.freeformTags = freeformTags;
        this.definedTags = definedTags;
        this.kmsKeyId = kmsKeyId;
        this.kmsKeyVersionId = kmsKeyVersionId;
        this.vaultId = vaultId;
        this.sidPrefix = sidPrefix;
        this.keyStoreId = keyStoreId;
        this.encryptionKeyLocationDetails = encryptionKeyLocationDetails;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getDbName() {
        return this.dbName;
    }

    public String getDbUniqueName() {
        return this.dbUniqueName;
    }

    public String getDatabaseSoftwareImageId() {
        return this.databaseSoftwareImageId;
    }

    public String getPdbName() {
        return this.pdbName;
    }

    public String getAdminPassword() {
        return this.adminPassword;
    }

    public String getTdeWalletPassword() {
        return this.tdeWalletPassword;
    }

    public String getCharacterSet() {
        return this.characterSet;
    }

    public String getNcharacterSet() {
        return this.ncharacterSet;
    }

    public DbWorkload getDbWorkload() {
        return this.dbWorkload;
    }

    public DbBackupConfig getDbBackupConfig() {
        return this.dbBackupConfig;
    }

    public Map<String, String> getFreeformTags() {
        return this.freeformTags;
    }

    public Map<String, Map<String, Object>> getDefinedTags() {
        return this.definedTags;
    }

    public String getKmsKeyId() {
        return this.kmsKeyId;
    }

    public String getKmsKeyVersionId() {
        return this.kmsKeyVersionId;
    }

    public String getVaultId() {
        return this.vaultId;
    }

    public String getSidPrefix() {
        return this.sidPrefix;
    }

    public String getKeyStoreId() {
        return this.keyStoreId;
    }

    public EncryptionKeyLocationDetails getEncryptionKeyLocationDetails() {
        return this.encryptionKeyLocationDetails;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("CreateDatabaseDetails(");
        sb.append("super=").append(super.toString());
        sb.append("dbName=").append(String.valueOf(this.dbName));
        sb.append(", dbUniqueName=").append(String.valueOf(this.dbUniqueName));
        sb.append(", databaseSoftwareImageId=").append(String.valueOf(this.databaseSoftwareImageId));
        sb.append(", pdbName=").append(String.valueOf(this.pdbName));
        sb.append(", adminPassword=").append(String.valueOf(this.adminPassword));
        sb.append(", tdeWalletPassword=").append("<redacted>");
        sb.append(", characterSet=").append(String.valueOf(this.characterSet));
        sb.append(", ncharacterSet=").append(String.valueOf(this.ncharacterSet));
        sb.append(", dbWorkload=").append(String.valueOf((Object)this.dbWorkload));
        sb.append(", dbBackupConfig=").append(String.valueOf((Object)this.dbBackupConfig));
        sb.append(", freeformTags=").append(String.valueOf(this.freeformTags));
        sb.append(", definedTags=").append(String.valueOf(this.definedTags));
        sb.append(", kmsKeyId=").append(String.valueOf(this.kmsKeyId));
        sb.append(", kmsKeyVersionId=").append(String.valueOf(this.kmsKeyVersionId));
        sb.append(", vaultId=").append(String.valueOf(this.vaultId));
        sb.append(", sidPrefix=").append(String.valueOf(this.sidPrefix));
        sb.append(", keyStoreId=").append(String.valueOf(this.keyStoreId));
        sb.append(", encryptionKeyLocationDetails=").append(String.valueOf((Object)this.encryptionKeyLocationDetails));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof CreateDatabaseDetails)) {
            return false;
        }
        CreateDatabaseDetails other = (CreateDatabaseDetails)((Object)o);
        return Objects.equals(this.dbName, other.dbName) && Objects.equals(this.dbUniqueName, other.dbUniqueName) && Objects.equals(this.databaseSoftwareImageId, other.databaseSoftwareImageId) && Objects.equals(this.pdbName, other.pdbName) && Objects.equals(this.adminPassword, other.adminPassword) && Objects.equals(this.tdeWalletPassword, other.tdeWalletPassword) && Objects.equals(this.characterSet, other.characterSet) && Objects.equals(this.ncharacterSet, other.ncharacterSet) && Objects.equals((Object)this.dbWorkload, (Object)other.dbWorkload) && Objects.equals((Object)this.dbBackupConfig, (Object)other.dbBackupConfig) && Objects.equals(this.freeformTags, other.freeformTags) && Objects.equals(this.definedTags, other.definedTags) && Objects.equals(this.kmsKeyId, other.kmsKeyId) && Objects.equals(this.kmsKeyVersionId, other.kmsKeyVersionId) && Objects.equals(this.vaultId, other.vaultId) && Objects.equals(this.sidPrefix, other.sidPrefix) && Objects.equals(this.keyStoreId, other.keyStoreId) && Objects.equals((Object)this.encryptionKeyLocationDetails, (Object)other.encryptionKeyLocationDetails) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.dbName == null ? 43 : this.dbName.hashCode());
        result = result * 59 + (this.dbUniqueName == null ? 43 : this.dbUniqueName.hashCode());
        result = result * 59 + (this.databaseSoftwareImageId == null ? 43 : this.databaseSoftwareImageId.hashCode());
        result = result * 59 + (this.pdbName == null ? 43 : this.pdbName.hashCode());
        result = result * 59 + (this.adminPassword == null ? 43 : this.adminPassword.hashCode());
        result = result * 59 + (this.tdeWalletPassword == null ? 43 : this.tdeWalletPassword.hashCode());
        result = result * 59 + (this.characterSet == null ? 43 : this.characterSet.hashCode());
        result = result * 59 + (this.ncharacterSet == null ? 43 : this.ncharacterSet.hashCode());
        result = result * 59 + (this.dbWorkload == null ? 43 : this.dbWorkload.hashCode());
        result = result * 59 + (this.dbBackupConfig == null ? 43 : this.dbBackupConfig.hashCode());
        result = result * 59 + (this.freeformTags == null ? 43 : this.freeformTags.hashCode());
        result = result * 59 + (this.definedTags == null ? 43 : this.definedTags.hashCode());
        result = result * 59 + (this.kmsKeyId == null ? 43 : this.kmsKeyId.hashCode());
        result = result * 59 + (this.kmsKeyVersionId == null ? 43 : this.kmsKeyVersionId.hashCode());
        result = result * 59 + (this.vaultId == null ? 43 : this.vaultId.hashCode());
        result = result * 59 + (this.sidPrefix == null ? 43 : this.sidPrefix.hashCode());
        result = result * 59 + (this.keyStoreId == null ? 43 : this.keyStoreId.hashCode());
        result = result * 59 + (this.encryptionKeyLocationDetails == null ? 43 : this.encryptionKeyLocationDetails.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    public static enum DbWorkload implements BmcEnum
    {
        Oltp("OLTP"),
        Dss("DSS");

        private final String value;
        private static Map<String, DbWorkload> map;

        private DbWorkload(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static DbWorkload create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            throw new IllegalArgumentException("Invalid DbWorkload: " + key);
        }

        static {
            map = new HashMap<String, DbWorkload>();
            for (DbWorkload v : DbWorkload.values()) {
                map.put(v.getValue(), v);
            }
        }
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="dbName")
        private String dbName;
        @JsonProperty(value="dbUniqueName")
        private String dbUniqueName;
        @JsonProperty(value="databaseSoftwareImageId")
        private String databaseSoftwareImageId;
        @JsonProperty(value="pdbName")
        private String pdbName;
        @JsonProperty(value="adminPassword")
        private String adminPassword;
        @JsonProperty(value="tdeWalletPassword")
        private String tdeWalletPassword;
        @JsonProperty(value="characterSet")
        private String characterSet;
        @JsonProperty(value="ncharacterSet")
        private String ncharacterSet;
        @JsonProperty(value="dbWorkload")
        private DbWorkload dbWorkload;
        @JsonProperty(value="dbBackupConfig")
        private DbBackupConfig dbBackupConfig;
        @JsonProperty(value="freeformTags")
        private Map<String, String> freeformTags;
        @JsonProperty(value="definedTags")
        private Map<String, Map<String, Object>> definedTags;
        @JsonProperty(value="kmsKeyId")
        private String kmsKeyId;
        @JsonProperty(value="kmsKeyVersionId")
        private String kmsKeyVersionId;
        @JsonProperty(value="vaultId")
        private String vaultId;
        @JsonProperty(value="sidPrefix")
        private String sidPrefix;
        @JsonProperty(value="keyStoreId")
        private String keyStoreId;
        @JsonProperty(value="encryptionKeyLocationDetails")
        private EncryptionKeyLocationDetails encryptionKeyLocationDetails;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder dbName(String dbName) {
            this.dbName = dbName;
            this.__explicitlySet__.add("dbName");
            return this;
        }

        public Builder dbUniqueName(String dbUniqueName) {
            this.dbUniqueName = dbUniqueName;
            this.__explicitlySet__.add("dbUniqueName");
            return this;
        }

        public Builder databaseSoftwareImageId(String databaseSoftwareImageId) {
            this.databaseSoftwareImageId = databaseSoftwareImageId;
            this.__explicitlySet__.add("databaseSoftwareImageId");
            return this;
        }

        public Builder pdbName(String pdbName) {
            this.pdbName = pdbName;
            this.__explicitlySet__.add("pdbName");
            return this;
        }

        public Builder adminPassword(String adminPassword) {
            this.adminPassword = adminPassword;
            this.__explicitlySet__.add("adminPassword");
            return this;
        }

        public Builder tdeWalletPassword(String tdeWalletPassword) {
            this.tdeWalletPassword = tdeWalletPassword;
            this.__explicitlySet__.add("tdeWalletPassword");
            return this;
        }

        public Builder characterSet(String characterSet) {
            this.characterSet = characterSet;
            this.__explicitlySet__.add("characterSet");
            return this;
        }

        public Builder ncharacterSet(String ncharacterSet) {
            this.ncharacterSet = ncharacterSet;
            this.__explicitlySet__.add("ncharacterSet");
            return this;
        }

        public Builder dbWorkload(DbWorkload dbWorkload) {
            this.dbWorkload = dbWorkload;
            this.__explicitlySet__.add("dbWorkload");
            return this;
        }

        public Builder dbBackupConfig(DbBackupConfig dbBackupConfig) {
            this.dbBackupConfig = dbBackupConfig;
            this.__explicitlySet__.add("dbBackupConfig");
            return this;
        }

        public Builder freeformTags(Map<String, String> freeformTags) {
            this.freeformTags = freeformTags;
            this.__explicitlySet__.add("freeformTags");
            return this;
        }

        public Builder definedTags(Map<String, Map<String, Object>> definedTags) {
            this.definedTags = definedTags;
            this.__explicitlySet__.add("definedTags");
            return this;
        }

        public Builder kmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
            this.__explicitlySet__.add("kmsKeyId");
            return this;
        }

        public Builder kmsKeyVersionId(String kmsKeyVersionId) {
            this.kmsKeyVersionId = kmsKeyVersionId;
            this.__explicitlySet__.add("kmsKeyVersionId");
            return this;
        }

        public Builder vaultId(String vaultId) {
            this.vaultId = vaultId;
            this.__explicitlySet__.add("vaultId");
            return this;
        }

        public Builder sidPrefix(String sidPrefix) {
            this.sidPrefix = sidPrefix;
            this.__explicitlySet__.add("sidPrefix");
            return this;
        }

        public Builder keyStoreId(String keyStoreId) {
            this.keyStoreId = keyStoreId;
            this.__explicitlySet__.add("keyStoreId");
            return this;
        }

        public Builder encryptionKeyLocationDetails(EncryptionKeyLocationDetails encryptionKeyLocationDetails) {
            this.encryptionKeyLocationDetails = encryptionKeyLocationDetails;
            this.__explicitlySet__.add("encryptionKeyLocationDetails");
            return this;
        }

        public CreateDatabaseDetails build() {
            CreateDatabaseDetails model = new CreateDatabaseDetails(this.dbName, this.dbUniqueName, this.databaseSoftwareImageId, this.pdbName, this.adminPassword, this.tdeWalletPassword, this.characterSet, this.ncharacterSet, this.dbWorkload, this.dbBackupConfig, this.freeformTags, this.definedTags, this.kmsKeyId, this.kmsKeyVersionId, this.vaultId, this.sidPrefix, this.keyStoreId, this.encryptionKeyLocationDetails);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(CreateDatabaseDetails model) {
            if (model.wasPropertyExplicitlySet("dbName")) {
                this.dbName(model.getDbName());
            }
            if (model.wasPropertyExplicitlySet("dbUniqueName")) {
                this.dbUniqueName(model.getDbUniqueName());
            }
            if (model.wasPropertyExplicitlySet("databaseSoftwareImageId")) {
                this.databaseSoftwareImageId(model.getDatabaseSoftwareImageId());
            }
            if (model.wasPropertyExplicitlySet("pdbName")) {
                this.pdbName(model.getPdbName());
            }
            if (model.wasPropertyExplicitlySet("adminPassword")) {
                this.adminPassword(model.getAdminPassword());
            }
            if (model.wasPropertyExplicitlySet("tdeWalletPassword")) {
                this.tdeWalletPassword(model.getTdeWalletPassword());
            }
            if (model.wasPropertyExplicitlySet("characterSet")) {
                this.characterSet(model.getCharacterSet());
            }
            if (model.wasPropertyExplicitlySet("ncharacterSet")) {
                this.ncharacterSet(model.getNcharacterSet());
            }
            if (model.wasPropertyExplicitlySet("dbWorkload")) {
                this.dbWorkload(model.getDbWorkload());
            }
            if (model.wasPropertyExplicitlySet("dbBackupConfig")) {
                this.dbBackupConfig(model.getDbBackupConfig());
            }
            if (model.wasPropertyExplicitlySet("freeformTags")) {
                this.freeformTags(model.getFreeformTags());
            }
            if (model.wasPropertyExplicitlySet("definedTags")) {
                this.definedTags(model.getDefinedTags());
            }
            if (model.wasPropertyExplicitlySet("kmsKeyId")) {
                this.kmsKeyId(model.getKmsKeyId());
            }
            if (model.wasPropertyExplicitlySet("kmsKeyVersionId")) {
                this.kmsKeyVersionId(model.getKmsKeyVersionId());
            }
            if (model.wasPropertyExplicitlySet("vaultId")) {
                this.vaultId(model.getVaultId());
            }
            if (model.wasPropertyExplicitlySet("sidPrefix")) {
                this.sidPrefix(model.getSidPrefix());
            }
            if (model.wasPropertyExplicitlySet("keyStoreId")) {
                this.keyStoreId(model.getKeyStoreId());
            }
            if (model.wasPropertyExplicitlySet("encryptionKeyLocationDetails")) {
                this.encryptionKeyLocationDetails(model.getEncryptionKeyLocationDetails());
            }
            return this;
        }
    }
}

