/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.core.requests;

import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class GetResourceIpInventoryRequest
extends BmcRequest<Void> {
    private String dataRequestId;
    private String opcRequestId;

    public String getDataRequestId() {
        return this.dataRequestId;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public Builder toBuilder() {
        return new Builder().dataRequestId(this.dataRequestId).opcRequestId(this.opcRequestId);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",dataRequestId=").append(String.valueOf(this.dataRequestId));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof GetResourceIpInventoryRequest)) {
            return false;
        }
        GetResourceIpInventoryRequest other = (GetResourceIpInventoryRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.dataRequestId, other.dataRequestId) && Objects.equals(this.opcRequestId, other.opcRequestId);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.dataRequestId == null ? 43 : this.dataRequestId.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<GetResourceIpInventoryRequest, Void> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String dataRequestId = null;
        private String opcRequestId = null;

        public Builder dataRequestId(String dataRequestId) {
            this.dataRequestId = dataRequestId;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(GetResourceIpInventoryRequest o) {
            this.dataRequestId(o.getDataRequestId());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public GetResourceIpInventoryRequest build() {
            GetResourceIpInventoryRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        public GetResourceIpInventoryRequest buildWithoutInvocationCallback() {
            GetResourceIpInventoryRequest request = new GetResourceIpInventoryRequest();
            request.dataRequestId = this.dataRequestId;
            request.opcRequestId = this.opcRequestId;
            return request;
        }
    }
}

