/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.core.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import com.oracle.bmc.http.internal.BmcEnum;
import java.beans.ConstructorProperties;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class RouteRule
extends ExplicitlySetBmcModel {
    @JsonProperty(value="cidrBlock")
    private final String cidrBlock;
    @JsonProperty(value="destination")
    private final String destination;
    @JsonProperty(value="destinationType")
    private final DestinationType destinationType;
    @JsonProperty(value="networkEntityId")
    private final String networkEntityId;
    @JsonProperty(value="description")
    private final String description;
    @JsonProperty(value="routeType")
    private final RouteType routeType;

    @Deprecated
    @ConstructorProperties(value={"cidrBlock", "destination", "destinationType", "networkEntityId", "description", "routeType"})
    public RouteRule(String cidrBlock, String destination, DestinationType destinationType, String networkEntityId, String description, RouteType routeType) {
        this.cidrBlock = cidrBlock;
        this.destination = destination;
        this.destinationType = destinationType;
        this.networkEntityId = networkEntityId;
        this.description = description;
        this.routeType = routeType;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getCidrBlock() {
        return this.cidrBlock;
    }

    public String getDestination() {
        return this.destination;
    }

    public DestinationType getDestinationType() {
        return this.destinationType;
    }

    public String getNetworkEntityId() {
        return this.networkEntityId;
    }

    public String getDescription() {
        return this.description;
    }

    public RouteType getRouteType() {
        return this.routeType;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("RouteRule(");
        sb.append("super=").append(super.toString());
        sb.append("cidrBlock=").append(String.valueOf(this.cidrBlock));
        sb.append(", destination=").append(String.valueOf(this.destination));
        sb.append(", destinationType=").append(String.valueOf((Object)this.destinationType));
        sb.append(", networkEntityId=").append(String.valueOf(this.networkEntityId));
        sb.append(", description=").append(String.valueOf(this.description));
        sb.append(", routeType=").append(String.valueOf((Object)this.routeType));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof RouteRule)) {
            return false;
        }
        RouteRule other = (RouteRule)((Object)o);
        return Objects.equals(this.cidrBlock, other.cidrBlock) && Objects.equals(this.destination, other.destination) && Objects.equals((Object)this.destinationType, (Object)other.destinationType) && Objects.equals(this.networkEntityId, other.networkEntityId) && Objects.equals(this.description, other.description) && Objects.equals((Object)this.routeType, (Object)other.routeType) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.cidrBlock == null ? 43 : this.cidrBlock.hashCode());
        result = result * 59 + (this.destination == null ? 43 : this.destination.hashCode());
        result = result * 59 + (this.destinationType == null ? 43 : this.destinationType.hashCode());
        result = result * 59 + (this.networkEntityId == null ? 43 : this.networkEntityId.hashCode());
        result = result * 59 + (this.description == null ? 43 : this.description.hashCode());
        result = result * 59 + (this.routeType == null ? 43 : this.routeType.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    public static enum DestinationType implements BmcEnum
    {
        CidrBlock("CIDR_BLOCK"),
        ServiceCidrBlock("SERVICE_CIDR_BLOCK"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, DestinationType> map;

        private DestinationType(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static DestinationType create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'DestinationType', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(DestinationType.class);
            map = new HashMap<String, DestinationType>();
            for (DestinationType v : DestinationType.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    public static enum RouteType implements BmcEnum
    {
        Static("STATIC"),
        Local("LOCAL"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, RouteType> map;

        private RouteType(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static RouteType create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'RouteType', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(RouteType.class);
            map = new HashMap<String, RouteType>();
            for (RouteType v : RouteType.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="cidrBlock")
        private String cidrBlock;
        @JsonProperty(value="destination")
        private String destination;
        @JsonProperty(value="destinationType")
        private DestinationType destinationType;
        @JsonProperty(value="networkEntityId")
        private String networkEntityId;
        @JsonProperty(value="description")
        private String description;
        @JsonProperty(value="routeType")
        private RouteType routeType;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder cidrBlock(String cidrBlock) {
            this.cidrBlock = cidrBlock;
            this.__explicitlySet__.add("cidrBlock");
            return this;
        }

        public Builder destination(String destination) {
            this.destination = destination;
            this.__explicitlySet__.add("destination");
            return this;
        }

        public Builder destinationType(DestinationType destinationType) {
            this.destinationType = destinationType;
            this.__explicitlySet__.add("destinationType");
            return this;
        }

        public Builder networkEntityId(String networkEntityId) {
            this.networkEntityId = networkEntityId;
            this.__explicitlySet__.add("networkEntityId");
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            this.__explicitlySet__.add("description");
            return this;
        }

        public Builder routeType(RouteType routeType) {
            this.routeType = routeType;
            this.__explicitlySet__.add("routeType");
            return this;
        }

        public RouteRule build() {
            RouteRule model = new RouteRule(this.cidrBlock, this.destination, this.destinationType, this.networkEntityId, this.description, this.routeType);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(RouteRule model) {
            if (model.wasPropertyExplicitlySet("cidrBlock")) {
                this.cidrBlock(model.getCidrBlock());
            }
            if (model.wasPropertyExplicitlySet("destination")) {
                this.destination(model.getDestination());
            }
            if (model.wasPropertyExplicitlySet("destinationType")) {
                this.destinationType(model.getDestinationType());
            }
            if (model.wasPropertyExplicitlySet("networkEntityId")) {
                this.networkEntityId(model.getNetworkEntityId());
            }
            if (model.wasPropertyExplicitlySet("description")) {
                this.description(model.getDescription());
            }
            if (model.wasPropertyExplicitlySet("routeType")) {
                this.routeType(model.getRouteType());
            }
            return this;
        }
    }
}

