/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.core.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.core.model.AddressType;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import com.oracle.bmc.http.internal.BmcEnum;
import java.beans.ConstructorProperties;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class ListIpInventoryDetails
extends ExplicitlySetBmcModel {
    @JsonProperty(value="regionList")
    private final List<String> regionList;
    @JsonProperty(value="compartmentList")
    private final List<String> compartmentList;
    @JsonProperty(value="overrideFilters")
    private final Boolean overrideFilters;
    @JsonProperty(value="utilization")
    private final Float utilization;
    @JsonProperty(value="overlappingVcnsOnly")
    private final Boolean overlappingVcnsOnly;
    @JsonProperty(value="addressTypeList")
    private final List<AddressType> addressTypeList;
    @JsonProperty(value="resourceTypeList")
    private final List<ResourceTypeList> resourceTypeList;
    @JsonProperty(value="searchKeyword")
    private final String searchKeyword;
    @JsonProperty(value="sortBy")
    private final SortBy sortBy;
    @JsonProperty(value="sortOrder")
    private final SortOrder sortOrder;
    @JsonProperty(value="paginationOffset")
    private final Integer paginationOffset;
    @JsonProperty(value="paginationLimit")
    private final Integer paginationLimit;

    @Deprecated
    @ConstructorProperties(value={"regionList", "compartmentList", "overrideFilters", "utilization", "overlappingVcnsOnly", "addressTypeList", "resourceTypeList", "searchKeyword", "sortBy", "sortOrder", "paginationOffset", "paginationLimit"})
    public ListIpInventoryDetails(List<String> regionList, List<String> compartmentList, Boolean overrideFilters, Float utilization, Boolean overlappingVcnsOnly, List<AddressType> addressTypeList, List<ResourceTypeList> resourceTypeList, String searchKeyword, SortBy sortBy, SortOrder sortOrder, Integer paginationOffset, Integer paginationLimit) {
        this.regionList = regionList;
        this.compartmentList = compartmentList;
        this.overrideFilters = overrideFilters;
        this.utilization = utilization;
        this.overlappingVcnsOnly = overlappingVcnsOnly;
        this.addressTypeList = addressTypeList;
        this.resourceTypeList = resourceTypeList;
        this.searchKeyword = searchKeyword;
        this.sortBy = sortBy;
        this.sortOrder = sortOrder;
        this.paginationOffset = paginationOffset;
        this.paginationLimit = paginationLimit;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public List<String> getRegionList() {
        return this.regionList;
    }

    public List<String> getCompartmentList() {
        return this.compartmentList;
    }

    public Boolean getOverrideFilters() {
        return this.overrideFilters;
    }

    public Float getUtilization() {
        return this.utilization;
    }

    public Boolean getOverlappingVcnsOnly() {
        return this.overlappingVcnsOnly;
    }

    public List<AddressType> getAddressTypeList() {
        return this.addressTypeList;
    }

    public List<ResourceTypeList> getResourceTypeList() {
        return this.resourceTypeList;
    }

    public String getSearchKeyword() {
        return this.searchKeyword;
    }

    public SortBy getSortBy() {
        return this.sortBy;
    }

    public SortOrder getSortOrder() {
        return this.sortOrder;
    }

    public Integer getPaginationOffset() {
        return this.paginationOffset;
    }

    public Integer getPaginationLimit() {
        return this.paginationLimit;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("ListIpInventoryDetails(");
        sb.append("super=").append(super.toString());
        sb.append("regionList=").append(String.valueOf(this.regionList));
        sb.append(", compartmentList=").append(String.valueOf(this.compartmentList));
        sb.append(", overrideFilters=").append(String.valueOf(this.overrideFilters));
        sb.append(", utilization=").append(String.valueOf(this.utilization));
        sb.append(", overlappingVcnsOnly=").append(String.valueOf(this.overlappingVcnsOnly));
        sb.append(", addressTypeList=").append(String.valueOf(this.addressTypeList));
        sb.append(", resourceTypeList=").append(String.valueOf(this.resourceTypeList));
        sb.append(", searchKeyword=").append(String.valueOf(this.searchKeyword));
        sb.append(", sortBy=").append(String.valueOf((Object)this.sortBy));
        sb.append(", sortOrder=").append(String.valueOf((Object)this.sortOrder));
        sb.append(", paginationOffset=").append(String.valueOf(this.paginationOffset));
        sb.append(", paginationLimit=").append(String.valueOf(this.paginationLimit));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ListIpInventoryDetails)) {
            return false;
        }
        ListIpInventoryDetails other = (ListIpInventoryDetails)((Object)o);
        return Objects.equals(this.regionList, other.regionList) && Objects.equals(this.compartmentList, other.compartmentList) && Objects.equals(this.overrideFilters, other.overrideFilters) && Objects.equals(this.utilization, other.utilization) && Objects.equals(this.overlappingVcnsOnly, other.overlappingVcnsOnly) && Objects.equals(this.addressTypeList, other.addressTypeList) && Objects.equals(this.resourceTypeList, other.resourceTypeList) && Objects.equals(this.searchKeyword, other.searchKeyword) && Objects.equals((Object)this.sortBy, (Object)other.sortBy) && Objects.equals((Object)this.sortOrder, (Object)other.sortOrder) && Objects.equals(this.paginationOffset, other.paginationOffset) && Objects.equals(this.paginationLimit, other.paginationLimit) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.regionList == null ? 43 : this.regionList.hashCode());
        result = result * 59 + (this.compartmentList == null ? 43 : this.compartmentList.hashCode());
        result = result * 59 + (this.overrideFilters == null ? 43 : this.overrideFilters.hashCode());
        result = result * 59 + (this.utilization == null ? 43 : this.utilization.hashCode());
        result = result * 59 + (this.overlappingVcnsOnly == null ? 43 : this.overlappingVcnsOnly.hashCode());
        result = result * 59 + (this.addressTypeList == null ? 43 : this.addressTypeList.hashCode());
        result = result * 59 + (this.resourceTypeList == null ? 43 : this.resourceTypeList.hashCode());
        result = result * 59 + (this.searchKeyword == null ? 43 : this.searchKeyword.hashCode());
        result = result * 59 + (this.sortBy == null ? 43 : this.sortBy.hashCode());
        result = result * 59 + (this.sortOrder == null ? 43 : this.sortOrder.hashCode());
        result = result * 59 + (this.paginationOffset == null ? 43 : this.paginationOffset.hashCode());
        result = result * 59 + (this.paginationLimit == null ? 43 : this.paginationLimit.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    public static enum SortBy implements BmcEnum
    {
        Displayname("DISPLAYNAME"),
        Utilization("UTILIZATION"),
        DnsHostname("DNS_HOSTNAME"),
        Region("REGION");

        private final String value;
        private static Map<String, SortBy> map;

        private SortBy(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static SortBy create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            throw new IllegalArgumentException("Invalid SortBy: " + key);
        }

        static {
            map = new HashMap<String, SortBy>();
            for (SortBy v : SortBy.values()) {
                map.put(v.getValue(), v);
            }
        }
    }

    public static enum SortOrder implements BmcEnum
    {
        Asc("ASC"),
        Desc("DESC");

        private final String value;
        private static Map<String, SortOrder> map;

        private SortOrder(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static SortOrder create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            throw new IllegalArgumentException("Invalid SortOrder: " + key);
        }

        static {
            map = new HashMap<String, SortOrder>();
            for (SortOrder v : SortOrder.values()) {
                map.put(v.getValue(), v);
            }
        }
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="regionList")
        private List<String> regionList;
        @JsonProperty(value="compartmentList")
        private List<String> compartmentList;
        @JsonProperty(value="overrideFilters")
        private Boolean overrideFilters;
        @JsonProperty(value="utilization")
        private Float utilization;
        @JsonProperty(value="overlappingVcnsOnly")
        private Boolean overlappingVcnsOnly;
        @JsonProperty(value="addressTypeList")
        private List<AddressType> addressTypeList;
        @JsonProperty(value="resourceTypeList")
        private List<ResourceTypeList> resourceTypeList;
        @JsonProperty(value="searchKeyword")
        private String searchKeyword;
        @JsonProperty(value="sortBy")
        private SortBy sortBy;
        @JsonProperty(value="sortOrder")
        private SortOrder sortOrder;
        @JsonProperty(value="paginationOffset")
        private Integer paginationOffset;
        @JsonProperty(value="paginationLimit")
        private Integer paginationLimit;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder regionList(List<String> regionList) {
            this.regionList = regionList;
            this.__explicitlySet__.add("regionList");
            return this;
        }

        public Builder compartmentList(List<String> compartmentList) {
            this.compartmentList = compartmentList;
            this.__explicitlySet__.add("compartmentList");
            return this;
        }

        public Builder overrideFilters(Boolean overrideFilters) {
            this.overrideFilters = overrideFilters;
            this.__explicitlySet__.add("overrideFilters");
            return this;
        }

        public Builder utilization(Float utilization) {
            this.utilization = utilization;
            this.__explicitlySet__.add("utilization");
            return this;
        }

        public Builder overlappingVcnsOnly(Boolean overlappingVcnsOnly) {
            this.overlappingVcnsOnly = overlappingVcnsOnly;
            this.__explicitlySet__.add("overlappingVcnsOnly");
            return this;
        }

        public Builder addressTypeList(List<AddressType> addressTypeList) {
            this.addressTypeList = addressTypeList;
            this.__explicitlySet__.add("addressTypeList");
            return this;
        }

        public Builder resourceTypeList(List<ResourceTypeList> resourceTypeList) {
            this.resourceTypeList = resourceTypeList;
            this.__explicitlySet__.add("resourceTypeList");
            return this;
        }

        public Builder searchKeyword(String searchKeyword) {
            this.searchKeyword = searchKeyword;
            this.__explicitlySet__.add("searchKeyword");
            return this;
        }

        public Builder sortBy(SortBy sortBy) {
            this.sortBy = sortBy;
            this.__explicitlySet__.add("sortBy");
            return this;
        }

        public Builder sortOrder(SortOrder sortOrder) {
            this.sortOrder = sortOrder;
            this.__explicitlySet__.add("sortOrder");
            return this;
        }

        public Builder paginationOffset(Integer paginationOffset) {
            this.paginationOffset = paginationOffset;
            this.__explicitlySet__.add("paginationOffset");
            return this;
        }

        public Builder paginationLimit(Integer paginationLimit) {
            this.paginationLimit = paginationLimit;
            this.__explicitlySet__.add("paginationLimit");
            return this;
        }

        public ListIpInventoryDetails build() {
            ListIpInventoryDetails model = new ListIpInventoryDetails(this.regionList, this.compartmentList, this.overrideFilters, this.utilization, this.overlappingVcnsOnly, this.addressTypeList, this.resourceTypeList, this.searchKeyword, this.sortBy, this.sortOrder, this.paginationOffset, this.paginationLimit);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(ListIpInventoryDetails model) {
            if (model.wasPropertyExplicitlySet("regionList")) {
                this.regionList(model.getRegionList());
            }
            if (model.wasPropertyExplicitlySet("compartmentList")) {
                this.compartmentList(model.getCompartmentList());
            }
            if (model.wasPropertyExplicitlySet("overrideFilters")) {
                this.overrideFilters(model.getOverrideFilters());
            }
            if (model.wasPropertyExplicitlySet("utilization")) {
                this.utilization(model.getUtilization());
            }
            if (model.wasPropertyExplicitlySet("overlappingVcnsOnly")) {
                this.overlappingVcnsOnly(model.getOverlappingVcnsOnly());
            }
            if (model.wasPropertyExplicitlySet("addressTypeList")) {
                this.addressTypeList(model.getAddressTypeList());
            }
            if (model.wasPropertyExplicitlySet("resourceTypeList")) {
                this.resourceTypeList(model.getResourceTypeList());
            }
            if (model.wasPropertyExplicitlySet("searchKeyword")) {
                this.searchKeyword(model.getSearchKeyword());
            }
            if (model.wasPropertyExplicitlySet("sortBy")) {
                this.sortBy(model.getSortBy());
            }
            if (model.wasPropertyExplicitlySet("sortOrder")) {
                this.sortOrder(model.getSortOrder());
            }
            if (model.wasPropertyExplicitlySet("paginationOffset")) {
                this.paginationOffset(model.getPaginationOffset());
            }
            if (model.wasPropertyExplicitlySet("paginationLimit")) {
                this.paginationLimit(model.getPaginationLimit());
            }
            return this;
        }
    }

    public static enum ResourceTypeList implements BmcEnum
    {
        Resource("Resource");

        private final String value;
        private static Map<String, ResourceTypeList> map;

        private ResourceTypeList(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static ResourceTypeList create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            throw new IllegalArgumentException("Invalid ResourceTypeList: " + key);
        }

        static {
            map = new HashMap<String, ResourceTypeList>();
            for (ResourceTypeList v : ResourceTypeList.values()) {
                map.put(v.getValue(), v);
            }
        }
    }
}

