/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.core.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.core.model.InventorySubnetSummary;
import com.oracle.bmc.core.model.InventoryVcnCidrBlockSummary;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import com.oracle.bmc.http.internal.BmcEnum;
import java.beans.ConstructorProperties;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class InventoryVcnSummary
extends ExplicitlySetBmcModel {
    @JsonProperty(value="vcnId")
    private final String vcnId;
    @JsonProperty(value="vcnName")
    private final String vcnName;
    @JsonProperty(value="resourceType")
    private final ResourceType resourceType;
    @JsonProperty(value="inventoryVcnCidrBlockCollection")
    private final List<InventoryVcnCidrBlockSummary> inventoryVcnCidrBlockCollection;
    @JsonProperty(value="dnsDomainName")
    private final String dnsDomainName;
    @JsonProperty(value="region")
    private final String region;
    @JsonProperty(value="compartmentId")
    private final String compartmentId;
    @JsonProperty(value="inventorySubnetcollection")
    private final List<InventorySubnetSummary> inventorySubnetcollection;

    @Deprecated
    @ConstructorProperties(value={"vcnId", "vcnName", "resourceType", "inventoryVcnCidrBlockCollection", "dnsDomainName", "region", "compartmentId", "inventorySubnetcollection"})
    public InventoryVcnSummary(String vcnId, String vcnName, ResourceType resourceType, List<InventoryVcnCidrBlockSummary> inventoryVcnCidrBlockCollection, String dnsDomainName, String region, String compartmentId, List<InventorySubnetSummary> inventorySubnetcollection) {
        this.vcnId = vcnId;
        this.vcnName = vcnName;
        this.resourceType = resourceType;
        this.inventoryVcnCidrBlockCollection = inventoryVcnCidrBlockCollection;
        this.dnsDomainName = dnsDomainName;
        this.region = region;
        this.compartmentId = compartmentId;
        this.inventorySubnetcollection = inventorySubnetcollection;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getVcnId() {
        return this.vcnId;
    }

    public String getVcnName() {
        return this.vcnName;
    }

    public ResourceType getResourceType() {
        return this.resourceType;
    }

    public List<InventoryVcnCidrBlockSummary> getInventoryVcnCidrBlockCollection() {
        return this.inventoryVcnCidrBlockCollection;
    }

    public String getDnsDomainName() {
        return this.dnsDomainName;
    }

    public String getRegion() {
        return this.region;
    }

    public String getCompartmentId() {
        return this.compartmentId;
    }

    public List<InventorySubnetSummary> getInventorySubnetcollection() {
        return this.inventorySubnetcollection;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("InventoryVcnSummary(");
        sb.append("super=").append(super.toString());
        sb.append("vcnId=").append(String.valueOf(this.vcnId));
        sb.append(", vcnName=").append(String.valueOf(this.vcnName));
        sb.append(", resourceType=").append(String.valueOf((Object)this.resourceType));
        sb.append(", inventoryVcnCidrBlockCollection=").append(String.valueOf(this.inventoryVcnCidrBlockCollection));
        sb.append(", dnsDomainName=").append(String.valueOf(this.dnsDomainName));
        sb.append(", region=").append(String.valueOf(this.region));
        sb.append(", compartmentId=").append(String.valueOf(this.compartmentId));
        sb.append(", inventorySubnetcollection=").append(String.valueOf(this.inventorySubnetcollection));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof InventoryVcnSummary)) {
            return false;
        }
        InventoryVcnSummary other = (InventoryVcnSummary)((Object)o);
        return Objects.equals(this.vcnId, other.vcnId) && Objects.equals(this.vcnName, other.vcnName) && Objects.equals((Object)this.resourceType, (Object)other.resourceType) && Objects.equals(this.inventoryVcnCidrBlockCollection, other.inventoryVcnCidrBlockCollection) && Objects.equals(this.dnsDomainName, other.dnsDomainName) && Objects.equals(this.region, other.region) && Objects.equals(this.compartmentId, other.compartmentId) && Objects.equals(this.inventorySubnetcollection, other.inventorySubnetcollection) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.vcnId == null ? 43 : this.vcnId.hashCode());
        result = result * 59 + (this.vcnName == null ? 43 : this.vcnName.hashCode());
        result = result * 59 + (this.resourceType == null ? 43 : this.resourceType.hashCode());
        result = result * 59 + (this.inventoryVcnCidrBlockCollection == null ? 43 : this.inventoryVcnCidrBlockCollection.hashCode());
        result = result * 59 + (this.dnsDomainName == null ? 43 : this.dnsDomainName.hashCode());
        result = result * 59 + (this.region == null ? 43 : this.region.hashCode());
        result = result * 59 + (this.compartmentId == null ? 43 : this.compartmentId.hashCode());
        result = result * 59 + (this.inventorySubnetcollection == null ? 43 : this.inventorySubnetcollection.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    public static enum ResourceType implements BmcEnum
    {
        Vcn("VCN"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, ResourceType> map;

        private ResourceType(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static ResourceType create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'ResourceType', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(ResourceType.class);
            map = new HashMap<String, ResourceType>();
            for (ResourceType v : ResourceType.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="vcnId")
        private String vcnId;
        @JsonProperty(value="vcnName")
        private String vcnName;
        @JsonProperty(value="resourceType")
        private ResourceType resourceType;
        @JsonProperty(value="inventoryVcnCidrBlockCollection")
        private List<InventoryVcnCidrBlockSummary> inventoryVcnCidrBlockCollection;
        @JsonProperty(value="dnsDomainName")
        private String dnsDomainName;
        @JsonProperty(value="region")
        private String region;
        @JsonProperty(value="compartmentId")
        private String compartmentId;
        @JsonProperty(value="inventorySubnetcollection")
        private List<InventorySubnetSummary> inventorySubnetcollection;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder vcnId(String vcnId) {
            this.vcnId = vcnId;
            this.__explicitlySet__.add("vcnId");
            return this;
        }

        public Builder vcnName(String vcnName) {
            this.vcnName = vcnName;
            this.__explicitlySet__.add("vcnName");
            return this;
        }

        public Builder resourceType(ResourceType resourceType) {
            this.resourceType = resourceType;
            this.__explicitlySet__.add("resourceType");
            return this;
        }

        public Builder inventoryVcnCidrBlockCollection(List<InventoryVcnCidrBlockSummary> inventoryVcnCidrBlockCollection) {
            this.inventoryVcnCidrBlockCollection = inventoryVcnCidrBlockCollection;
            this.__explicitlySet__.add("inventoryVcnCidrBlockCollection");
            return this;
        }

        public Builder dnsDomainName(String dnsDomainName) {
            this.dnsDomainName = dnsDomainName;
            this.__explicitlySet__.add("dnsDomainName");
            return this;
        }

        public Builder region(String region) {
            this.region = region;
            this.__explicitlySet__.add("region");
            return this;
        }

        public Builder compartmentId(String compartmentId) {
            this.compartmentId = compartmentId;
            this.__explicitlySet__.add("compartmentId");
            return this;
        }

        public Builder inventorySubnetcollection(List<InventorySubnetSummary> inventorySubnetcollection) {
            this.inventorySubnetcollection = inventorySubnetcollection;
            this.__explicitlySet__.add("inventorySubnetcollection");
            return this;
        }

        public InventoryVcnSummary build() {
            InventoryVcnSummary model = new InventoryVcnSummary(this.vcnId, this.vcnName, this.resourceType, this.inventoryVcnCidrBlockCollection, this.dnsDomainName, this.region, this.compartmentId, this.inventorySubnetcollection);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(InventoryVcnSummary model) {
            if (model.wasPropertyExplicitlySet("vcnId")) {
                this.vcnId(model.getVcnId());
            }
            if (model.wasPropertyExplicitlySet("vcnName")) {
                this.vcnName(model.getVcnName());
            }
            if (model.wasPropertyExplicitlySet("resourceType")) {
                this.resourceType(model.getResourceType());
            }
            if (model.wasPropertyExplicitlySet("inventoryVcnCidrBlockCollection")) {
                this.inventoryVcnCidrBlockCollection(model.getInventoryVcnCidrBlockCollection());
            }
            if (model.wasPropertyExplicitlySet("dnsDomainName")) {
                this.dnsDomainName(model.getDnsDomainName());
            }
            if (model.wasPropertyExplicitlySet("region")) {
                this.region(model.getRegion());
            }
            if (model.wasPropertyExplicitlySet("compartmentId")) {
                this.compartmentId(model.getCompartmentId());
            }
            if (model.wasPropertyExplicitlySet("inventorySubnetcollection")) {
                this.inventorySubnetcollection(model.getInventorySubnetcollection());
            }
            return this;
        }
    }
}

